/*
 * Decompiled with CFR 0.152.
 */
package demo.gui;

import demo.gui.ArrayPanel;
import demo.gui.ProxyMethodDescriptor;
import demo.gui.ReturnFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;
import matlabcontrol.MatlabProxyFactoryOptions;
import matlabcontrol.PermissiveSecurityManager;

public class DemoFrame
extends JFrame {
    private static final String STATUS_DISCONNECTED = "Connection Status: Disconnected";
    private static final String STATUS_CONNECTING = "Connection Status: Connecting";
    private static final String STATUS_CONNECTED_EXISTING = "Connection Status: Connected (Existing)";
    private static final String STATUS_CONNECTED_LAUNCHED = "Connection Status: Connected (Launched)";
    private static final String RETURNED_DEFAULT = "Returned Object / Java Exception";
    private static final String RETURNED_OBJECT = "Returned Object";
    private static final String RETURNED_EXCEPTION = "Java Exception";
    private static final int PANEL_WIDTH = 660;
    private static final Dimension CONNECTION_PANEL_SIZE = new Dimension(660, 70);
    private static final Dimension RETURN_PANEL_SIZE = new Dimension(660, 250);
    private static final Dimension METHOD_PANEL_SIZE = new Dimension(660, 194);
    private static final Dimension DESCRIPTION_PANE_SIZE = new Dimension(660, 200);
    private static final Dimension COMMAND_PANEL_SIZE = new Dimension(660, DemoFrame.METHOD_PANEL_SIZE.height + DemoFrame.DESCRIPTION_PANE_SIZE.height);
    private static final Dimension MAIN_PANEL_SIZE = new Dimension(660, DemoFrame.CONNECTION_PANEL_SIZE.height + DemoFrame.COMMAND_PANEL_SIZE.height + DemoFrame.RETURN_PANEL_SIZE.height);
    private final MatlabProxyFactory _factory;
    private final AtomicReference<MatlabProxy> _proxyHolder = new AtomicReference();
    private JButton _invokeButton;
    private JScrollPane _returnPane;
    private JTextArea _returnArea;

    public DemoFrame(String title, String matlabLocation) {
        super(title);
        System.setSecurityManager(new PermissiveSecurityManager());
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/demo/gui/icon.png")));
        }
        catch (Exception e) {
            // empty catch block
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setPreferredSize(MAIN_PANEL_SIZE);
        mainPanel.setSize(MAIN_PANEL_SIZE);
        this.add(mainPanel);
        final JPanel connectionPanel = new JPanel();
        connectionPanel.setBackground(mainPanel.getBackground());
        connectionPanel.setBorder(BorderFactory.createTitledBorder(STATUS_DISCONNECTED));
        connectionPanel.setPreferredSize(CONNECTION_PANEL_SIZE);
        connectionPanel.setSize(CONNECTION_PANEL_SIZE);
        final JButton connectionButton = new JButton("Connect");
        connectionPanel.add(connectionButton);
        final JProgressBar connectionBar = new JProgressBar();
        connectionPanel.add(connectionBar);
        this._returnArea = new JTextArea();
        this._returnArea.setEditable(false);
        this._returnPane = new JScrollPane(this._returnArea);
        this._returnPane.setBackground(Color.WHITE);
        this._returnPane.setPreferredSize(RETURN_PANEL_SIZE);
        this._returnPane.setBorder(BorderFactory.createTitledBorder(RETURNED_DEFAULT));
        JPanel commandPanel = this.createCommandPanel();
        JPanel combinedPanel = new JPanel(new BorderLayout());
        combinedPanel.add((Component)connectionPanel, "North");
        combinedPanel.add((Component)commandPanel, "South");
        mainPanel.add((Component)combinedPanel, "North");
        mainPanel.add((Component)this._returnPane, "Center");
        this.pack();
        MatlabProxyFactoryOptions options = new MatlabProxyFactoryOptions.Builder().setUsePreviouslyControlledSession(true).setMatlabLocation(matlabLocation).build();
        this._factory = new MatlabProxyFactory(options);
        connectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DemoFrame.this._factory.requestProxy(new MatlabProxyFactory.RequestCallback(){

                        @Override
                        public void proxyCreated(final MatlabProxy proxy) {
                            DemoFrame.this._proxyHolder.set(proxy);
                            proxy.addDisconnectionListener(new MatlabProxy.DisconnectionListener(){

                                @Override
                                public void proxyDisconnected(MatlabProxy proxy) {
                                    DemoFrame.this._proxyHolder.set(null);
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            connectionPanel.setBorder(BorderFactory.createTitledBorder(DemoFrame.STATUS_DISCONNECTED));
                                            DemoFrame.this._returnPane.setBorder(BorderFactory.createTitledBorder(DemoFrame.RETURNED_DEFAULT));
                                            DemoFrame.this._returnArea.setText("");
                                            connectionBar.setValue(0);
                                            connectionButton.setEnabled(true);
                                            DemoFrame.this._invokeButton.setEnabled(false);
                                        }
                                    });
                                }
                            });
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String status = proxy.isExistingSession() ? DemoFrame.STATUS_CONNECTED_EXISTING : DemoFrame.STATUS_CONNECTED_LAUNCHED;
                                    connectionPanel.setBorder(BorderFactory.createTitledBorder(status));
                                    connectionBar.setValue(100);
                                    connectionBar.setIndeterminate(false);
                                    DemoFrame.this._invokeButton.setEnabled(true);
                                }
                            });
                        }
                    });
                    connectionPanel.setBorder(BorderFactory.createTitledBorder(DemoFrame.STATUS_CONNECTING));
                    connectionBar.setIndeterminate(true);
                    connectionButton.setEnabled(false);
                }
                catch (MatlabConnectionException exc) {
                    DemoFrame.this._returnPane.setBorder(BorderFactory.createTitledBorder(DemoFrame.RETURNED_EXCEPTION));
                    DemoFrame.this._returnArea.setText(ReturnFormatter.formatException(exc));
                    DemoFrame.this._returnArea.setCaretPosition(0);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                Dimension size = DemoFrame.this.getSize();
                size.height = (int)((double)size.height * 0.8);
                DemoFrame.this.setMinimumSize(size);
            }
        });
    }

    private JPanel createCommandPanel() {
        JPanel commandPanel = new JPanel(new BorderLayout());
        commandPanel.setBackground(Color.WHITE);
        commandPanel.setPreferredSize(COMMAND_PANEL_SIZE);
        commandPanel.setSize(COMMAND_PANEL_SIZE);
        JPanel methodPanel = new JPanel(new BorderLayout());
        methodPanel.setBorder(BorderFactory.createTitledBorder("Method"));
        methodPanel.setBackground(Color.WHITE);
        methodPanel.setPreferredSize(METHOD_PANEL_SIZE);
        methodPanel.setSize(METHOD_PANEL_SIZE);
        commandPanel.add((Component)methodPanel, "North");
        JPanel methodUpperPanel = new JPanel();
        methodUpperPanel.setBackground(Color.WHITE);
        methodPanel.add((Component)methodUpperPanel, "North");
        JPanel methodLowerPanel = new JPanel();
        methodLowerPanel.setBackground(Color.WHITE);
        methodPanel.add((Component)methodLowerPanel, "South");
        final JComboBox<ProxyMethodDescriptor> methodBox = new JComboBox<ProxyMethodDescriptor>(ProxyMethodDescriptor.values());
        methodUpperPanel.add(methodBox);
        this._invokeButton = new JButton("Invoke");
        this._invokeButton.setEnabled(false);
        methodUpperPanel.add(this._invokeButton);
        final JTextField field = new JTextField();
        field.setBackground(methodPanel.getBackground());
        field.setColumns(16);
        methodLowerPanel.add(field);
        final JFormattedTextField nargoutField = new JFormattedTextField((Object)0);
        nargoutField.setBackground(methodPanel.getBackground());
        nargoutField.setColumns(8);
        nargoutField.setBorder(BorderFactory.createTitledBorder("nargout"));
        methodLowerPanel.add(nargoutField);
        final ArrayPanel arrayPanel = new ArrayPanel();
        methodLowerPanel.add(arrayPanel);
        final JEditorPane descriptionArea = new JEditorPane("text/html", "");
        descriptionArea.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        JScrollPane descriptionPane = new JScrollPane(descriptionArea);
        descriptionPane.setBackground(Color.WHITE);
        descriptionArea.setFont(new Font("SansSerif", 0, 13));
        descriptionPane.setBorder(BorderFactory.createTitledBorder("Method description"));
        descriptionPane.setPreferredSize(DESCRIPTION_PANE_SIZE);
        descriptionArea.setEditable(false);
        commandPanel.add((Component)descriptionPane, "South");
        methodBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyMethodDescriptor method = (ProxyMethodDescriptor)((Object)methodBox.getSelectedItem());
                field.setBorder(BorderFactory.createTitledBorder(method.stringInputName));
                if (method.returnCountEnabled) {
                    nargoutField.setText("1");
                    nargoutField.setEnabled(true);
                } else {
                    nargoutField.setText("N/A");
                    nargoutField.setEnabled(false);
                }
                arrayPanel.setBorder(BorderFactory.createTitledBorder(method.argsInputName));
                arrayPanel.enableInputFields(method.argsInputNumberEnabled);
                descriptionArea.setText(method.message);
                descriptionArea.setCaretPosition(0);
                field.selectAll();
                field.grabFocus();
            }
        });
        methodBox.setSelectedIndex(0);
        this._invokeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyMethodDescriptor descriptor = (ProxyMethodDescriptor)((Object)methodBox.getSelectedItem());
                if (descriptor == ProxyMethodDescriptor.EVAL) {
                    try {
                        ((MatlabProxy)DemoFrame.this._proxyHolder.get()).eval(field.getText());
                        DemoFrame.this.displayReturn();
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                } else if (descriptor == ProxyMethodDescriptor.RETURNING_EVAL) {
                    int nargout = 0;
                    try {
                        nargout = Integer.parseInt(nargoutField.getText());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        DemoFrame.this.displayResult(((MatlabProxy)DemoFrame.this._proxyHolder.get()).returningEval(field.getText(), nargout));
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                } else if (descriptor == ProxyMethodDescriptor.FEVAL) {
                    try {
                        ((MatlabProxy)DemoFrame.this._proxyHolder.get()).feval(field.getText(), arrayPanel.getArray());
                        DemoFrame.this.displayReturn();
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                } else if (descriptor == ProxyMethodDescriptor.RETURNING_FEVAL) {
                    int nargout = 0;
                    try {
                        nargout = Integer.parseInt(nargoutField.getText());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        DemoFrame.this.displayResult(((MatlabProxy)DemoFrame.this._proxyHolder.get()).returningFeval(field.getText(), nargout, arrayPanel.getArray()));
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                } else if (descriptor == ProxyMethodDescriptor.SET_VARIABLE) {
                    try {
                        ((MatlabProxy)DemoFrame.this._proxyHolder.get()).setVariable(field.getText(), arrayPanel.getFirstEntry());
                        DemoFrame.this.displayReturn();
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                } else if (descriptor == ProxyMethodDescriptor.GET_VARIABLE) {
                    try {
                        DemoFrame.this.displayResult(((MatlabProxy)DemoFrame.this._proxyHolder.get()).getVariable(field.getText()));
                    }
                    catch (MatlabInvocationException ex) {
                        DemoFrame.this.displayException(ex);
                    }
                }
            }
        });
        return commandPanel;
    }

    private void displayReturn() {
        this._returnArea.setText("");
    }

    private void displayResult(Object result) {
        this._returnPane.setBorder(BorderFactory.createTitledBorder(RETURNED_OBJECT));
        this._returnArea.setForeground(Color.BLACK);
        this._returnArea.setText(ReturnFormatter.formatResult(result));
        this._returnArea.setCaretPosition(0);
    }

    private void displayException(Exception exc) {
        this._returnPane.setBorder(BorderFactory.createTitledBorder(RETURNED_EXCEPTION));
        this._returnArea.setForeground(Color.RED);
        this._returnArea.setText(ReturnFormatter.formatException(exc));
        this._returnArea.setCaretPosition(0);
    }
}

