/*
 * Decompiled with CFR 0.152.
 */
package demo.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;

class ReturnFormatter {
    private ReturnFormatter() {
    }

    public static String formatException(Exception exc) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exc.printStackTrace(printWriter);
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String formatResult(Object result) {
        return ReturnFormatter.formatResult(result, 0);
    }

    private static String formatResult(Object result, int level) {
        StringBuilder builder = new StringBuilder();
        String tab = "";
        for (int i = 0; i < level + 1; ++i) {
            tab = tab + "  ";
        }
        if (result == null) {
            builder.append("null encountered\n");
        } else if (result.getClass().isArray()) {
            Class<?> componentClass = result.getClass().getComponentType();
            if (componentClass.isPrimitive()) {
                String componentName = componentClass.toString();
                int length = Array.getLength(result);
                builder.append(componentName);
                builder.append(" array, length = ");
                builder.append(length);
                builder.append("\n");
                for (int i = 0; i < length; ++i) {
                    builder.append(tab);
                    builder.append("index ");
                    builder.append(i);
                    builder.append(", ");
                    builder.append(componentName);
                    builder.append(": ");
                    builder.append(Array.get(result, i));
                    builder.append("\n");
                }
            } else {
                Object[] array = (Object[])result;
                builder.append(array.getClass().getComponentType().getName());
                builder.append(" array, length = ");
                builder.append(array.length);
                builder.append("\n");
                for (int i = 0; i < array.length; ++i) {
                    builder.append(tab);
                    builder.append("index ");
                    builder.append(i);
                    builder.append(", ");
                    builder.append(ReturnFormatter.formatResult(array[i], level + 1));
                }
            }
        } else {
            builder.append(result.getClass().getCanonicalName());
            builder.append(": ");
            builder.append(result);
            builder.append("\n");
        }
        return builder.toString();
    }
}

