/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeExpr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_lbool;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Expr
extends AST {
    public Expr simplify() throws Z3Exception {
        return this.simplify(null);
    }

    public Expr simplify(Params params) throws Z3Exception {
        if (params == null) {
            return Expr.create(this.getContext(), Native.simplify(this.getContext().nCtx(), this.getNativeObject()));
        }
        return Expr.create(this.getContext(), Native.simplifyEx(this.getContext().nCtx(), this.getNativeObject(), params.getNativeObject()));
    }

    public FuncDecl getFuncDecl() throws Z3Exception {
        return new FuncDecl(this.getContext(), Native.getAppDecl(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Z3_lbool getBoolValue() throws Z3Exception {
        return Z3_lbool.fromInt(Native.getBoolValue(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumArgs() throws Z3Exception {
        return Native.getAppNumArgs(this.getContext().nCtx(), this.getNativeObject());
    }

    public Expr[] getArgs() throws Z3Exception {
        int n = this.getNumArgs();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.create(this.getContext(), Native.getAppArg(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return exprArray;
    }

    public void update(Expr[] exprArray) throws Z3Exception {
        this.getContext().checkContextMatch(exprArray);
        if (this.isApp() && exprArray.length != this.getNumArgs()) {
            throw new Z3Exception("Number of arguments does not match");
        }
        this.setNativeObject(Native.updateTerm(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray)));
    }

    public Expr substitute(Expr[] exprArray, Expr[] exprArray2) throws Z3Exception {
        this.getContext().checkContextMatch(exprArray);
        this.getContext().checkContextMatch(exprArray2);
        if (exprArray.length != exprArray2.length) {
            throw new Z3Exception("Argument sizes do not match");
        }
        return Expr.create(this.getContext(), Native.substitute(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray), Expr.arrayToNative(exprArray2)));
    }

    public Expr substitute(Expr expr, Expr expr2) throws Z3Exception {
        return this.substitute(new Expr[]{expr}, new Expr[]{expr2});
    }

    public Expr substituteVars(Expr[] exprArray) throws Z3Exception {
        this.getContext().checkContextMatch(exprArray);
        return Expr.create(this.getContext(), Native.substituteVars(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray)));
    }

    @Override
    public Expr translate(Context context) throws Z3Exception {
        if (this.getContext() == context) {
            return this;
        }
        return Expr.create(context, Native.translate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean isNumeral() throws Z3Exception {
        return Native.isNumeralAst(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isWellSorted() throws Z3Exception {
        return Native.isWellSorted(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort getSort() throws Z3Exception {
        return Sort.create(this.getContext(), Native.getSort(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isConst() throws Z3Exception {
        return this.isApp() && this.getNumArgs() == 0 && this.getFuncDecl().getDomainSize() == 0;
    }

    public boolean isIntNum() throws Z3Exception {
        return this.isNumeral() && this.isInt();
    }

    public boolean isRatNum() throws Z3Exception {
        return this.isNumeral() && this.isReal();
    }

    public boolean isAlgebraicNumber() throws Z3Exception {
        return Native.isAlgebraicNumber(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isBool() throws Z3Exception {
        return this.isExpr() && Native.isEqSort(this.getContext().nCtx(), Native.mkBoolSort(this.getContext().nCtx()), Native.getSort(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isTrue() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TRUE;
    }

    public boolean isFalse() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_FALSE;
    }

    public boolean isEq() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EQ;
    }

    public boolean isDistinct() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_DISTINCT;
    }

    public boolean isITE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ITE;
    }

    public boolean isAnd() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_AND;
    }

    public boolean isOr() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_OR;
    }

    public boolean isIff() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IFF;
    }

    public boolean isXor() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_XOR;
    }

    public boolean isNot() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_NOT;
    }

    public boolean isImplies() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IMPLIES;
    }

    public boolean isInt() throws Z3Exception {
        return Native.isNumeralAst(this.getContext().nCtx(), this.getNativeObject()) && Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_INT_SORT.toInt();
    }

    public boolean isReal() throws Z3Exception {
        return Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_REAL_SORT.toInt();
    }

    public boolean isArithmeticNumeral() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ANUM;
    }

    public boolean isLE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LE;
    }

    public boolean isGE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_GE;
    }

    public boolean isLT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LT;
    }

    public boolean isGT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_GT;
    }

    public boolean isAdd() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ADD;
    }

    public boolean isSub() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SUB;
    }

    public boolean isUMinus() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UMINUS;
    }

    public boolean isMul() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_MUL;
    }

    public boolean isDiv() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_DIV;
    }

    public boolean isIDiv() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IDIV;
    }

    public boolean isRemainder() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_REM;
    }

    public boolean isModulus() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_MOD;
    }

    public boolean isIntToReal() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TO_REAL;
    }

    public boolean isRealToInt() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TO_INT;
    }

    public boolean isRealIsInt() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IS_INT;
    }

    public boolean isArray() throws Z3Exception {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject()))) == Z3_sort_kind.Z3_ARRAY_SORT;
    }

    public boolean isStore() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_STORE;
    }

    public boolean isSelect() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SELECT;
    }

    public boolean isConstantArray() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CONST_ARRAY;
    }

    public boolean isDefaultArray() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ARRAY_DEFAULT;
    }

    public boolean isArrayMap() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ARRAY_MAP;
    }

    public boolean isAsArray() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_AS_ARRAY;
    }

    public boolean isSetUnion() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_UNION;
    }

    public boolean isSetIntersect() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_INTERSECT;
    }

    public boolean isSetDifference() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_DIFFERENCE;
    }

    public boolean isSetComplement() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_COMPLEMENT;
    }

    public boolean isSetSubset() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_SUBSET;
    }

    public boolean isBV() throws Z3Exception {
        return Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_BV_SORT.toInt();
    }

    public boolean isBVNumeral() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNUM;
    }

    public boolean isBVBitOne() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BIT1;
    }

    public boolean isBVBitZero() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BIT0;
    }

    public boolean isBVUMinus() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNEG;
    }

    public boolean isBVAdd() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BADD;
    }

    public boolean isBVSub() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSUB;
    }

    public boolean isBVMul() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BMUL;
    }

    public boolean isBVSDiv() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSDIV;
    }

    public boolean isBVUDiv() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUDIV;
    }

    public boolean isBVSRem() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSREM;
    }

    public boolean isBVURem() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUREM;
    }

    public boolean isBVSMod() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSMOD;
    }

    boolean IsBVSDiv0() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSDIV0;
    }

    boolean IsBVUDiv0() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUDIV0;
    }

    boolean IsBVSRem0() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSREM0;
    }

    boolean IsBVURem0() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUREM0;
    }

    boolean IsBVSMod0() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSMOD0;
    }

    public boolean isBVULE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ULEQ;
    }

    public boolean isBVSLE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SLEQ;
    }

    public boolean isBVUGE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UGEQ;
    }

    public boolean isBVSGE() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SGEQ;
    }

    public boolean isBVULT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ULT;
    }

    public boolean isBVSLT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SLT;
    }

    public boolean isBVUGT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UGT;
    }

    public boolean isBVSGT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SGT;
    }

    public boolean isBVAND() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BAND;
    }

    public boolean isBVOR() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BOR;
    }

    public boolean isBVNOT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNOT;
    }

    public boolean isBVXOR() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BXOR;
    }

    public boolean isBVNAND() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNAND;
    }

    public boolean isBVNOR() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNOR;
    }

    public boolean isBVXNOR() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BXNOR;
    }

    public boolean isBVConcat() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CONCAT;
    }

    public boolean isBVSignExtension() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SIGN_EXT;
    }

    public boolean isBVZeroExtension() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ZERO_EXT;
    }

    public boolean isBVExtract() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXTRACT;
    }

    public boolean isBVRepeat() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_REPEAT;
    }

    public boolean isBVReduceOR() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BREDOR;
    }

    public boolean isBVReduceAND() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BREDAND;
    }

    public boolean isBVComp() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BCOMP;
    }

    public boolean isBVShiftLeft() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSHL;
    }

    public boolean isBVShiftRightLogical() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BLSHR;
    }

    public boolean isBVShiftRightArithmetic() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BASHR;
    }

    public boolean isBVRotateLeft() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ROTATE_LEFT;
    }

    public boolean isBVRotateRight() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ROTATE_RIGHT;
    }

    public boolean isBVRotateLeftExtended() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_LEFT;
    }

    public boolean isBVRotateRightExtended() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_RIGHT;
    }

    public boolean isIntToBV() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_INT2BV;
    }

    public boolean isBVToInt() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BV2INT;
    }

    public boolean isBVCarry() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CARRY;
    }

    public boolean isBVXOR3() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_XOR3;
    }

    public boolean isLabel() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LABEL;
    }

    public boolean isLabelLit() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LABEL_LIT;
    }

    public boolean isOEQ() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_OEQ;
    }

    public boolean isProofTrue() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRUE;
    }

    public boolean isProofAsserted() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_ASSERTED;
    }

    public boolean isProofGoal() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_GOAL;
    }

    public boolean isProofModusPonens() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS;
    }

    public boolean isProofReflexivity() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REFLEXIVITY;
    }

    public boolean isProofSymmetry() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_SYMMETRY;
    }

    public boolean isProofTransitivity() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY;
    }

    public boolean isProofTransitivityStar() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY_STAR;
    }

    public boolean isProofMonotonicity() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MONOTONICITY;
    }

    public boolean isProofQuantIntro() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INTRO;
    }

    public boolean isProofDistributivity() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DISTRIBUTIVITY;
    }

    public boolean isProofAndElimination() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_AND_ELIM;
    }

    public boolean isProofOrElimination() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NOT_OR_ELIM;
    }

    public boolean isProofRewrite() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE;
    }

    public boolean isProofRewriteStar() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE_STAR;
    }

    public boolean isProofPullQuant() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT;
    }

    public boolean isProofPullQuantStar() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT_STAR;
    }

    public boolean isProofPushQuant() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PUSH_QUANT;
    }

    public boolean isProofElimUnusedVars() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_ELIM_UNUSED_VARS;
    }

    public boolean isProofDER() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DER;
    }

    public boolean isProofQuantInst() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INST;
    }

    public boolean isProofHypothesis() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_HYPOTHESIS;
    }

    public boolean isProofLemma() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_LEMMA;
    }

    public boolean isProofUnitResolution() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_UNIT_RESOLUTION;
    }

    public boolean isProofIFFTrue() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_TRUE;
    }

    public boolean isProofIFFFalse() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_FALSE;
    }

    public boolean isProofCommutativity() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_COMMUTATIVITY;
    }

    public boolean isProofDefAxiom() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_AXIOM;
    }

    public boolean isProofDefIntro() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_INTRO;
    }

    public boolean isProofApplyDef() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_APPLY_DEF;
    }

    public boolean isProofIFFOEQ() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_OEQ;
    }

    public boolean isProofNNFPos() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_POS;
    }

    public boolean isProofNNFNeg() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_NEG;
    }

    public boolean isProofNNFStar() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_STAR;
    }

    public boolean isProofCNFStar() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_CNF_STAR;
    }

    public boolean isProofSkolemize() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_SKOLEMIZE;
    }

    public boolean isProofModusPonensOEQ() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS_OEQ;
    }

    public boolean isProofTheoryLemma() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TH_LEMMA;
    }

    public boolean isRelation() throws Z3Exception {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_RELATION_SORT.toInt();
    }

    public boolean isRelationStore() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_STORE;
    }

    public boolean isEmptyRelation() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_EMPTY;
    }

    public boolean isIsEmptyRelation() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_IS_EMPTY;
    }

    public boolean isRelationalJoin() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_JOIN;
    }

    public boolean isRelationUnion() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_UNION;
    }

    public boolean isRelationWiden() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_WIDEN;
    }

    public boolean isRelationProject() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_PROJECT;
    }

    public boolean isRelationFilter() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_FILTER;
    }

    public boolean isRelationNegationFilter() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_NEGATION_FILTER;
    }

    public boolean isRelationRename() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_RENAME;
    }

    public boolean isRelationComplement() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_COMPLEMENT;
    }

    public boolean isRelationSelect() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_SELECT;
    }

    public boolean isRelationClone() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_CLONE;
    }

    public boolean isFiniteDomain() throws Z3Exception {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_FINITE_DOMAIN_SORT.toInt();
    }

    public boolean isFiniteDomainLT() throws Z3Exception {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_FD_LT;
    }

    public int getIndex() throws Z3Exception {
        if (!this.isVar()) {
            throw new Z3Exception("Term is not a bound variable.");
        }
        return Native.getIndexValue(this.getContext().nCtx(), this.getNativeObject());
    }

    protected Expr(Context context) {
        super(context);
    }

    protected Expr(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void checkNativeObject(long l) throws Z3Exception {
        if (!Native.isApp(this.getContext().nCtx(), l) && Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_VAR_AST.toInt() && Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a term");
        }
        super.checkNativeObject(l);
    }

    static Expr create(Context context, FuncDecl funcDecl, Expr ... exprArray) throws Z3Exception {
        long l = Native.mkApp(context.nCtx(), funcDecl.getNativeObject(), AST.arrayLength(exprArray), AST.arrayToNative(exprArray));
        return Expr.create(context, l);
    }

    static Expr create(Context context, long l) throws Z3Exception {
        Z3_ast_kind z3_ast_kind = Z3_ast_kind.fromInt(Native.getAstKind(context.nCtx(), l));
        if (z3_ast_kind == Z3_ast_kind.Z3_QUANTIFIER_AST) {
            return new Quantifier(context, l);
        }
        long l2 = Native.getSort(context.nCtx(), l);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(context.nCtx(), l2));
        if (Native.isAlgebraicNumber(context.nCtx(), l)) {
            return new AlgebraicNum(context, l);
        }
        if (Native.isNumeralAst(context.nCtx(), l)) {
            switch (z3_sort_kind) {
                case Z3_INT_SORT: {
                    return new IntNum(context, l);
                }
                case Z3_REAL_SORT: {
                    return new RatNum(context, l);
                }
                case Z3_BV_SORT: {
                    return new BitVecNum(context, l);
                }
            }
        }
        switch (z3_sort_kind) {
            case Z3_BOOL_SORT: {
                return new BoolExpr(context, l);
            }
            case Z3_INT_SORT: {
                return new IntExpr(context, l);
            }
            case Z3_REAL_SORT: {
                return new RealExpr(context, l);
            }
            case Z3_BV_SORT: {
                return new BitVecExpr(context, l);
            }
            case Z3_ARRAY_SORT: {
                return new ArrayExpr(context, l);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeExpr(context, l);
            }
        }
        return new Expr(context, l);
    }
}

