/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;
import matlabcontrol.JMIWrapperRemote;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.RequestReceiver;

class RemoteMatlabProxy
extends MatlabProxy {
    private final JMIWrapperRemote _jmiWrapper;
    private final RequestReceiver _receiver;
    private final Timer _connectionTimer;
    private volatile boolean _isConnected = true;
    private static final int CONNECTION_CHECK_PERIOD = 1000;

    RemoteMatlabProxy(JMIWrapperRemote internalProxy, RequestReceiver receiver, MatlabProxy.Identifier id, boolean existingSession) {
        super(id, existingSession);
        this._connectionTimer = new Timer("MLC Connection Listener " + id);
        this._jmiWrapper = internalProxy;
        this._receiver = receiver;
    }

    void init() {
        this._connectionTimer.schedule((TimerTask)new CheckConnectionTask(), 1000L, 1000L);
    }

    @Override
    public boolean isRunningInsideMatlab() {
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this._isConnected) {
            boolean connected;
            try {
                this._jmiWrapper.checkConnection();
                connected = true;
            }
            catch (RemoteException e) {
                connected = false;
            }
            this._isConnected = connected;
        }
        return this._isConnected;
    }

    @Override
    public boolean disconnect() {
        this._connectionTimer.cancel();
        try {
            this._isConnected = !UnicastRemoteObject.unexportObject(this._receiver, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        return this.isConnected();
    }

    private <T> T invoke(RemoteInvocation<T> invocation) throws MatlabInvocationException {
        if (!this._isConnected) {
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException();
        }
        try {
            return invocation.invoke();
        }
        catch (UnmarshalException e) {
            throw MatlabInvocationException.Reason.UNMARSHAL.asException(e);
        }
        catch (MarshalException e) {
            throw MatlabInvocationException.Reason.MARSHAL.asException(e);
        }
        catch (RemoteException e) {
            if (this.isConnected()) {
                throw MatlabInvocationException.Reason.UNKNOWN.asException(e);
            }
            throw MatlabInvocationException.Reason.PROXY_NOT_CONNECTED.asException(e);
        }
    }

    @Override
    public void setVariable(final String variableName, final Object value) throws MatlabInvocationException {
        this.invoke(new RemoteInvocation<Void>(){

            @Override
            public Void invoke() throws RemoteException, MatlabInvocationException {
                RemoteMatlabProxy.this._jmiWrapper.setVariable(variableName, value);
                return null;
            }
        });
    }

    @Override
    public Object getVariable(final String variableName) throws MatlabInvocationException {
        return this.invoke(new RemoteInvocation<Object>(){

            @Override
            public Object invoke() throws RemoteException, MatlabInvocationException {
                return RemoteMatlabProxy.this._jmiWrapper.getVariable(variableName);
            }
        });
    }

    @Override
    public void exit() throws MatlabInvocationException {
        this.invoke(new RemoteInvocation<Void>(){

            @Override
            public Void invoke() throws RemoteException, MatlabInvocationException {
                RemoteMatlabProxy.this._jmiWrapper.exit();
                return null;
            }
        });
    }

    @Override
    public void eval(final String command) throws MatlabInvocationException {
        this.invoke(new RemoteInvocation<Void>(){

            @Override
            public Void invoke() throws RemoteException, MatlabInvocationException {
                RemoteMatlabProxy.this._jmiWrapper.eval(command);
                return null;
            }
        });
    }

    @Override
    public Object[] returningEval(final String command, final int nargout) throws MatlabInvocationException {
        return this.invoke(new RemoteInvocation<Object[]>(){

            @Override
            public Object[] invoke() throws RemoteException, MatlabInvocationException {
                return RemoteMatlabProxy.this._jmiWrapper.returningEval(command, nargout);
            }
        });
    }

    @Override
    public void feval(final String functionName, final Object ... args) throws MatlabInvocationException {
        this.invoke(new RemoteInvocation<Void>(){

            @Override
            public Void invoke() throws RemoteException, MatlabInvocationException {
                RemoteMatlabProxy.this._jmiWrapper.feval(functionName, args);
                return null;
            }
        });
    }

    @Override
    public Object[] returningFeval(final String functionName, final int nargout, final Object ... args) throws MatlabInvocationException {
        return this.invoke(new RemoteInvocation<Object[]>(){

            @Override
            public Object[] invoke() throws RemoteException, MatlabInvocationException {
                return RemoteMatlabProxy.this._jmiWrapper.returningFeval(functionName, nargout, args);
            }
        });
    }

    @Override
    public <T> T invokeAndWait(final MatlabProxy.MatlabThreadCallable<T> callable) throws MatlabInvocationException {
        return this.invoke(new RemoteInvocation<T>(){

            @Override
            public T invoke() throws RemoteException, MatlabInvocationException {
                return RemoteMatlabProxy.this._jmiWrapper.invokeAndWait(callable);
            }
        });
    }

    private static interface RemoteInvocation<T> {
        public T invoke() throws RemoteException, MatlabInvocationException;
    }

    private class CheckConnectionTask
    extends TimerTask {
        private CheckConnectionTask() {
        }

        @Override
        public void run() {
            if (!RemoteMatlabProxy.this.isConnected()) {
                RemoteMatlabProxy.this.disconnect();
                RemoteMatlabProxy.this.notifyDisconnectionListeners();
                RemoteMatlabProxy.this._connectionTimer.cancel();
            }
        }
    }
}

