/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_parameter_kind;

public class FuncDecl
extends AST {
    @Override
    public boolean equals(Object object) {
        FuncDecl funcDecl = (FuncDecl)object;
        if (funcDecl == null) {
            return false;
        }
        return this == funcDecl;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        try {
            return Native.funcDeclToString(this.getContext().nCtx(), this.getNativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    @Override
    public int getId() throws Z3Exception {
        return Native.getFuncDeclId(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getArity() throws Z3Exception {
        return Native.getArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getDomainSize() throws Z3Exception {
        return Native.getDomainSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort[] getDomain() throws Z3Exception {
        int n = this.getDomainSize();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this.getContext(), Native.getDomain(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return sortArray;
    }

    public Sort getRange() throws Z3Exception {
        return Sort.create(this.getContext(), Native.getRange(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Z3_decl_kind getDeclKind() throws Z3Exception {
        return Z3_decl_kind.fromInt(Native.getDeclKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Symbol getName() throws Z3Exception {
        return Symbol.create(this.getContext(), Native.getDeclName(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumParameters() throws Z3Exception {
        return Native.getDeclNumParameters(this.getContext().nCtx(), this.getNativeObject());
    }

    public Parameter[] getParameters() throws Z3Exception {
        int n = this.getNumParameters();
        Parameter[] parameterArray = new Parameter[n];
        block9: for (int i = 0; i < n; ++i) {
            Z3_parameter_kind z3_parameter_kind = Z3_parameter_kind.fromInt(Native.getDeclParameterKind(this.getContext().nCtx(), this.getNativeObject(), i));
            switch (z3_parameter_kind) {
                case Z3_PARAMETER_INT: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclIntParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_DOUBLE: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclDoubleParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_SYMBOL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Symbol.create(this.getContext(), Native.getDeclSymbolParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_SORT: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Sort.create(this.getContext(), Native.getDeclSortParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_AST: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, new AST(this.getContext(), Native.getDeclAstParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_FUNC_DECL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, new FuncDecl(this.getContext(), Native.getDeclFuncDeclParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_RATIONAL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclRationalParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                default: {
                    throw new Z3Exception("Unknown function declaration parameter kind encountered");
                }
            }
        }
        return parameterArray;
    }

    FuncDecl(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    FuncDecl(Context context, Symbol symbol, Sort[] sortArray, Sort sort) throws Z3Exception {
        super(context, Native.mkFuncDecl(context.nCtx(), symbol.getNativeObject(), AST.arrayLength(sortArray), AST.arrayToNative(sortArray), sort.getNativeObject()));
    }

    FuncDecl(Context context, String string, Sort[] sortArray, Sort sort) throws Z3Exception {
        super(context, Native.mkFreshFuncDecl(context.nCtx(), string, AST.arrayLength(sortArray), AST.arrayToNative(sortArray), sort.getNativeObject()));
    }

    @Override
    void checkNativeObject(long l) throws Z3Exception {
        if (Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_FUNC_DECL_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a function declaration");
        }
        super.checkNativeObject(l);
    }

    public Expr apply(Expr ... exprArray) throws Z3Exception {
        this.getContext().checkContextMatch(exprArray);
        return Expr.create(this.getContext(), this, exprArray);
    }

    public class Parameter {
        private Z3_parameter_kind kind;
        private int i;
        private double d;
        private Symbol sym;
        private Sort srt;
        private AST ast;
        private FuncDecl fd;
        private String r;

        public int getInt() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_INT) {
                throw new Z3Exception("parameter is not an int");
            }
            return this.i;
        }

        public double getDouble() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_DOUBLE) {
                throw new Z3Exception("parameter is not a double ");
            }
            return this.d;
        }

        public Symbol getSymbol() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SYMBOL) {
                throw new Z3Exception("parameter is not a Symbol");
            }
            return this.sym;
        }

        public Sort getSort() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SORT) {
                throw new Z3Exception("parameter is not a Sort");
            }
            return this.srt;
        }

        public AST getAST() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_AST) {
                throw new Z3Exception("parameter is not an AST");
            }
            return this.ast;
        }

        public FuncDecl getFuncDecl() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_FUNC_DECL) {
                throw new Z3Exception("parameter is not a function declaration");
            }
            return this.fd;
        }

        public String getRational() throws Z3Exception {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_RATIONAL) {
                throw new Z3Exception("parameter is not a rational String");
            }
            return this.r;
        }

        public Z3_parameter_kind getParameterKind() throws Z3Exception {
            return this.kind;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, int n) {
            this.kind = z3_parameter_kind;
            this.i = n;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, double d) {
            this.kind = z3_parameter_kind;
            this.d = d;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, Symbol symbol) {
            this.kind = z3_parameter_kind;
            this.sym = symbol;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, Sort sort) {
            this.kind = z3_parameter_kind;
            this.srt = sort;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, AST aST) {
            this.kind = z3_parameter_kind;
            this.ast = aST;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, FuncDecl funcDecl2) {
            this.kind = z3_parameter_kind;
            this.fd = funcDecl2;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, String string) {
            this.kind = z3_parameter_kind;
            this.r = string;
        }
    }
}

