/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ApplyResult;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_goal_prec;

public class Goal
extends Z3Object {
    public Z3_goal_prec getPrecision() throws Z3Exception {
        return Z3_goal_prec.fromInt(Native.goalPrecision(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isPrecise() throws Z3Exception {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_PRECISE;
    }

    public boolean isUnderApproximation() throws Z3Exception {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER;
    }

    public boolean isOverApproximation() throws Z3Exception {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_OVER;
    }

    public boolean isGarbage() throws Z3Exception {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER_OVER;
    }

    public void add(BoolExpr ... boolExprArray) throws Z3Exception {
        this.getContext().checkContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.goalAssert(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject());
        }
    }

    public boolean inconsistent() throws Z3Exception {
        return Native.goalInconsistent(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getDepth() throws Z3Exception {
        return Native.goalDepth(this.getContext().nCtx(), this.getNativeObject());
    }

    public void reset() throws Z3Exception {
        Native.goalReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public int size() throws Z3Exception {
        return Native.goalSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public BoolExpr[] getFormulas() throws Z3Exception {
        int n = this.size();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = new BoolExpr(this.getContext(), Native.goalFormula(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return boolExprArray;
    }

    public int getNumExprs() throws Z3Exception {
        return Native.goalNumExprs(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedSat() throws Z3Exception {
        return Native.goalIsDecidedSat(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedUnsat() throws Z3Exception {
        return Native.goalIsDecidedUnsat(this.getContext().nCtx(), this.getNativeObject());
    }

    public Goal translate(Context context) throws Z3Exception {
        return new Goal(context, Native.goalTranslate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    public Goal simplify() throws Z3Exception {
        Tactic tactic = this.getContext().mkTactic("simplify");
        ApplyResult applyResult = tactic.apply(this);
        if (applyResult.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return applyResult.getSubgoals()[0];
    }

    public Goal simplify(Params params) throws Z3Exception {
        Tactic tactic = this.getContext().mkTactic("simplify");
        ApplyResult applyResult = tactic.apply(this, params);
        if (applyResult.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return applyResult.getSubgoals()[0];
    }

    public String toString() {
        try {
            return Native.goalToString(this.getContext().nCtx(), this.getNativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    Goal(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    Goal(Context context, boolean bl, boolean bl2, boolean bl3) throws Z3Exception {
        super(context, Native.mkGoal(context.nCtx(), bl, bl2, bl3));
    }

    @Override
    void incRef(long l) throws Z3Exception {
        this.getContext().goal_DRQ().incAndClear(this.getContext(), l);
        super.incRef(l);
    }

    @Override
    void decRef(long l) throws Z3Exception {
        this.getContext().goal_DRQ().add(l);
        super.decRef(l);
    }
}

