/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_lbool;

public class Solver
extends Z3Object {
    public String getHelp() throws Z3Exception {
        return Native.solverGetHelp(this.getContext().nCtx(), this.getNativeObject());
    }

    public void setParameters(Params params) throws Z3Exception {
        this.getContext().checkContextMatch(params);
        Native.solverSetParams(this.getContext().nCtx(), this.getNativeObject(), params.getNativeObject());
    }

    public ParamDescrs getParameterDescriptions() throws Z3Exception {
        return new ParamDescrs(this.getContext(), Native.solverGetParamDescrs(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumScopes() throws Z3Exception {
        return Native.solverGetNumScopes(this.getContext().nCtx(), this.getNativeObject());
    }

    public void push() throws Z3Exception {
        Native.solverPush(this.getContext().nCtx(), this.getNativeObject());
    }

    public void pop() throws Z3Exception {
        this.pop(1);
    }

    public void pop(int n) throws Z3Exception {
        Native.solverPop(this.getContext().nCtx(), this.getNativeObject(), n);
    }

    public void reset() throws Z3Exception {
        Native.solverReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public void add(BoolExpr ... boolExprArray) throws Z3Exception {
        this.getContext().checkContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.solverAssert(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject());
        }
    }

    public void assertAndTrack(BoolExpr[] boolExprArray, BoolExpr[] boolExprArray2) throws Z3Exception {
        this.getContext().checkContextMatch(boolExprArray);
        this.getContext().checkContextMatch(boolExprArray2);
        if (boolExprArray.length != boolExprArray2.length) {
            throw new Z3Exception("Argument size mismatch");
        }
        for (int i = 0; i < boolExprArray.length; ++i) {
            Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), boolExprArray[i].getNativeObject(), boolExprArray2[i].getNativeObject());
        }
    }

    public void assertAndTrack(BoolExpr boolExpr, BoolExpr boolExpr2) throws Z3Exception {
        this.getContext().checkContextMatch(boolExpr);
        this.getContext().checkContextMatch(boolExpr2);
        Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject(), boolExpr2.getNativeObject());
    }

    public int getNumAssertions() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return aSTVector.size();
    }

    public BoolExpr[] getAssertions() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        int n = aSTVector.size();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = new BoolExpr(this.getContext(), aSTVector.get(i).getNativeObject());
        }
        return boolExprArray;
    }

    public Status check(Expr ... exprArray) throws Z3Exception {
        Z3_lbool z3_lbool = exprArray == null ? Z3_lbool.fromInt(Native.solverCheck(this.getContext().nCtx(), this.getNativeObject())) : Z3_lbool.fromInt(Native.solverCheckAssumptions(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, AST.arrayToNative(exprArray)));
        switch (z3_lbool) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    public Status check() throws Z3Exception {
        return this.check(null);
    }

    public Model getModel() throws Z3Exception {
        long l = Native.solverGetModel(this.getContext().nCtx(), this.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return new Model(this.getContext(), l);
    }

    public Expr getProof() throws Z3Exception {
        long l = Native.solverGetProof(this.getContext().nCtx(), this.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), l);
    }

    public Expr[] getUnsatCore() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetUnsatCore(this.getContext().nCtx(), this.getNativeObject()));
        int n = aSTVector.size();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.create(this.getContext(), aSTVector.get(i).getNativeObject());
        }
        return exprArray;
    }

    public String getReasonUnknown() throws Z3Exception {
        return Native.solverGetReasonUnknown(this.getContext().nCtx(), this.getNativeObject());
    }

    public Statistics getStatistics() throws Z3Exception {
        return new Statistics(this.getContext(), Native.solverGetStatistics(this.getContext().nCtx(), this.getNativeObject()));
    }

    public String toString() {
        try {
            return Native.solverToString(this.getContext().nCtx(), this.getNativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    Solver(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void incRef(long l) throws Z3Exception {
        this.getContext().solver_DRQ().incAndClear(this.getContext(), l);
        super.incRef(l);
    }

    @Override
    void decRef(long l) throws Z3Exception {
        this.getContext().solver_DRQ().add(l);
        super.decRef(l);
    }
}

