/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class FuncInterp
extends Z3Object {
    public int getNumEntries() {
        return Native.funcInterpGetNumEntries(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry[] getEntries() {
        int n = this.getNumEntries();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[i] = new Entry(this.getContext(), Native.funcInterpGetEntry(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return entryArray;
    }

    public Expr getElse() {
        return Expr.create(this.getContext(), Native.funcInterpGetElse(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getArity() {
        return Native.funcInterpGetArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        try {
            String string = "";
            string = string + "[";
            for (Entry entry : this.getEntries()) {
                int n = entry.getNumArgs();
                if (n > 1) {
                    string = string + "[";
                }
                Expr[] exprArray = entry.getArgs();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        string = string + ", ";
                    }
                    string = string + exprArray[i];
                }
                if (n > 1) {
                    string = string + "]";
                }
                string = string + " -> " + entry.getValue() + ", ";
            }
            string = string + "else -> " + this.getElse();
            string = string + "]";
            return string;
        }
        catch (Z3Exception z3Exception) {
            return new String("Z3Exception: " + z3Exception.getMessage());
        }
    }

    FuncInterp(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef(long l) {
        this.getContext().getFuncInterpDRQ().incAndClear(this.getContext(), l);
        super.incRef(l);
    }

    @Override
    void decRef(long l) {
        this.getContext().getFuncInterpDRQ().add(l);
        super.decRef(l);
    }

    public class Entry
    extends Z3Object {
        public Expr getValue() {
            return Expr.create(this.getContext(), Native.funcEntryGetValue(this.getContext().nCtx(), this.getNativeObject()));
        }

        public int getNumArgs() {
            return Native.funcEntryGetNumArgs(this.getContext().nCtx(), this.getNativeObject());
        }

        public Expr[] getArgs() {
            int n = this.getNumArgs();
            Expr[] exprArray = new Expr[n];
            for (int i = 0; i < n; ++i) {
                exprArray[i] = Expr.create(this.getContext(), Native.funcEntryGetArg(this.getContext().nCtx(), this.getNativeObject(), i));
            }
            return exprArray;
        }

        public String toString() {
            try {
                int n = this.getNumArgs();
                String string = "[";
                Expr[] exprArray = this.getArgs();
                for (int i = 0; i < n; ++i) {
                    string = string + exprArray[i] + ", ";
                }
                return string + this.getValue() + "]";
            }
            catch (Z3Exception z3Exception) {
                return new String("Z3Exception: " + z3Exception.getMessage());
            }
        }

        Entry(Context context, long l) {
            super(context, l);
        }

        @Override
        void incRef(long l) {
            this.getContext().getFuncEntryDRQ().incAndClear(this.getContext(), l);
            super.incRef(l);
        }

        @Override
        void decRef(long l) {
            this.getContext().getFuncEntryDRQ().add(l);
            super.decRef(l);
        }
    }
}

