/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.Map;

public class InterpolationContext
extends Context {
    public InterpolationContext() {
        this.m_ctx = Native.mkInterpolationContext(0L);
        this.initContext();
    }

    public InterpolationContext(Map<String, String> map) {
        long l = Native.mkConfig();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Native.setParamValue(l, entry.getKey(), entry.getValue());
        }
        this.m_ctx = Native.mkInterpolationContext(l);
        Native.delConfig(l);
        this.initContext();
    }

    public BoolExpr MkInterpolant(BoolExpr boolExpr) {
        this.checkContextMatch(boolExpr);
        return new BoolExpr(this, Native.mkInterpolant(this.nCtx(), boolExpr.getNativeObject()));
    }

    public Expr[] GetInterpolant(Expr expr, Expr expr2, Params params) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        this.checkContextMatch(params);
        ASTVector aSTVector = new ASTVector(this, Native.getInterpolant(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), params.getNativeObject()));
        int n = aSTVector.size();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.create(this, aSTVector.get(i).getNativeObject());
        }
        return exprArray;
    }

    public Z3_lbool ComputeInterpolant(Expr expr, Params params, ASTVector aSTVector, Model model) {
        this.checkContextMatch(expr);
        this.checkContextMatch(params);
        Native.LongPtr longPtr = new Native.LongPtr();
        Native.LongPtr longPtr2 = new Native.LongPtr();
        int n = Native.computeInterpolant(this.nCtx(), expr.getNativeObject(), params.getNativeObject(), longPtr, longPtr2);
        aSTVector = new ASTVector(this, longPtr.value);
        model = new Model(this, longPtr2.value);
        return Z3_lbool.fromInt(n);
    }

    public String InterpolationProfile() {
        return Native.interpolationProfile(this.nCtx());
    }

    public int CheckInterpolant(Expr[] exprArray, int[] nArray, Expr[] exprArray2, String string, Expr[] exprArray3) {
        Native.StringPtr stringPtr = new Native.StringPtr();
        int n = Native.checkInterpolant(this.nCtx(), exprArray.length, Expr.arrayToNative(exprArray), nArray, Expr.arrayToNative(exprArray2), stringPtr, exprArray3.length, Expr.arrayToNative(exprArray3));
        string = stringPtr.value;
        return n;
    }

    public int ReadInterpolationProblem(String string, Expr[] exprArray, int[] nArray, String string2, Expr[] exprArray2) {
        int n;
        Native.IntPtr intPtr = new Native.IntPtr();
        Native.IntPtr intPtr2 = new Native.IntPtr();
        Native.ObjArrayPtr objArrayPtr = new Native.ObjArrayPtr();
        Native.UIntArrayPtr uIntArrayPtr = new Native.UIntArrayPtr();
        Native.ObjArrayPtr objArrayPtr2 = new Native.ObjArrayPtr();
        Native.StringPtr stringPtr = new Native.StringPtr();
        int n2 = Native.readInterpolationProblem(this.nCtx(), intPtr, objArrayPtr, uIntArrayPtr, string, stringPtr, intPtr2, objArrayPtr2);
        int n3 = intPtr.value;
        int n4 = intPtr2.value;
        string2 = stringPtr.value;
        exprArray = new Expr[n3];
        nArray = new int[n3];
        exprArray2 = new Expr[n4];
        for (n = 0; n < n3; ++n) {
            exprArray[n] = Expr.create(this, objArrayPtr.value[n]);
            nArray[n] = uIntArrayPtr.value[n];
        }
        for (n = 0; n < n4; ++n) {
            exprArray2[n] = Expr.create(this, objArrayPtr2.value[n]);
        }
        return n2;
    }

    public void WriteInterpolationProblem(String string, Expr[] exprArray, int[] nArray, String string2, Expr[] exprArray2) {
        Native.writeInterpolationProblem(this.nCtx(), exprArray.length, Expr.arrayToNative(exprArray), nArray, string, exprArray2.length, Expr.arrayToNative(exprArray2));
    }
}

