/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Model
extends Z3Object {
    public Expr getConstInterp(Expr expr) {
        this.getContext().checkContextMatch(expr);
        return this.getConstInterp(expr.getFuncDecl());
    }

    public Expr getConstInterp(FuncDecl funcDecl) {
        this.getContext().checkContextMatch(funcDecl);
        if (funcDecl.getArity() != 0 || Native.getSortKind(this.getContext().nCtx(), Native.getRange(this.getContext().nCtx(), funcDecl.getNativeObject())) == Z3_sort_kind.Z3_ARRAY_SORT.toInt()) {
            throw new Z3Exception("Non-zero arity functions and arrays have FunctionInterpretations as a model. Use FuncInterp.");
        }
        long l = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), l);
    }

    public FuncInterp getFuncInterp(FuncDecl funcDecl) {
        this.getContext().checkContextMatch(funcDecl);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), Native.getRange(this.getContext().nCtx(), funcDecl.getNativeObject())));
        if (funcDecl.getArity() == 0) {
            long l = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
            if (z3_sort_kind == Z3_sort_kind.Z3_ARRAY_SORT) {
                if (l == 0L) {
                    return null;
                }
                if (Native.isAsArray(this.getContext().nCtx(), l) ^ true) {
                    throw new Z3Exception("Argument was not an array constant");
                }
                long l2 = Native.getAsArrayFuncDecl(this.getContext().nCtx(), l);
                return this.getFuncInterp(new FuncDecl(this.getContext(), l2));
            }
            throw new Z3Exception("Constant functions do not have a function interpretation; use ConstInterp");
        }
        long l = Native.modelGetFuncInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return new FuncInterp(this.getContext(), l);
    }

    public int getNumConsts() {
        return Native.modelGetNumConsts(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl[] getConstDecls() {
        int n = this.getNumConsts();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return funcDeclArray;
    }

    public int getNumFuncs() {
        return Native.modelGetNumFuncs(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl[] getFuncDecls() {
        int n = this.getNumFuncs();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return funcDeclArray;
    }

    public FuncDecl[] getDecls() {
        int n;
        int n2 = this.getNumFuncs();
        int n3 = this.getNumConsts();
        int n4 = n2 + n3;
        FuncDecl[] funcDeclArray = new FuncDecl[n4];
        for (n = 0; n < n3; ++n) {
            funcDeclArray[n] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), n));
        }
        for (n = 0; n < n2; ++n) {
            funcDeclArray[n3 + n] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), n));
        }
        return funcDeclArray;
    }

    public Expr eval(Expr expr, boolean bl) {
        Native.LongPtr longPtr = new Native.LongPtr();
        if (Native.modelEval(this.getContext().nCtx(), this.getNativeObject(), expr.getNativeObject(), bl, longPtr) ^ true) {
            throw new ModelEvaluationFailedException();
        }
        return Expr.create(this.getContext(), longPtr.value);
    }

    public Expr evaluate(Expr expr, boolean bl) {
        return this.eval(expr, bl);
    }

    public int getNumSorts() {
        return Native.modelGetNumSorts(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort[] getSorts() {
        int n = this.getNumSorts();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this.getContext(), Native.modelGetSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return sortArray;
    }

    public Expr[] getSortUniverse(Sort sort) {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.modelGetSortUniverse(this.getContext().nCtx(), this.getNativeObject(), sort.getNativeObject()));
        int n = aSTVector.size();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.create(this.getContext(), aSTVector.get(i).getNativeObject());
        }
        return exprArray;
    }

    public String toString() {
        try {
            return Native.modelToString(this.getContext().nCtx(), this.getNativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    Model(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef(long l) {
        this.getContext().getModelDRQ().incAndClear(this.getContext(), l);
        super.incRef(l);
    }

    @Override
    void decRef(long l) {
        this.getContext().getModelDRQ().add(l);
        super.decRef(l);
    }

    public class ModelEvaluationFailedException
    extends Z3Exception {
    }
}

