/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;

public class Quantifier
extends BoolExpr {
    public boolean isUniversal() {
        return Native.isQuantifierForall(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isExistential() {
        return !this.isUniversal();
    }

    public int getWeight() {
        return Native.getQuantifierWeight(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getNumPatterns() {
        return Native.getQuantifierNumPatterns(this.getContext().nCtx(), this.getNativeObject());
    }

    public Pattern[] getPatterns() {
        int n = this.getNumPatterns();
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            patternArray[i] = new Pattern(this.getContext(), Native.getQuantifierPatternAst(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return patternArray;
    }

    public int getNumNoPatterns() {
        return Native.getQuantifierNumNoPatterns(this.getContext().nCtx(), this.getNativeObject());
    }

    public Pattern[] getNoPatterns() {
        int n = this.getNumNoPatterns();
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            patternArray[i] = new Pattern(this.getContext(), Native.getQuantifierNoPatternAst(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return patternArray;
    }

    public int getNumBound() {
        return Native.getQuantifierNumBound(this.getContext().nCtx(), this.getNativeObject());
    }

    public Symbol[] getBoundVariableNames() {
        int n = this.getNumBound();
        Symbol[] symbolArray = new Symbol[n];
        for (int i = 0; i < n; ++i) {
            symbolArray[i] = Symbol.create(this.getContext(), Native.getQuantifierBoundName(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return symbolArray;
    }

    public Sort[] getBoundVariableSorts() {
        int n = this.getNumBound();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this.getContext(), Native.getQuantifierBoundSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return sortArray;
    }

    public BoolExpr getBody() {
        return new BoolExpr(this.getContext(), Native.getQuantifierBody(this.getContext().nCtx(), this.getNativeObject()));
    }

    Quantifier(Context context, boolean bl, Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) {
        super(context, 0L);
        this.getContext().checkContextMatch(patternArray);
        this.getContext().checkContextMatch(exprArray);
        this.getContext().checkContextMatch(sortArray);
        this.getContext().checkContextMatch(symbolArray);
        this.getContext().checkContextMatch(expr);
        if (sortArray.length != symbolArray.length) {
            throw new Z3Exception("Number of sorts does not match number of names");
        }
        if (exprArray == null && symbol == null && symbol2 == null) {
            this.setNativeObject(Native.mkQuantifier(context.nCtx(), bl, n, AST.arrayLength(patternArray), AST.arrayToNative(patternArray), AST.arrayLength(sortArray), AST.arrayToNative(sortArray), Symbol.arrayToNative(symbolArray), expr.getNativeObject()));
        } else {
            this.setNativeObject(Native.mkQuantifierEx(context.nCtx(), bl, n, AST.getNativeObject(symbol), AST.getNativeObject(symbol2), AST.arrayLength(patternArray), AST.arrayToNative(patternArray), AST.arrayLength(exprArray), AST.arrayToNative(exprArray), AST.arrayLength(sortArray), AST.arrayToNative(sortArray), Symbol.arrayToNative(symbolArray), expr.getNativeObject()));
        }
    }

    Quantifier(Context context, boolean bl, Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) {
        super(context, 0L);
        this.getContext().checkContextMatch(exprArray2);
        this.getContext().checkContextMatch(patternArray);
        this.getContext().checkContextMatch(expr);
        if (exprArray2 == null && symbol == null && symbol2 == null) {
            this.setNativeObject(Native.mkQuantifierConst(context.nCtx(), bl, n, AST.arrayLength(exprArray), AST.arrayToNative(exprArray), AST.arrayLength(patternArray), AST.arrayToNative(patternArray), expr.getNativeObject()));
        } else {
            this.setNativeObject(Native.mkQuantifierConstEx(context.nCtx(), bl, n, AST.getNativeObject(symbol), AST.getNativeObject(symbol2), AST.arrayLength(exprArray), AST.arrayToNative(exprArray), AST.arrayLength(patternArray), AST.arrayToNative(patternArray), AST.arrayLength(exprArray2), AST.arrayToNative(exprArray2), expr.getNativeObject()));
        }
    }

    Quantifier(Context context, long l) {
        super(context, l);
    }

    @Override
    void checkNativeObject(long l) {
        if (Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a quantifier");
        }
        super.checkNativeObject(l);
    }
}

