/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class Statistics
extends Z3Object {
    public String toString() {
        try {
            return Native.statsToString(this.getContext().nCtx(), this.getNativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    public int size() {
        return Native.statsSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry[] getEntries() {
        int n = this.size();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            Entry entry;
            String string = Native.statsGetKey(this.getContext().nCtx(), this.getNativeObject(), i);
            if (Native.statsIsUint(this.getContext().nCtx(), this.getNativeObject(), i)) {
                entry = new Entry(string, Native.statsGetUintValue(this.getContext().nCtx(), this.getNativeObject(), i));
            } else if (Native.statsIsDouble(this.getContext().nCtx(), this.getNativeObject(), i)) {
                entry = new Entry(string, Native.statsGetDoubleValue(this.getContext().nCtx(), this.getNativeObject(), i));
            } else {
                throw new Z3Exception("Unknown data entry value");
            }
            entryArray[i] = entry;
        }
        return entryArray;
    }

    public String[] getKeys() {
        int n = this.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.statsGetKey(this.getContext().nCtx(), this.getNativeObject(), i);
        }
        return stringArray;
    }

    public Entry get(String string) {
        int n = this.size();
        Entry[] entryArray = this.getEntries();
        for (int i = 0; i < n; ++i) {
            if (entryArray[i].Key != string) continue;
            return entryArray[i];
        }
        return null;
    }

    Statistics(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef(long l) {
        this.getContext().getStatisticsDRQ().incAndClear(this.getContext(), l);
        super.incRef(l);
    }

    @Override
    void decRef(long l) {
        this.getContext().getStatisticsDRQ().add(l);
        super.decRef(l);
    }

    public class Entry {
        public String Key;
        private boolean m_is_int = false;
        private boolean m_is_double = false;
        private int m_int = 0;
        private double m_double = 0.0;

        public int getUIntValue() {
            return this.m_int;
        }

        public double getDoubleValue() {
            return this.m_double;
        }

        public boolean isUInt() {
            return this.m_is_int;
        }

        public boolean isDouble() {
            return this.m_is_double;
        }

        public String getValueString() {
            if (this.isUInt()) {
                return Integer.toString(this.m_int);
            }
            if (this.isDouble()) {
                return Double.toString(this.m_double);
            }
            throw new Z3Exception("Unknown statistical entry type");
        }

        public String toString() {
            try {
                return this.Key + ": " + this.getValueString();
            }
            catch (Z3Exception z3Exception) {
                return new String("Z3Exception: " + z3Exception.getMessage());
            }
        }

        Entry(String string, int n) {
            this.Key = string;
            this.m_is_int = true;
            this.m_int = n;
        }

        Entry(String string, double d) {
            this.Key = string;
            this.m_is_double = true;
            this.m_double = d;
        }
    }
}

