'''
Created by Hyst v1.5
Hybrid Automaton in PySim
Converted from file: ./output/solved_with_spaceex/stable/A1_1__for_pysim__..spaceex.xml
Command Line arguments: -i ./output/solved_with_spaceex/stable/A1_1__for_pysim__..spaceex.xml -o ./output/solved_with_spaceex/stable/A1_1_pysim.py -tool pysim "-star True -corners True -rand 50 -xdim 1 -ydim 2"
'''

import math
import hybridpy.pysim.simulate as sim
from hybridpy.pysim.simulate import init_list_to_q_list, PySimSettings
from hybridpy.pysim.hybrid_automaton import HybridAutomaton, HyperRectangle

def define_ha():
    '''make the hybrid automaton and return it'''

    ha = HybridAutomaton()
    ha.variables = ["tau", "t", "x_p_1", "y_sampled_1", "x_d_1", "u_1", "Sample_y_1_pseudorandom_state", "Actuate_1_pseudorandom_state"]


    wait_wait_always_tick_always_always = ha.new_mode('wait_wait_always_tick_always_always')
    wait_wait_always_tick_always_always.inv = lambda state: state[0] <= 0.002 and state[0] <= 0.002 and -1.0 / 2.0 <= state[0] and state[0] <= 1.0 / 2.0
    wait_wait_always_tick_always_always.der = lambda _, state: [1.0, 1.0, 0.05 * state[2] + 0.5 * state[5], 0.0, 0.0, 0.0, 0.0, 0.0]
    wait_wait_always_tick_always_always.der_interval_list = [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]

    wait_done_always_tick_always_always = ha.new_mode('wait_done_always_tick_always_always')
    wait_done_always_tick_always_always.inv = lambda state: state[0] <= 0.002 and -1.0 / 2.0 <= state[0] and state[0] <= 1.0 / 2.0
    wait_done_always_tick_always_always.der = lambda _, state: [1.0, 1.0, 0.05 * state[2] + 0.5 * state[5], 0.0, 0.0, 0.0, 0.0, 0.0]
    wait_done_always_tick_always_always.der_interval_list = [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]

    done_wait_always_tick_always_always = ha.new_mode('done_wait_always_tick_always_always')
    done_wait_always_tick_always_always.inv = lambda state: state[0] <= 0.002 and -1.0 / 2.0 <= state[0] and state[0] <= 1.0 / 2.0
    done_wait_always_tick_always_always.der = lambda _, state: [1.0, 1.0, 0.05 * state[2] + 0.5 * state[5], 0.0, 0.0, 0.0, 0.0, 0.0]
    done_wait_always_tick_always_always.der_interval_list = [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]

    done_done_always_tick_always_always = ha.new_mode('done_done_always_tick_always_always')
    done_done_always_tick_always_always.inv = lambda state: -1.0 / 2.0 <= state[0] and state[0] <= 1.0 / 2.0
    done_done_always_tick_always_always.der = lambda _, state: [1.0, 1.0, 0.05 * state[2] + 0.5 * state[5], 0.0, 0.0, 0.0, 0.0, 0.0]
    done_done_always_tick_always_always.der_interval_list = [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]

    t = ha.new_transition(wait_wait_always_tick_always_always, done_wait_always_tick_always_always)
    t.guard = lambda state: state[0] >= -0.1 + state[6] * (0.002 - -0.1)
    t.reset = lambda state: [None, None, None, state[2] * 1.0 + 0.0, None, None, None, None]

    t = ha.new_transition(wait_done_always_tick_always_always, done_done_always_tick_always_always)
    t.guard = lambda state: state[0] >= -0.1 + state[6] * (0.002 - -0.1)
    t.reset = lambda state: [None, None, None, state[2] * 1.0 + 0.0, None, None, None, None]

    t = ha.new_transition(wait_wait_always_tick_always_always, wait_done_always_tick_always_always)
    t.guard = lambda state: state[0] >= -0.001 + state[7] * (0.002 - -0.001)
    t.reset = lambda state: [None, None, None, None, None, state[4] * 1.0 + 0.0, None, None]

    t = ha.new_transition(done_wait_always_tick_always_always, done_done_always_tick_always_always)
    t.guard = lambda state: state[0] >= -0.001 + state[7] * (0.002 - -0.001)
    t.reset = lambda state: [None, None, None, None, None, state[4] * 1.0 + 0.0, None, None]

    t = ha.new_transition(done_done_always_tick_always_always, wait_wait_always_tick_always_always)
    t.guard = lambda state: state[0] >= 1.0 / 2.0
    t.reset = lambda state: [-1.0 / 2.0, None, None, None, -0.4 * state[3] + -0.01 * state[4] + 0.0, None, 0.5 + 0.5 * math.cos(1234.0 * state[6]), 0.5 + 0.5 * math.cos(1234.0 * state[7])]

    return ha

def define_init_states(ha):
    '''returns a list of (mode, HyperRectangle)'''
    # Variable ordering: [tau, t, x_p_1, y_sampled_1, x_d_1, u_1, Sample_y_1_pseudorandom_state, Actuate_1_pseudorandom_state]
    rv = []
    
    rv.append((ha.modes['done_done_always_tick_always_always'],HyperRectangle([(0, 0), (0, 0), (-1, 1), (0, 0), (0, 0), (0, 0), (0.5, 0.7495), (0, 0.2495)])))
    return rv


def define_settings():
    '''defines the automaton / plot settings'''
    s = PySimSettings()
    s.max_time = 25.0
    s.step = 0.001
    s.dim_x = 1
    s.dim_y = 2

    return s

def simulate(init_states, settings):
    '''simulate the automaton from each initial rect'''

    q_list = init_list_to_q_list(init_states, center=True, star=True, corners=True, rand=50)
    result = sim.simulate_multi(q_list, settings.max_time)

    return result

def plot(result, init_states, image_path, settings):
    '''plot a simulation result to a file'''

    draw_events = len(result) == 1
    shouldShow = False
    sim.plot_sim_result_multi(result, settings.dim_x, settings.dim_y, image_path, draw_events, legend=True, title='Simulation', show=shouldShow, init_states=init_states)

if __name__ == '__main__':
    ha = define_ha()
    settings = define_settings()
    init_states = define_init_states(ha)
    plot(simulate(init_states, settings), init_states, 'plot.png', settings)

