﻿// set EVERY 'state' here so will undo ALL layout changes
// used by the 'Reset State' button: myLayout.loadState( stateResetSettings )
var stateResetSettings = {
    west__size: 200
    , west__initClosed: false
    , west__initHidden: false
    //,	east__size:			300
    //,	east__initClosed:	false
    //,	east__initHidden:	false
};

var myLayout;

$(document).ready(function () {

    // this layout could be created with NO OPTIONS - but showing some here just as a sample...
    // myLayout = $('body').layout(); -- syntax with No Options

    myLayout = $('body').layout({

        //	reference only - these options are NOT required because 'true' is the default
        closable: true	// pane can open & close
        , resizable: true	// when open, pane can be resized
        , slidable: true	// when closed, pane can 'slide' open over other panes - closes on mouse-out
        , livePaneResizing: true

        //	some pane-size settings
        , west__minSize: 100
        , east__size: 300
        , east__minSize: 200
        , east__maxSize: .5 // 50% of layout width
        , center__minWidth: 100

        //	some pane animation settings
        , west__animatePaneSizing: false
        , west__fxSpeed_size: "fast"	// 'fast' animation when resizing west-pane
        , west__fxSpeed_open: 500	// 1-second animation when opening west-pane
        , west__fxSettings_open: { easing: "swing" }
        //,	west__fxName_close:			"none"	// NO animation when closing west-pane
        , west__fxSpeed_close: 500
        , west__fxSettings_close: { easing: "swing" }

        //	enable showOverflow on west-pane so CSS popups will overlap north pane
        , west__showOverflowOnHover: false

        //	enable state management
        , stateManagement__enabled: true // automatic cookie load & save enabled by default

        , showDebugMessages: true // log and/or display messages from debugging & testing code

        //, togglerLength_open: 50
        //, togglerLength_closed: "100%"
        , west__togglerLength_open: 50
        , west__togglerLength_closed: "100%"
        , west__togglerContent_open: "&nbsp;"
        , west__togglerContent_closed: "&nbsp;"
    });

    // if there is no state-cookie, then DISABLE state management initially
    //var cookieExists = !$.isEmptyObject( myLayout.readCookie() );
    //if (!cookieExists) toggleStateManagement( true, false );
});