/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.modify.UpdateEngine;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateRequest;
import org.openjena.atlas.logging.Log;

public abstract class UpdateEngineBase
implements UpdateEngine {
    protected final GraphStore graphStore;
    protected final Context context;
    protected final Binding startBinding;
    protected UpdateRequest request;

    public UpdateEngineBase(GraphStore graphStore, UpdateRequest request, Binding input, Context context) {
        this.graphStore = graphStore;
        this.request = request;
        this.context = UpdateEngineBase.setupContext(context, graphStore);
        if (input == null) {
            Log.warn(this, "Null initial input");
            input = BindingRoot.create();
        }
        this.startBinding = input;
        this.context.put(ARQConstants.sysCurrentUpdateRequest, request);
    }

    @Override
    public abstract void execute();

    private static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
        return context;
    }
}

