/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMap;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import com.hp.hpl.jena.sparql.modify.NodeTransformBNodesToVariables;
import com.hp.hpl.jena.sparql.modify.TemplateLib;
import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateAdd;
import com.hp.hpl.jena.sparql.modify.request.UpdateBinaryOp;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCopy;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateDropClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.modify.request.UpdateMove;
import com.hp.hpl.jena.sparql.modify.request.UpdateVisitor;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.data.BagFactory;
import org.openjena.atlas.data.DefaultDataBag;
import org.openjena.atlas.data.ThresholdPolicy;
import org.openjena.atlas.data.ThresholdPolicyFactory;
import org.openjena.atlas.iterator.Iter;
import org.openjena.riot.SerializationFactoryFinder;

public class UpdateEngineWorker
implements UpdateVisitor {
    protected final GraphStore graphStore;
    protected final Binding initialBinding;
    protected final boolean alwaysSilent = true;
    protected final Context context;

    public UpdateEngineWorker(GraphStore graphStore, Binding initialBinding, Context context) {
        this.graphStore = graphStore;
        this.initialBinding = initialBinding;
        this.context = context;
    }

    @Override
    public void visit(UpdateDrop update2) {
        this.execDropClear(update2, false);
    }

    @Override
    public void visit(UpdateClear update2) {
        this.execDropClear(update2, true);
    }

    protected void execDropClear(UpdateDropClear update2, boolean isClear) {
        if (update2.isAll()) {
            this.execDropClear(update2, null, true);
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isAllNamed()) {
            this.execDropClearAllNamed(update2, isClear);
        } else if (update2.isDefault()) {
            this.execDropClear(update2, null, true);
        } else if (update2.isOneGraph()) {
            this.execDropClear(update2, update2.getGraph(), isClear);
        } else {
            throw new ARQInternalErrorException("Target is undefined: " + update2.getTarget());
        }
    }

    protected void execDropClear(UpdateDropClear update2, Node g, boolean isClear) {
        if (isClear) {
            if (g == null || this.graphStore.containsGraph(g)) {
                UpdateEngineWorker.graph(this.graphStore, g).getBulkUpdateHandler().removeAll();
            }
        } else {
            this.graphStore.removeGraph(g);
        }
    }

    protected void execDropClearAllNamed(UpdateDropClear update2, boolean isClear) {
        List<Node> list = Iter.toList(this.graphStore.listGraphNodes());
        for (Node gn : list) {
            this.execDropClear(update2, gn, isClear);
        }
    }

    @Override
    public void visit(UpdateCreate update2) {
        Node g = update2.getGraph();
        if (g == null) {
            return;
        }
        if (this.graphStore.containsGraph(g)) {
            return;
        }
        this.graphStore.addGraph(g, GraphFactory.createDefaultGraph());
    }

    @Override
    public void visit(UpdateLoad update2) {
        block2: {
            String source = update2.getSource();
            Node dest = update2.getDest();
            try {
                Model model = FileManager.get().loadModel(source);
                Graph g = UpdateEngineWorker.graph(this.graphStore, dest);
                g.getBulkUpdateHandler().add(model.getGraph());
            }
            catch (RuntimeException ex) {
                if (update2.getSilent()) break block2;
                throw ex;
            }
        }
    }

    @Override
    public void visit(UpdateAdd update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopyTriples(this.graphStore, update2.getSrc(), update2.getDest());
    }

    @Override
    public void visit(UpdateCopy update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest(), update2.getSilent());
    }

    @Override
    public void visit(UpdateMove update2) {
        if (!this.validBinaryGraphOp(update2)) {
            return;
        }
        if (update2.getSrc().equals(update2.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.graphStore, update2.getSrc(), update2.getDest(), update2.getSilent());
        UpdateEngineWorker.gsDrop(this.graphStore, update2.getSrc(), true);
    }

    private boolean validBinaryGraphOp(UpdateBinaryOp update2) {
        if (update2.getSrc().isDefault()) {
            return true;
        }
        if (update2.getSrc().isOneNamedGraph()) {
            Node gn = update2.getSrc().getGraph();
            if (!this.graphStore.containsGraph(gn)) {
                if (!update2.getSilent()) {
                    UpdateEngineWorker.error("No such graph: " + gn);
                }
                return false;
            }
            return true;
        }
        UpdateEngineWorker.error("Invalid source target for oepration; " + update2.getSrc());
        return false;
    }

    protected static void gsCopy(GraphStore gStore, Target src, Target dest, boolean isSilent) {
        if (dest.equals(src)) {
            return;
        }
        UpdateEngineWorker.gsClear(gStore, dest, true);
        UpdateEngineWorker.gsCopyTriples(gStore, src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void gsCopyTriples(GraphStore gStore, Target src, Target dest) {
        Graph gSrc = UpdateEngineWorker.graph(gStore, src);
        Graph gDest = UpdateEngineWorker.graph(gStore, dest);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(gStore.getContext());
        DefaultDataBag<Triple> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.tripleSerializationFactory());
        try {
            ExtendedIterator triples = gSrc.find(null, null, null);
            db.addAll(triples);
            Iter.close(triples);
            Iterator it = db.iterator();
            gDest.getBulkUpdateHandler().add(it);
            Iter.close(it);
        }
        finally {
            db.close();
        }
    }

    protected static void gsClear(GraphStore gStore, Target target, boolean isSilent) {
        Graph g = UpdateEngineWorker.graph(gStore, target);
        g.getBulkUpdateHandler().removeAll();
    }

    protected static void gsDrop(GraphStore gStore, Target target, boolean isSilent) {
        if (target.isDefault()) {
            gStore.getDefaultGraph().getBulkUpdateHandler().removeAll();
        } else {
            gStore.removeGraph(target.getGraph());
        }
    }

    @Override
    public void visit(UpdateDataInsert update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.addToGraphStore(this.graphStore, quad);
        }
    }

    @Override
    public void visit(UpdateDataDelete update2) {
        for (Quad quad : update2.getQuads()) {
            UpdateEngineWorker.deleteFromGraphStore(this.graphStore, quad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateDeleteWhere update2) {
        List<Quad> quads = update2.getQuads();
        Element el = this.elementFromQuads(quads);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.graphStore.getContext());
        DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());
        try {
            Iterator<Binding> bindings2 = this.evalBindings(el, null);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            this.execDelete(quads, null, it);
            Iter.close(it);
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateModify update2) {
        Node withGraph = update2.getWithIRI();
        Query query2 = this.elementToQuery(update2.getWherePattern());
        DatasetGraph dsg = this.processUsing(update2, query2);
        if (dsg == null && withGraph != null) {
            Graph g = UpdateEngineWorker.graph(this.graphStore, withGraph);
            dsg = new DatasetGraphAltDefaultGraph(this.graphStore, g);
        }
        if (dsg == null) {
            dsg = this.graphStore;
        }
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.graphStore.getContext());
        DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());
        try {
            Iterator<Binding> bindings2 = UpdateEngineWorker.evalBindings(query2, dsg, this.initialBinding, this.context);
            db.addAll(bindings2);
            Iter.close(bindings2);
            Iterator<Binding> it = db.iterator();
            this.execDelete(update2.getDeleteQuads(), withGraph, it);
            Iter.close(it);
            Iterator<Binding> it2 = db.iterator();
            this.execInsert(update2.getInsertQuads(), withGraph, it2);
            Iter.close(it2);
        }
        finally {
            db.close();
        }
    }

    protected DatasetGraph processUsing(UpdateModify update2, Query query2) {
        if (update2.getUsing().size() == 0 && update2.getUsingNamed().size() == 0) {
            return null;
        }
        DatasetGraphMap dsg = new DatasetGraphMap(this.graphStore);
        if (update2.getUsing().size() > 0) {
            if (update2.getUsing().size() > 1) {
                Graph g = GraphFactory.createGraphMem();
                for (Node gn : update2.getUsing()) {
                    Graph g2 = this.graphStore.getGraph(gn);
                    g.getBulkUpdateHandler().add(g2);
                }
                dsg.setDefaultGraph(g);
            } else {
                Node gn = update2.getUsing().get(0);
                dsg.setDefaultGraph(this.graphStore.getGraph(gn));
            }
        }
        if (update2.getUsingNamed().size() > 0) {
            dsg = new DatasetGraphMap(dsg.getDefaultGraph());
            for (Node gn : update2.getUsingNamed()) {
                dsg.addGraph(gn, this.graphStore.getGraph(gn));
            }
        }
        return dsg;
    }

    protected static List<Quad> unused_convertBNodesToVariables(List<Quad> quads) {
        NodeTransformBNodesToVariables bnodesToVariables = new NodeTransformBNodesToVariables();
        return NodeTransformLib.transformQuads(bnodesToVariables, quads);
    }

    protected Element elementFromQuads(List<Quad> quads) {
        ElementGroup el = new ElementGroup();
        ElementTriplesBlock x = new ElementTriplesBlock();
        el.addElement(x);
        Node g = Quad.defaultGraphNodeGenerated;
        for (Quad q : quads) {
            if (q.getGraph() != g) {
                g = q.getGraph();
                x = new ElementTriplesBlock();
                if (g == null || g == Quad.defaultGraphNodeGenerated) {
                    el.addElement(x);
                } else {
                    ElementNamedGraph eng = new ElementNamedGraph(g, x);
                    el.addElement(eng);
                }
            }
            x.addTriple(q.asTriple());
        }
        return el;
    }

    protected void execDelete(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it = TemplateLib.template(quads, dftGraph, bindings2);
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Quad q = it.next();
            this.graphStore.delete(q);
        }
    }

    protected void execInsert(List<Quad> quads, Node dftGraph, Iterator<Binding> bindings2) {
        Iterator<Quad> it = TemplateLib.template(quads, dftGraph, bindings2);
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Quad q = it.next();
            UpdateEngineWorker.addToGraphStore(this.graphStore, q);
        }
    }

    private static void addToGraphStore(GraphStore graphStore, Quad quad) {
        if (quad.isLegalAsData()) {
            graphStore.add(quad);
        }
    }

    private static void deleteFromGraphStore(GraphStore graphStore, Quad quad) {
        graphStore.delete(quad);
    }

    protected Query elementToQuery(Element pattern) {
        if (pattern == null) {
            return null;
        }
        Query query2 = new Query();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        query2.setResultVars();
        return query2;
    }

    protected Iterator<Binding> evalBindings(Element pattern, Node dftGraph) {
        return this.evalBindings(this.elementToQuery(pattern), dftGraph);
    }

    protected Iterator<Binding> evalBindings(Query query2, Node dftGraph) {
        DatasetGraph dsg = this.graphStore;
        if (query2 != null && dftGraph != null) {
            Graph g = dsg.getGraph(dftGraph);
            dsg = new DatasetGraphAltDefaultGraph(dsg, g);
        }
        return UpdateEngineWorker.evalBindings(query2, dsg, this.initialBinding, this.context);
    }

    protected static Iterator<Binding> evalBindings(Query query2, DatasetGraph dsg, Binding initialBinding, Context context) {
        QueryIterator toReturn;
        if (query2 != null) {
            Plan plan = QueryExecutionFactory.createPlan(query2, dsg, initialBinding, context);
            toReturn = plan.iterator();
        } else {
            toReturn = Iter.singleton(initialBinding != null ? initialBinding : BindingRoot.create());
        }
        return toReturn;
    }

    protected static Graph graph(GraphStore graphStore, Node gn) {
        if (gn == null || gn == Quad.defaultGraphNodeGenerated) {
            return graphStore.getDefaultGraph();
        }
        return graphStore.getGraph(gn);
    }

    protected static Graph graph(GraphStore graphStore, Target target) {
        if (target.isDefault()) {
            return graphStore.getDefaultGraph();
        }
        if (target.isOneNamedGraph()) {
            return UpdateEngineWorker.graph(graphStore, target.getGraph());
        }
        UpdateEngineWorker.error("Target does not name one graph: " + target);
        return null;
    }

    protected static void error(String msg) {
        throw new UpdateException(msg);
    }

    static class DatasetGraphAltDefaultGraph
    extends DatasetGraphWrapper {
        private Graph dftGraph;

        public DatasetGraphAltDefaultGraph(DatasetGraph dsg, Graph dftGraph) {
            super(dsg);
            this.setDefaultGraph(dftGraph);
        }

        @Override
        public Graph getDefaultGraph() {
            return this.dftGraph;
        }

        @Override
        public void setDefaultGraph(Graph g) {
            this.dftGraph = g;
        }
    }
}

