/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.checker.CheckerBlankNodes;
import org.openjena.riot.checker.CheckerIRI;
import org.openjena.riot.checker.CheckerLiterals;
import org.openjena.riot.checker.CheckerVar;
import org.openjena.riot.checker.NodeChecker;
import org.openjena.riot.system.IRIResolver;

public final class Checker {
    private boolean allowRelativeIRIs = false;
    private boolean warningsAreErrors = false;
    private ErrorHandler handler;
    private NodeChecker checkLiterals;
    private NodeChecker checkURIs;
    private NodeChecker checkBlankNodes;
    private NodeChecker checkVars;

    public Checker() {
        this(null);
    }

    public Checker(ErrorHandler handler) {
        if (handler == null) {
            handler = ErrorHandlerFactory.errorHandlerStd;
        }
        this.handler = handler;
        this.checkLiterals = new CheckerLiterals(handler);
        this.checkURIs = new CheckerIRI(handler, IRIResolver.iriFactory);
        this.checkBlankNodes = new CheckerBlankNodes(handler);
        this.checkVars = new CheckerVar(handler);
    }

    public ErrorHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ErrorHandler handler) {
        this.handler = handler;
    }

    public boolean check(Node node, long line, long col) {
        if (node.isURI()) {
            return this.checkIRI(node, line, col);
        }
        if (node.isBlank()) {
            return this.checkBlank(node, line, col);
        }
        if (node.isLiteral()) {
            return this.checkLiteral(node, line, col);
        }
        if (node.isVariable()) {
            return this.checkVar(node, line, col);
        }
        this.handler.warning("Not a recognized node: ", line, col);
        return false;
    }

    public boolean check(Triple triple, long line, long col) {
        return this.checkTriple(triple.getSubject(), triple.getPredicate(), triple.getObject(), line, col);
    }

    public boolean checkTriple(Node subject, Node predicate, Node object, long line, long col) {
        boolean rc = true;
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            this.handler.error("Subject is not a URI or blank node", line, col);
            rc = false;
        }
        if (predicate == null || !predicate.isURI()) {
            this.handler.error("Predicate not a URI", line, col);
            rc = false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.handler.error("Object is not a URI, blank node or literal", line, col);
            rc = false;
        }
        return rc;
    }

    public static boolean validate(String msg, Triple triple) {
        return Checker.validate(msg, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public static boolean validate(String msg, Node subject, Node predicate, Node object) {
        if (msg == null) {
            msg = "Validation";
        }
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            ErrorHandlerFactory.errorHandlerStd.error(msg + ": Subject is not a URI or blank node", -1L, -1L);
            return false;
        }
        if (predicate == null || !predicate.isURI()) {
            ErrorHandlerFactory.errorHandlerStd.error(msg + ": Predicate not a URI", -1L, -1L);
            return false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            ErrorHandlerFactory.errorHandlerStd.error(msg + ": Object is not a URI, blank node or literal", -1L, -1L);
            return false;
        }
        return true;
    }

    public final boolean checkVar(Node node, long line, long col) {
        return this.checkVars.check(node, line, col);
    }

    public final boolean checkLiteral(Node node, long line, long col) {
        return this.checkLiterals.check(node, line, col);
    }

    public final boolean checkBlank(Node node, long line, long col) {
        return this.checkBlankNodes.check(node, line, col);
    }

    public final boolean checkIRI(Node node, long line, long col) {
        return this.checkURIs.check(node, line, col);
    }

    public final boolean checkIRI(IRI iri2, long line, long col) {
        if (!(this.checkURIs instanceof CheckerIRI)) {
            return true;
        }
        return ((CheckerIRI)this.checkURIs).checkIRI(iri2, line, col);
    }

    public final NodeChecker getCheckLiterals() {
        return this.checkLiterals;
    }

    public final void setCheckLiterals(NodeChecker checkLiterals) {
        this.checkLiterals = checkLiterals;
    }

    public final NodeChecker getCheckURIs() {
        return this.checkURIs;
    }

    public final void setCheckURIs(NodeChecker checkURIs) {
        this.checkURIs = checkURIs;
    }

    public final NodeChecker getCheckBlankNodes() {
        return this.checkBlankNodes;
    }

    public final void setCheckBlankNodes(NodeChecker checkBlankNodes) {
        this.checkBlankNodes = checkBlankNodes;
    }

    public final NodeChecker getCheckVars() {
        return this.checkVars;
    }

    public final void setCheckVars(NodeChecker checkVars) {
        this.checkVars = checkVars;
    }
}

