/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.gunit.AbstractTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.ITestCase;
import org.antlr.gunit.ITestSuite;
import org.antlr.gunit.InvalidInputException;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestResult;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class gUnitExecutor
implements ITestSuite {
    public GrammarInfo grammarInfo;
    private final ClassLoader grammarClassLoader;
    private final String testsuiteDir;
    public int numOfTest;
    public int numOfSuccess;
    public int numOfFailure;
    private String title;
    public int numOfInvalidInput;
    private String parserName;
    private String lexerName;
    public List<AbstractTest> failures;
    public List<AbstractTest> invalids;
    private PrintStream console = System.out;
    private PrintStream consoleErr = System.err;

    public gUnitExecutor(GrammarInfo grammarInfo, String testsuiteDir) {
        this(grammarInfo, gUnitExecutor.determineClassLoader(), testsuiteDir);
    }

    private static ClassLoader determineClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = gUnitExecutor.class.getClassLoader();
        }
        return classLoader;
    }

    public gUnitExecutor(GrammarInfo grammarInfo, ClassLoader grammarClassLoader, String testsuiteDir) {
        this.grammarInfo = grammarInfo;
        this.grammarClassLoader = grammarClassLoader;
        this.testsuiteDir = testsuiteDir;
        this.numOfTest = 0;
        this.numOfSuccess = 0;
        this.numOfFailure = 0;
        this.numOfInvalidInput = 0;
        this.failures = new ArrayList<AbstractTest>();
        this.invalids = new ArrayList<AbstractTest>();
    }

    protected ClassLoader getGrammarClassLoader() {
        return this.grammarClassLoader;
    }

    protected final Class classForName(String name) throws ClassNotFoundException {
        return this.getGrammarClassLoader().loadClass(name);
    }

    public String execTest() throws IOException {
        StringTemplate testResultST = this.getTemplateGroup().getInstanceOf("testResult");
        try {
            if (this.grammarInfo.getGrammarPackage() != null) {
                this.parserName = this.grammarInfo.getGrammarPackage() + "." + this.grammarInfo.getGrammarName() + "Parser";
                this.lexerName = this.grammarInfo.getGrammarPackage() + "." + this.grammarInfo.getGrammarName() + "Lexer";
            } else {
                this.parserName = this.grammarInfo.getGrammarName() + "Parser";
                this.lexerName = this.grammarInfo.getGrammarName() + "Lexer";
            }
            this.title = this.grammarInfo.getTreeGrammarName() != null ? "executing testsuite for tree grammar:" + this.grammarInfo.getTreeGrammarName() + " walks " + this.parserName : "executing testsuite for grammar:" + this.grammarInfo.getGrammarName();
            this.executeTests();
            testResultST.setAttribute("title", (Object)this.title);
            testResultST.setAttribute("num_of_test", this.numOfTest);
            testResultST.setAttribute("num_of_failure", this.numOfFailure);
            if (this.numOfFailure > 0) {
                testResultST.setAttribute("failure", this.failures);
            }
            if (this.numOfInvalidInput > 0) {
                testResultST.setAttribute("has_invalid", (Object)new Boolean(true));
                testResultST.setAttribute("num_of_invalid", this.numOfInvalidInput);
                testResultST.setAttribute("invalid", this.invalids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return testResultST.toString();
    }

    private StringTemplateGroup getTemplateGroup() {
        CommonGroupLoader loader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer((Class)AngleBracketTemplateLexer.class);
        StringTemplateGroup group = StringTemplateGroup.loadGroup((String)"gUnitTestResult");
        return group;
    }

    private gUnitTestResult runCorrectParser(String parserName, String lexerName, String rule, String lexicalRule, String treeRule, gUnitTestInput input) throws Exception {
        if (lexicalRule != null) {
            return this.runLexer(lexerName, lexicalRule, input);
        }
        if (treeRule != null) {
            return this.runTreeParser(parserName, lexerName, rule, treeRule, input);
        }
        return this.runParser(parserName, lexerName, rule, input);
    }

    private void executeTests() throws Exception {
        Iterator<gUnitTestSuite> i$ = this.grammarInfo.getRuleTestSuites().iterator();
        while (i$.hasNext()) {
            gUnitTestSuite ts = i$.next();
            String rule = ts.getRuleName();
            String lexicalRule = ts.getLexicalRuleName();
            String treeRule = ts.getTreeRuleName();
            Iterator<gUnitTestInput> i$2 = ts.testSuites.keySet().iterator();
            while (i$2.hasNext()) {
                gUnitTestInput input = i$2.next();
                ++this.numOfTest;
                gUnitTestResult result = null;
                AbstractTest test = ts.testSuites.get(input);
                try {
                    result = this.runCorrectParser(this.parserName, this.lexerName, rule, lexicalRule, treeRule, input);
                }
                catch (InvalidInputException e) {
                    ++this.numOfInvalidInput;
                    test.setHeader(rule, lexicalRule, treeRule, this.numOfTest, input.line);
                    test.setActual(input.input);
                    this.invalids.add(test);
                    continue;
                }
                String expected = test.getExpected();
                String actual = test.getResult(result);
                test.setActual(actual);
                if (actual == null) {
                    ++this.numOfFailure;
                    test.setHeader(rule, lexicalRule, treeRule, this.numOfTest, input.line);
                    test.setActual("null");
                    this.failures.add(test);
                    this.onFail(test);
                    continue;
                }
                if (expected.equals(actual) || expected.equals("FAIL") && !actual.equals("OK")) {
                    ++this.numOfSuccess;
                    this.onPass(test);
                    continue;
                }
                if (ts.testSuites.get(input).getType() == 4) {
                    ++this.numOfFailure;
                    test.setHeader(rule, lexicalRule, treeRule, this.numOfTest, input.line);
                    test.setActual("\t{ACTION} is not supported in the grammarInfo yet...");
                    this.failures.add(test);
                    this.onFail(test);
                    continue;
                }
                ++this.numOfFailure;
                test.setHeader(rule, lexicalRule, treeRule, this.numOfTest, input.line);
                this.failures.add(test);
                this.onFail(test);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runLexer(String lexerName, String testRuleName, gUnitTestInput testInput) throws Exception {
        gUnitTestResult gUnitTestResult2;
        Class lexer = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        try {
            CharStream input = this.getANTLRInputStream(testInput);
            lexer = this.classForName(lexerName);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            Method ruleName = lexer.getMethod("m" + testRuleName, new Class[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            ruleName.invoke(lexObj, new Object[0]);
            Method ruleName2 = lexer.getMethod("getCharIndex", new Class[0]);
            int currentIndex = (Integer)ruleName2.invoke(lexObj, new Object[0]);
            if (currentIndex != input.size()) {
                ps2.print("extra text found, '" + input.substring(currentIndex, input.size() - 1) + "'");
            }
            if (err.toString().length() > 0) {
                gUnitTestResult testResult = new gUnitTestResult(false, err.toString(), true);
                testResult.setError(err.toString());
                gUnitTestResult gUnitTestResult3 = testResult;
                return gUnitTestResult3;
            }
            String stdout = null;
            if (out.toString().length() > 0) {
                stdout = out.toString();
            }
            gUnitTestResult gUnitTestResult4 = new gUnitTestResult(true, stdout, true);
            return gUnitTestResult4;
        }
        catch (IOException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new Exception("This should be unreachable?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runParser(String parserName, String lexerName, String testRuleName, gUnitTestInput testInput) throws Exception {
        gUnitTestResult gUnitTestResult2;
        Class lexer = null;
        Class parser = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        try {
            gUnitTestResult gUnitTestResult3;
            CharStream input = this.getANTLRInputStream(testInput);
            lexer = this.classForName(lexerName);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            CommonTokenStream tokens = new CommonTokenStream((Lexer)lexObj);
            parser = this.classForName(parserName);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Object parObj = parConstructor.newInstance(parArgs);
            if (this.grammarInfo.getAdaptor() != null) {
                parArgTypes = new Class[]{TreeAdaptor.class};
                Method _setTreeAdaptor = parser.getMethod("setTreeAdaptor", parArgTypes);
                Class _treeAdaptor = this.classForName(this.grammarInfo.getAdaptor());
                _setTreeAdaptor.invoke(parObj, _treeAdaptor.newInstance());
            }
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke(parObj, new Object[0]);
            String astString = null;
            String stString = null;
            if (ruleReturn != null && ruleReturn.getClass().toString().indexOf(testRuleName + "_return") > 0) {
                try {
                    Method[] methods;
                    Class _return = this.classForName(parserName + "$" + testRuleName + "_return");
                    Method[] arr$ = methods = _return.getDeclaredMethods();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Method returnName;
                        Method method = arr$[i$];
                        if (method.getName().equals("getTree")) {
                            returnName = _return.getMethod("getTree", new Class[0]);
                            CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
                            astString = tree.toStringTree();
                            continue;
                        }
                        if (!method.getName().equals("getTemplate")) continue;
                        returnName = _return.getMethod("getTemplate", new Class[0]);
                        StringTemplate st = (StringTemplate)returnName.invoke(ruleReturn, new Object[0]);
                        stString = st.toString();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (tokens.index() != tokens.size() - 1) {
                ps2.print("Invalid input");
            }
            if (err.toString().length() > 0) {
                gUnitTestResult testResult = new gUnitTestResult(false, err.toString());
                testResult.setError(err.toString());
                gUnitTestResult3 = testResult;
                return gUnitTestResult3;
            }
            String stdout = null;
            if (out.toString().length() > 0) {
                stdout = out.toString();
            }
            if (astString != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, astString);
                return gUnitTestResult3;
            }
            if (stString != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, stString);
                return gUnitTestResult3;
            }
            if (ruleReturn != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, String.valueOf(ruleReturn));
                return gUnitTestResult3;
            }
            gUnitTestResult3 = new gUnitTestResult(true, stdout, stdout);
            return gUnitTestResult3;
        }
        catch (IOException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new Exception("This should be unreachable?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runTreeParser(String parserName, String lexerName, String testRuleName, String testTreeRuleName, gUnitTestInput testInput) throws Exception {
        gUnitTestResult gUnitTestResult2;
        Class lexer = null;
        Class parser = null;
        Class treeParser = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        try {
            gUnitTestResult gUnitTestResult3;
            CharStream input = this.getANTLRInputStream(testInput);
            String treeParserPath = this.grammarInfo.getGrammarPackage() != null ? this.grammarInfo.getGrammarPackage() + "." + this.grammarInfo.getTreeGrammarName() : this.grammarInfo.getTreeGrammarName();
            lexer = this.classForName(lexerName);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            CommonTokenStream tokens = new CommonTokenStream((Lexer)lexObj);
            parser = this.classForName(parserName);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Object parObj = parConstructor.newInstance(parArgs);
            TreeAdaptor customTreeAdaptor = null;
            if (this.grammarInfo.getAdaptor() != null) {
                parArgTypes = new Class[]{TreeAdaptor.class};
                Method _setTreeAdaptor = parser.getMethod("setTreeAdaptor", parArgTypes);
                Class _treeAdaptor = this.classForName(this.grammarInfo.getAdaptor());
                customTreeAdaptor = (TreeAdaptor)_treeAdaptor.newInstance();
                _setTreeAdaptor.invoke(parObj, customTreeAdaptor);
            }
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke(parObj, new Object[0]);
            Class _return = this.classForName(parserName + "$" + testRuleName + "_return");
            Method returnName = _return.getMethod("getTree", new Class[0]);
            CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
            CommonTreeNodeStream nodes = customTreeAdaptor != null ? new CommonTreeNodeStream(customTreeAdaptor, tree) : new CommonTreeNodeStream(tree);
            nodes.setTokenStream(tokens);
            treeParser = this.classForName(treeParserPath);
            Class[] treeParArgTypes = new Class[]{TreeNodeStream.class};
            Constructor treeParConstructor = treeParser.getConstructor(treeParArgTypes);
            Object[] treeParArgs = new Object[]{nodes};
            Object treeParObj = treeParConstructor.newInstance(treeParArgs);
            Method treeRuleName = treeParser.getMethod(testTreeRuleName, new Class[0]);
            Object treeRuleReturn = treeRuleName.invoke(treeParObj, new Object[0]);
            String astString = null;
            String stString = null;
            if (treeRuleReturn != null && treeRuleReturn.getClass().toString().indexOf(testTreeRuleName + "_return") > 0) {
                try {
                    Method[] methods;
                    Class _treeReturn = this.classForName(treeParserPath + "$" + testTreeRuleName + "_return");
                    Method[] arr$ = methods = _treeReturn.getDeclaredMethods();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Method treeReturnName;
                        Method method = arr$[i$];
                        if (method.getName().equals("getTree")) {
                            treeReturnName = _treeReturn.getMethod("getTree", new Class[0]);
                            CommonTree returnTree = (CommonTree)treeReturnName.invoke(treeRuleReturn, new Object[0]);
                            astString = returnTree.toStringTree();
                            continue;
                        }
                        if (!method.getName().equals("getTemplate")) continue;
                        treeReturnName = _return.getMethod("getTemplate", new Class[0]);
                        StringTemplate st = (StringTemplate)treeReturnName.invoke(treeRuleReturn, new Object[0]);
                        stString = st.toString();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (tokens.index() != tokens.size() - 1) {
                ps2.print("Invalid input");
            }
            if (err.toString().length() > 0) {
                gUnitTestResult testResult = new gUnitTestResult(false, err.toString());
                testResult.setError(err.toString());
                gUnitTestResult3 = testResult;
                return gUnitTestResult3;
            }
            String stdout = null;
            if (out.toString().length() > 0) {
                stdout = out.toString();
            }
            if (astString != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, astString);
                return gUnitTestResult3;
            }
            if (stString != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, stString);
                return gUnitTestResult3;
            }
            if (treeRuleReturn != null) {
                gUnitTestResult3 = new gUnitTestResult(true, stdout, String.valueOf(treeRuleReturn));
                return gUnitTestResult3;
            }
            gUnitTestResult3 = new gUnitTestResult(true, stdout, stdout);
            return gUnitTestResult3;
        }
        catch (IOException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            gUnitTestResult2 = this.getTestExceptionResult(e);
            return gUnitTestResult2;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new Exception("Should not be reachable?");
    }

    private CharStream getANTLRInputStream(gUnitTestInput testInput) throws IOException {
        ANTLRStringStream input;
        if (testInput.isFile) {
            String filePath = testInput.input;
            File testInputFile = new File(filePath);
            if (!testInputFile.exists()) {
                testInputFile = new File(this.testsuiteDir, filePath);
                if (testInputFile.exists()) {
                    filePath = testInputFile.getCanonicalPath();
                } else if (this.grammarInfo.getGrammarPackage() != null && (testInputFile = new File("." + File.separator + this.grammarInfo.getGrammarPackage().replace(".", File.separator), filePath)).exists()) {
                    filePath = testInputFile.getCanonicalPath();
                }
            }
            input = new ANTLRFileStream(filePath);
        } else {
            input = new ANTLRStringStream(testInput.input);
        }
        return input;
    }

    private gUnitTestResult getTestExceptionResult(Exception e) {
        gUnitTestResult testResult;
        if (e.getCause() != null) {
            testResult = new gUnitTestResult(false, e.getCause().toString(), true);
            testResult.setError(e.getCause().toString());
        } else {
            testResult = new gUnitTestResult(false, e.toString(), true);
            testResult.setError(e.toString());
        }
        return testResult;
    }

    public void onPass(ITestCase passTest) {
    }

    public void onFail(ITestCase failTest) {
    }
}

