within ;

class {{COMPONENT_NAME}}_wrapper
  extends ExternalObject;
  function constructor
    output {{COMPONENT_NAME}}_wrapper context;
    external "C" context = {{COMPONENT_NAME}}_wrapper_init();
  end constructor

  function destructor
    input {{COMPONENT_NAME}}_wrapper context;
    external "C" {{COMPONENT_NAME}}_wrapper_destroy( context );
  end destructor;
end {{COMPONENT_NAME}}_wrapper;

function {{COMPONENT_NAME}}_wrapper_main
    "{{COMPONENT_NAME}} code external function wrapper."
  input {{COMPONENT_NAME}}_wrapper context;
  {{#INPUT_SIGNAL}}
  input {{DATA_TYPE}} {{DATA_NAME}};
  {{/INPUT_SIGNAL}}
  {{#OUTPUT_SIGNAL}}
  output {{DATA_TYPE}} {{DATA_NAME}};
  {{/OUTPUT_SIGNAL}}
  external "C" {{COMPONENT_NAME}}_wrapper_main(context{{#INPUT_SIGNAL}},{{DATA_NAME}}{{/INPUT_SIGNAL}}{{#OUTPUT_SIGNAL}},{{DATA_NAME}}{{/OUTPUT_SIGNAL}});
  annotation(Include="#include <{{COMPONENT_NAME}}_wrapper.h>", Library="{{COMPONENT_NAME}}", IncludeDirectory="..", LibraryDirectory="Release");
end {{COMPONENT_NAME}}_wrapper_main;

// This part has the interface elements instantiated from the CyPhyML 
// component model.
model {{COMPONENT_NAME}}_type
     extends ISIS.Icons.Component;
  
 {{COMPONENT_NAME}}_wrapper tcontext = {{COMPONENT_NAME}}_wrapper();
 
 {{#PORT_DEF}}
 {{PORT_TYPE}} {{PORT_NAME}}
 {{/PORT_DEF}}

  parameter Real samplePeriod = 0.5;
  output Boolean sampleTrigger;

equation
  sampleTrigger = sample( 0, samplePeriod );
  when sampleTrigger then
  {{COMPONENT_NAME}}_wrapper_main( tcontext{{#INPUT_PORT}},{{PORT_NAME}}{{/INPUT_PORT}}{{#OUTPUT_PORT}},{{PORT_NAME}}{{/OUTPUT_PORT}});
  end when;

  annotation (uses(Modelica(version="3.2")));
end {{COMPONENT_NAME}}_type;

