; Setup for .NET v4 Client Profile

#pragma option -v+
#pragma verboselevel 9

#define OutputFileBase "setup_ISIS-HiLiTeVerifier"


#define GMEVER "'10.2.9'"

#define OUTPUT_PATH SourcePath
#define COMPONENT_PATH SourcePath + "..\HiLiTeVerifierPlugin\"
#define COMPONENT_VER  "1.0"
; DLL file name without path
#define COMPONENT_DLL_NAME "HiLiTeVerifierPlugin.dll"
; Guid of the Component (ComponentConfig.guid) between double opening braces and single closing one
#define COMPONENT_GUID "{{9F0A2479-DA93-41FC-B1F2-1EEAD03339DC}"
; The ProgId of the component: ComponentConfig.ProgId
#define COMPONENT_PROGID "CyPhy.Plugin.HiLiTeVerifierPlugin"
; The fully qualified name of the assembly. Version, etc in AssemblyInfo.cs. Use SDK tool sn -Tp to find the public key token.
#define COMPONENT_ASSEMBLY_INFO "HiLiTeVerifierPlugin, Version=1.0.0.0, Culture=neutral, PublicKeyToken=62c99deed25eb22a"
; The component class that has the Guid, ProgId, etc. attributes with full namespace names delimited by dots. E.g. GME.CSharp.MyComponent.MyComponent
#define COMPONENT_CLASS "HiLiTeVerifierPlugin.HiLiteVerifierPlugin"
; ComponentConfig.componentName
#define COMPONENT_NAME "Vanderbilt HiLiTe Verifier"

#define TYPELIB_NAME   "HiLiTeVerifierPlugin.tlb"

#define SAMPLE_PATH SourcePath + "..\Model123Sample"
#define SAMPLE2_PATH SourcePath + "..\FlightControlSample"



[Setup]
AppName=ISIS HiLiTe Verifier {#COMPONENT_VER}
AppVerName=ISIS HiLiTe Verifier {#COMPONENT_VER}
AppPublisher=ISIS, Vanderbilt University
DefaultDirName={pf}\ISIS\HiLiTeVerifier
DefaultGroupName=ISIS HiLiTe Verifier
SourceDir={#COMPONENT_PATH}
OutputDir={#OUTPUT_PATH}
OutputBaseFilename={#OutputFileBase}{#COMPONENT_VER}
Compression=lzma
SolidCompression=yes
ChangesEnvironment=true
AppCopyright=Copyright (C) 2007-2011 ISIS, Vanderbilt University

[Languages]
Name: english; MessagesFile: compiler:Default.isl


[Files]
; Interpreter DLL
Source: {#COMPONENT_PATH}bin\Release\{#COMPONENT_DLL_NAME}; DestDir: {app}\bin; Flags: ignoreversion
Source: {#COMPONENT_PATH}bin\Release\{#TYPELIB_NAME}; DestDir: {app}\bin; Flags: regtypelib 32bit

; Sources (C# project structure)
Source: {#COMPONENT_PATH}*.cs;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}Properties\*.cs;DestDir: {app}\src\\Properties; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.snk;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.csproj;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.sln;DestDir: {app}\src; Flags: ignoreversion 

;Samples
Source: {#SAMPLE_PATH}\*.xme;DestDir: {app}\samples\Model123Sample; Flags: ignoreversion
Source: {#SAMPLE_PATH}\MatlabEmulation\*.mdl;DestDir: {app}\samples\Model123Sample; Flags: ignoreversion
Source: {#SAMPLE_PATH}\MatlabEmulation\*.txt;DestDir: {app}\samples\Model123Sample; Flags: ignoreversion

Source: {#SAMPLE2_PATH}\*.xme;DestDir: {app}\samples\FlightControlSample; Flags: ignoreversion
Source: {#SAMPLE2_PATH}\*.mdl;DestDir: {app}\samples\FlightControlSample; Flags: ignoreversion
Source: {#SAMPLE2_PATH}\*.txt;DestDir: {app}\samples\FlightControlSample; Flags: ignoreversion



;Doc
Source: {#COMPONENT_PATH}\..\Doc\*.txt; DestDir: {app}; Flags: ignoreversion





[Registry]
;;;;;;;;; Component Registration - Windows ;;;;;;;
; ProgID
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID};ValueType: string; ValueData: {#COMPONENT_CLASS};Flags: uninsdeletekey;
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\Implemented Categories;

;The component category identified by the guid 62C8FE65-4EBB-45e7-B440-6E39B2CDBF29 identifies all .NET components.
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\Implemented Categories\{{62C8FE65-4EBB-45e7-B440-6E39B2CDBF29}

;InprocServer
;Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueData:"mscoree.dll";Flags: uninsdeletekey;
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"ThreadingModel";ValueData:"Both";
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"Class";ValueData:{#COMPONENT_CLASS};
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"Assembly";ValueData: {#COMPONENT_ASSEMBLY_INFO};
; Change this line to Full 4.0 profiel or other .NET versions:
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"RuntimeVersion";ValueData:"{reg:HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Client,Version|v4.0.30319}";
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"CodeBase";ValueData:{code:PathToURI|{app}\bin\{#COMPONENT_DLL_NAME}};

Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32\1.0.0.0; ValueType: string; ValueName:"Class";ValueData:{#COMPONENT_CLASS};
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32\1.0.0.0; ValueType: string; ValueName:"Assembly";ValueData: {#COMPONENT_ASSEMBLY_INFO};
; Change this line to Full 4.0 profiel or other .NET versions:
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32\1.0.0.0; ValueType: string; ValueName:"RuntimeVersion";ValueData:"{reg:HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Client,Version|v4.0.30319}";
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32\1.0.0.0; ValueType: string; ValueName:"CodeBase";ValueData:{code:PathToURI|{app}\bin\{#COMPONENT_DLL_NAME}};



Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\ProgId; ValueType: string; ValueData: {#COMPONENT_PROGID}


Root: HKCR; Subkey:{#COMPONENT_PROGID};ValueType:string;ValueData: {#COMPONENT_CLASS}; Flags: uninsdeletekey;
Root: HKCR; Subkey:{#COMPONENT_PROGID}\CLSID;ValueType:string;ValueData:{#COMPONENT_GUID}



[Code]

function PathToURI(path:String):String;
begin
    StringChangeEx(path, '\', '/', True);
    Result:= 'file:///' + path; 
end;




function VersionNumberToInteger(version: String): Integer;
var
   dotPos: Integer;
 begin
 
  repeat
    dotPos := Pos('.', version);
    if (dotPos <> 0) then
    begin
     Delete(version, dotPos, 1);
    end
   until  dotPos<>0;

    Result := StrToInt(version);
 end;


function IsGMEVersionCurrentOrLater(version:String): Boolean;
var
  gme_path : String;
  gme_version: String;
  gme_object :  Variant;


begin
  gme_path := GetEnv('GME_ROOT');
  if gme_path = '' then begin
    MsgBox('Unable to locate GME.  Please install GME first.', mbError, MB_OK);
    Result := False;
  end 
  else 
  begin
    gme_object := CreateOleObject('GME.Application');
    gme_version := gme_object.Version;

    if VersionNumberToInteger(gme_version)> VersionNumberToInteger(version) then begin
      MsgBox('GME Component needs GME '+ version+' or later. The current GME version is '+gme_object.Version+'.'#13#13'Please install an appropriate GME version first.', mbError, MB_OK);
      Result := False;
    end
    else
      Result:=True;
    IDispatchInvoke(gme_object, False, 'Exit', []);
  end;

  MsgBox('GME' + version, mbError, MB_OK);
  MsgBox(gme_version, mbError, MB_OK);

end;



function NextButtonClick(CurPageID: Integer): Boolean;
begin
  Result := True;
  if (CurPageID = wpInfoBefore) and not WizardSilent() then begin
    Result := IsGMEVersionCurrentOrLater({#GMEVER});
  end;
end;

