﻿/*
 * Copyright (c) 2011, Vanderbilt University.
 * Developed with the sponsorship of the Defense Advanced Research Projects Agency (DARPA). Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this data, including any software or models in source or binary form, as well as any drawings, 
 * specifications, and documentation (collectively "the Data"), to deal in the Data without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Data, and to permit persons 
 * to whom the Data is furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Data.

 * THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS 
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
 * WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GME.MGA;

namespace HybridSALVerifierPlugin
{
   
    public class Integrator
    {
        public Integrator(string name, MgaModel block)
        {
            this.name = name;
            this.block = block;
        }

        public double upperSaturation = Double.NaN;
        public double lowerSaturation = Double.NaN;
        public MgaModel block;
        public string name;
        public int stateVariablePos;
        public int derivativePos;
        public int initialValuePos; // -1 if there is no initial value
        public int resetVariablePos;

    }

    public class Saturation
    {
        public Saturation(string name, MgaModel block)
        {
            this.name = name;
            this.block = block;
        }
        public string name;
        public MgaModel block;
        public int variablePos; // Currently only output variables are supported

    }
}
