﻿/*
 * Copyright (c) 2011, Vanderbilt University.
 * Developed with the sponsorship of the Defense Advanced Research Projects Agency (DARPA). Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this data, including any software or models in source or binary form, as well as any drawings, 
 * specifications, and documentation (collectively "the Data"), to deal in the Data without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Data, and to permit persons 
 * to whom the Data is furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Data.

 * THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS 
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
 * WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using MGALib;

namespace CyPhy2HybridSAL
{
    public class StateSpace
    {
        public Matrix ode;
        public List<string> columnVariableNames = new List<string>();
        public List<IMgaModel> columnOutputPorts = new List<IMgaModel>();
        public Dictionary<IMgaModel, int> outputPort2Column = new Dictionary<IMgaModel, int>();
        public int outputIndex; // The index of y1...
        public int derivativeIndex; // The index of x1dot...
        public int variableIndex; // The index of x1...        
        public int inputIndex; // The index of u1...

        public List<Integrator> integrators = new List<Integrator>();
        public List<Saturation> saturations = new List<Saturation>();


        public void BuildPort2ColumnMapAndVariableNames()
        {

            for (int i = 0; i < columnOutputPorts.Count; i++)
            {
                outputPort2Column.Add(columnOutputPorts[i], i);
                if (i < outputIndex)
                {
                    columnVariableNames.Add(String.Format("{0}", columnOutputPorts[i].ParentModel.Name));
                }
                else if(i >= outputIndex && i < derivativeIndex)
                {
                    columnVariableNames.Add(String.Format("{0}", columnOutputPorts[i].Name));
                }

                else if (i >= derivativeIndex && i < variableIndex)
                {
                    columnVariableNames.Add(String.Format("x{0}dot", i-derivativeIndex ));
                }
                else if (i >= variableIndex && i < inputIndex)
                {
                    columnVariableNames.Add(String.Format("x{0}", i-variableIndex));
                }
                else if (i >= inputIndex)
                {
                    columnVariableNames.Add(String.Format("{0}", columnOutputPorts[i].Name));
                }

            }
        }

        public void Dump()
        {
            foreach (IMgaModel columnOutputPort in columnOutputPorts)
            {
                System.Diagnostics.Debug.WriteLine(String.Format("{0}/{1} ", columnOutputPort.ParentModel.Name, columnOutputPort.Name));
            }

            ode.Dump();

        }
    }
}

   