/*
Copyright (c) 2011, Vanderbilt University.
Developed with the sponsorship of the Defense Advanced Research Projects Agency (DARPA).
Permission is hereby granted, free of charge, to any person obtaining a copy of this data, including any software or models in 
source or binary form, as well as any drawings, specifications, and documentation (collectively "the Data"), to deal in the 
Data without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Data, and to permit persons to whom the Data is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Data.
THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS, SPONSORS, DEVELOPERS, 
CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.
*/

// Used: http://www.ibm.com/developerworks/linux/library/l-ubuntu-inotify/index.html

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/inotify.h>
#include <unistd.h>


#define EVENT_SIZE  ( sizeof (struct inotify_event) )
#define BUF_LEN     ( 1024 * ( EVENT_SIZE + 16 ) )
#define READ_BUFF_SIZE 100

int main( int argc, char **argv ) 
{
	int length, i = 0;
	int fd;
	int wd;
	char buffer[BUF_LEN];
	char read_buffer[READ_BUFF_SIZE];

	int ret;
	fd_set readfs;
	


	if(argc != 3)
	{
		printf("Usage: <file to watch> <command line to execute \n");
		return -1;
	}

	fd = inotify_init();

	if ( fd < 0 ) {
		perror( "inotify_init" );
	}

	wd = inotify_add_watch( fd, argv[1], IN_ALL_EVENTS );
	if ( wd < 0 ) 
	{
		perror( "inotify_add_watch (probably bad path is given as the first argument)" );
	}



	while(1)
	{

		FD_ZERO ( &readfs );	  
		FD_SET(fd, &readfs);
		FD_SET(fileno(stdin), &readfs);

		ret = select ( fd + 1, &readfs, NULL, NULL, NULL);

		if ( ret < 0 ) 
		{
			fprintf(stderr, "Unknown error in select");
		}

		else if( FD_ISSET( fileno(stdin), &readfs )) // stdin
		{
			ret = read(fileno(stdin), read_buffer, READ_BUFF_SIZE);

			if(ret >=0)
			{
				return 0;
			}
		}
		else if ( FD_ISSET ( fd, &readfs ) ) 
		{

			
			length = read( fd, buffer, BUF_LEN );  

			if ( length < 0 ) 
			{
				perror( "read" );
			}  

			i = 0;
			while ( i < length ) 
			{			

				struct inotify_event *event = ( struct inotify_event * ) &buffer[ i ];

				if ( event->mask & IN_CREATE ) 
				{
					printf( "The file was created.\n");
				}
				else if ( event->mask & IN_MODIFY ) 
				{
					printf( "The file was modified.\n");
				}
				else if( event->mask & IN_ATTRIB)
				{
					printf( "A file attribute was modified.\n");
				}
				else if( event->mask & IN_ACCESS)
				{
					printf( "The file was accessed.\n");
					system(argv[2]);
				}
				
				else
				{
					printf( "Unknown access (%X).",event->mask); 
				}

				i += EVENT_SIZE + event->len;
			}
		}
		else
		{
			printf("Unknown read notification.\n");
		}

	}

	( void ) inotify_rm_watch( fd, wd );
	( void ) close( fd );

	exit( 0 );
}
