/*
Copyright (c) 2011, Vanderbilt University.
Developed with the sponsorship of the Defense Advanced Research Projects Agency (DARPA).
Permission is hereby granted, free of charge, to any person obtaining a copy of this data, including any software or models in 
source or binary form, as well as any drawings, specifications, and documentation (collectively "the Data"), to deal in the 
Data without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Data, and to permit persons to whom the Data is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Data.
THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS, SPONSORS, DEVELOPERS, 
CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.
*/



#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <limits.h>

#define READ_BUFF_SIZE 100

int main( int argc, char **argv ) 
{
	char read_buffer[READ_BUFF_SIZE];
	struct timeval time_to_wait;
	int ret;
	fd_set readfs;
	char path_buff[PATH_MAX + 20];
	int err;
	int fd;
	int fd_processing;


	if(argc != 3)
	{
		printf("Usage: <file to watch> <command line to execute \n");
		return -1;
	}

	time_to_wait.tv_sec = 1;
	time_to_wait.tv_usec = 0;



	while(1)
	{

		FD_ZERO ( &readfs );	  
		FD_SET(fileno(stdin)+1, &readfs);

		ret = select ( fileno(stdin) + 1, &readfs, NULL, NULL, &time_to_wait);

		if ( ret < 0 ) 
		{
			fprintf(stderr, "Unknown error in select\n");
		}
		else if( ret == 0)
		{

			fd_processing = open("./processing", O_RDONLY);
			if(  fd_processing > -1)
			{
				close(fd_processing);
				continue;
			}

			

			fd = open(argv[1], O_RDONLY);
			if( fd > -1)
			{
				close(fd);
				printf("File has been created\n");				
				system("echo \"processing\" > ./processing");
				system(argv[2]);
			}
			
		}

		else if( FD_ISSET( fileno(stdin), &readfs )) // stdin
		{
			ret = read(fileno(stdin), read_buffer, READ_BUFF_SIZE);

			if(ret >=0)
			{
				return 0;
			}
		}	
	}


	exit( 0 );
}
