function sl_customization( cm )
% SL_CUSTOMIZATION Customization file for Model Transformations and Verification.
%   Adds MTV to the Simulink editor's Tools menu.
    
%   Author(s): Gabor Pap, Tihamer Levendovszky
%   Copyright 2010-2011 ISIS - Vanderbilt University
%   $Revision: 1.0.0.0 $  $Date: 2011/01/15

    % SL Tools Menu
    cm.addCustomMenuFcn('Simulink:ToolsMenu', @getSLMenuItems);
    
    % SL Context Menu
    cm.addCustomMenuFcn('Simulink:PreContextMenu', @getSLContextMenuItems);
    
end

function schemaFcns = getSLContextMenuItems(callbackInfo)
    schemaFcns = { @getSL_CMItem};
end

function schema = getSL_CMItem(callbackInfo)
    schema          = sl_action_schema;
    schema.tag      = 'Simulink:MDL2HAItem1';
    schema.label    = '&MDL 2 HA';
    schema.callback = @dummy1;
end

function dummy1(varargin)
    disp('MDL2HA Context Menu called');
end
%-------------------------------------------------------------------------
function schemaFcns = getSLMenuItems(callbackInfo)
    schemaFcns = { @getSL_TMItem };
end

function schema = getSL_TMItem(callbackInfo)
    schema          = sl_action_schema;
    schema.tag      = 'Simulink:MDL2HAItem2';
    schema.label    = '&MDL 2 HA';
    schema.callback = @dummy2;
end

function dummy2(varargin)
    disp('MDL2HA Tools Menu called');
end
