; Setup for .NET v4 Client Profile

#pragma option -v+
#pragma verboselevel 9

#define OutputFileBase "setup_ISIS-VerificationManager"

#define GMEVER "'10.2.9'"

#define OUTPUT_PATH SourcePath
#define COMPONENT_PATH SourcePath + "..\VerificationManager\"
#define COMPONENT_VER  "1.0"
; DLL file name without path
#define COMPONENT_DLL_NAME "VerificationManager.dll"
; Guid of the Component (ComponentConfig.guid) between double opening braces and single closing one
#define COMPONENT_GUID "{{3B361AF0-8507-4595-87CF-2D76B9DA5472}"
; The ProgId of the component: ComponentConfig.ProgId
#define COMPONENT_PROGID "MGA.Interpreter.VerificationManager"
; The fully qualified name of the assembly. Version, etc in AssemblyInfo.cs. Use SDK tool sn -Tp to find the public key token.
#define COMPONENT_ASSEMBLY_INFO "VerificationManager, Version=1.0.0.0, Culture=neutral, PublicKeyToken=7c6db9f15cab782d"
; The component class that has the Guid, ProgId, etc. attributes with full namespace names delimited by dots. E.g. GME.CSharp.MyComponent.MyComponent
#define COMPONENT_CLASS "GME.CSharp.VerificationManager.VerificationManager"
; ComponentConfig.componentName
#define COMPONENT_NAME "Vanderbilt Verification Manager"
; ComponentConfig.paradigmName
#define PARADIGM_NAME "CyPhyML"


#define CYPHY_PATH SourcePath+ "..\..\..\..\meta\CyPhyML"
#define VERIFICATION_MANAGER_INTERFACE SourcePath  + "..\GeneralIntegrationInterface"

[Setup]
AppName=ISIS Verification Manager {#COMPONENT_VER}
AppVerName=ISIS Verification Manager {#COMPONENT_VER}
AppPublisher=ISIS, Vanderbilt University
DefaultDirName={pf}\ISIS\Verification Manager
DefaultGroupName=ISIS Verification Manager
SourceDir={#COMPONENT_PATH}
OutputDir={#OUTPUT_PATH}
OutputBaseFilename={#OutputFileBase}{#COMPONENT_VER}
Compression=lzma
SolidCompression=yes
ChangesEnvironment=true
AppCopyright=Copyright (C) 2007-2011 ISIS, Vanderbilt University

[Languages]
Name: english; MessagesFile: compiler:Default.isl


[Files]
; Interpreter DLL
Source: {#COMPONENT_PATH}bin\Release\{#COMPONENT_DLL_NAME}; DestDir: {app}\bin; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\Interface\VerificationIntegratorLib.dll; DestDir: {app}\bin; StrongAssemblyName: "VerificationIntegratorLib, Version=1.0.0.0, Culture=neutral, PublicKeyToken=15530e110e792458"; Flags: ignoreversion gacinstall sharedfile uninsnosharedfileprompt


; Component icon
Source: {#COMPONENT_PATH}Component.ico;DestDir: {app}\bin; Flags: ignoreversion

; Sources (C# project structure)
Source: {#COMPONENT_PATH}*.cs;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}Properties\*.cs;DestDir: {app}\src\\Properties; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.snk;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.csproj;DestDir: {app}\src; Flags: ignoreversion
Source: {#COMPONENT_PATH}*.sln;DestDir: {app}\src; Flags: ignoreversion

; Interface
Source: {#VERIFICATION_MANAGER_INTERFACE}\Interface\*.idl;DestDir: {app}\interface; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\Interface\*.tlb;DestDir: {app}\interface; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\Interface\*.snk;DestDir: {app}\interface; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\SampleIntegratorPlugin\*.snk;DestDir: {app}\interface\SampleIntegratorPlugin; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\SampleIntegratorPlugin\*.cs;DestDir: {app}\interface\SampleIntegratorPlugin; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\SampleIntegratorPlugin\Properties\*.cs;DestDir: {app}\interface\SampleIntegratorPlugin\Properties; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\SampleIntegratorPlugin\*.csproj;DestDir: {app}\interface\SampleIntegratorPlugin; Flags: ignoreversion
Source: {#VERIFICATION_MANAGER_INTERFACE}\SampleIntegratorPlugin\*.sln;DestDir: {app}\interface\SampleIntegratorPlugin; Flags: ignoreversion

; CyPhy
Source: {#CYPHY_PATH}\CyPhyML.xme;DestDir: {app}\CyPhy\; Flags: ignoreversion
Source: {#CYPHY_PATH}\icons\*.bmp;DestDir: {app}\CyPhy\icons\; Flags: ignoreversion
Source: {#CYPHY_PATH}\icons\*.jpg;DestDir: {app}\CyPhy\icons\; Flags: ignoreversion
Source: {#CYPHY_PATH}\icons\*.png;DestDir: {app}\CyPhy\icons\; Flags: ignoreversion
Source: {#CYPHY_PATH}\icons\*.svg;DestDir: {app}\CyPhy\icons\; Flags: ignoreversion
Source: {#CYPHY_PATH}\icons\IFV_Icons\*.png;DestDir: {app}\CyPhy\icons\; Flags: ignoreversion





[Registry]
;;;;;;;;; Component Registration - Windows ;;;;;;;
; ProgID
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID};ValueType: string; ValueData: {#COMPONENT_CLASS};Flags: uninsdeletekey;
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\Implemented Categories;

;The component category identified by the guid 62C8FE65-4EBB-45e7-B440-6E39B2CDBF29 identifies all .NET components.
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\Implemented Categories\{{62C8FE65-4EBB-45e7-B440-6E39B2CDBF29}

;InprocServer
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueData:"mscoree.dll";Flags: uninsdeletekey;
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"ThreadingModel";ValueData:"Both";
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"Class";ValueData:{#COMPONENT_CLASS};
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"Assembly";ValueData: {#COMPONENT_ASSEMBLY_INFO};
; Change this line to Full 4.0 profiel or other .NET versions:
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"RuntimeVersion";ValueData:"{reg:HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Client,Version|v4.0.30319}";
Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\InprocServer32; ValueType: string; ValueName:"CodeBase";ValueData:{code:PathToURI|{app}\bin\{#COMPONENT_DLL_NAME}};

Root: HKCR; Subkey:CLSID\{#COMPONENT_GUID}\ProgId; ValueType: string; ValueData: {#COMPONENT_PROGID}


Root: HKCR; Subkey:{#COMPONENT_PROGID};ValueType:string;ValueData: {#COMPONENT_CLASS}; Flags: uninsdeletekey;
Root: HKCR; Subkey:{#COMPONENT_PROGID}\CLSID;ValueType:string;ValueData:{#COMPONENT_GUID}



;;;;;;;;; Component Registration - GME ;;;;;;;
Root: HKLM; Subkey: Software\GME\Components\{#COMPONENT_PROGID}; ValueName:Description;ValueType:string; ValueData:{#COMPONENT_NAME};Flags: uninsdeletekey;
Root: HKLM; Subkey: Software\GME\Components\{#COMPONENT_PROGID}; ValueName:Icon;ValueType:string; ValueData: {app}\bin\Component.ico
Root: HKLM; Subkey: Software\GME\Components\{#COMPONENT_PROGID}; ValueName:Paradigm;ValueType:string; ValueData:{#PARADIGM_NAME}
Root: HKLM; Subkey: Software\GME\Components\{#COMPONENT_PROGID}; ValueName:Type;ValueType:dword; ValueData: "$1"
Root: HKLM; Subkey: Software\GME\Components\{#COMPONENT_PROGID}\Associated; ValueName:{#PARADIGM_NAME};ValueType: string; ValueData:"";

[Code]

function PathToURI(path:String):String;
begin
    StringChangeEx(path, '\', '/', True);
    Result:= 'file:///' + path; 
end;




function VersionNumberToInteger(version: String): Integer;
var
   dotPos: Integer;
 begin
 
  repeat
    dotPos := Pos('.', version);
    if (dotPos <> 0) then
    begin
     Delete(version, dotPos, 1);
    end
   until  dotPos<>0;

    Result := StrToInt(version);
 end;


function IsGMEVersionCurrentOrLater(version:String): Boolean;
var
  gme_path : String;
  gme_version: String;
  gme_object :  Variant;


begin
  gme_path := GetEnv('GME_ROOT');
  if gme_path = '' then begin
    MsgBox('Unable to locate GME.  Please install GME first.', mbError, MB_OK);
    Result := False;
  end 
  else 
  begin
    gme_object := CreateOleObject('GME.Application');
    gme_version := gme_object.Version;

    if VersionNumberToInteger(gme_version)> VersionNumberToInteger(version) then begin
      MsgBox('GME Component needs GME '+ version+' or later. The current GME version is '+gme_object.Version+'.'#13#13'Please install an appropriate GME version first.', mbError, MB_OK);
      Result := False;
    end
    else
      Result:=True;
    IDispatchInvoke(gme_object, False, 'Exit', []);
  end;
end;



function NextButtonClick(CurPageID: Integer): Boolean;
begin
  Result := True;
  if (CurPageID = wpInfoBefore) and not WizardSilent() then begin
    Result := IsGMEVersionCurrentOrLater({#GMEVER});
  end;
end;

