

class ValuePortDirectionality:
    _PushToDesign_ = "PushToDesign"
    _PullFromDesign_ = "PullFromDesign"


import ISIS
import AVM.META.Design

class Environment:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        pass


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.Environment\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.Environment\":  " + str( e )

        return self





class ExecutionType:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        pass


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.ExecutionType\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.ExecutionType\":  " + str( e )

        return self





class PostProcessing:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Script = ""


    def get_Script(self):
        return self._Script


    def set_Script(self,Script):
        self._Script = Script


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Script":
                    self.deserialize_Script( jsonObject[ "Script" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.PostProcessing\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.PostProcessing\":  " + str( e )

        return self


    def deserialize_Script( self, object ):
        self.set_Script( object )





class TestBenchModel:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._ExecutionType = None
        self._Metrics = []
        self._Name = ""
        self._PortConnectors = []
        self._PostProcessing = []
        self._TestBenchPort = None
        self._TestBenchValuePort = None
        self._TestComponents = []
        self._ValueConnector = None


    def get_Name(self):
        return self._Name


    def set_ExecutionType(self,ExecutionType):
        self._ExecutionType = ExecutionType


    def set_Name(self,Name):
        self._Name = Name


    def set_TestBenchPort(self,TestBenchPort):
        self._TestBenchPort = TestBenchPort


    def set_TestBenchValuePort(self,TestBenchValuePort):
        self._TestBenchValuePort = TestBenchValuePort


    def set_ValueConnector(self,ValueConnector):
        self._ValueConnector = ValueConnector


    def get_ExecutionType(self):
        return self._ExecutionType


    def get_Metrics(self):
        return self._Metrics


    def get_PortConnectors(self):
        return self._PortConnectors


    def get_PostProcessing(self):
        return self._PostProcessing


    def get_TestBenchPort(self):
        return self._TestBenchPort


    def get_TestBenchValuePort(self):
        return self._TestBenchValuePort


    def get_TestComponents(self):
        return self._TestComponents


    def get_ValueConnector(self):
        return self._ValueConnector


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ExecutionType":
                    self.deserialize_ExecutionType( jsonObject[ "ExecutionType" ] )
                elif memberName == "Metrics":
                    self.deserialize_Metrics( jsonObject[ "Metrics" ] )
                elif memberName == "PortConnectors":
                    self.deserialize_PortConnectors( jsonObject[ "PortConnectors" ] )
                elif memberName == "PostProcessing":
                    self.deserialize_PostProcessing( jsonObject[ "PostProcessing" ] )
                elif memberName == "TestBenchPort":
                    self.deserialize_TestBenchPort( jsonObject[ "TestBenchPort" ] )
                elif memberName == "TestBenchValuePort":
                    self.deserialize_TestBenchValuePort( jsonObject[ "TestBenchValuePort" ] )
                elif memberName == "TestComponents":
                    self.deserialize_TestComponents( jsonObject[ "TestComponents" ] )
                elif memberName == "ValueConnector":
                    self.deserialize_ValueConnector( jsonObject[ "ValueConnector" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.TestBenchModel\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.TestBenchModel\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_ExecutionType( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_ExecutionType )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.META.Design.TestBench.ExecutionType\" instance.  Cannot create instance directly from \"AVM.META.Design.TestBench.ExecutionType\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "ExecutionType" ] )
            baseAVMClass = getattr( baseModule, "ExecutionType" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.ExecutionType\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.ExecutionType\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_ExecutionType(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return


    def deserialize_Metrics( self, object ):
        del self.get_Metrics()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Metrics(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBench.Metric\" object.  Creating instance directly from \"AVM.META.Design.TestBench.Metric\" class."
                objectType = "AVM.META.Design.TestBench.Metric"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "Metric" ] )
                baseAVMClass = getattr( baseModule, "Metric" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.Metric\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.Metric\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Metrics().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_PortConnectors( self, object ):
        del self.get_PortConnectors()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PortConnectors(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.PortConnector\" object.  Creating instance directly from \"AVM.META.Design.PortConnector\" class."
                objectType = "AVM.META.Design.PortConnector"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "PortConnector" ] )
                baseAVMClass = getattr( baseModule, "PortConnector" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.PortConnector\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.PortConnector\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PortConnectors().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_PostProcessing( self, object ):
        del self.get_PostProcessing()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PostProcessing(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBench.PostProcessing\" object.  Creating instance directly from \"AVM.META.Design.TestBench.PostProcessing\" class."
                objectType = "AVM.META.Design.TestBench.PostProcessing"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "PostProcessing" ] )
                baseAVMClass = getattr( baseModule, "PostProcessing" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.PostProcessing\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.PostProcessing\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PostProcessing().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_TestBenchPort( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_TestBenchPort )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBench.TestBenchPort\" object.  Creating instance directly from \"AVM.META.Design.TestBench.TestBenchPort\" class."
            objectType = "AVM.META.Design.TestBench.TestBenchPort"

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "TestBenchPort" ] )
            baseAVMClass = getattr( baseModule, "TestBenchPort" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.TestBenchPort\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.TestBenchPort\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_TestBenchPort(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return


    def deserialize_TestBenchValuePort( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_TestBenchValuePort )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBench.TestBenchValuePort\" object.  Creating instance directly from \"AVM.META.Design.TestBench.TestBenchValuePort\" class."
            objectType = "AVM.META.Design.TestBench.TestBenchValuePort"

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "TestBenchValuePort" ] )
            baseAVMClass = getattr( baseModule, "TestBenchValuePort" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.TestBenchValuePort\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.TestBenchValuePort\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_TestBenchValuePort(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return


    def deserialize_TestComponents( self, object ):
        del self.get_TestComponents()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_TestComponents(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.ComponentInstance\" object.  Creating instance directly from \"AVM.META.Design.ComponentInstance\" class."
                objectType = "AVM.META.Design.ComponentInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ComponentInstance" ] )
                baseAVMClass = getattr( baseModule, "ComponentInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ComponentInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ComponentInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_TestComponents().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_ValueConnector( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_ValueConnector )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "WARNING:  No \"$type\" for \"AVM.META.Design.ValueConnector\" object.  Creating instance directly from \"AVM.META.Design.ValueConnector\" class."
            objectType = "AVM.META.Design.ValueConnector"

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ValueConnector" ] )
            baseAVMClass = getattr( baseModule, "ValueConnector" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.ValueConnector\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ValueConnector\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_ValueConnector(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class DynamicsSimulation(ExecutionType):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ExecutionType.__init__(self)
        self._Environments = []
        self._NumberOfIntervals = 0
        self._StartTime = 0.0
        self._StopTime = 0.0
        self._Tolerance = 0.0
        self._ToolSpecificAnnotations = []


    def get_NumberOfIntervals(self):
        return self._NumberOfIntervals


    def get_StartTime(self):
        return self._StartTime


    def get_StopTime(self):
        return self._StopTime


    def get_Tolerance(self):
        return self._Tolerance


    def get_ToolSpecificAnnotations(self):
        return self._ToolSpecificAnnotations


    def set_NumberOfIntervals(self,NumberOfIntervals):
        self._NumberOfIntervals = NumberOfIntervals


    def set_StartTime(self,StartTime):
        self._StartTime = StartTime


    def set_StopTime(self,StopTime):
        self._StopTime = StopTime


    def set_Tolerance(self,Tolerance):
        self._Tolerance = Tolerance


    def get_Environments(self):
        return self._Environments


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "NumberOfIntervals":
                    self.deserialize_NumberOfIntervals( jsonObject[ "NumberOfIntervals" ] )
                elif memberName == "StartTime":
                    self.deserialize_StartTime( jsonObject[ "StartTime" ] )
                elif memberName == "StopTime":
                    self.deserialize_StopTime( jsonObject[ "StopTime" ] )
                elif memberName == "Tolerance":
                    self.deserialize_Tolerance( jsonObject[ "Tolerance" ] )
                elif memberName == "ToolSpecificAnnotations":
                    self.deserialize_ToolSpecificAnnotations( jsonObject[ "ToolSpecificAnnotations" ] )
                elif memberName == "Environments":
                    self.deserialize_Environments( jsonObject[ "Environments" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.DynamicsSimulation\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.DynamicsSimulation\":  " + str( e )

        return self


    def deserialize_NumberOfIntervals( self, object ):
        self.set_NumberOfIntervals( object )


    def deserialize_StartTime( self, object ):
        self.set_StartTime( object )


    def deserialize_StopTime( self, object ):
        self.set_StopTime( object )


    def deserialize_Tolerance( self, object ):
        self.set_Tolerance( object )


    def deserialize_ToolSpecificAnnotations( self, object ):
        del self.get_ToolSpecificAnnotations()[:]
        for arrayObject in object:
            self.get_ToolSpecificAnnotations().append( arrayObject )

    def deserialize_Environments( self, object ):
        del self.get_Environments()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Environments(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBench.Environment\" object.  Creating instance directly from \"AVM.META.Design.TestBench.Environment\" class."
                objectType = "AVM.META.Design.TestBench.Environment"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "Environment" ] )
                baseAVMClass = getattr( baseModule, "Environment" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.TestBench.Environment\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBench.Environment\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Environments().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class Metric(AVM.META.Design.ValueType):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.META.Design.ValueType.__init__(self)
        self._Name = ""
        self._Unit = ""


    def get_Name(self):
        return self._Name


    def get_Unit(self):
        return self._Unit


    def set_Name(self,Name):
        self._Name = Name


    def set_Unit(self,Unit):
        self._Unit = Unit


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.Metric\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.Metric\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )





class TestBenchPort(AVM.META.Design.AbstractPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.META.Design.AbstractPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "PortConnector":
                    self.deserialize_PortConnector( jsonObject[ "PortConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.TestBenchPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.TestBenchPort\":  " + str( e )

        return self





class TestBenchValuePort(AVM.META.Design.ValueType):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.META.Design.ValueType.__init__(self)
        self._Directionality = None


    def get_Directionality(self):
        return self._Directionality


    def set_Directionality(self,Directionality):
        self._Directionality = Directionality


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Directionality":
                    self.deserialize_Directionality( jsonObject[ "Directionality" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBench.TestBenchValuePort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBench.TestBenchValuePort\":  " + str( e )

        return self


    def deserialize_Directionality( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META.Design.TestBench", globals(), locals(), [ "ValuePortDirectionality" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "ValuePortDirectionality" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.Design.TestBench.ValuePortDirectionality\":  " + str( e )
            return

        self.set_Directionality(  getattr( baseAVMEnumClass, "_" + object + "_" )  )




