function vf_constraintplot(element) {

	var self = this;
	this.data = eval($(element).attr('data'));
	this.element = element;
		
	/* Render Method */
	this.render = function () {
		//try{
		
			if (($(element).attr('rendered') == undefined || $(element).attr('rendered') == "false")) {
			var jsondata = eval($(this.element).attr('data'));
	
		console.debug(jsondata);
		
		function getR(rid, json_fns) {
			for (var i = 0; i < json_fns.length; i++) {
			   if (json_fns[i].rid == rid) {
				   return json_fns[i];
			   }
			}
			return null;
		}
		
		
		//small to large - used to change 31 to 13 because coefficient exists as b13 instead of b31
		function smtolg(a,b) {
			if(parseInt(a)<parseInt(b))
				return a +""+ b;
			else {
				return b +""+ a;
			}
		}
		//default value for variable
		function getDefault(input) {
			var dvs=jsondata.userInputs.defaultVariableValues;
			for (var i = 0; i < dvs.length; i++) {
				if(dvs[i].label==input.label)
					return dvs[i].defaultValue;
			}
		}

		//calculate coefficient a,b,c,d,e,f of a+b*x+c*y+d*x*x+e*y*y+f*x*y by setting 2 variables as x and y and others as constant
		function plot_p(ii, jj, r) {
		
			var plot = new Object();
			plot.r = r;
			plot.rid = r.rid;
			plot.inequality = srs[kk].inequality;
			plot.color = srs[kk].color;
			plot.z = srs[kk].value;
			plot.x_index = ii;
			plot.x_label = aresponse.inputs[ii - 1].label;
			plot.xmin = aresponse.inputs[ii - 1].min;
			plot.xmax = aresponse.inputs[ii - 1].max;
			plot.y_index = jj;
			plot.y_label = aresponse.inputs[jj - 1].label;
			plot.ymin = aresponse.inputs[jj - 1].min;
			plot.ymax = aresponse.inputs[jj - 1].max;
			var counter = 0;
			plot.constvs = new Array();
			for (var k = 1; k < numinputs + 1; k++) {
				if (parseInt(k) != parseInt(ii) && parseInt(k) != parseInt(jj)) {
					plot.constvs[counter++] = k;
				}
			}
			plot.a = r.coefficients["b0"];
			plot.b = r.coefficients["b" + ii];
			plot.c = r.coefficients["b" + jj];
			plot.d = r.coefficients["b" + ii + ii];
			plot.e = r.coefficients["b" + jj + jj];
			plot.f = r.coefficients["b" + ii + jj];
			
			console.debug("=========Before===============");	
			console.debug("plot.a: " + plot.a);
			console.debug("plot.b: " + plot.b);
			console.debug("plot.c: " + plot.c);
			console.debug("plot.d: " + plot.d);
			console.debug("plot.e: " + plot.e);
			console.debug("plot.f: " + plot.f);
			console.debug("==============================");
			
			//based on constant coefficient a, b, and c are modified.
			for (var i = 0; i < plot.constvs.length; i++) {
				var cindex = "b" + plot.constvs[i];
				var cindexindex = cindex + plot.constvs[i];
				var index = plot.constvs[i] - 1;
				//console.debug(i + ", " + plot.a+ " " + r.coefficients[cindexindex] * getDefault(r.inputs[index]) * getDefault(r.inputs[index]) );
				plot.a += r.coefficients[cindexindex] * getDefault(r.inputs[index]) * getDefault(r.inputs[index]);
				//console.debug(i + ", " + plot.a);
				plot.a += r.coefficients[cindex] * getDefault(r.inputs[index]);
				//console.debug(i + ", " + plot.a);
				var bindex = "b" + smtolg(ii, plot.constvs[i]);
				var cindex = "b" + smtolg(jj, plot.constvs[i]);
				plot.b += r.coefficients[bindex] * getDefault(r.inputs[index]);
				plot.c += r.coefficients[cindex] * getDefault(r.inputs[index]);
			}
			console.debug(plot.constvs);
			
			for (var i = 0; i < plot.constvs.length; i++ ){
				for ( var j = i + 1; j < plot.constvs.length; j++ ){
					if ( j > i ) {
						var cindex = "b"+ plot.constvs[i] + plot.constvs[j];
						//console.debug("plot.a:" + plot.a);
						//console.debug("adding to b0 coefficitent : " + cindex + "* const" +  plot.constvs[i] + "* const" + plot.constvs[j]
						//+ " (" + r.coefficients[cindex] + "*" + getDefault(r.inputs[plot.constvs[i]-1]) + "*" + getDefault(r.inputs[plot.constvs[j]-1]) + ")");
						plot.a += r.coefficients[cindex] * getDefault(r.inputs[plot.constvs[i]-1]) *getDefault(r.inputs[plot.constvs[j]-1]);
					}
				}
			}
		
			console.debug("===========After==============");	
			console.debug("plot.a: " + plot.a);
			console.debug("plot.b: " + plot.b);
			console.debug("plot.c: " + plot.c);
			console.debug("plot.d: " + plot.d);
			console.debug("plot.e: " + plot.e);
			console.debug("plot.f: " + plot.f);
			console.debug("==============================");
			return plot;
		} //end of plot function


		var srs = jsondata.userInputs.selectedResponses;
		var selected_v_labels = jsondata.userInputs.selectedVariables;
		
		if ( srs.length == 0 && selected_v_labels.length == 0 ){
			console.debug("Not possible to create constraint plot.");
			$(element).attr('rendered', 'true');
			return;
		}
		var responses = jsondata.responses;
		var allplots_f = new Array();
		var counter_f = 0;
		for (var kk = 0; kk < srs.length; kk++) {
			var aresponse = getR(srs[kk].rid, jsondata.responses)
			var numinputs = aresponse.inputs.length;
			for (var is = 1; is < numinputs; is++) {
				for (var j = 2; j < numinputs + 1; j++) {
					if (is < j) {
						allplots_f[counter_f] = plot_p(is, j, aresponse);
						counter_f++;
					}
				}
			}
		}

		
		var vconfigs = new Array();
		for (var i = 0; i < selected_v_labels.length; i++) {
			vconfigs.push(vConfig(selected_v_labels[i], allplots_f));
		}
		
		function getConstraintPlots(i, j, json_rs, vconfigs, num_of_grids, existing_cps)
		{
			function boundary(x, y) {
					return { xmin: x.min, xmax: x.max, ymin: y.min, ymax: y.max }
			}
			cps = new Array();
			var counter = 0;
			for (var k = 0; k < json_rs.length; k++) 
			{
				//reverse = false;
				if (json_rs[k].x_label == vconfigs[i].label && json_rs[k].y_label == vconfigs[j].label) 
				{
					console.debug("rid: " + json_rs[k].rid + " 1st create cp x = " + vconfigs[j].label + " vs. y = " + vconfigs[i].label);
					
				
					if ( existing_cps != null && existing_cps[counter] != null && existing_cps[counter].fail == false){
						console.debug("============existing_cps[k]============");
						console.debug(existing_cps[counter]);
						cps[counter] = new CConstraintPlot(existing_cps[counter]);
					}
					else {
						/*if ( json_rs[k].e == 0 && json_rs[k].d != 0){
							console.debug("e coefficient is 0: " + json_rs[k].e);
							cps[counter] = null;
						}
						else {*/
							cps[counter] =  new ConstraintPlot(json_rs[k], num_of_grids, boundary(vconfigs[i], vconfigs[j]), false, vconfigs[i].label, vconfigs[j].label, false);
							if ( cps[counter].fail ){
								//keep cps[counter].fail = true then reverse = true will calculate
							}
							else if ( existing_cps != null && existing_cps[counter]!= null && existing_cps[counter].fail == true){
								console.debug("exisiting_cps[k] is null so set as just calculated one");
								existing_cps[counter] = new CConstraintPlot(cps[counter]);
							}
							
						//}
					}
					counter++;
				}
				//reverse = true
				else if (json_rs[k].x_label == vconfigs[j].label && json_rs[k].y_label == vconfigs[i].label) 
				{
					console.debug("rid: " + json_rs[k].rid + " 2nd create cp x = " + vconfigs[j].label + " vs. y = " + vconfigs[i].label);
					
					//if ( existing_cps != null && existing_cps[counter] != null){
					if ( existing_cps != null && existing_cps[counter] != null && existing_cps[counter].fail == false){
						console.debug("============existing_cps[k]============");
						console.debug(existing_cps[counter]);
						cps[counter] = new CConstraintPlot(existing_cps[counter]);
					}
					else {
						/*if ( json_rs[k].d == 0 && json_rs[k].e != 0){
							console.debug("d coefficient is 0: " + json_rs[k].d + "e: " +  json_rs[k].e);
							cps[counter] = null;
						}
						else {*/
							cps[counter] = new ConstraintPlot(json_rs[k], num_of_grids, boundary(vconfigs[j], vconfigs[i]), true, vconfigs[j].label, vconfigs[i].label, false);
							console.debug("********************** calculation done *********************");
							
							if ( cps[counter].fail){
								//keep cps[counter].fail = true then reverse = false will calculate
							}
							else if ( existing_cps != null && existing_cps[counter]!= null && existing_cps[counter].fail == true){
								console.debug("exisiting_cps[k] is null so set as just calculated one's copy");
								existing_cps[counter] = new CConstraintPlot(cps[counter]);
								console.debug(existing_cps[counter]);
							}
						//}
					}
					counter++;
				}
				
			}
			if (cps.length == 0)
				this.cps = null;
				//return null;
			else 
				this.cps = cps;
				//return cps;
			this.old = 	existing_cps;
			console.debug("==================original ================");
			console.debug(this.old);
		}


			function getrs(vconfigs, json_rs, num_of_grids) {
			
				function boundary(x, y) {
					return { xmin: x.min, xmax: x.max, ymin: y.min, ymax: y.max }
				}
	
				var r = {};
				var cps;
				var b_r_add;
				console.debug(vconfigs);
				for (var i = 0; i < vconfigs.length; i++) 
				{
					for (var j = 0; j < vconfigs.length; j++) 
					{
						console.debug("===========plot[" + i + "vs" + j + "]===========");
						if (vconfigs[i].min == null || vconfigs[i].max == null) 
						{
							r[i + "" + j] = null;
							console.debug("r[" + i + "" + j + "] = null----- vconfigs[i].min: " + vconfigs[i].min + " vconfigs[i].max: " + vconfigs[i].max);
						}
						else if (i == j)
							r[i + "" + j] = null;
						else if (vconfigs[j].min == null || vconfigs[j].max == null) 
						{
							console.debug("r[" + i + "" + j + "] = null----- vconfigs.min: " + vconfigs[j].min + " vconfigs.max: " + vconfigs[j].max);
							r[i + "" + j] = null;
						}
						else {
							//new algorithm - only calculate half of plots
							var xx = new getConstraintPlots(i, j, json_rs, vconfigs, num_of_grids ,r[j + "" + i]);
							r[i + "" + j] = xx.cps;
							r[j + "" + i] = xx.old;
							
						}
						
					} //end of for

				} //end of for
				return r;
			}
			//size parameters
			
			
			var n = vconfigs.length;
			var padding = 35;
            var size = (($(element).parent().width() - (padding)) / n) - 1.5;
			var margin = { 
				"right": 20,
				"left": 0,
				"top": 0,
				"bottom": 20
			};
			
	
	
			//num of grids to calculate target value
			var num_of_grids = (($(element).parent().width() - (padding)) / 4 / n) - 1.5; //default = "low"
			if ( jsondata.fidelity == "high") 
				num_of_grids = ((($(element).parent().width() - (padding)) / n))* 2 - 1.5;
			else if ( jsondata.fidelity == "med")
				num_of_grids = (($(element).parent().width() - (padding)) / n) - 1.5;
			//default
			if ( num_of_grids < 0 || !isFinite(num_of_grids)){
				n = 0;
			}
			/*if ( !isFinite(size)){
				size = 500;
				n = 2;
			}
			*/
			//num_of_grids = 500;
			console.debug("num_of_grids: " + num_of_grids);
			
			

			/* if n is zero do nothing */
			if (n != 0) {

				//get responces per cell
				var per_cell = getrs(vconfigs, allplots_f, num_of_grids);
				
				// Position scales.
				var x = {}, y = {};
				vconfigs.forEach(function (vconfigs, index) {
					variable = vconfigs.label;
					var value = function (d) {
						return +d[variable];
					};
					var domain = [vconfigs.min, vconfigs.max],
						range = [padding / 2, size - padding / 2];

					x[variable] = d3.scale.linear()
									.domain(domain)
									.range(range);

					y[variable] = d3.scale.linear()
									.domain(domain)
									.range(range.slice().reverse());
				});

				// Axes. cell
				var axis = d3.svg.axis()
							  .ticks(5)
							  .tickSize(size * n);

				// Brush.
				//            var brush = d3.svg.brush()
				//						  .on("brushstart", brushstart)
				//						  .on("brush", brush)
				//						  .on("brushend", brushend);

				// Root panel.

				var svg = d3.select('#'+$(element).attr('id')).append("svg")
							  .attr("width", size * n + padding)
							  .attr("height", size * n + padding);

				// X-axis.
				svg.selectAll("g.x.axis")
							   .data(vconfigs)
								.enter().append("g")
									.attr("class", "x axis")
									.attr("transform", function (d, i) {
										return "translate(" + i * size + ",0)";
									})
									.each(function (d) {
										d3.select(this)
											.call(axis.scale(x[d.label])
											.orient("bottom"));
									});

				// Y-axis.
				svg.selectAll("g.y.axis")
							  .data(vconfigs)
							.enter().append("g")
							  .attr("class", "y axis")
							  .attr("transform", function (d, i) { return "translate(0," + i * size + ")"; })
							  .each(function (d) { d3.select(this).call(axis.scale(y[d.label]).orient("right")); });


				// Cell and plot.
				var cell = svg.selectAll("g.cell")
							.data(cross(vconfigs, vconfigs))
							.enter().append("g")
							  .attr("class", "cell")
							  .attr("transform", function (d) {
								  return "translate(" + d.i * size + "," + d.j * size + ")";
							  })
							  .each(plot);

				// Titles for the diagonal.
				cell.filter(function (d) { return d.i == d.j; }).append("text")
							  .attr("x", padding)
							  .attr("y", padding)
							  .attr("dy", ".71em")
							  .text(function (d) {
								  //								var unit = "";
								  //								if(outputs.Unit[$.inArray(d.x, outputs.variables)] != ""){
								  //									unit = '  [' + outputs.Unit[$.inArray(d.x, outputs.variables)] + ']'
								  //								}
								  //								return outputs.labels[$.inArray(d.x, outputs.variables)] + unit;
								  if (!(d instanceof Array)) {
									  return d.x.label;
								  }

							  });

				

				function plot(p) 
				{
					var cell = d3.select(this);
					
					// Plot brush?
					//cell.call(brush.x(x[p.x]).y(y[p.y]));

					var p_cell = per_cell[p.i + "" + p.j];
					//p_cell is null if i=j(diagonal) or variable's min > max
					
					if (p_cell == null || p_cell.length == 0)
					{
						//Even if its the diagonal, plot a box... MJD
						cell.append("rect")
						.attr("class", "frame")
						.attr("x", padding / 2)
						.attr("y", padding / 2)
						.attr("width", size - padding)
						.attr("height", size - padding);
						
						return;
					}

					var line, line1, line2, lineM, midex;
					
					for (var i = 0; i < p_cell.length; i++) 
					{
						if (p_cell[i] == null || p_cell[i].all.length == 0)
							continue;
						
						for (var j = 0; j < p_cell[i].all.length; j++) 
						{
							cell.datum(p_cell[i].all[j].ps);
							
							if ( p_cell[i].copied){
								//copied
								console.debug("copied --- [" + p.i + "" + p.j + "] " + p_cell[i].name);
								line = d3.svg.line()
										.x(function (d) { 
											return x[p.x.label](d.y); 
										})
										.y(function (d) { 
											return y[p.y.label](d.x); 
										});	
							}
							else {
								//not copied
								console.debug("notcopied --- [" + p.i  + "" + p.j + "] " + p_cell[i].name);
								line = d3.svg.line()
											.x(function (d) { 
												//console.debug( "x====" + d.x + " " + x[p.x.label](d.x));
												return x[p.x.label](d.x); 
											})
											.y(function (d) { 
												//console.debug( "y====" + d.y + " " + x[p.y.label](d.y));
												return y[p.y.label](d.y); 
											});	
							}
							path = cell.append("path")
									.attr("class", "cp")
									.attr("fill", getColor(p_cell[i].rid))
									.style("stroke-width", 10)
									.attr("opacity", 1)
									.attr("rid", p_cell[i].rid)
									.attr("d", line)
									.attr("id", "rline")
									.attr("pointer-events", "stroke")
									.on("mouseover", mousein)
									.on("mouseout", mouseout);
							path.datum(p_cell[i]); //to show rid using .text(d.rid);
						}
					
					}
                    for (var i = 0; i < p_cell.length; i++) {
					
						//console.debug( "Pcell------------: " + i );
						//console.debug(p_cell[i]);
						/*
                        if ( p_cell[i]== null || p_cell[i].all.length == 0) {
							cell.append("text")
							.attr("x", padding)
							.attr("y", padding)
							.attr("dy", ".71em")
							.text(function(){
								return "Not possible to plot.";
							});
					        continue;
					    }
						*/
						if ( p_cell[i]== null )
							continue;
						cell.append("text")
						cell.append("text")

							.attr("x", padding - padding * 1 + 40)
							.attr("y", padding + (padding - 18) * i - 2)
							.attr("fill", "white")
							.attr("rid", p_cell[i].rid)
							.text(function(){
								if ( p_cell[i].fail && p_cell[i].all.length == 0)
									return p_cell[i].name + " - Not possible to plot";
								else
									return p_cell[i].name;  //MJD
							});
						
						//adding response label on left of cell
						rrect = cell.append("rect")
							.attr("class", "rrect")
							.attr("d", line)
							.attr("x", padding - padding * 1 + 25)
							.attr("y", padding + (padding - 18) * i - 10)
							.attr("width", 10)
							.attr("height", 10)
							.attr("fill", getColor(p_cell[i].rid))
							.attr("rid", p_cell[i].rid)
							.on("mouseover", mousein)
							.on("mouseout", mouseout);
						rrect.datum(p_cell[i]);
						
					}
					
					//Make the cell box on top of the contours (paths) drawn
					//This will make hovering over contours look a lot better... MJD
					cell.append("rect")
						.attr("class", "frame")
						.attr("x", padding / 2)
						.attr("y", padding / 2)
						.attr("width", size - padding)
						.attr("height", size - padding);
				}
				

				function mousein(d) {
					var srid = d.rid;
					var ins = svg.selectAll("path").filter(function (d, i) { if (d.rid == srid) { return true } else return false; });
					ins.attr("mover", true);
				}
				function mouseout(d) {
					var srid = d.rid;
					var ins = svg.selectAll("path").filter(function (d, i) { return d.rid ==srid; });
					ins.attr("mover", false);
				}
				function cross(a, b) {
					var c = [], n = a.length, m = b.length, i, j;
					for (i = -1; ++i < n; ) {
						for (j = -1; ++j < m; ) {
							c.push({ x: a[i], i: i, y: b[j], j: j });
						}
					}
					return c;
				}

				// fix negative signs in axis
				$('text').each(function(index,item){item.textContent = item.textContent.replace("−","-");});

			}
		
		   
			//find functions uses label
			function vConfig(label, json_fns_o) {

				console.debug("======Looking for ====s_label ================ " + label);
				var json_fns_index = new Array();
				var n_min; //possible to be undefined if no response uses this variable
				var n_max; //possible to be undefined if no response uses this variable

				var rfn;
				//for (var i = 0; i < rids.length; i++) {
				for (var i = 0; i < json_fns_o.length; i++) {
					rfn = json_fns_o[i];
					//  rfn = getR(rids[i], json_fns_o);
					if (rfn.x_label == label) {
						console.debug(rfn.x_label + " " + rfn.xmin + " " + rfn.xmax);
						json_fns_index.push(i);
						if (n_min == null || n_min < Number(rfn.xmin))
							n_min = Number(rfn.xmin);
						if (n_max == null || n_max > Number(rfn.xmax))
							n_max = Number(rfn.xmax);
					}
					else if (rfn.y_label == label) {
						console.debug(rfn.y_label + " " + rfn.ymin + " " + rfn.ymax);
						json_fns_index.push(i);
						if (n_min == null || n_min < Number(rfn.ymin))
							n_min = Number(rfn.ymin);
						if (n_max == null || n_max > Number(rfn.ymax))
							n_max = Number(rfn.ymax);
					}
				}
				if (n_min >= n_max) {
					//console.debug("*********************n_min: " + n_min + " n_max: " + n_max);
					n_min = null;
					n_max = null;
				}
				console.debug(label + " " + n_min + " " + n_max + " " + json_fns_index);
				return { label: label, min: n_min, max: n_max, r_index: json_fns_index };
			}
			function getColor(rid){
				for (var i = 0; i < allplots_f.length; i++) {
					if (allplots_f[i].rid == rid) {
						return allplots_f[i].color;
					}
				}
				return null;
			}
			
			// copy existing ConstraintPlot but make reverse opposite
			function CConstraintPlot( cp )
			{
				this.rid = cp.rid;
				this.reverse = cp.reverse;
				this.name = cp.name;
				this.all = cp.all;
				this.copied = !cp.copied;
				this.fail = false;

				this.Points1 = cp.Points1;
				this.Points2 = cp.Points2;
				this.PointsM = cp.PointsM;
			}
			//per line
			function ConstraintPlot (fn, num_of_grids, v, reverse, xlabel, ylabel, copied)
			{
				this.fail = false;
				this.copied = copied;
				this.rid = fn.rid;
				this.reverse = reverse;
				this.name = fn.r.metric; //MJD
				this.all = new Array(); //contains list of points 1) all points in 1 array 2) P1 is bottom points to create path & P2 is top points to create path

				
				var a = Number(fn.a);
				var b = Number(fn.b);
				var c = Number(fn.c);
				var d = Number(fn.d);
				var e = Number(fn.e);
				var f = Number(fn.f);
				
				if ( e == 0 && d != 0 && !reverse){
					console.debug("e coefficient is 0: e = " + e + " d = " + d);
					this.fail = true;
					return;
				}
				else if ( d == 0 && e != 0 && reverse){
					console.debug("d coefficient is 0: d = " + d + " e = " + e);
					this.fail = true;
					return;
				}
				
				
				var z_target = Number(fn.z); ;
				var inequality = fn.inequality;
				
				if (reverse) {
					this.ymin = Number(v.xmin);
					this.ymax = Number(v.xmax);
					this.xmin = Number(v.ymin);
					this.xmax = Number(v.ymax);
				}
				else {
					this.xmin = Number(v.xmin);
					this.xmax = Number(v.xmax);
					this.ymin = Number(v.ymin);
					this.ymax = Number(v.ymax);
				}
				console.debug("========================= rname: " + this.name + " is reverse?: " + reverse);
				console.debug("xmin: " + this.xmin + " xmax: " + this.xmax);
				console.debug("ymin: " + this.ymin + " ymax: " + this.ymax);
				console.debug("ztarget: " + inequality + " " + z_target);
				console.debug("a: " + a );
				console.debug("b: " + b );
				console.debug("c: " + c );
				console.debug("d: " + d );
				console.debug("e: " + e );
				console.debug("f: " + f );

				
				if ( d == 0 && e == 0 ) {
					if ( jsondata.fidelity == "low" || jsondata.fidelity == "med") {
						console.debug("fidelity is low/med -> change to high from " + num_of_grids);
						num_of_grids = ((($(element).parent().width() - (padding)) / n))* 2 - 1.5;
						console.debug("to: " + num_of_grids);
					}
				}
				
				var myXGrids = new XGrids(this.xmin, this.xmax, num_of_grids);
				console.debug(myXGrids);
				this.x_grid_data = myXGrids.x_data;

				var Points1 = new Array();
				var Points2 = new Array();
				var PointsM = new Array(); //contain both x and y but may be y itself is ok if always having P1 and P2 at xi
				var top; //p1 or p2
				var p1_ymin, p1_ymax, p2_ymin, p2_ymax, p1_ymax_index, p2_ymax_index

				
		
			
			
				
				for (var i = 0; i < this.x_grid_data.length; i++) {
					if (!reverse) {
						p = new Find_Y_Points  (a, b, c, d, e, f, z_target, this.x_grid_data, i, this.ymin, this.ymax);
					}
					else { //reverse
						p = new Find_Y_Points_R(a, b, c, d, e, f, z_target, this.x_grid_data, i, this.ymin, this.ymax);
					}
					
					//console.debug(i + " " + "x: " + this.x_grid_data[i] + " p.y1: " + p.y1 + " p.y2" + p.y2 + " z_ymin: " + p.z_ymin + " z_ymax: " + p.z_ymax);
					
					if ( p.y1 == null ) {//means temp was negative - can't create valid plot
						console.debug("temp (inside root) was negative so returning null. - can't calculate y values");
						this.fail = true;
						return;
					}
						
					if (isNaN(p.z_ymin) || isNaN(p.z_ymax)) {
						console.error("Boundary is invalid.  target value is NaN. Can't create a valid graph.");
						this.fail = true;
						return;
					}
					
					//p.y1 is a valid number
					if (!isNaN(p.y1)){
						//if ( d == 0 && e == 0 && (p.y1 > this.ymax || p.y1 < this.ymin))
							//continue;
						Points1.push(new Point(this.x_grid_data[i], p.y1));
						if (p1_ymin == null) {
							p1_ymin = p.y1;
							p1_ymax = p.y1;
							p1_ymax_index = i;
						}
						else if (p.y1 < p1_ymin)
							p1_ymin = p.y1;
						else if (p.y1 > p1_ymax) {
							p1_ymax = p.y1;
							p1_ymax_index = i;
						}
					}
					
					//p.y2 is a valid number	
					if (!isNaN(p.y2)) {
						Points2.push(new Point(this.x_grid_data[i], p.y2));
						if (p2_ymin == null) {
							p2_ymin = p.y2;
							p2_ymax = p.y2;
							p2_ymax_index = i;
						}
						else if (p.y2 < p2_ymin)
							p2_ymin = p.y2;
						else if (p.y2 > p2_ymax) {
							p2_ymax = p.y2;
							p2_ymax_index = i;
						}
					}
					//find which points (Points1 or Points2) are top
					//once top is set, should not be chaned if the equation is valid.

					if (!isNaN(p.y1) && !isNaN(p.y2)) {
						if (p.y1 > p.y2) { //p1 should be top
							PointsM.push(new Point(this.x_grid_data[i], (p.y1 - p.y2) / 2 + p.y2));
							if (top != null && top != "p1") {
								console.error("response is not valid.");
								return;
							}
							top = "p1";
						}
						else if (p.y1 < p.y2) { //p2 should be top
							PointsM.push(new Point(this.x_grid_data[i], (p.y2 - p.y1) / 2 + p.y1));
							if (top != null && top != "p2") {
								console.error("response is not valid.");
								return;
							}
							top = "p2";
						}
						//ignore both are the same case
					}
				} //end of i

                //top is null if a+bx+cy+dx^2+ey^2+fxy's d and e are zero.
				if (top == null){
    				var hDEZero = new handleDAndEAreZero(Points1, a, b, c, d, e, f, this.xmin, this.ymin, this.xmax, this.ymax, reverse, z_target, inequality);
					if ( hDEZero.fail ){
						this.fail = true;
						if ( reverse ){ //if reverse is not possible to plot too then show the error.
							console.error("Not possible to plot.  Please increase the fidelity or screen size.");
							console.debug("num_of_grids: " + num_of_grids);
						}
						console.debug("Not able to plot - only reverse is true show the alert (reverse = " + reverse + ")");
						//this.all = false;
						
					}
					this.all = hDEZero.lines;
					return;
				}

	            //debug
	            this.Points1 = Points1;
	            this.Points2 = Points2;
	            this.PointsM = PointsM;

	            //define 4 corner points
	            var pii = new Point(this.xmin, this.ymin); //xminymin
	            var pai = new Point(this.xmax, this.ymin); //xmaxymin
	            var paa = new Point(this.xmax, this.ymax); //xmaxymax
	            var pia = new Point(this.xmin, this.ymax); //xminymax

				//no point with z = ztarget found so check at 4 corner
				if (Points1.length == 0 && Points2.length == 0) {
				    //check if all min max corner has number
				    var vs = new get4ConnerZValues(a, b, c, d, e, f, this.xmin, this.ymin, this.xmax, this.ymax, reverse);

    				console.debug("Point1.length = 0 & Point2.length = 0" );
					console.debug("target : " + inequality  + z_target);

					//check 4 corner value - may return solid(all fail) or empty(all pass)
					if (inequality == ">=") {
							if ((vs.vpii >= z_target) && (vs.vpai >= z_target) && (vs.vpaa >= z_target) && (vs.vpia >= z_target)) {
							   this.all = new PointSet(new Array());
								return;
							}
							else if ((vs.vpii <= z_target) && (vs.vpai <= z_target) && (vs.vpaa <= z_target) && (vs.vpia <= z_target)) {
								 this.all.push(get4CornerPointSet(pii, pai, paa, pia)); //solid
							}
						}
						else if (inequality == "<=") {
							if ((vs.vpii <= z_target) && (vs.vpai <= z_target) && (vs.vpaa <= z_target) && (vs.vpia <= z_target)) {
								this.all = new PointSet(new Array());
								return;
							}
							else if ((vs.vpii >= z_target) && (vs.vpai >= z_target) && (vs.vpaa >= z_target) && (vs.vpia >= z_target)) {
								this.all.push(get4CornerPointSet(pii, pai, paa, pia)); //solid
								return;
							}
					}
					else {
						console.error("inequality has invalid selection.  Please use >= or <=");
						this.fail = true;
                        return;
					}
				}

				var p_top_ymin, p_top_ymax, p_bot_ymin, p_bot_ymax, p_top_ymax_index, p_bot_ymax_index;
				//#2 find pt_top and pt_bottom
				var p_top; //top points
				var p_bot; //bottom points
				if (Points1.length < 2 && Points2.length < 2) {
					console.error("Not possible to plot \"" + this.name + "\"");
					this.fail = true;
					return ;
				}
				if (top == "p1") {
					p_top = Points1;
					p_bot = Points2;
					console.debug("Points1 are top");
					p_top_ymin = p1_ymin;
					p_top_ymax = p1_ymax;
					p_bot_ymin = p2_ymin;
					p_bot_ymax = p2_ymax;
					p_top_ymax_index = p1_ymax_index;
					p_bot_ymax_index = p2_ymax_index;
				}
				else if (top == "p2") {
					p_top = Points2;
					p_bot = Points1;
					console.debug("Points2 are top");
					p_top_ymin = p2_ymin;
					p_top_ymax = p2_ymax;
					p_bot_ymin = p1_ymin;
					p_bot_ymax = p1_ymax;
					p_top_ymax_index = p2_ymax_index;
					p_bot_ymax_index = p1_ymax_index;

				}
				else {
					console.error("top line could not be identified.");
					return false;
				}

				console.debug("============== top " + p_top.length + "=======================");
				console.debug("p_top_ymin: " + p_top_ymin);
				console.debug("p_top_ymax: " + p_top_ymax + " p_top_ymax_index: " + p_top_ymax_index);
				console.debug(p_top);

				console.debug("============== bottom " + p_bot.length + "=======================");
				console.debug("p_bot_ymin: " + p_bot_ymin);
				console.debug("p_bot_ymax: " + p_bot_ymax + " p_bot_ymax_index: " + p_bot_ymax_index);
				console.debug(p_bot);

				console.debug("============= middle: " +PointsM.length +" ======================");
				console.debug(PointsM);
				

				
				var is__middle_target = IsMiddleTargetRegion(a, b, c, d, e, f, PointsM, z_target, inequality, reverse); //target region
				
				if ( is__middle_target == undefined) 
				{
					throw "Constraint Plot can not plotted because its target region can not be determined.";
					
				}
				//modify so that shadinging area is target area
				if (!is__middle_target) 
				{ //middle is not in target so shade (non-target region)
					//good region is outside so shade inside
					console.debug("SHADE IN");
					this.all= getInPointsLine(p_top, p_bot, this.xmin, this.xmax, this.ymin, this.ymax);//, p_top_ymin, p_top_ymax, p_bot_ymin, p_bot_ymax, pii, pai, paa, pia);
				}
				else 
				{
					//good region is inside - so shade outside
					console.debug("SHADE OUT");
					//Points1(top) and Points2(top) contains Points that is having number x y corrdinate
					this.all = getOutPointsLinesTop(p_top, p_bot, PointsM, pii, pai, paa, pia, this.xmin, this.xmax, this.ymin, this.ymax, a, b, c, d, e, f, z_target);
					this.all = this.all.concat(getOutPointsLinesBottom(p_top, p_bot, PointsM, pii, pai, paa, pia, this.xmin, this.xmax, this.ymin, this.ymax));
				}
				console.debug("===========all=================");
				console.debug(this.all);
				return true;
			} //end of ConstraintPlot
			
			//return false if can 't plot
			//An error message and alert are handle at calling method
			function handleDAndEAreZero(Points, a, b, c, d, e, f, xmin, ymin, xmax, ymax, reverse, z_target, inequality) {

				this.fail = false;
			    this.lines = new Array();
			    if (Points[0].y < ymax && Points[0].y > ymin) { //A, D, F ...
			        var pADF = new PatternADF(Points, xmin, ymin, xmax, ymax);
			        var vaa_in_target = false;

			        console.debug("pADF.pattern : " + pADF.pattern);
			        if (inTarget(getZValue(a, b, c, d, e, f, xmax, ymax, reverse), z_target, inequality)) //check if vaa is in target or not
			            vaa_in_target = true;
                    if (pADF.pattern == "D") {
                         if (vaa_in_target) {
							if (inTarget(getZValue(a, b, c, d, e, f, xmin, ymax, reverse), z_target, inequality)){ //check via
								pADF.fline.push(new Point(xmax, ymin)); //vai
								pADF.fline.push(new Point(xmin, ymin)); //vii
							 }
							 else {
								this.fail = true;
								return;
								}
                         }
                         else {
							if (!inTarget(getZValue(a, b, c, d, e, f, xmin, ymax, reverse), z_target, inequality)){ //check via
								pADF.fline.push(new Point(xmax, ymax)); //vaa
								pADF.fline.push(new Point(xmin, ymax)); //via
							 }
							  else {
								this.fail = true;
								return;
								}
                         }
                         pADF.fline.push(pADF.fline[0]);
                         this.lines.push(new PointSet(pADF.fline));
                    }
                    else {
                        var pBCD = new PatternBCE(Points, pADF.lastindex + 1, xmin, ymin, xmax, ymax);
                        console.debug("pBCD.pattern : " + pBCD.pattern);
                        if (pBCD.pattern == null || pBCD.pattern == "BU" || pBCD.pattern == "BD") {
                            if (pADF.pattern == "A") {
                                if (vaa_in_target) {
                                    pADF.fline.push(new Point(xmin, ymax)); //via
                                }
                                else {
                                    pADF.fline.push(new Point(xmax, ymax)); //vaa
                                    pADF.fline.push(new Point(xmax, ymin)); //vai
                                    pADF.fline.push(new Point(xmin, ymin)); //vii
                                }
                            }
                            else { //F
                                if (vaa_in_target) {
                                    pADF.fline.push(new Point(xmin, ymin)); //vii
                                }
                                else {
                                    pADF.fline.push(new Point(xmax, ymin)); //vai
                                    pADF.fline.push(new Point(xmax, ymax)); //vaa
                                    pADF.fline.push(new Point(xmin, ymax)); //via
                                }
                            }
                            pADF.fline.push(pADF.fline[0]);
                            this.lines.push(new PointSet(pADF.fline));
                        }
                        else if (pBCD.pattern == "E") { //AE
                            if (pADF.pattern == "A") {
                                if (vaa_in_target) {
                                    pADF.fline.push(new Point(xmin, ymax)); //via
                                    pADF.fline.push(pADF.fline[0]);
                                    this.lines.push(new PointSet(pADF.fline));
                                    pBCD.fline.push(new Point(xmax, ymin)); //vai
                                    pBCD.fline.push(pBCD.fline[0]);
                                    this.lines.push(new PointSet(pBCD.fline));
                                }
                                else {
                                    pADF.fline.push(new Point(xmax, ymax)); //vaa
                                    for (var i = pBCD.fline.length - 1; i >= 0; i--) {
                                        pADF.fline.push(pBCD.fline[i]);
                                    }
                                    pADF.fline.push(new Point(xmin, ymin)); //vii
                                    pADF.fline.push(pADF.fline[0]);
                                    this.lines.push(new PointSet(pADF.fline));
                                }
                            }
                            else {
								this.fail = true;
								return;
								}
                        }

                        else if (pBCD.pattern == "C") {
                            if (pADF.pattern == "F") {
                                if (vaa_in_target) { //FC
                                    pADF.fline.push(new Point(xmax, ymin)); //vai
                                    for (var i = pBCD.fline.length - 1; i >= 0; i--) {
                                        pADF.fline.push(pBCD.fline[i]);
                                    }
                                    pADF.fline.push(new Point(xmin, ymax)); //via
                                    pADF.fline.push(pADF.fline[0]);
                                    this.lines.push(new PointSet(pADF.fline));
                                }
                                else {
                                    pADF.fline.push(new Point(xmin, ymin)); //vii
                                    pADF.fline.push(pADF.fline[0]);
                                    this.lines.push(new PointSet(pADF.fline));
                                    pBCD.fline.push(new Point(xmax, ymax)); //vaa
                                    pBCD.fline.push(pBCD.fline[0]);
                                    this.lines.push(new PointSet(pBCD.fline));
                                }
                            }
							 else {
								this.fail = true;
								return;
								}
                        }
                        else {
								this.fail = true;
								return;
						}
                    }
  		         }
			    else { // (Points[0].y > ymax || Points[0].y < ymin) { //pattern B, C, E

			        var pBCD = new PatternBCE(Points, 0, xmin, ymin, xmax, ymax);
			        console.debug("pBCD.lastindex: " + pBCD.lastindex);
			        console.debug("pBCD.fline: " + pBCD.fline);
			        console.debug("pBCD.pattern: " + pBCD.pattern);

					var vs = new get4ConnerZValues(a, b, c, d, e, f, xmin, ymin, xmax, ymax, reverse);
					console.debug("zvpii: " + vs.vpii);
					console.debug("zvpai: " + vs.vpai);
					console.debug("zvpaa: " + vs.vpaa);
					console.debug("zvpia: " + vs.vpia);
					
					if ( pBCD.pattern == null ){
					
						console.debug("inequality: " + inequality);
						//check 4 corner value - may return solid(all fail) or empty(all pass)
						if (inequality == ">=") {
							if ((vs.vpii >= z_target) && (vs.vpai >= z_target) && (vs.vpaa >= z_target) && (vs.vpia >= z_target)) {
								console.debug ("all corner points are larger than " + z_target + " so no empty");
								this.lines.push(new PointSet(new Array()));
								 return;
							}
							else if ((vs.vpii <= z_target) && (vs.vpai <= z_target) && (vs.vpaa <= z_target) && (vs.vpia <= z_target)) {
								console.debug ("all corner points are less than " + z_target + " so solid.");
								this.lines.push(get4CornerPointSet(new Point(xmin, ymin), new Point(xmax, ymin),  new Point(xmax, ymax),  new Point(xmin, ymax)));
								return;
							}
							else {
								this.fail = true;
								return;
							}
						}
						else if (inequality == "<=") {
							if ((vs.vpii <= z_target) && (vs.vpai <= z_target) && (vs.vpaa <= z_target) && (vs.vpia <= z_target)) {
								console.debug ("all corner points are less than " + z_target + " so no empty");
								this.lines.push(new PointSet(new Array()));
								return;
							}
							else if ((vs.vpii >= z_target) && (vs.vpai >= z_target) && (vs.vpaa >= z_target) && (vs.vpia >= z_target)) {
								console.debug ("zzzall corner points are larger than " + z_target + " so solid");
								this.lines.push(get4CornerPointSet(new Point(xmin, ymin), new Point(xmax, ymin),  new Point(xmax, ymax),  new Point(xmin, ymax)));
								return;
								
							}
							else {
								this.fail = true;
								return
							}
						}
						else {
							this.fail = true;
							return;
						}
					}
					
			        else if ( pBCD.lastindex == Points.length - 1) { //pattern should be C or E
			            if (pBCD.pattern == "C") {
			                var vpaa = getZValue(a, b, c, d, e, f, xmax, ymax, reverse);
			                if (inTarget(vpaa, z_target, inequality)) {
			                    pBCD.fline.push(new Point(xmax, ymin)); //vai
			                    pBCD.fline.push(new Point(xmin, ymin)); //vii
			                    pBCD.fline.push(new Point(xmin, ymax)); //via
			                }
			                else {
			                    pBCD.fline.push(new Point(xmax, ymax)); //vpaa
			                }
			            }
			            else { //pBCD.pattern is E
			                var vpai = getZValue(a, b, c, d, e, f, xmax, ymin, reverse);
			                if (inTarget(vpai, z_target, inequality)) {
			                    pBCD.fline.push(new Point(xmax, ymax)); //vaa
			                    pBCD.fline.push(new Point(xmin, ymax)); //via
			                    pBCD.fline.push(new Point(xmin, ymin)); //vii
			                }
			                else {
			                    pBCD.fline.push(new Point(xmax, ymin)); //vpai
			                }
			            }
			           
			        }
					
			        else { //must be "B"
	    	            var vpaa = getZValue(a, b, c, d, e, f, xmax, ymax, reverse);
			            if (inTarget(vpaa, z_target, inequality)) {
			                if (pBCD.pattern == "BU") {
			                    pBCD.fline.push(new Point(xmin, ymax)); //via 
			                    pBCD.fline.push(new Point(xmin, ymin)); //vii
			                }
			                else {//pattern = "BD"
			                    pBCD.fline.push(new Point(xmin, ymin)); //vii
			                    pBCD.fline.push(new Point(xmin, ymax)); //via
			                }
			            }
			            else {
			                if (pBCD.pattern == "BU") {
			                    pBCD.fline.push(new Point(xmax, ymax)); //vaa
			                    pBCD.fline.push(new Point(xmax, ymin)); //vai
			                }
			                else {//pattern = "BD"
			                    pBCD.fline.push(new Point(xmax, ymin)); //vai
			                    pBCD.fline.push(new Point(xmax, ymax)); //vaa
			                }
			            }
                    }
			        pBCD.fline.push(pBCD.fline[0]);
			        this.lines.push(new PointSet(pBCD.fline));
			    }
			    console.debug(this.lines);

			}
            function PatternADF(Points, xmin, ymin, xmax, ymax ){
                this.fline = new Array();
			    this.lastindex = null;
			    this.pattern = null;
                for ( var i = 0; i < Points.length; i++ ){
                    this.lastindex = i;
					if ( !isFinite(Points[i].y)){ //ignore becaue just one point
						continue;
					}
                    else if (Points[i].y <= ymax && Points[i].y >= ymin) {
                        this.fline.push(Points[i]);
                    }
                    else if (Points[i].y > ymax) { //A
                        this.pattern = "A";
                        this.fline.push(new Point(Points[i].x, ymax));
                        break;
                    }
                    else { //Point[i].y < ymin //F
                        this.pattern = "F";
                        this.fline.push(new Point(Points[i].x, ymin));
                        break;
                    }
                }
                if ( this.pattern == null )
                    this.pattern = "D";

            }
           
			function PatternBCE(Points, startindex, xmin, ymin, xmax, ymax) {

			    this.fline = new Array();
			    this.lastindex = null;
			    this.pattern = null;
                first = false;
                for (var i = startindex; i < Points.length; i++) {
                    this.lastindex = i;
					if ( !isFinite(Points[i].y)){ //ignore because just one point
						continue;
					}
			       else if (Points[i].y > ymax) {
			            if (first == false) //not cross ymin or ymax yet
			                continue;
			            else {
			                this.fline.push(new Point(Points[i].x, ymax));
			                this.pattern = "BU"; // up right direction /
			                break;
			            }
			        }
			        else if ( Points[i].y < ymin) {
			            if (first == false) //not cross ymin or ymax yet
			                continue;
			            else {
			                this.fline.push(new Point(Points[i].x, ymin));
			                this.pattern = "BD"; //bottom right direction \
			                break;
			            }
			        }
			        else if (Points[i].y < ymax && Points[i].y > ymin) {
			            if (first == false) { //put 1st point clossing ymax
			                if (Points[i - 1].y > ymax) { //comming down -> B or C
			                    this.fline.push(new Point(Points[i].x, ymax));
			                    this.pattern = "C";
			                }
			                else { //coming up -> B or E
			                    this.fline.push(new Point(Points[i].x, ymin));
			                    this.pattern = "E";
			                }
			                first = true;
			            }
			            this.fline.push(Points[i]);
			        }
			    } //end of for loop
			      
			}


			function inTarget ( z, z_target, inequality) {
				console.debug( z + " " + inequality + " " + z_target + "?" );
			    if (inequality == ">=" && z >= z_target)
			        return true;
			    else if (inequality == "<=" && z <= z_target)
			        return true;
                else
			        return false;
			}
			function get4ConnerZValues(a, b, c, d, e, f, xmin, ymin, xmax, ymax, reverse) {
				this.vpii = getZValue(a, b, c, d, e, f, xmin, ymin, reverse);
			    this.vpai = getZValue(a, b, c, d, e, f, xmax, ymin, reverse);
			    this.vpaa = getZValue(a, b, c, d, e, f, xmax, ymax, reverse);
			    this.vpia = getZValue(a, b, c, d, e, f, xmin, ymax, reverse);
			}


			function getInPointsLine(pt, pb, xmin, xmax, ymin, ymax) {
				var lines = new Array();
				var all = new Array();
				for (var i = 0; i < pt.length; i++) {
					if (pt[i].y > ymax) {
						if ( pb[i].y > ymax ){
							continue;
						}
						else { //pb[i].y < ymax	
							all.push(new Point(pt[i].x, ymax));
						}
					}
					else if (pt[i].y < ymin){
						continue;
						}
					else {
						all.push(pt[i]);
						}
				}
				
				for (var i = pb.length - 1; i > -1; i--) {
						if (pb[i].y < ymin) {
							if (pt[i].y < ymin){
								continue;
							}
							else { //pt[i].y > ymin
								all.push(new Point(pb[i].x, ymin));
							}
							
						}
						else if (pb[i].y > ymax){
							continue;
						}
						else{
							all.push(pb[i]);
						}
					}
				
				
				if ( all.length > 0 ){
					//put 1st point to close the loop
					all.push(all[0]);
					lines.push(new PointSet(all));
				}
				return lines;
			}
			function IsMiddleTargetRegion(a, b, c, d, e, f, pms, z_target, inequality, reverse) {
				var is_target;
				for (var i = 0; i < pms.length; i++) {
					var z = getZValue(a, b, c, d, e, f, pms[i].x, pms[i].y, reverse);
					if (i%1000 == 0 )
						console.debug(i + " zvalue_m ( " + pms[i].x + "," + pms[i].y + "):" + z);
					if (inequality == ">=") {
						if (z >= z_target) {
							if (i%1000 == 0 )
								console.debug("z >= z_target-----z: " + z + " ztarget: " + z_target ); 
							if (is_target != null && !is_target) {
								//console.error(i + " of " + pms.length + ": zvalue_m ( " + pms[i].x + "," + pms[i].y + "):" + z);
								console.error("P middle is not always IN of target region." + i + " of " + pms.length);
								if (i == 0 || i == pms.length - 1) //it may possible ends point being little off?
									continue;
								return;
							}
							is_target = true;
						}
						else {
							if (i%1000 == 0 )
								console.debug("z <= z_target-----z: " + z + " ztarget: " + z_target ); 
							if (is_target != null && is_target) {
								//console.error(i + " of " + pms.length + ": zvalue_m ( " + pms[i].x + "," + pms[i].y + "):" + z);
								console.error("P middle is not always OUT of target region." + i + " of " + pms.length);
								if (i == 0 || i == pms.length - 1) //it may possible ends point being little off?
									continue;
								return;
							}
							is_target = false;
						}
					}
					else { // if ( inequality == "<="){
						if (z <= z_target) {
							if (is_target != null && !is_target) {
								//console.error(i + " of " + pms.length + ": zvalue_m ( " + pms[i].x + "," + pms[i].y + "):" + z);
								console.error("P middle is not always In of target region." + i + " of " + pms.length);
								if (i == 0 || i == pms.length - 1) //it may possible ends point being little off?
									continue;
								return;
							}
							is_target = true;
						}
						else {
							if (is_target != null && is_target) {
								//console.error(i + " of " + pms.length + ": zvalue_m ( " + pms[i].x + "," + pms[i].y + "):" + z);
								console.error("P middle is not always OUT of target region." + i + " of " + pms.length);
								if (i == 0 || i == pms.length - 1) //it may possible ends point being little off?
									continue;
								return;
							}
							is_target = false;
						}
					}
				}
			  	console.debug("returning is_target: " + is_target);
				return is_target;

			}
			function get4CornerPointSet(pii, pai, paa, pia) {
				var a = new Array();
				a.push(pii);
				a.push(pai);
				a.push(paa);
				a.push(pia);
				a.push(pii);
				return new PointSet(a);
			}

			//finding z value
			function getZValue(a, b, c, d, e, f, x, y, reserve) {
				if (reserve)
					return a + b * y + c * x + d * y * y + e * x * x + f * y * x;
				else
					return a + b * x + c * y + d * x * x + e * y * y + f * x * y;
			}

			function getY1(a, b, c, d, e, f, z, x) {
				temp = Math.pow(Math.pow(-c - f * x, 2) + 4 * e * (-a - b * x - d * x * x + z), 0.5);
				return (-1) * (c + f * x + temp) / (2 * e);
			}
			function getY2(a, b, c, d, e, f, z, x) {
				temp = Math.pow(Math.pow(-c - f * x, 2) + 4 * e * (-a - b * x - d * x * x + z), 0.5);
				return (-c - f * x + temp) / (2 * e);
			}
			function getY(a,b,c,d,e,f,z,x,top)
			{
				if (top == "p1") 
					return getY1(a,b,c,d,e,f,z,x);
				else
					return getY2(a,b,c,d,e,f,z,x);
			}
			function getX1(a,b,c,d,e,f,z,y)
			{
				temp = Math.pow(Math.pow(-b - f * y, 2) + 4 * d * (-a - c * y - e * y* y + z), 0.5);
				return (-1) * (b + f * y + temp) / (2 * d);
			}
			function getX2(a,b,c,d,e,f,z,y)
			{
				temp = Math.pow(Math.pow(-b - f * y, 2) + 4 * d * (-a - c * y - e * y * y + z), 0.5);
				return (-b - f *y + temp) / (2 * d);
			}
	
			//geting X value = reversed
			function getX(a,b,c,d,e,f,z,y,top)
			{
				if ( top == "p1")
					return getX1(a,b,c,d,e,f,z,y);
				else
					return getX2(a,b,c,d,e,f,z,y);
			}
			
			
			//finding y value
			function Find_Y_Points(a, b, c, d, e, f, z, x_grid_data, index, ymin, ymax) {
				
				if ( e == 0 && d == 0 ) {
					//Solve[z == a + b*x + c*y + f*x*y, y]
					//{{y -> (-a - b x + z)/(c + f x)}}
					this.y1 = (-a - b * x_grid_data[index] + z)/(c + f *x_grid_data[index])
				}
				else {
				
					temp = Math.pow(Math.pow(-c - f * x_grid_data[index], 2) + 4 * e * (-a - b * x_grid_data[index] - d * x_grid_data[index] * x_grid_data[index] + z), 0.5);
					//var zz = Math.pow(-c - f * x_grid_data[index], 2) + 4 * e * (-a - b * x_grid_data[index] - d * x_grid_data[index] * x_grid_data[index] + z);
					//console.debug("xxx: " +  zz);
					if (isNaN(temp))
						return;
					this.y1 = (-1) * (c + f * x_grid_data[index] + temp) / (2 * e);
					this.y2 = (-c - f * x_grid_data[index] + temp) / (2 * e);
					
				}
				this.z_ymin = getZValue(a, b, c, d, e, f, x_grid_data[index], ymin);
				this.z_ymax = getZValue(a, b, c, d, e, f, x_grid_data[index], ymax);
			}

			//finding y value for reverse
			function Find_Y_Points_R(a, b, c, d, e, f, z, x_grid_data, index, ymin, ymax) {
				if ( e == 0 && d == 0 ) {
					//Solve[z == a + b*x + c*y + f*x*y, x]
					//{{x -> (-a - c y + z)/(b + f y)}}
					this.y1 = (-a - c *x_grid_data[index] + z)/(b + f *x_grid_data[index])
				}
				else {
					temp = Math.pow(Math.pow(-b - f * x_grid_data[index], 2) + 4 * d * (-a - c * x_grid_data[index] - e * x_grid_data[index] * x_grid_data[index] + z), 0.5);
					if ( isNaN(temp))
						return;
					this.y1 = (-1) * (b + f * x_grid_data[index] + temp) / (2 * d);
					this.y2 = (-b - f * x_grid_data[index] + temp) / (2 * d);
				}
				this.z_ymin = getZValue(a, b, c, d, e, f, x_grid_data[index], ymin);
				this.z_ymax = getZValue(a, b, c, d, e, f, x_grid_data[index], ymax);
			}


			//index = index of selected Points1
			function PointSet(points) {
				this.ps = points;
				this.fill = "in";
				//this.fill = "out";
				PointSet.prototype.length = function () {
					return this.ps.length;
				}

			}

			function Point(px, py) {
				this.x = px;
				this.y = py;
			}
			function XGrids(xmin, xmax, num) {

				this.x_data = new Array();
				var dx = (xmax - xmin) / num;
				for (var x0 = xmin; x0 < xmax - dx; x0 = x0 + dx) {
					this.x_data.push(x0);
					//console.debug(x0);
				}
				this.x_data.push(xmax); //last point is added as xmax because significant error make the last points not be xmax
				console.debug("Grid count: " + this.x_data.length);

			}

			function getOutPointsLinesTop(pt, pb, pm, pii, pai, paa, pia, xmin, xmax, ymin, ymax, a, b, c, d, e, f, z, top) {
			
				var lines = new Array();
				var line = new Array();
				for (var i = 0; i < pt.length; i++) {
					//console.debug("A0");
				
					if (pt[i].y > ymax) { //pt is crossing ymax
						if (line.length != 0) {
							line.push(new Point(pt[i].x, ymax)); // better if calculate x when z = target, y = ymax ------------ Pt E
							if (line[0].y != ymax) {
								line.push(pia);
								if (line[0].x != xmin)
									if (pt[0].y < ymin)
										line.push(new Point(xmin, ymin));
									else if (pm[0].y < ymin)
										line.push(new Point(xmin, ymin));
									else {
										line.push(new Point(xmin, pm[0].y)); //better if calculate y when z = target, x = xmin ----- Pt F
										
									}
							}
							else{
								line.push(new Point(line[0].x, ymax)); //better if caldulate x when z = target, y = ymax -------Pt G
								}
							if (pt[0].y > ymax){
								line.push(new Point(pt[0].x, ymax));
								}
							else if ( pt[0].y < ymin)
								line.push(new Point(pt[0].x, ymin));
							else {
								line.push(pt[0]); //connect back mw 12/14/12
								console.debug(pt[0]);
								console.debug("C2");
							}
						
							lines.push(new PointSet(line));
							line = new Array(); //reset
						}
					}
					else if (pt[i].y < ymin){
						line.push(new Point(pt[i].x, ymin));
						}
					else{
						line.push(pt[i]);
						}

				} //end of i
				//add last line to lines

				if (line.length != 0) {
					var n = pt.length - 1;
					if (lines.length == 1) { //region in left and right
						if (pt[n].x != xmax) {
							line.push(pm[n]);
							line.push(new Point(xmax, pm[n].y)); //better calculate y when x = xmax ------------------Pt H
						}
						if (pt[n].y <= ymax) {
							line.push(paa);
							line.push(new Point(line[0].x, ymax)); //better calculate x when y = ymax ------------------------------Pt I
						}
					}
					else if (lines.length == 0) {
						if (pt[n].x != xmax) {
							if (pt[n].y > ymax){
								line.push(new Point(pt[n].x, ymax)); // better if calculate x when z = target, y = ymax ------------ Pt E
								}
							else if (pt[n].y < ymin) {
								line.push(pai);
								line.push(paa);
							}
							else {
								line.push(pm[n]);
								line.push(new Point(xmax, pm[n].y)); //better calculate y when x = xmax ------------------Pt H ----- horizontal line to xmax
								line.push(paa);
							}
						}
						else {
							line.push(paa);
						}
						if (line[0].x == xmin) {
							if (line[0].y != ymax) {
								line.push(pia);
								line.push(line[0]); //go back
							}
						}
						else if (line[0].y != ymax) {
							if (pt[0].y > ymax) {
								line.push(new Point(line[0].x, ymax)); //better if caldulate x when z = target, y = ymax -------Pt G
								line.push(line[0]); //go back
							}
							else {
								line.push(pia);
								if (pt[0].y < ymin) {
									line.push(new Point(xmin, ymin));
									line.push(new Point(pt[0].x, ymin));
								}
								else if (pm[0].y < ymin) {
									line.push(new Point(xmin, ymin));
									line.push(new Point(pm[0].x, ymin));
								}
								else {
									line.push(new Point(xmin, pm[0].y));
									line.push(pm[0]);
								}
							}
						}

					}
					else
						console.error("Not supported");

					lines.push(new PointSet(line));
				}
				return lines;
			}

			function getOutPointsLinesBottom(pt, pb, pm, pii, pai, paa, pia, xmin, xmax, ymin, ymax) {
			var lines = new Array();
			var line = new Array();
			for (var i = 0; i < pb.length; i++) {
				if (pb[i].y < ymin) { //pt is crossing ymin
					if (line.length != 0) {
						line.push(new Point(pb[i].x, ymin)); // better if calculate x when z = target, y = ymax ------------ Pt E
						if (line[0].y != ymin) {
							line.push(pii);
							if (line[0].x != xmin) {
								if (pb[0].y > ymax)
									line.push(new Point(xmin, ymax));
								else if (pm[0].y > ymax)
									line.push(new Point(xmin, ymax));
								else {
									line.push(new Point(xmin, pm[0].y));  //better if calculate y when z = target, x = xmin ----- Pt F
									}
							}
						}
						else
							line.push(new Point(line[0].x, ymin)); //better if caldulate x when z = target, y = ymax -------Pt G

						if (pb[0].y > ymax)
							line.push(new Point(pb[0].x, ymax));
						else if (pb[0].y < ymin)
							line.push(new Point(pb[0].x, ymin));
						else 
							line.push(pb[0]); //connect back 12/14/12
						lines.push(new PointSet(line));
						line = new Array(); //reset
					}
				}
				else if (pb[i].y > ymax)
					line.push(new Point(pb[i].x, ymax));
				else
					line.push(pb[i]);

			} //end of i
			//add last line to lines
			if (line.length != 0) {
				var n = pb.length - 1;
				if (lines.length == 1) { //region in left and right
					if (pb[n].x != xmax) {
						line.push(pm[n]);
						line.push(new Point(xmax, pm[n].y)); //better calculate y when x = xmax ------------------Pt H
					}
					if (pb[n].y >= ymin) {
						line.push(pai);
						line.push(new Point(line[0].x, ymin)); //better calculate x when y = ymax ------------------------------Pt I
					}
				}
				else if (lines.length == 0) {
					if (pb[n].x != xmax) {
						if (pb[n].y < ymin) {
							line.push(new Point(pb[n].x, ymin)); // better if calculate x when z = target, y = ymax ------------ Pt E
						}
						else if (pb[n].y > ymax) {
							line.push(paa);
							line.push(pai);
						}
						else {
							line.push(pm[n]);
							line.push(new Point(xmax, pm[n].y)); //better calculate y when x = xmax ------------------Pt H ----- horizontal line to xmax
							line.push(pai);
						}
					}
					else {
						line.push(pai);
					}
					if (line[0].x == xmin) {
						if (line[0].y != ymin) {
							line.push(pii);
							line.push(line[0]); //go back
						}
					}
					else if (line[0].y != ymin) {
						if (pb[0].y < ymin) {
							line.push(new Point(line[0].x, ymin)); //better if caldulate x when z = target, y = ymax -------Pt G
							line.push(line[0]); //go back
						}
						else {
							line.push(pii);
							if (pb[0].y > ymax) {
								line.push(new Point(xmin, ymax));
								line.push(new Point(pb[0].x, ymax));
							}
							else if (pm[0].y > ymax) {
								line.push(new Point(xmin, ymax));
								line.push(new Point(pm[0].x, ymax));
							}
							else {
								line.push(new Point(xmin, pm[0].y));
								line.push(pm[0]);
							}
						}
					}

				}
				else
					alert("Not supported");

				lines.push(new PointSet(line));
			}
			return lines;
			} //end of function
			/* Mark <vf-table> as rendered */
			$(element).attr('rendered', 'true');
			}
		/*}
		catch(err){
			console.warn(err );
			$(element).attr('rendered', 'true');
		}
		*/
	}
	/* Rerender Method */
	this.rerender = function () {
		updateTabSize();
		$(this.element).empty();
		$(element).attr('rendered', 'false');
		this.render();
	}
	
	/* Update Method */
	this.update = function () {
		this.rerender();
	}
}