#!python -u

import sys
import os
import os.path
import win32com.client
import gen_dir_wxi

import xml.etree.ElementTree as ET

prefs = { 'verbose': True }

os.environ['PATH'] = os.environ['PATH'].replace('"', '')

def add_wix_to_path():
    import _winreg
    found = False
    versions = ('3.5', '3.6', '3.7')
    for wix_ver in versions:
        try:
            with _winreg.OpenKey(_winreg.HKEY_LOCAL_MACHINE, 'SOFTWARE\\Microsoft\\Windows Installer XML\\' + wix_ver) as wixkey:
                os.environ['PATH'] = _winreg.QueryValueEx(wixkey, 'InstallRoot')[0] + ';' + os.environ['PATH']
                found = True
        except Exception as e:
            pass

    if not found:
        raise Exception('WIX is probably not installed. Required version: {0}'.format(versions))
        
def system(args, dirname=None):
    """
    Executes a system command (throws an exception on error)
    params
        args : [command, arg1, arg2, ...]
        dirname : if set, execute the command within this directory
    """
    import subprocess
    #print args
    with open(os.devnull, "w") as nulfp:
        # n.b. stderr=subprocess.STDOUT fails mysteriously
        import sys
        subprocess.check_call(args, stdout=(sys.stdout if prefs['verbose'] else nulfp), stderr=subprocess.STDOUT, shell=False, cwd=dirname)

if __name__=='__main__':
    try:
        pass
        # KMS: IFV.xme no longer contains CompLib as a library (r4740)
        #system([sys.executable, 'remove_IFV_lib.py'], os.path.dirname(os.path.abspath(__file__)) + '\\..\\models\\IFV\\')
    except Exception as e:
        # -2146234327 = HOST_E_EXITPROCESS_TIMEOUT. no idea why this happens
        if not "-2146234327" in str(e):
            raise

    add_wix_to_path()
    def get_wixobj(file):
        return os.path.splitext(file)[0] + ".wixobj"
    def adjacent_file(file):
        return os.path.join(os.path.dirname(__file__), file)
    
    gen_dir_wxi.main(r"CAD_Installs\Proe ISIS Extensions", "Proe_ISIS_Extensions_x64.wxi", "Proe_ISIS_Extensions_x64")
    gen_dir_wxi.main(r"..\meta\CyPhyML\icons",)
    gen_dir_wxi.main(r"..\models\MassSpringDamper",)
    gen_dir_wxi.main(r"..\bin",)
    gen_dir_wxi.main(r"..\ModelicaWrapperTemplates",)
    gen_dir_wxi.main(r"..\externals\HCDDES\src\lib\BlockTemplate\Python", id='src_BlockTemplate_Python')
    gen_dir_wxi.main(r"..\externals\HCDDES\generated\BlockTemplate\Python", id='generated_BlockTemplate_Python')

    def get_svnversion():
        import subprocess
        p = subprocess.Popen(['svnversion', '-n', adjacent_file('..')], stdout=subprocess.PIPE)
        out, err = p.communicate()
        if p.returncode:
            raise subprocess.CalledProcessError(p.returncode, 'svnversion')
        return out
    svnversion = get_svnversion()

    print "SVN version: " + str(get_svnversion())
    sourcedir = adjacent_file('')
    
    
    import glob
    if len(sys.argv[1:]) > 0:
        source_wxs = sys.argv[1]
    else:
        source_wxs = 'META_x64.wxs'
    sources_all = glob.glob(sourcedir + '*.wxi') + glob.glob(sourcedir + source_wxs)
    sources = []
    include_wxis = []

    for wxs in glob.glob(sourcedir + source_wxs):
        tree = ET.parse(wxs)
        root = tree.getroot()
        #print root
        all_nodes = root.findall('.//')
        for node in all_nodes:
            if node.tag == '{http://schemas.microsoft.com/wix/2006/wi}ComponentGroupRef':
                include_wxis.append(node.attrib['Id'] + '.wxi')
                include_wxis.append(node.attrib['Id'] + '_x64.wxi')
                if 'Proe' in node.attrib['Id'] + '_x64.wxi':
                    print node.attrib['Id'] + '_x64.wxi'
            if node.tag == '{http://schemas.microsoft.com/wix/2006/wi}ComponentRef':
                include_wxis.append(node.attrib['Id'].rsplit( ".", 1 )[ 0 ] + '.wxi')
                include_wxis.append(node.attrib['Id'].rsplit( ".", 1 )[ 0 ] + '_x64.wxi')
    
    sources = [source for source in sources_all if (os.path.basename(source) in include_wxis)]
    sources.append(source_wxs)

    if len(sources) == 0:
        raise Exception("0 sources found in " + sourcedir)

    defines = [ ('InterpreterBin', '../src/bin') ]

    metaproject = win32com.client.Dispatch("MGA.MgaMetaProject")
    metaproject.Open('MGA=' + adjacent_file('../generated/CyPhyML/models/CyPhyML.mta'))
    import uuid
    defines.append(('GUIDSTRCYPHYML', '{' + str(uuid.UUID(bytes_le=metaproject.GUID)).upper() + '}'))
    defines.append(('VERSIONSTRCYPHYML', metaproject.Version))
    metaproject.Close()
    
    #defines.append(('UDMDLL_3_2_VS10', os.environ['UDM_PATH'] + r'\bin\UdmDll_3_2_VS10.dll'))
    def _adjacent_file(file):
        import os.path
        return os.path.join(os.path.dirname(os.path.abspath(__file__)), file)
    defines.append(('UDMDLL_3_2_VS10', _adjacent_file(r'UdmDll_3_2_VS10.dll')))
    defines.append(('XERCES_C_2_8', os.environ['UDM_PATH'] + r'\bin\xerces-c_2_8.dll'))
    version = '13.09.'
    if 'M' in svnversion:
        version = version + '1'
    else:
        # this will crash for switched or sparse checkouts
        version = version + str(int(svnversion))
    print 'Installer version: ' + version
    defines.append(('VERSIONSTR', version))
    defines.append(('SVNVERSION', svnversion))

    for source in sources:
        arch = [ '-arch', ('x86' if source.find('x64') == -1 else 'x64') ]
        system(['candle', '-ext', 'WiXUtilExtension'] + ['-d' + d[0] + '=' + d[1] for d in defines ] + arch + [ '-out', get_wixobj(source), source] + ['-nologo'])

    #ignore warning 1055, ICE82 from VC9 merge modules
    if source_wxs.startswith("META"):
        system(['light', '-sw1055', '-sice:ICE82', '-sice:ICE57', '-ext', 'WixNetFxExtension', '-ext', 'WixUIExtension', '-ext', 'WixUtilExtension', 
            '-o', os.path.splitext(source_wxs)[0] + ".msi"] + [ get_wixobj(file) for file in sources ])
    else:
        msm_output = os.path.splitext(source_wxs)[0] + ".msm"
        system(['light', '-ext', 'WixUtilExtension', '-o', msm_output] + [ get_wixobj(file) for file in sources ])
