// Example main.c - This should be generated by the FRODO code generator
#include "main.h"


/*****************************************************************************/


void* Task1_exec( void *cntx ) {
	// Cast to a context structure
	Context_t* context = (Context_t*)cntx;
	char localBuffer[256];
	data_t data;
	ReturnCode_t returnCode;
	while ( true ) {
		// Wait to execute
		SchedSignalExecution( context->task1 );
		// Read the message port
		ReadSamplingMessage( context->msgPort, &data, NULL, NULL, &returnCode );
		sprintf( localBuffer, "====>\t\tValue: %4.3f.\n", data.value );
		LogMessage( localBuffer );
		// Increment pos_data value a bit
		data.value += 0.05;
		// Write the new value back to the port
		WriteSamplingMessage( context->msgPort, &data, sizeof(data_t), &returnCode );
		// Signal that we are done with this execution
		SchedSignalCompletion( context->task1 );
	}
	// Must return something - never will get here
	return NULL;
}


/*****************************************************************************/


/** Primary entry function ***/
int main( int argc, char* argv[] ) {
	ReturnCode_t returnCode;
	// Create the master context
	Context_t context;
	// Zero the context
	memset( &context, 0, sizeof(Context_t) );
	// Check the command line arguments for local and remote IP addresses and number of hyperperiods
	assert( argc == 4 );

	/*** Initialize the FRODO subsystems ***/

	SysEventInitialize( AllCategories, false, true, false );
	PeripheralInitialize();
	LogInitialize();
	ErrorHandlerInitialize();
	SchedInitialize( EarliestDeadlineFirst, ErrSchedulerHandler, 20.0, 1, &context );
	UDPInitialize( ErrUDPHandler );

	/*** Create message ports ***/
	{
		// Set initial value of port message
		data_t data = { 1.0 };
		CreateSamplingPort( "data", sizeof(data_t), Bidirectional, 0, &(context.msgPort), &returnCode );
		WriteSamplingMessage( context.msgPort, &data, sizeof(data_t), &returnCode );
	}

	/*** Create Tasks ***/

	{
		// Create task with instances
		pfloat_t Task1_times[1] = { 4.0 };
		SchedCreatePeriodicTask( "Task1", Task1_exec, &context.task1, 1.00, NoRestriction, 1, Task1_times );
	}

	/*** Create Peripherals ***/

	{
		pfloat_t send_times[1] = { 8.0 };
		pfloat_t receive_times[1] = { 14.0 };
		SyncExpectation syncExpects[2] = {
			{ ExpectSend, 1, sizeof(data_t), 1, send_times, 2.0, context.msgPort, NULL },
			{ ExpectReceive, 1, sizeof(data_t), 1, receive_times, 2.0, context.msgPort, NULL }
		};
		context.udpChannel = UDPCreateChannel( argv[1], argv[2], 21212, 2, syncExpects, 0, NULL, true, false, 2 );
	}

	/*** Execute the schedule ***/

	// Wait for the platform to wake up ( Platform Dependent )
	NanoSleep( SCHEDULER_INITIALIZATION_WAIT );
	// Execute the schedule
	SchedExecute( atoi(argv[3]) );

	/*** Shutdown the application ***/

	// If this returns we must shut everything down
	UDPShutdown( );
	SchedShutdown( );
	SysEventShutdown( NULL );
}
