// Example main.c - This should be generated by the FRODO code generator
#include "main.h"


/*****************************************************************************/


void* Task1_exec( void *cntx ) {
	// Cast to a context structure
	Context_t* context = (Context_t*)cntx;
	char localBuffer[256];
	data_t data;
	ReturnCode_t returnCode;
	for ( ; ; ) {
		// Wait to execute
		SchedSignalExecution( context->task1 );
		// Read the message port
		ReadSamplingMessage( context->msgPort, &data, NULL, NULL, &returnCode );
		sprintf( localBuffer, "====>\t\tValue: %4.3f.\n", data.value );
		LogMessage( localBuffer );
		// Increment pos_data value a bit
		data.value += 0.05;
		// Write the new value back to the port
		WriteSamplingMessage( context->msgPort, &data, sizeof(data_t), &returnCode );
		// Signal that we are done with this execution
		SchedSignalCompletion( context->task1 );
	}
	// Must return something - never will get here
	return NULL;
}


/*****************************************************************************/


/** Primary entry function ***/
int main( int argc, char* argv[] ) {
	ReturnCode_t returnCode;
	// Create the master context
	Context_t context;
	memset( &context, 0, sizeof(Context_t) );
	// Command line arguments should be: app, local IP, remote IP
	assert( argc == 4 );
	// Initialize the FRODO subsystems
	SysEventInitialize( AllCategories, false, true, false );
	PeripheralInitialize();
	LogInitialize();
	ErrorHandlerInitialize();
	SchedInitialize( EarliestDeadlineFirst, ErrSchedulerHandler, 20.0, 1, &context );
	UDPInitialize( ErrUDPHandler );

	/*** Create message ports ***/
	{
		// Set initial value of port message
		data_t data = { 1.0 };
		CreateSamplingPort( "data", sizeof(data_t), Bidirectional, 0, &(context.msgPort), &returnCode );	
		WriteSamplingMessage( context.msgPort, &data, sizeof(data_t), &returnCode );
	}
	
	/*** Create Tasks ***/

	{
		// Create task with instances
		pfloat_t Task1_times[1] = { 11.0 };
		SchedCreatePeriodicTask( "Task1", Task1_exec, &context.task1, 1.0, NoRestriction, 1, Task1_times );
	}

	/*** Create Peripheral Channels ***/
	
	{
		pfloat_t receive_times[1] = { 8.0 };
		pfloat_t send_times[1] = { 14.0 };
		SyncExpectation expects[2] = {
			{ ExpectReceive, 1, sizeof(data_t), 1, receive_times, 1.0, context.msgPort, NULL },
			{ ExpectSend, 1, sizeof(data_t), 1, send_times, 1.0, context.msgPort, NULL }
		};
		context.udpChannel = UDPCreateChannel( argv[1], argv[2], 21212, 2, expects, 0, NULL, true, true, 2 );
	}

	/*** Execute the schedule ***/

	// Wait for the platform to wake up ( Platform Dependent )
	NanoSleep( SCHEDULER_INITIALIZATION_WAIT );
	// Execute the schedule
	SchedExecute( 100000 );

	/*** Shutdown the application ***/

	// If here, we must shut everything down
	UDPShutdown( );
	SchedShutdown( );
	SysEventShutdown( NULL );
}