// Example main.c - This should be generated by the FRODO code generator
#include "main.h"
#include "logger.h"
#include "arch/highres_timing.h"
#include "error_handler.h"
#include "scheduler.h"
#include "serialio.h"
#include "ports.h"


#define UTILIZATION				0.95


/*****************************************************************************/


/*** Message Structures ***/

// Message struct for message type pos_data_msg_t
typedef struct {
	pfloat_t pos_data;
} pos_data_msg_t;


// Global Context
typedef struct {
	// Schedulable instances
	FS_Schedulable*				task1;
	// Channel instances
	Serial_Channel*				serialchan;
	// Message Ports
	PortId_t					msgPort;
} Context_t;


/*****************************************************************************/


void* Task1_exec( void *cntx ) {
	// Cast to a context structure
	Context_t* context = (Context_t*)cntx;
	char logBuffer[256];
	pos_data_msg_t pos_data;
	ReturnCode_t returnCode;
	while ( true ) {
		// Wait to execute
		FS_SignalExecution( context->task1 );
		// Get the value of the message from the port
		ReadMessage( context->msgPort, &pos_data, NULL, NULL, &returnCode );
		// Print out the values of the message
		sprintf( logBuffer, "=======> PosData: %4.3f.\n", pos_data.pos_data );
		// Do we need to do an async send?
		if ( pos_data.pos_data >= 1.20 ) {
			// Try to send Msg#1 in the next 20ms over channel syncUDP
			Serial_AsyncSend( context->serialchan, 1, 20.0 );
		}
		LogMessage( logBuffer );
		// Signal that we are done with this execution
		FS_SignalCompletion( context->task1 );
	}
	// Must return something - never will get here
	return NULL;
}


/*****************************************************************************/


/** Primary entry function ***/
int main(void) {
	ReturnCode_t returnCode;
	// Create the master context
	Context_t context;
	// Zero the context
	memset( &context, 0, sizeof(Context_t) );
	// Initialize all task data structures
	//...

	// Initialize the logging subsystem
	FL_Initialize( ToConsole, AllCategories, false, "SimpleExample.log");
	FL_SetTypeMask( Scheduler, AllEvents & ~HyperperiodEnd );
	FL_SetTypeMask( Peripheral, AllEvents & ~ReceiveBegin );
	// Initialize Scheduler with hyperperiod length and context
	FS_Initialize( DeadlineMonotonic, FE_SchedulerError, 20.0, 1, &context );
	// Initialize the UDP subsystem
	Serial_Initialize( FE_SerialError );

	/*** Create message ports ***/
	CreateSamplingPort( "pos_msg", sizeof(pos_data_msg_t), Bidirectional, 0, &(context.msgPort), &returnCode );


	/*** Create Tasks ***/

	{
		// Create task with instances
		pfloat_t Task1_data[1] = { 15.0 };
		FS_CreatePeriodicTask( "Task1", Task1_exec, &context.task1, 1.00, NoRestriction, 1, Task1_data );
	}

	/*** Create Peripherals ***/

	{
		pfloat_t msg1_rtimes[1] = { 10.0 };
		FP_SyncExpectation syncExpects[2] = {
			{ ExpectReceive, 1, sizeof(pos_data_msg_t), 1, msg1_rtimes, 2.0, context.msgPort, NULL }
		};

		FP_AsyncExpectation asyncExpects[1] = {
			{ ExpectSend, 1, sizeof(pos_data_msg_t), 1.0, 0.0, 20.0, context.msgPort, NULL }
		};
		context.serialchan = Serial_CreateChannel( SERIAL_DEVICE, 
                        SERIAL_BAUD, SERIAL_DATABITS, 
			SERIAL_PARITY, SERIAL_STOPBITS,
			1, syncExpects, 1, asyncExpects,
                        true, true, 2 );
	}

	/*** Execute the schedule ***/

	// Wait for the platform to wake up ( Platform Dependent )
	NanoSleep( SCHEDULER_INITIALIZATION_WAIT, SCHEDULER_RESOLUTION_MS );
	// Execute the schedule
	FS_Execute( 12 );

	/*** Shutdown the application ***/

	// If this returns we must shut everything down
	Serial_Shutdown( );
	FS_Shutdown( );
	// Shutdown the logger
	FL_Shutdown( );
	// Destroy message semaphores
//	_DestroySemaphore( "syncUDPIn", context.syncUDPIn_sem );
}
