// Example main.c - This should be generated by the FRODO code generator
#include "main.h"
#include "logger.h"
#include "arch/highres_timing.h"
#include "error_handler.h"
#include "scheduler.h"
#include "udp.h"
#include "ports.h"


#define UTILIZATION				0.95


/*****************************************************************************/


/*** Message Structures ***/

// Message struct for message type ...
typedef struct pos_data_msg_t {
	pfloat_t pos_data;
};


// Global Context
typedef struct {
	// Schedulable instances
	FS_Schedulable*			task1;
	// Peripheral instances
	UDP_Channel*			udpChannel;
	// Message ports
	PortId_t				msgPort;
} Context_t;


/*****************************************************************************/


void* Task1_exec( void *cntx ) {
	// Cast to a context structure
	Context_t* context = (Context_t*)cntx;
	char localBuffer[256];
	struct pos_data_msg_t pos_data;
	ReturnCode_t returnCode;
	for ( ; ; ) {
		// Wait to execute
		FS_SignalExecution( context->task1 );
		// Read the message port
		ReadSamplingMessage( context->msgPort, &pos_data, NULL, NULL, &returnCode );
		sprintf( localBuffer, "====>\t\tValue: %4.3f.\n", pos_data.pos_data );
		LogMessage( localBuffer );
		// Increment pos_data value a bit
		pos_data.pos_data += 0.05;
		// Write the new value back to the port
		WriteSamplingMessage( context->msgPort, &pos_data, sizeof(struct pos_data_msg_t), &returnCode );
		// Signal that we are done with this execution
		FS_SignalCompletion( context->task1 );
	}
	// Must return something - never will get here
	return NULL;
}


/*****************************************************************************/


/** Primary entry function ***/
int main(void) {
	ReturnCode_t returnCode;
	// Create the master context
	Context_t context;
	memset( &context, 0, sizeof(Context_t) );

	// Initialize the logging subsystem
	FL_Initialize( ToConsole, AllCategories, false, NULL);
	FL_SetTypeMask( Scheduler, AllEvents & ~HyperperiodEnd );
	FL_SetTypeMask( Peripheral, AllEvents & ~ReceiveBegin );
	// Initialize Scheduler with hyperperiod length and context
	FS_Initialize( DeadlineMonotonic, FE_SchedulerError, 20.0, 1, &context );
	// Initialize IO Devices
	UDP_Initialize( FE_UDPError );

	/*** Create message ports ***/

	pos_data_msg_t pos_data = { 1.0 };
	CreateSamplingPort( "pos_msg", sizeof(struct pos_data_msg_t), Bidirectional, 0, &(context.msgPort), &returnCode );	
	WriteSamplingMessage( context.msgPort, &pos_data, sizeof(struct pos_data_msg_t), &returnCode );
	
	/*** Create Tasks ***/

	{
		// Create task with instances
		pfloat_t Task1_times[1] = { 15.0 };
		FS_CreatePeriodicTask( "Task1", Task1_exec, &context.task1, 1.0, NoRestriction, 1, Task1_times );
	}

	/*** Create Peripheral Channels ***/
	
	{
		pfloat_t msg1_stimes[1] = { 10.0 };
		FP_SyncExpectation expects[2] = {
			{ ExpectSend, 1, sizeof(struct pos_data_msg_t), 1, msg1_stimes, 1.0, context.msgPort, NULL } };
		context.udpChannel = UDP_CreateChannel( UDP_LOCALADDRESS, UDP_REMOTEADDRESS, 21212,
											   1, expects, 0, NULL, true, true, 2 );
	}

	/*** Execute the schedule ***/

	// Wait for the platform to wake up ( Platform Dependent )
	NanoSleep( SCHEDULER_INITIALIZATION_WAIT, SCHEDULER_RESOLUTION_MS );
	// Execute the schedule
	FS_Execute( 10 );

	/*** Shutdown the application ***/

	// If here, we must shut everything down
	UDP_Shutdown( );
	FS_Shutdown( );
	// Shutdown the logger
	FL_Shutdown( );
}