// Example main.c - This should be generated by the FRODO code generator
#include "frodo.h"


/*****************************************************************************/


/*** Message Structures ***/


// Global Context
typedef struct {
	// Schedulable instances
	SchedSchedulable*				task1;
	// Data collection
	pfloat_t						value;
} Context_t;


/*****************************************************************************/


void* Task1_exec( void *cntx ) {
	// Cast to a context structure
	Context_t* context = (Context_t*)cntx;
//	char localBuffer[256];
	while ( true ) {
		// Wait to execute
		SchedSignalExecution( context->task1 );

		// Write out a message for the moment
//		sprintf( localBuffer, "====>\t\tValue: %4.3f.\n", context->value += 0.5 );
//		LogMessage( localBuffer );

		// Signal that we are done with this execution
		SchedSignalCompletion( context->task1 );
	}
	// Must return something - never will get here
	return NULL;
}


/*****************************************************************************/


/** Primary entry function ***/
int main( int argc, char* argv[] ) {
	// Create the master context
	Context_t context;
	// Zero the context
	memset( &context, 0, sizeof(Context_t) );
	// Command line args: app cycles
	assert( argc = 2 );

	/*** Initialize the FRODO subsystems ***/

	SysEventInitialize( AllCategories, true, true, false );
	PeripheralInitialize();
	LogInitialize();
	ErrorHandlerInitialize();
	SchedInitialize( EarliestDeadlineFirst, ErrSchedulerHandler, 20.0, 1, &context );

	/*** Create Tasks ***/

	{
		// Create task with instances
		pfloat_t Task1_times[9] = { 6.0, 2.75, 2.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0 };
		SchedCreatePeriodicTask( "Task1", Task1_exec, &context.task1, 0.70, NoRestriction, 9, Task1_times );
	}

	/*** Execute the schedule ***/

	// Wait for the platform to wake up ( Platform Dependent )
	NanoSleep( SCHEDULER_INITIALIZATION_WAIT );
	// Execute the schedule
	SchedExecute( atoi(argv[1]) );

	/*** Shutdown the application ***/

	SchedShutdown( );
	SysEventShutdown( NULL );
}
