function cellInfo = ControlParameters(varargin) 
% CONTROLPARAMETERS returns a cell array containing bus object information 
% 
% Optional Input: 'false' will suppress a call to Simulink.Bus.cellToObject 
%                 when the MATLAB file is executed. 
% The order of bus element attributes is as follows:
%   ElementName, Dimensions, DataType, SampleTime, Complexity, SamplingMode, DimensionsMode 

suppressObject = false; 
if nargin == 1 && islogical(varargin{1}) && varargin{1} == false 
    suppressObject = true; 
elseif nargin > 1 
    error('Invalid input argument(s) encountered'); 
end 

cellInfo = { ... 
  { ... 
    'ControlParameters', ... 
    '', ... 
    sprintf(''), { ... 
      {'WPM', 1, 'single', -1, 'real', 'Sample', 'Fixed'}; ...
      {'TC', 1, 'single', -1, 'real', 'Sample', 'Fixed'}; ...
    } ...
  } ...
}'; 

if ~suppressObject 
    % Create bus objects in the MATLAB base workspace 
    Simulink.Bus.cellToObject(cellInfo) 
end 
