/*
 * MCLParser: P a r s e r  H e a d e r 
 *
 * Generated from: mcl.g
 *
 * Terence Parr, Russell Quong, Will Cohen, and Hank Dietz: 1989-1998
 * Parr Research Corporation
 * with Purdue University Electrical Engineering
 * with AHPCRC, University of Minnesota
 * ANTLR Version 1.33MR12b
 */

#ifndef MCLParser_h
#define MCLParser_h

#ifndef ANTLR_VERSION
#define ANTLR_VERSION 13312
#endif

#include "AParser.h"


#undef DEBUG	// Uncomment this to see run-time messages -- this is only
// useful when using a console app driver.

//#include "afx.h"

//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

//#define new DEBUG_NEW

#include "defs.h"
#include "cldef.h"
#include "pure.h"
#include "MCLLexer.h"
#include "PBlackBox.h"
typedef ANTLRCommonToken ANTLRToken;
extern CTypedPtrList<CPtrList, CStringList*> g_stringlists;
extern CObList g_parlist;
extern ClBase *g_top;
class MCLParser : public ANTLRParser {
public:
	static  const ANTLRChar *tokenName(int tk);
protected:
	static  ANTLRChar *_token_tbl[];
private:

public:
static bool parseString(const char *constraintString) {
	bool res = false;
	parseErr = false;
	setError("");
	parsingFile = false;
	
    int parseSignal;
	DLGStringInput *in;
	MCLLexer *scan;
	_ANTLRTokenPtr tok;
	ANTLRTokenBuffer *pipe;
	MCLParser *p;
	extern bool _at_end;
	
	in = new DLGStringInput((const DLGChar *)constraintString);
	scan = new MCLLexer(in);
	pipe = new ANTLRTokenBuffer(scan);
	tok = new ANTLRToken;
	scan->setToken(tok);
	p = new MCLParser(pipe);
	p->init();
	g_top = 0;
	
	_at_end = false;
	while(!_at_end && !parseErr){
		p->cdef(&parseSignal);	// parameter needed for exception handling
	}
	res = !parseErr;
	{
		POSITION pos = g_stringlists.GetHeadPosition();
		while(pos) delete g_stringlists.GetNext(pos);
		g_stringlists.RemoveAll();
	}
	{
		POSITION pos = g_parlist.GetHeadPosition();
		while(pos) delete (ClParList *)g_parlist.GetNext(pos);
		g_parlist.RemoveAll();
	}
	delete p;
	delete tok;
	delete pipe;
	delete scan;
	delete in;
	if (!res) delete g_top;
	return res;
}

  static bool load(char *fname) {
	bool res = false;
	extern bool _at_end;
	
    parseErr = false;
	setError("");
	parsingFile = true;
	int parseSignal;
	
    FILE* f = fopen(fname,"r");
	if(!f) { return false; }
	
    ParserBlackBox<MCLLexer,MCLParser,ANTLRToken> p(f);
	currentLexer = p.getLexer();
	_at_end = false;
	while(!_at_end && !parseErr){
		p.parser()->cdef(&parseSignal);	// parameter needed for exception handling
	}
	res = !parseErr;
	fclose(f);
	return res;
}

  static char* getError() {
	return(errMsg);
}

private:
static bool parseErr;
static bool parsingFile;
static MCLLexer *currentLexer;
static char errMsg[100];

  static void setError(char* e) {
	strcpy(errMsg, e);
}
	static SetWordType EDITING_EVENT_set[12];
	static SetWordType setwd1[90];
	static SetWordType setwd2[90];
	static SetWordType setwd3[90];
	static SetWordType setwd4[90];
	static SetWordType setwd5[90];
	static SetWordType setwd6[90];
	static SetWordType setwd7[90];
private:
	void zzdflthandlers( int _signal, int *_retsignal );

public:

struct _rv14 {
	ClLExpr::LOp _lOp;
	ClLExpr* _next ;
};

struct _rv17 {
	ClAddExpr::AddOp _addOp;
	ClAddExpr* _next ;
};

struct _rv19 {
	ClMulExpr::MulOp _mulOp;
	ClMulExpr* _next ;
};
	MCLParser(ANTLRTokenBuffer *input);
	  CString    name(int *_retsignal);
	void cdef(int *_retsignal);
	 int   priority(int *_retsignal);
	 CString   description(int *_retsignal);
	 CString   catname(int *_retsignal);
	 CString   modelname(int *_retsignal);
	 CString   aspectname(int *_retsignal);
	 CString   eventname(int *_retsignal);
	void cpars(int *_retsignal, ClParList* cpars );
	 ClPar*   cpar(int *_retsignal);
	 ClExpr*   cexpr(int *_retsignal);
	 ClIfExpr*   ifexpr(int *_retsignal);
	 ClLExpr*   lexpr(int *_retsignal);
	struct _rv14 lexpr_r(int *_retsignal);
	 ClRelExpr*   relexpr(int *_retsignal);
	 ClAddExpr*   addexpr(int *_retsignal);
	struct _rv17 addexpr_r(int *_retsignal);
	 ClMulExpr*   mulexpr(int *_retsignal);
	struct _rv19 mulexpr_r(int *_retsignal);
	 ClUnaExpr*   unaexpr(int *_retsignal);
	 ClPostfixExpr*   postfixexpr(int *_retsignal);
	 ClPostfixCall*   postfixcall(int *_retsignal);
	 ClPrimExpr*   primexpr(int *_retsignal);
	 ClCallPars*   callpars(int *_retsignal);
	 ClLit *  lit(int *_retsignal);
	 ClType *  tname(int *_retsignal);
	 ClLitColl *  litcoll(int *_retsignal);
	 ClExprlRange*   cexprlrange(int *_retsignal);
	 ClCall*   call(int *_retsignal);
	 ClDecl*   decl(int *_retsignal);
	 ClObjName *  objname(int *_retsignal);
	 ClActParList*   actparlist(int *_retsignal);
	 ClLExpr::LOp   lop(int *_retsignal);
	 ClLitColl::CollType   coll(int *_retsignal);
	 ClRelExpr::RelOp   rop(int *_retsignal);
	 ClAddExpr::AddOp   addop(int *_retsignal);
	 ClMulExpr::MulOp   mulop(int *_retsignal);
	 ClUnaExpr::UnaOp   unaryop(int *_retsignal);
	  CString    string(int *_retsignal);
	 ClNumber*   number(int *_retsignal);
};

#endif /* MCLParser_h */
