/*
 * A n t l r  T r a n s l a t i o n  H e a d e r
 *
 * Terence Parr, Will Cohen, and Hank Dietz: 1989-1998
 * Purdue University Electrical Engineering
 * With AHPCRC, University of Minnesota
 * ANTLR Version 1.33MR12b
 *
 *   .\antlr -CC -ga mcl.g
 *
 */

#define ANTLR_VERSION	13312
#include <stdio.h>
#include "tokens.h"

#undef DEBUG	// Uncomment this to see run-time messages -- this is only
// useful when using a console app driver.

//#include "afx.h"

//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

//#define new DEBUG_NEW

#include "defs.h"
#include "cldef.h"
#include "pure.h"
#include "MCLLexer.h"
#include "PBlackBox.h"
typedef ANTLRCommonToken ANTLRToken;
extern CTypedPtrList<CPtrList, CStringList*> g_stringlists;
extern CObList g_parlist;
extern ClBase *g_top;
#define EXCEPTION_HANDLING
#define NUM_SIGNALS 3
#include "AParser.h"
#include "MCLParser.h"
#include "DLexerBase.h"
#include "ATokPtr.h"
#ifndef PURIFY
#define PURIFY(r,s) memset((char *) &(r),'\0',(s));
#endif

typedef ANTLRCommonToken ANTLRToken;

bool ParseMCLFile(char* fname) {
	return MCLParser::load(fname);
}

bool ParseMCLString(const char *constraintString) {
	return MCLParser::parseString(constraintString);
}

char* GetMCLErrorMessage() {
	return MCLParser::getError();
}

bool MCLParser::parseErr = false;
bool MCLParser::parsingFile = false;
char MCLParser::errMsg[100];
MCLLexer* MCLParser::currentLexer = nil;
bool _at_end = false;
CTypedPtrList<CPtrList, CStringList*> g_stringlists;
CObList g_parlist;
ClBase *g_top;

void MCLParser::
zzdflthandlers( int _signal, int *_retsignal )
{
	switch ( _signal ) {
	case NoSignal: break;  /* MR7 */
	default :
		
		char dummy[100];
		if(parsingFile){
			sprintf(dummy,"Syntax error at line %d at token \"%s\"",
			currentLexer->line(),LT(1)->getText());
			setError(dummy);
		}
		else{
			sprintf(dummy,"Syntax error at token \"%s\"", LT(1)->getText());
			setError(dummy);
		}
		suppressSignal;
		parseErr = true;
		_signal=NoSignal;  /* MR7 */
		break;  /* MR7 */
	}
}


  CString   
MCLParser::name(int *_retsignal)
{
	  CString   	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr id=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof(  CString   	))
	*_retsignal = NoSignal;
	zzmatch_wsig(IDENT, _handler);
	
	if ( !guessing ) {
		id = (ANTLRTokenPtr)LT(1);
	}
	
	if ( !guessing ) {
	_retv = CString( id->getText());   
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x1);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

void
MCLParser::cdef(int *_retsignal)
{
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	*_retsignal = NoSignal;
	
	CString _name; CString cName, mName, aName, eName, cDescription;
	int cPriority;
	ClParList* _cpars = new ClParList; g_parlist.AddTail(_cpars); ClExpr* _cexpr;
	{
		if ( (LA(1)==INN) ) {
			zzmatch_wsig(INN, _handler);
			 consume();
			if ( !guessing ) {
				 cName  = catname(&_signal); if (_signal) goto _handler;

			} else {
				catname(&_signal);
			}
			{
				if ( (LA(1)==DOT) ) {
					zzmatch_wsig(DOT, _handler);
					 consume();
					if ( !guessing ) {
						 mName  = modelname(&_signal); if (_signal) goto _handler;

					} else {
						modelname(&_signal);
					}
					{
						if ( (LA(1)==DOT) ) {
							zzmatch_wsig(DOT, _handler);
							 consume();
							if ( !guessing ) {
								 aName  = aspectname(&_signal); if (_signal) goto _handler;

							} else {
								aspectname(&_signal);
							}
						}
					}
				}
			}
		}
	}
	{
		if ( (LA(1)==ON) ) {
			zzmatch_wsig(ON, _handler);
			 consume();
			if ( !guessing ) {
				 eName  = eventname(&_signal); if (_signal) goto _handler;

			} else {
				eventname(&_signal);
			}
		}
	}
	zzmatch_wsig(CONSTRAINT, _handler);
	 consume();
	if ( !guessing ) {
		 _name  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	zzmatch_wsig(LPAR, _handler);
	 consume();
	{
		if ( (LA(1)==IDENT) ) {
			cpars(&_signal, _cpars ); if (_signal) goto _handler;
		}
	}
	zzmatch_wsig(RPAR, _handler);
	 consume();
	if ( !guessing ) {
		 cPriority  = priority(&_signal); if (_signal) goto _handler;

	} else {
		priority(&_signal);
	}
	if ( !guessing ) {
		 cDescription  = description(&_signal); if (_signal) goto _handler;

	} else {
		description(&_signal);
	}
	zzmatch_wsig(LBRACE, _handler);
	 consume();
	if ( !guessing ) {
		 _cexpr  = cexpr(&_signal); if (_signal) goto _handler;

	} else {
		cexpr(&_signal);
	}
	zzmatch_wsig(RBRACE, _handler);
	
	if ( !guessing ) {
	
#ifdef DEBUG
	printf("constraint: %s\n", _name);
	printf("\tdescription: %s\n", cDescription);
	printf("\t   priority: %d\n", cPriority);
	printf("\t   category: %s\n", cName);
	printf("\t      model: %s\n", mName);
	printf("\t     aspect: %s\n", aName);
	printf("\t      event: %s\n", eName);
#endif
	}
 consume();
	if ( !guessing ) {
	
	ClConstraint::Make(_name,_cpars,_cexpr,cName,mName,aName,eName,cPriority,cDescription);
	POSITION pos; if (pos=g_parlist.Find(_cpars)) g_parlist.RemoveAt(pos);
	g_top = ClConstraint::GetLastConstraint();
	}
	return;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x2);
_handler:
	zzdflthandlers(_signal,_retsignal);
	return;
}

 int  
MCLParser::priority(int *_retsignal)
{
	 int  	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr id=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( int  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==PRIORITY) ) {
		zzmatch_wsig(PRIORITY, _handler);
		 consume();
		zzmatch_wsig(80,_handler);
		 consume();
		zzmatch_wsig(INTEGER, _handler);
		
		if ( !guessing ) {
				id = (ANTLRTokenPtr)LT(1);
		}
		
		if ( !guessing ) {
		
		int n;
		n = atoi( id->getText());
		if(n<0 )
		_retv = nil;
		else if(n > 3)
		_retv = 3;
		else
		_retv = n;
		}
 consume();
	}
	else {
		if ( (setwd1[LA(1)]&0x4) ) {
			if ( !guessing ) {
			_retv = nil;  
			}
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x8);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 CString  
MCLParser::description(int *_retsignal)
{
	 CString  	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr id=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( CString  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==STR) ) {
		zzmatch_wsig(STR, _handler);
		
		if ( !guessing ) {
				id = (ANTLRTokenPtr)LT(1);
		}
		
		if ( !guessing ) {
		_retv =  id->getText();  
		}
 consume();
	}
	else {
		if ( (LA(1)==LBRACE) ) {
			if ( !guessing ) {
			_retv = "";  
			}
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x10);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 CString  
MCLParser::catname(int *_retsignal)
{
	 CString  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( CString  	))
	*_retsignal = NoSignal;
	if ( !guessing ) {
		 _retv  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 CString  
MCLParser::modelname(int *_retsignal)
{
	 CString  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( CString  	))
	*_retsignal = NoSignal;
	if ( !guessing ) {
		 _retv  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x40);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 CString  
MCLParser::aspectname(int *_retsignal)
{
	 CString  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( CString  	))
	*_retsignal = NoSignal;
	if ( !guessing ) {
		 _retv  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd1, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 CString  
MCLParser::eventname(int *_retsignal)
{
	 CString  	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr id=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( CString  	))
	*_retsignal = NoSignal;
	zzsetmatch_wsig(EDITING_EVENT_set, _handler);
	
	if ( !guessing ) {
		id = (ANTLRTokenPtr)LT(1);
	}
	
	if ( !guessing ) {
	_retv =  id->getText();  
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x1);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

void
MCLParser::cpars(int *_retsignal, ClParList* cpars )
{
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	*_retsignal = NoSignal;
	ClPar* _cpar;   
	if ( !guessing ) {
		 _cpar  = cpar(&_signal); if (_signal) goto _handler;

	} else {
		cpar(&_signal);
	}
	if ( !guessing ) {
	cpars->AddTail(_cpar);   
	}
	{
		while ( (LA(1)==COMMA) ) {
			zzmatch_wsig(COMMA, _handler);
			 consume();
			if ( !guessing ) {
				 _cpar  = cpar(&_signal); if (_signal) goto _handler;

			} else {
				cpar(&_signal);
			}
			if ( !guessing ) {
			cpars->AddTail(_cpar);   
			}
		}
	}
	return;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x2);
_handler:
	zzdflthandlers(_signal,_retsignal);
	return;
}

 ClPar*  
MCLParser::cpar(int *_retsignal)
{
	 ClPar*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClPar*  	))
	*_retsignal = NoSignal;
	CString pName, pType; _retv = nil;   
	if ( !guessing ) {
		 pName  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	{
		if ( (LA(1)==COLON) ) {
			zzmatch_wsig(COLON, _handler);
			 consume();
			if ( !guessing ) {
				 pType  = name(&_signal); if (_signal) goto _handler;

			} else {
				name(&_signal);
			}
		}
	}
	if ( !guessing ) {
	_retv = new ClPar(pName,pType); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x4);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClExpr*  
MCLParser::cexpr(int *_retsignal)
{
	 ClExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClExpr*  	))
	*_retsignal = NoSignal;
	ClLExpr* _lexpr; _retv = nil;   
	if ( !guessing ) {
		 _lexpr  = lexpr(&_signal); if (_signal) goto _handler;

	} else {
		lexpr(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClExpr(_lexpr); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x8);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClIfExpr*  
MCLParser::ifexpr(int *_retsignal)
{
	 ClIfExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClIfExpr*  	))
	*_retsignal = NoSignal;
	ClExpr *_condE, *_thenE, *_elseE = nil; _retv = nil;   
	zzmatch_wsig(IF, _handler);
	 consume();
	if ( !guessing ) {
		 _condE  = cexpr(&_signal); if (_signal) goto _handler;

	} else {
		cexpr(&_signal);
	}
	zzmatch_wsig(THEN, _handler);
	 consume();
	if ( !guessing ) {
		 _thenE  = cexpr(&_signal); if (_signal) goto _handler;

	} else {
		cexpr(&_signal);
	}
	{
		if ( (LA(1)==ELSE) ) {
			zzmatch_wsig(ELSE, _handler);
			 consume();
			if ( !guessing ) {
				 _elseE  = cexpr(&_signal); if (_signal) goto _handler;

			} else {
				cexpr(&_signal);
			}
		}
	}
	zzmatch_wsig(ENDIF, _handler);
	
	if ( !guessing ) {
	_retv = new ClIfExpr(_condE,_thenE,_elseE); g_top = _retv;   
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x10);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClLExpr*  
MCLParser::lexpr(int *_retsignal)
{
	 ClLExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClLExpr*  	))
	*_retsignal = NoSignal;
	ClRelExpr* _relExpr; 
	ClLExpr::LOp _lOp = ClLExpr::noOp;
	ClLExpr* _next = nil; _retv = nil;
	if ( !guessing ) {
		 _relExpr  = relexpr(&_signal); if (_signal) goto _handler;

	} else {
		relexpr(&_signal);
	}
	if ( !guessing ) {
		{ struct _rv14 _trv; _trv = lexpr_r(&_signal); if (_signal) goto _handler;

		_lOp = _trv._lOp; _next  = _trv._next; }
	} else {
		lexpr_r(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClLExpr(_relExpr,_lOp,_next); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

MCLParser::_rv14
MCLParser::lexpr_r(int *_retsignal)
{
	struct _rv14 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof(struct _rv14))
	*_retsignal = NoSignal;
	_retv._lOp = ClLExpr::noOp; _retv._next = nil; 
	ClRelExpr* _relExpr;
	ClLExpr::LOp rLOp = ClLExpr::noOp;
	ClLExpr *rNext = nil;   
	{
		if ( (setwd2[LA(1)]&0x40) ) {
			if ( !guessing ) {
				 _retv._lOp  = lop(&_signal); if (_signal) goto _handler;

			} else {
				lop(&_signal);
			}
			if ( !guessing ) {
				 _relExpr  = relexpr(&_signal); if (_signal) goto _handler;

			} else {
				relexpr(&_signal);
			}
			if ( !guessing ) {
				{ struct _rv14 _trv; _trv = lexpr_r(&_signal); if (_signal) goto _handler;

				rLOp = _trv._lOp; rNext  = _trv._next; }
			} else {
				lexpr_r(&_signal);
			}
			if ( !guessing ) {
			_retv._next = new ClLExpr(_relExpr,rLOp,rNext);   
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd2, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClRelExpr*  
MCLParser::relexpr(int *_retsignal)
{
	 ClRelExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClRelExpr*  	))
	*_retsignal = NoSignal;
	ClAddExpr* _addExpr;
	ClRelExpr::RelOp _relOp = ClRelExpr::noOp;
	ClAddExpr* _next = nil; _retv = nil;   
	if ( !guessing ) {
		 _addExpr  = addexpr(&_signal); if (_signal) goto _handler;

	} else {
		addexpr(&_signal);
	}
	{
		if ( (setwd3[LA(1)]&0x1) ) {
			if ( !guessing ) {
				 _relOp  = rop(&_signal); if (_signal) goto _handler;

			} else {
				rop(&_signal);
			}
			if ( !guessing ) {
				 _next  = addexpr(&_signal); if (_signal) goto _handler;

			} else {
				addexpr(&_signal);
			}
		}
	}
	if ( !guessing ) {
	_retv = new ClRelExpr(_addExpr,_relOp,_next); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd3, 0x2);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClAddExpr*  
MCLParser::addexpr(int *_retsignal)
{
	 ClAddExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClAddExpr*  	))
	*_retsignal = NoSignal;
	ClMulExpr* _mulExpr;
	ClAddExpr::AddOp _addOp = ClAddExpr::noOp;
	ClAddExpr* _next = nil; _retv = nil;  
	if ( !guessing ) {
		 _mulExpr  = mulexpr(&_signal); if (_signal) goto _handler;

	} else {
		mulexpr(&_signal);
	}
	if ( !guessing ) {
		{ struct _rv17 _trv; _trv = addexpr_r(&_signal); if (_signal) goto _handler;

		_addOp = _trv._addOp; _next  = _trv._next; }
	} else {
		addexpr_r(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClAddExpr(_mulExpr,_addOp,_next); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd3, 0x4);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

MCLParser::_rv17
MCLParser::addexpr_r(int *_retsignal)
{
	struct _rv17 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof(struct _rv17))
	*_retsignal = NoSignal;
	_retv._addOp = ClAddExpr::noOp; _retv._next = nil;
	ClMulExpr* _mulExpr; 
	ClAddExpr::AddOp rAddOp = ClAddExpr::noOp;
	ClAddExpr *rNext = nil;   
	{
		if ( (setwd3[LA(1)]&0x8) ) {
			if ( !guessing ) {
				 _retv._addOp  = addop(&_signal); if (_signal) goto _handler;

			} else {
				addop(&_signal);
			}
			if ( !guessing ) {
				 _mulExpr  = mulexpr(&_signal); if (_signal) goto _handler;

			} else {
				mulexpr(&_signal);
			}
			if ( !guessing ) {
				{ struct _rv17 _trv; _trv = addexpr_r(&_signal); if (_signal) goto _handler;

				rAddOp = _trv._addOp; rNext  = _trv._next; }
			} else {
				addexpr_r(&_signal);
			}
			if ( !guessing ) {
			_retv._next = new ClAddExpr(_mulExpr,rAddOp,rNext);   
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd3, 0x10);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClMulExpr*  
MCLParser::mulexpr(int *_retsignal)
{
	 ClMulExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClMulExpr*  	))
	*_retsignal = NoSignal;
	ClUnaExpr* _unaExpr;
	ClMulExpr::MulOp _mulOp = ClMulExpr::noOp;
	ClMulExpr* _next = nil; _retv = nil;  
	if ( !guessing ) {
		 _unaExpr  = unaexpr(&_signal); if (_signal) goto _handler;

	} else {
		unaexpr(&_signal);
	}
	if ( !guessing ) {
		{ struct _rv19 _trv; _trv = mulexpr_r(&_signal); if (_signal) goto _handler;

		_mulOp = _trv._mulOp; _next  = _trv._next; }
	} else {
		mulexpr_r(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClMulExpr(_unaExpr,_mulOp,_next); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd3, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

MCLParser::_rv19
MCLParser::mulexpr_r(int *_retsignal)
{
	struct _rv19 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof(struct _rv19))
	*_retsignal = NoSignal;
	_retv._mulOp = ClMulExpr::noOp; _retv._next = nil;
	ClUnaExpr* _unaExpr; 
	ClMulExpr::MulOp rMulOp = ClMulExpr::noOp;
	ClMulExpr *rNext = nil;   
	{
		if ( (setwd3[LA(1)]&0x40) ) {
			if ( !guessing ) {
				 _retv._mulOp  = mulop(&_signal); if (_signal) goto _handler;

			} else {
				mulop(&_signal);
			}
			if ( !guessing ) {
				 _unaExpr  = unaexpr(&_signal); if (_signal) goto _handler;

			} else {
				unaexpr(&_signal);
			}
			if ( !guessing ) {
				{ struct _rv19 _trv; _trv = mulexpr_r(&_signal); if (_signal) goto _handler;

				rMulOp = _trv._mulOp; rNext  = _trv._next; }
			} else {
				mulexpr_r(&_signal);
			}
			if ( !guessing ) {
			_retv._next = new ClMulExpr(_unaExpr,rMulOp,rNext);   
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd3, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClUnaExpr*  
MCLParser::unaexpr(int *_retsignal)
{
	 ClUnaExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClUnaExpr*  	))
	*_retsignal = NoSignal;
	ClPostfixExpr* _postfixExpr; ClUnaExpr::UnaOp _unaOp; _retv = nil;   
	if ( (setwd4[LA(1)]&0x1) ) {
		{
			if ( !guessing ) {
				 _unaOp  = unaryop(&_signal); if (_signal) goto _handler;

			} else {
				unaryop(&_signal);
			}
			if ( !guessing ) {
				 _postfixExpr  = postfixexpr(&_signal); if (_signal) goto _handler;

			} else {
				postfixexpr(&_signal);
			}
		}
		if ( !guessing ) {
		_retv = new ClUnaExpr(_postfixExpr,_unaOp); g_top = _retv;   
		}
	}
	else {
		if ( (setwd4[LA(1)]&0x2) ) {
			if ( !guessing ) {
				 _postfixExpr  = postfixexpr(&_signal); if (_signal) goto _handler;

			} else {
				postfixexpr(&_signal);
			}
			if ( !guessing ) {
			_retv = new ClUnaExpr(_postfixExpr); g_top = _retv;   
			}
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd4, 0x4);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClPostfixExpr*  
MCLParser::postfixexpr(int *_retsignal)
{
	 ClPostfixExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClPostfixExpr*  	))
	*_retsignal = NoSignal;
	ClPrimExpr* _primExpr; 
	ClPostfixCall* _postfixCall = nil; _retv = nil;   
	if ( !guessing ) {
		 _primExpr  = primexpr(&_signal); if (_signal) goto _handler;

	} else {
		primexpr(&_signal);
	}
	if ( !guessing ) {
		 _postfixCall  = postfixcall(&_signal); if (_signal) goto _handler;

	} else {
		postfixcall(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClPostfixExpr(_primExpr,_postfixCall); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd4, 0x8);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClPostfixCall*  
MCLParser::postfixcall(int *_retsignal)
{
	 ClPostfixCall*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClPostfixCall*  	))
	*_retsignal = NoSignal;
	ClPostfixCall::CallOp _callOp = ClPostfixCall::noOp;
	ClCall* _call = nil;
	ClPostfixCall* _next = nil; _retv = nil; _retv = nil;   
	{
		if ( (setwd4[LA(1)]&0x10) ) {
			{
				{
					if ( (LA(1)==DOT) ) {
						zzmatch_wsig(DOT, _handler);
						
						if ( !guessing ) {
						_callOp = ClPostfixCall::objCallOp;   
						}
 consume();
					}
					else {
						if ( (LA(1)==ARROW) ) {
							zzmatch_wsig(ARROW, _handler);
							
							if ( !guessing ) {
							_callOp = ClPostfixCall::collCallOp;  
							}
 consume();
						}
						else {
							if ( (LA(1)==CARET) ) {
								zzmatch_wsig(CARET, _handler);
								
								if ( !guessing ) {
								_callOp = ClPostfixCall::stdCallOp;   
								}
 consume();
							}
							else {
								if ( guessing ) goto fail;
								if (_sva) _signal=NoViableAlt;
								else _signal=NoSemViableAlt;
								goto _handler;  /* MR7 */
							}
						}
					}
				}
				if ( !guessing ) {
					 _call  = call(&_signal); if (_signal) goto _handler;

				} else {
					call(&_signal);
				}
			}
			if ( !guessing ) {
				 _next  = postfixcall(&_signal); if (_signal) goto _handler;

			} else {
				postfixcall(&_signal);
			}
			if ( !guessing ) {
			_retv = new ClPostfixCall(_callOp,_call,_next); g_top = _retv;   
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd4, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClPrimExpr*  
MCLParser::primexpr(int *_retsignal)
{
	 ClPrimExpr*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClPrimExpr*  	))
	*_retsignal = NoSignal;
	ClLitColl* _litColl; ClLit* _lit;
	ClObjName* _objName; ClCallPars *_callPars = nil;
	ClExpr* _cexpr; ClIfExpr* _ifExpr; _retv = nil;
	if ( (setwd4[LA(1)]&0x40) ) {
		if ( !guessing ) {
			 _litColl  = litcoll(&_signal); if (_signal) goto _handler;

		} else {
			litcoll(&_signal);
		}
		if ( !guessing ) {
		_retv = new ClPrimExpr(_litColl); g_top = _retv;   
		}
	}
	else {
		if ( (setwd4[LA(1)]&0x80) ) {
			if ( !guessing ) {
				 _lit  = lit(&_signal); if (_signal) goto _handler;

			} else {
				lit(&_signal);
			}
			if ( !guessing ) {
			_retv = new ClPrimExpr(_lit); g_top = _retv;   
			}
		}
		else {
			if ( (setwd5[LA(1)]&0x1) ) {
				if ( !guessing ) {
					 _objName  = objname(&_signal); if (_signal) goto _handler;

				} else {
					objname(&_signal);
				}
				if ( !guessing ) {
					 _callPars  = callpars(&_signal); if (_signal) goto _handler;

				} else {
					callpars(&_signal);
				}
				if ( !guessing ) {
				_retv = new ClPrimExpr(_objName,_callPars); g_top = _retv;   
				}
			}
			else {
				if ( (LA(1)==LPAR) ) {
					zzmatch_wsig(LPAR, _handler);
					 consume();
					if ( !guessing ) {
						 _cexpr  = cexpr(&_signal); if (_signal) goto _handler;

					} else {
						cexpr(&_signal);
					}
					zzmatch_wsig(RPAR, _handler);
					
					if ( !guessing ) {
					_retv = new ClPrimExpr(_cexpr); g_top = _retv;   
					}
 consume();
				}
				else {
					if ( (LA(1)==IF) ) {
						if ( !guessing ) {
							 _ifExpr  = ifexpr(&_signal); if (_signal) goto _handler;

						} else {
							ifexpr(&_signal);
						}
						if ( !guessing ) {
						_retv = new ClPrimExpr(_ifExpr); g_top = _retv;   
						}
					}
					else {
						if ( guessing ) goto fail;
						if (_sva) _signal=NoViableAlt;
						else _signal=NoSemViableAlt;
						goto _handler;  /* MR7 */
					}
				}
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd5, 0x2);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClCallPars*  
MCLParser::callpars(int *_retsignal)
{
	 ClCallPars*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClCallPars*  	))
	*_retsignal = NoSignal;
	ClDecl* _decl = nil, *_dummy;
	ClActParList* _actParList = nil; 
	_retv = nil;   
	{
		if ( (LA(1)==LPAR) ) {
			zzmatch_wsig(LPAR, _handler);
			 consume();
			{
				zzGUESS_BLOCK
				zzGUESS
				if ( !zzrv && (LA(1)==IDENT) ) {
					{
						if ( !guessing ) {
							 _dummy  = decl(&_signal); if (_signal) goto _handler;

						} else {
							decl(&_signal);
						}
					}
					zzGUESS_DONE
					if ( !guessing ) {
						 _decl  = decl(&_signal); if (_signal) goto _handler;

					} else {
						decl(&_signal);
					}
					{
						if ( (setwd5[LA(1)]&0x4) ) {
							if ( !guessing ) {
								 _actParList  = actparlist(&_signal); if (_signal) goto _handler;

							} else {
								actparlist(&_signal);
							}
						}
					}
				}
				else {
					if ( !zzrv ) zzGUESS_DONE;
					if ( (setwd5[LA(1)]&0x8) ) {
						{
							if ( (setwd5[LA(1)]&0x10) ) {
								if ( !guessing ) {
									 _actParList  = actparlist(&_signal); if (_signal) goto _handler;

								} else {
									actparlist(&_signal);
								}
							}
						}
					}
					else {
						if ( guessing ) goto fail;
						if (_sva) _signal=NoViableAlt;
						else _signal=NoSemViableAlt;
						goto _handler;  /* MR7 */
					}
				}
			}
			if ( !guessing ) {
			_retv = new ClCallPars(_decl,_actParList); g_top = _retv;   
			}
			zzmatch_wsig(RPAR, _handler);
			 consume();
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd5, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClLit * 
MCLParser::lit(int *_retsignal)
{
	 ClLit * 	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClLit * 	))
	*_retsignal = NoSignal;
	CString str; ClNumber* cnum; _retv = nil;   
	if ( (LA(1)==STR) ) {
		if ( !guessing ) {
			 str  = string(&_signal); if (_signal) goto _handler;

		} else {
			string(&_signal);
		}
		if ( !guessing ) {
		_retv = new ClLit(str); g_top = _retv;   
		}
	}
	else {
		if ( (setwd5[LA(1)]&0x40) ) {
			if ( !guessing ) {
				 cnum  = number(&_signal); if (_signal) goto _handler;

			} else {
				number(&_signal);
			}
			if ( !guessing ) {
			_retv = new ClLit(cnum); g_top = _retv;   
			}
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd5, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClType * 
MCLParser::tname(int *_retsignal)
{
	 ClType * 	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClType * 	))
	*_retsignal = NoSignal;
	CString _name; _retv = nil;   
	if ( !guessing ) {
		 _name  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClType(_name); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x1);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClLitColl * 
MCLParser::litcoll(int *_retsignal)
{
	 ClLitColl * 	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClLitColl * 	))
	*_retsignal = NoSignal;
	ClLitColl::CollType _coll;
	ClExprlRange* _range= nil; _retv = nil;   
	if ( !guessing ) {
		 _coll  = coll(&_signal); if (_signal) goto _handler;

	} else {
		coll(&_signal);
	}
	zzmatch_wsig(LBRACE, _handler);
	 consume();
	{
		if ( (setwd6[LA(1)]&0x2) ) {
			if ( !guessing ) {
				 _range  = cexprlrange(&_signal); if (_signal) goto _handler;

			} else {
				cexprlrange(&_signal);
			}
		}
	}
	zzmatch_wsig(RBRACE, _handler);
	
	if ( !guessing ) {
	_retv = new ClLitColl(_coll,_range); g_top = _retv;   
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x4);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClExprlRange*  
MCLParser::cexprlrange(int *_retsignal)
{
	 ClExprlRange*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClExprlRange*  	))
	*_retsignal = NoSignal;
	ClExpr *_from = nil, *_to = nil, *_next = nil; 
	ClExprList *_list = nil; _retv = nil;   
	if ( !guessing ) {
		 _from  = cexpr(&_signal); if (_signal) goto _handler;

	} else {
		cexpr(&_signal);
	}
	{
		if ( (LA(1)==COMMA) ) {
			{
				_list = new ClExprList;  
				{
					int zzcnt=1;
					do {
						zzmatch_wsig(COMMA, _handler);
						 consume();
						if ( !guessing ) {
							 _next  = cexpr(&_signal); if (_signal) goto _handler;

						} else {
							cexpr(&_signal);
						}
						if ( !guessing ) {
						_list->AddTail(_next);  
						}
					} while ( (LA(1)==COMMA) );
				}
			}
		}
		else {
			if ( (LA(1)==DDOT) ) {
				{
					zzmatch_wsig(DDOT, _handler);
					 consume();
					if ( !guessing ) {
						 _to  = cexpr(&_signal); if (_signal) goto _handler;

					} else {
						cexpr(&_signal);
					}
				}
			}
		}
	}
	if ( !guessing ) {
	_retv = _list ? 
	new ClExprlRange(_from,_list) :
	new ClExprlRange(_from,_to); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x8);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClCall*  
MCLParser::call(int *_retsignal)
{
	 ClCall*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClCall*  	))
	*_retsignal = NoSignal;
	CString _name; ClCallPars *_pars; _retv = nil;   
	if ( !guessing ) {
		 _name  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	if ( !guessing ) {
		 _pars  = callpars(&_signal); if (_signal) goto _handler;

	} else {
		callpars(&_signal);
	}
	if ( !guessing ) {
	_retv = new ClCall(_name,_pars); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x10);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClDecl*  
MCLParser::decl(int *_retsignal)
{
	 ClDecl*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClDecl*  	))
	*_retsignal = NoSignal;
	CStringList* _names = new CStringList; 
	CString _name; ClType* _tname = nil; g_stringlists.AddTail(_names); _retv = nil;   
	if ( !guessing ) {
		 _name  = name(&_signal); if (_signal) goto _handler;

	} else {
		name(&_signal);
	}
	if ( !guessing ) {
	_names->AddTail(_name);   
	}
	{
		while ( (LA(1)==COMMA) ) {
			zzmatch_wsig(COMMA, _handler);
			 consume();
			if ( !guessing ) {
				 _name  = name(&_signal); if (_signal) goto _handler;

			} else {
				name(&_signal);
			}
			if ( !guessing ) {
			_names->AddTail(_name);  
			}
		}
	}
	{
		if ( (LA(1)==COLON) ) {
			zzmatch_wsig(COLON, _handler);
			 consume();
			if ( !guessing ) {
				 _tname  = tname(&_signal); if (_signal) goto _handler;

			} else {
				tname(&_signal);
			}
		}
	}
	zzmatch_wsig(83,_handler);
	
	if ( !guessing ) {
	_retv = new ClDecl(_names,_tname); g_top = _retv;
	POSITION pos; if (pos=g_stringlists.Find(_names)) g_stringlists.RemoveAt(pos);   
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClObjName * 
MCLParser::objname(int *_retsignal)
{
	 ClObjName * 	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClObjName * 	))
	*_retsignal = NoSignal;
	CString _name; _retv = nil;   
	if ( (LA(1)==IDENT) ) {
		if ( !guessing ) {
			 _name  = name(&_signal); if (_signal) goto _handler;

		} else {
			name(&_signal);
		}
		if ( !guessing ) {
		_retv = new ClObjName(_name); g_top = _retv;   
		}
	}
	else {
		if ( (LA(1)==SELF) ) {
			zzmatch_wsig(SELF, _handler);
			
			if ( !guessing ) {
			_retv = new ClObjName(); g_top = _retv;   
			}
 consume();
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x40);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClActParList*  
MCLParser::actparlist(int *_retsignal)
{
	 ClActParList*  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClActParList*  	))
	*_retsignal = NoSignal;
	ClExpr* _cexpr;
	ClExprList* _list = new ClExprList; _retv = nil;   
	if ( !guessing ) {
		 _cexpr  = cexpr(&_signal); if (_signal) goto _handler;

	} else {
		cexpr(&_signal);
	}
	if ( !guessing ) {
	_list->AddTail(_cexpr);   
	}
	{
		while ( (LA(1)==COMMA) ) {
			zzmatch_wsig(COMMA, _handler);
			 consume();
			if ( !guessing ) {
				 _cexpr  = cexpr(&_signal); if (_signal) goto _handler;

			} else {
				cexpr(&_signal);
			}
			if ( !guessing ) {
			_list->AddTail(_cexpr);   
			}
		}
	}
	if ( !guessing ) {
	_retv = new ClActParList(_list); g_top = _retv;   
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd6, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClLExpr::LOp  
MCLParser::lop(int *_retsignal)
{
	 ClLExpr::LOp  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClLExpr::LOp  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==AND) ) {
		zzmatch_wsig(AND, _handler);
		
		if ( !guessing ) {
		_retv = ClLExpr::andOp;   
		}
 consume();
	}
	else {
		if ( (LA(1)==OR) ) {
			zzmatch_wsig(OR, _handler);
			
			if ( !guessing ) {
			_retv = ClLExpr::orOp;   
			}
 consume();
		}
		else {
			if ( (LA(1)==XOR) ) {
				zzmatch_wsig(XOR, _handler);
				
				if ( !guessing ) {
				_retv = ClLExpr::xorOp;   
				}
 consume();
			}
			else {
				if ( (LA(1)==IMPLIES) ) {
					zzmatch_wsig(IMPLIES, _handler);
					
					if ( !guessing ) {
					_retv = ClLExpr::implOp;   
					}
 consume();
				}
				else {
					if ( guessing ) goto fail;
					if (_sva) _signal=NoViableAlt;
					else _signal=NoSemViableAlt;
					goto _handler;  /* MR7 */
				}
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x1);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClLitColl::CollType  
MCLParser::coll(int *_retsignal)
{
	 ClLitColl::CollType  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClLitColl::CollType  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==SET) ) {
		zzmatch_wsig(SET, _handler);
		
		if ( !guessing ) {
		_retv = ClLitColl::setColl;   
		}
 consume();
	}
	else {
		if ( (LA(1)==BAG) ) {
			zzmatch_wsig(BAG, _handler);
			
			if ( !guessing ) {
			_retv = ClLitColl::bagColl;   
			}
 consume();
		}
		else {
			if ( (LA(1)==SEQUENCE) ) {
				zzmatch_wsig(SEQUENCE, _handler);
				
				if ( !guessing ) {
				_retv = ClLitColl::seqColl;   
				}
 consume();
			}
			else {
				if ( (LA(1)==COLLECTION) ) {
					zzmatch_wsig(COLLECTION, _handler);
					
					if ( !guessing ) {
					_retv = ClLitColl::collColl;   
					}
 consume();
				}
				else {
					if ( guessing ) goto fail;
					if (_sva) _signal=NoViableAlt;
					else _signal=NoSemViableAlt;
					goto _handler;  /* MR7 */
				}
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x2);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClRelExpr::RelOp  
MCLParser::rop(int *_retsignal)
{
	 ClRelExpr::RelOp  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClRelExpr::RelOp  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==80) ) {
		zzmatch_wsig(80,_handler);
		
		if ( !guessing ) {
		_retv = ClRelExpr::eqOp;   
		}
 consume();
	}
	else {
		if ( (LA(1)==84) ) {
			zzmatch_wsig(84,_handler);
			
			if ( !guessing ) {
			_retv = ClRelExpr::ltOp;   
			}
 consume();
		}
		else {
			if ( (LA(1)==85) ) {
				zzmatch_wsig(85,_handler);
				
				if ( !guessing ) {
				_retv = ClRelExpr::gtOp;   
				}
 consume();
			}
			else {
				if ( (LA(1)==86) ) {
					zzmatch_wsig(86,_handler);
					
					if ( !guessing ) {
					_retv = ClRelExpr::geOp;   
					}
 consume();
				}
				else {
					if ( (LA(1)==87) ) {
						zzmatch_wsig(87,_handler);
						
						if ( !guessing ) {
						_retv = ClRelExpr::leOp;   
						}
 consume();
					}
					else {
						if ( (LA(1)==88) ) {
							zzmatch_wsig(88,_handler);
							
							if ( !guessing ) {
							_retv = ClRelExpr::neOp;   
							}
 consume();
						}
						else {
							if ( guessing ) goto fail;
							if (_sva) _signal=NoViableAlt;
							else _signal=NoSemViableAlt;
							goto _handler;  /* MR7 */
						}
					}
				}
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x4);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClAddExpr::AddOp  
MCLParser::addop(int *_retsignal)
{
	 ClAddExpr::AddOp  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClAddExpr::AddOp  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==PLUS) ) {
		zzmatch_wsig(PLUS, _handler);
		
		if ( !guessing ) {
		_retv = ClAddExpr::plusOp;   
		}
 consume();
	}
	else {
		if ( (LA(1)==MINUS) ) {
			zzmatch_wsig(MINUS, _handler);
			
			if ( !guessing ) {
			_retv = ClAddExpr::minusOp;   
			}
 consume();
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x8);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClMulExpr::MulOp  
MCLParser::mulop(int *_retsignal)
{
	 ClMulExpr::MulOp  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClMulExpr::MulOp  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==MUL) ) {
		zzmatch_wsig(MUL, _handler);
		
		if ( !guessing ) {
		_retv = ClMulExpr::starOp;   
		}
 consume();
	}
	else {
		if ( (LA(1)==DIV) ) {
			zzmatch_wsig(DIV, _handler);
			
			if ( !guessing ) {
			_retv = ClMulExpr::perOp;   
			}
 consume();
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x10);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClUnaExpr::UnaOp  
MCLParser::unaryop(int *_retsignal)
{
	 ClUnaExpr::UnaOp  	 _retv;
	zzRULE;
	int _sva=1;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClUnaExpr::UnaOp  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==MINUS) ) {
		zzmatch_wsig(MINUS, _handler);
		
		if ( !guessing ) {
		_retv = ClUnaExpr::minOp;   
		}
 consume();
	}
	else {
		if ( (LA(1)==NOT) ) {
			zzmatch_wsig(NOT, _handler);
			
			if ( !guessing ) {
			_retv = ClUnaExpr::notOp;   
			}
 consume();
		}
		else {
			if ( (LA(1)==SIN) ) {
				zzmatch_wsig(SIN, _handler);
				
				if ( !guessing ) {
				_retv = ClUnaExpr::sinOp;   
				}
 consume();
			}
			else {
				if ( (LA(1)==COS) ) {
					zzmatch_wsig(COS, _handler);
					
					if ( !guessing ) {
					_retv = ClUnaExpr::cosOp;   
					}
 consume();
				}
				else {
					if ( (LA(1)==TAN) ) {
						zzmatch_wsig(TAN, _handler);
						
						if ( !guessing ) {
						_retv = ClUnaExpr::tanOp;   
						}
 consume();
					}
					else {
						if ( (LA(1)==ASIN) ) {
							zzmatch_wsig(ASIN, _handler);
							
							if ( !guessing ) {
							_retv = ClUnaExpr::asinOp;   
							}
 consume();
						}
						else {
							if ( (LA(1)==ACOS) ) {
								zzmatch_wsig(ACOS, _handler);
								
								if ( !guessing ) {
								_retv = ClUnaExpr::acosOp;   
								}
 consume();
							}
							else {
								if ( (LA(1)==ATAN) ) {
									zzmatch_wsig(ATAN, _handler);
									
									if ( !guessing ) {
									_retv = ClUnaExpr::atanOp;   
									}
 consume();
								}
								else {
									if ( (LA(1)==SINH) ) {
										zzmatch_wsig(SINH, _handler);
										
										if ( !guessing ) {
										_retv = ClUnaExpr::sinhOp;   
										}
 consume();
									}
									else {
										if ( (LA(1)==COSH) ) {
											zzmatch_wsig(COSH, _handler);
											
											if ( !guessing ) {
											_retv = ClUnaExpr::coshOp;   
											}
 consume();
										}
										else {
											if ( (LA(1)==TANH) ) {
												zzmatch_wsig(TANH, _handler);
												
												if ( !guessing ) {
												_retv = ClUnaExpr::tanhOp;   
												}
 consume();
											}
											else {
												if ( (LA(1)==ASINH) ) {
													zzmatch_wsig(ASINH, _handler);
													
													if ( !guessing ) {
													_retv = ClUnaExpr::asinhOp;   
													}
 consume();
												}
												else {
													if ( (LA(1)==ACOSH) ) {
														zzmatch_wsig(ACOSH, _handler);
														
														if ( !guessing ) {
														_retv = ClUnaExpr::acoshOp;   
														}
 consume();
													}
													else {
														if ( (LA(1)==ATANH) ) {
															zzmatch_wsig(ATANH, _handler);
															
															if ( !guessing ) {
															_retv = ClUnaExpr::atanhOp;   
															}
 consume();
														}
														else {
															if ( (LA(1)==LOG2) ) {
																zzmatch_wsig(LOG2, _handler);
																
																if ( !guessing ) {
																_retv = ClUnaExpr::log2Op;   
																}
 consume();
															}
															else {
																if ( (LA(1)==LOG10) ) {
																	zzmatch_wsig(LOG10, _handler);
																	
																	if ( !guessing ) {
																	_retv = ClUnaExpr::log10Op;   
																	}
 consume();
																}
																else {
																	if ( (LA(1)==LN) ) {
																		zzmatch_wsig(LN, _handler);
																		
																		if ( !guessing ) {
																		_retv = ClUnaExpr::lnOp;   
																		}
 consume();
																	}
																	else {
																		if ( (LA(1)==EXP) ) {
																			zzmatch_wsig(EXP, _handler);
																			
																			if ( !guessing ) {
																			_retv = ClUnaExpr::expOp;   
																			}
 consume();
																		}
																		else {
																			if ( (LA(1)==SQRT) ) {
																				zzmatch_wsig(SQRT, _handler);
																				
																				if ( !guessing ) {
																				_retv = ClUnaExpr::sqrtOp;   
																				}
 consume();
																			}
																			else {
																				if ( (LA(1)==SIGN) ) {
																					zzmatch_wsig(SIGN, _handler);
																					
																					if ( !guessing ) {
																					_retv = ClUnaExpr::signOp;   
																					}
 consume();
																				}
																				else {
																					if ( (LA(1)==RINT) ) {
																						zzmatch_wsig(RINT, _handler);
																						
																						if ( !guessing ) {
																						_retv = ClUnaExpr::rintOp;   
																						}
 consume();
																					}
																					else {
																						if ( (LA(1)==ABS) ) {
																							zzmatch_wsig(ABS, _handler);
																							
																							if ( !guessing ) {
																							_retv = ClUnaExpr::absOp;   
																							}
 consume();
																						}
																						else {
																							if ( guessing ) goto fail;
																							if (_sva) _signal=NoViableAlt;
																							else _signal=NoSemViableAlt;
																							goto _handler;  /* MR7 */
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x20);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

  CString   
MCLParser::string(int *_retsignal)
{
	  CString   	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr str=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof(  CString   	))
	*_retsignal = NoSignal;
	zzmatch_wsig(STR, _handler);
	
	if ( !guessing ) {
		str = (ANTLRTokenPtr)LT(1);
	}
	
	if ( !guessing ) {
	_retv = CString(str->getText());
	int n = _retv.GetLength();
	_retv = _retv.Left(n - 1).Right(n - 2);   
	}
 consume();
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x40);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}

 ClNumber*  
MCLParser::number(int *_retsignal)
{
	 ClNumber*  	 _retv;
	zzRULE;
	int _sva=1;
	ANTLRTokenPtr r=NULL, n=NULL;
	int _signal=NoSignal;
	PURIFY(_retv,sizeof( ClNumber*  	))
	*_retsignal = NoSignal;
	if ( (LA(1)==REAL) ) {
		zzmatch_wsig(REAL, _handler);
		
		if ( !guessing ) {
				r = (ANTLRTokenPtr)LT(1);
		}
		
		if ( !guessing ) {
		double d = 0; sscanf(r->getText(),"%lf",&d);
		_retv = new ClNumber(d); g_top = _retv;   
		}
 consume();
	}
	else {
		if ( (LA(1)==INTEGER) ) {
			zzmatch_wsig(INTEGER, _handler);
			
			if ( !guessing ) {
						n = (ANTLRTokenPtr)LT(1);
			}
			
			if ( !guessing ) {
			int i = 0; sscanf(n->getText(),"%d",&i);
			_retv = new ClNumber(i); g_top = _retv;   
			}
 consume();
		}
		else {
			if ( guessing ) goto fail;
			if (_sva) _signal=NoViableAlt;
			else _signal=NoSemViableAlt;
			goto _handler;  /* MR7 */
		}
	}
	return _retv;
fail:
	if ( guessing ) zzGUESS_FAIL;
	syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
	resynch(setwd7, 0x80);
	return _retv;
_handler:
	zzdflthandlers(_signal,_retsignal);
	return _retv;
}
