
package AVM;
import com.google.gson.*;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

import java.lang.reflect.Type;
import java.util.*;


/**
 * Created with IntelliJ IDEA.
 * User: adam
 * Date: 9/26/12
 * Time: 5:36 PM
 * To change this template use File | Settings | File Templates.
 */

class AVMComponentDeserializer implements JsonDeserializer<Object>
{
    private Map<String,Type> m_AVMTypes;
    AVMComponentDeserializer()
    {
        // Get list of all classes in AVM namespace. We'll need this on Deserialize.
        List<ClassLoader> classLoadersList = new LinkedList<ClassLoader>();
        classLoadersList.add(ClasspathHelper.contextClassLoader());
        classLoadersList.add(ClasspathHelper.staticClassLoader());
                Reflections reflections = new Reflections(new ConfigurationBuilder()
                .setScanners(new SubTypesScanner(false /* don't exclude Object.class */), new ResourcesScanner())
                .setUrls(ClasspathHelper.forClassLoader(classLoadersList.toArray(new ClassLoader[0])))
                .filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix("AVM"))));

        // Get the types
        Set<Class<? extends Object>> allClasses =
                reflections.getSubTypesOf(Object.class);

        // Add the types to the dictionary

        m_AVMTypes = new HashMap<String,Type>();
        for (Type t : allClasses)
        {
            String s_ClassName = t.toString();
            s_ClassName = s_ClassName.substring( 6 );
            m_AVMTypes.put(s_ClassName,t);
        }
    }
    @Override
    public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException
    {
        JsonElement je_type = json.getAsJsonObject().get("Type");
        String s_type = je_type.getAsString();

        GsonBuilder gb = new GsonBuilder();
        gb.setPrettyPrinting();
        gb.registerTypeAdapter(Object.class,this);
        Gson gson = gb.create();

        Object rtn = gson.fromJson(json,m_AVMTypes.get(s_type));
        return rtn;
    }
}

public class Component {
    public String AVMID;
    public List<String> Categories;
    public String Name;
    public List<Feature> Features;
    public String Type;

    public Component()
    {
        this.Type = "AVM.Component";
        this.Categories = new ArrayList<String>();
        this.Features = new ArrayList<Feature>();
    }
    public static Component Deserialize(String json)
    {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(AVM.Feature.class,new AVMComponentDeserializer());
        Gson gson = gb.create();
        return gson.fromJson(json,AVM.Component.class);
    }
}
