import java.io.*;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;

import AVM.META.Design.*;
import AVM.iFAB.IJoin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import AVM.META.NamedValue;
import ISIS.JSONFormatter;
import ISIS.JSONDeserializeHelper;

/**
 * Created with IntelliJ IDEA.
 * User: adam
 * Date: 9/26/12
 * Time: 6:02 PM
 * To change this template use File | Settings | File Templates.
 */

public class AdamMain {

    public static void main(String [ ] args)
    {
    	AVM.META.NamedValue namedValue = new NamedValue();
    	namedValue.set_DistributionType( AVM.DistributionTypeEnum.Exponential );
    	namedValue.set_Name( "foobar" );
    	namedValue.set_id( "12345" );
    	
        String myJSON = JSONFormatter.format( namedValue.serialize() );
        System.out.println( myJSON );

        JSONParser newJSONParser = new JSONParser();
        JSONObject newJSONObject = null;
        try {
            newJSONObject = (JSONObject)(  newJSONParser.parse( myJSON )  );
        } catch( Exception e ) {
            e.printStackTrace();
            System.exit( 1 );
        }

        Object object = JSONDeserializeHelper.deserialize( newJSONObject );
        
        if ( object instanceof AVM.META.NamedValue ) {
            AVM.META.NamedValue newNamedValue = (AVM.META.NamedValue)object;

            newNamedValue.deserialize( newJSONObject );
            System.out.println( "DistributionType = " + newNamedValue.get_DistributionType() );        	
        } else {
        	System.out.println(  "Unexpected object of type \"" + object.getClass().getPackage() + "." + object.getClass().getName() + "\" encountered." );
        }
        
    	
        String p_JSONFileToLoad = "MassSpringDamper_WithJoins.metadesign.json";

        String json = new String();
        try {
            FileInputStream stream = new FileInputStream(new File(p_JSONFileToLoad));
            try {
                FileChannel fc = stream.getChannel();
                MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0, fc.size());
                /* Instead of using default, pass in a decoder. */
                json = Charset.defaultCharset().decode(bb).toString();
            }
            finally {
                stream.close();
            }
        } catch (IOException ex) {
        }

        JSONParser jsonParser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)(  jsonParser.parse( json )  );
        } catch( Exception e ) {
            e.printStackTrace();
            System.exit( 1 );
        }
        
        object = ISIS.JSONDeserializeHelper.deserialize( jsonObject );
        
        if ( !( object instanceof AVM.META.Design.DesignModel )  ) {
        	System.out.println(  "Unexpected object of type \"" + object.getClass().getPackage() + "." + object.getClass().getName() + "\" encountered." );
        } else {
	        DesignModel dm = (DesignModel)object;
	
	        ArrayList<IContainer> containers = dm.get_Containers();
	        for (IContainer container : containers) {
	            StringBuilder sb = new StringBuilder();
	            sb.append( String.format("%1s has children:", container.get_Name()) );
	
	            for (IContainer nestedContainer : container.get_Containers()) {
	                sb.append( String.format(" %1s (Container),",nestedContainer.get_Name()));
	            }
	            for (IComponentInstance componentInstance : container.get_ComponentInstances()) {
	                sb.append( String.format(" %1s (ComponentInstance),",componentInstance.get_Name()));
	            }
	
	            System.out.println(sb);
	        };
	
	        ArrayList<IConnector> connectors = dm.get_Connectors();
	        for (IConnector connector : connectors)
	        {
	            // StructuralInterfaceConnectors will have join data
	            if (connector instanceof StructuralInterfaceConnector)
	            {
	                StringBuilder sb = new StringBuilder();
	                StructuralInterfaceConnector sic = StructuralInterfaceConnector.class.cast(connector);
	
	                sb.append( "StructuralInterfaceConnector has endpoints [" );
	                ArrayList<IAbstractStructuralInterface> endpoints = sic.get_EndPoints();
	                for (IAbstractStructuralInterface endpoint : endpoints) {
	                    sb.append(endpoint.get_id());
	                    sb.append("  ");
	                }
	                sb.append( "] with join data:" );
	
	                for (IJoin join : sic.get_Joins())
	                {
	                    sb.append(join.get_Data());
	                }
	                System.out.println(sb);
	            }
	        }
        }

//        int wait=2;
        /*Component component = new Component();
        component.set_Name( "Name" );
        component.set_AVMID( "ID22" );

        NamedValue namedValue = new NamedValue();
        namedValue.set_Value( "5" );
        namedValue.set_Name( "NV1" );
        namedValue.set_id( "ID2" );
        component.get_Features().add( namedValue );

        NamedValue namedValue2 = new NamedValue();
        namedValue2.set_Value( "6" );
        namedValue2.set_Name( "NV2" );
        namedValue2.set_id( "ID7" );
        component.get_Features().add( namedValue2 );
        
        Association association = new Association();
        association.set_SrcAssociable( namedValue );
        association.set_DstAssociable( namedValue2 );
        component.get_Associations().add( association );
        
        String json = JSONFormatter.format( component.serialize() );
        System.out.println( json );

        JSONParser jsonParser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)(  jsonParser.parse( json )  );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 1 );
        }
        
        Component component2 = new Component();
        component2.deserialize( jsonObject );
        json = JSONFormatter.format( component2.serialize() );
        System.out.println( json );   
        
        FileReader fileReader = null;
        try {
        	fileReader = new FileReader(  new File( "C:/Projects/Debug/Adam/RC_Car/RC_Car.metadesign.json" )  );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 2 );
        }
        
        DesignModel designModel = new DesignModel();
        try {
            jsonObject = (JSONObject)jsonParser.parse( fileReader );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 1 );
        }
        
        designModel.deserialize( jsonObject );
        json = JSONFormatter.format( designModel.serialize() );
        System.out.println( json );      */
    }
}
