package ISIS;

import org.json.simple.JSONObject;

public class JSONDeserializeHelper {
	public static Object deserialize( JSONObject jsonObject ) {

        String objectType = (String)(  jsonObject.get( "$type" )  );

        if ( objectType == null ) {
            System.err.println( "ERROR:  JSONDeserializeHelper:  No \"$type\" for JSON object.  Cannot create object without knowing its type." );
            return null;
        }
        Class< ? > avmClass = null;
        try {
            avmClass = Class.forName( objectType );
        } catch( Exception e ) {
            System.err.println( "ERROR:  JSONDeserializeHelper:  Class \"" + objectType + "\" not found" );
            return null;
        }
        if (  java.lang.reflect.Modifier.isAbstract( avmClass.getModifiers() )  ) {
            System.err.println( "ERROR:  JSONDeserializeHelper:  Cannot create instance of \"" + objectType + "\" class:  class is abstract." );
            return null;
        }
        Class< ? > parameterClasses[] = { org.json.simple.JSONObject.class };
        Object args[] = { jsonObject };
        Object object = null;
        try {
            object = avmClass.getMethod( "deserialize", parameterClasses ).invoke( avmClass.newInstance(), args );
        } catch ( Exception e ) {
            System.err.println( "ERROR:  JSONDeserializeHelper:  Cannot call \"deserialize\" method for \"" + objectType + "\" class." );
            return null;
        }

        return object;
	}
	
}
