package ISIS;

import java.net.URL;
import java.util.LinkedList;
import java.util.TreeSet;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;


public class JSONFormatter {
	
    private static STGroup _jsonFormatTemplateGroup;
    
    static {
    	URL jsonPrettyPrintURL = JSONFormatter.class.getResource( "JSONPrettyPrint.stg" );
    	_jsonFormatTemplateGroup = new STGroupFile( jsonPrettyPrintURL.getPath() );
    }

	private static abstract class JSONTemplate {
		public abstract boolean getIsJSONObject();
		public abstract boolean getIsJSONArray();
		
		public static JSONTemplate getJSONTemplate( Object object ) {
			if ( object.getClass() == JSONObject.class ) return new JSONObjectTemplate( (JSONObject)object );
			if ( object.getClass() == JSONArray.class ) return new JSONArrayTemplate( (JSONArray)object );
			return new JSONValueTemplate( object );
		}
	}
	
	private static class JSONValueTemplate extends JSONTemplate {

		private ST _value = new ST( "<value>" );
		
		public JSONValueTemplate( Object object ) {
			String value = object.toString();
			if ( object instanceof String ) value = "\"" + value + "\"";
			_value.add( "value", value );
		}

		@SuppressWarnings("unused")
		public Object getValue() { return _value.getAttribute( "value" ); }
	
		public boolean getIsJSONObject() { return false; }
		public boolean getIsJSONArray() { return false; }
	}
	
	private static class JSONArrayTemplate extends JSONTemplate {
		private ST _values = new ST( "<value>" );
		
		public JSONArrayTemplate( JSONArray jsonArray ) {
			for( Object object : jsonArray ) _values.add(  "value", JSONTemplate.getJSONTemplate( object )  );
		}
		
		@SuppressWarnings("unused")
		public Object getValues() { return _values.getAttribute( "value" ); }

		public boolean getIsJSONObject() { return false; }
		public boolean getIsJSONArray() { return true; }
	}
	
	private static class Pair {
		private String _name;
		private JSONTemplate _value;
		
		public Pair( String name, JSONTemplate value ) {
			_name = name;
			_value = value;
		}
		
		@SuppressWarnings("unused")
		public String getName() { return _name; }
		@SuppressWarnings("unused")
		public Object getValue() { return _value; }
	}
	
	private static class JSONObjectTemplate extends JSONTemplate {
				
		private ST _pairs = new ST( "<pair>" );
		
		public JSONObjectTemplate( JSONObject jsonObject ) {

			LinkedList< Pair > pairList = new LinkedList< Pair >();
			LinkedList< Pair > refPairList = new LinkedList< Pair >();
			
			@SuppressWarnings("unchecked")
			TreeSet< String > sortedKeySet = new TreeSet< String >( jsonObject.keySet() );

			for( Object key : sortedKeySet ) {
				Object object = jsonObject.get( key );
				Pair pair = new Pair(  (String)key, JSONTemplate.getJSONTemplate( object )  );
				if (  "$type".equals( key )  ) _pairs.add( "pair", pair );
				else if (  JSONReferenceCheck.hasRef( object )  ) refPairList.addLast( pair );
				else                                              pairList.addLast( pair );
			}
			
			for( Pair pair : pairList ) _pairs.add( "pair", pair );
			for( Pair pair : refPairList ) _pairs.add( "pair", pair );
		}
		
		@SuppressWarnings("unused")
		public Object getPairs() { return _pairs.getAttribute( "pair" ); }
		
		public boolean getIsJSONObject() { return true; }
		public boolean getIsJSONArray() { return false; }

	}
	
	public static String format( Object object ) {
        ST jsonFormatTemplate = _jsonFormatTemplateGroup.getInstanceOf( "jsonValue" );
        jsonFormatTemplate.add(  "object", JSONTemplate.getJSONTemplate( object )  );
        return jsonFormatTemplate.render();
	}

}
