package ISIS;

import java.util.HashMap;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONReferenceCheck {
	
	private static HashMap< Object, Boolean > _jsonEntityHasRefMap = new HashMap< Object, Boolean >();
	
	public static boolean hasRef( Object object ) {
		if ( object instanceof JSONObject ) return hasRef( (JSONObject)object );
		if ( object instanceof JSONArray )  return hasRef( (JSONArray)object );
		return false;
	}
	public static boolean hasRef( JSONObject jsonObject ) {
		_jsonEntityHasRefMap.clear();
		return hasRefAux( jsonObject );
	}
	public static boolean hasRef( JSONArray jsonArray ) {
		_jsonEntityHasRefMap.clear();
		return hasRefAux( jsonArray );
	}
		
	private static boolean hasRefAux( JSONObject jsonObject ) {
		if (  _jsonEntityHasRefMap.containsKey( jsonObject )  ) return _jsonEntityHasRefMap.get( jsonObject );
		
		if ( jsonObject.containsKey( "$ref" )  ) return true;
		
		for( Object value : jsonObject.values() ) {
			if (  value instanceof JSONObject && hasRefAux( (JSONObject)value ) || value instanceof JSONArray && hasRefAux( (JSONArray)value )  ) {
				_jsonEntityHasRefMap.put( jsonObject, true );
				return true;
			}
		}
			
		_jsonEntityHasRefMap.put( jsonObject, false );
		return false;
	}

	private static boolean hasRefAux( JSONArray jsonArray ) {
		if (  _jsonEntityHasRefMap.containsKey( jsonArray )  ) return _jsonEntityHasRefMap.get( jsonArray );
		
		for( Object value : jsonArray ) {
			if (  value instanceof JSONObject && hasRefAux( (JSONObject)value ) || value instanceof JSONArray && hasRefAux( (JSONArray)value )  ) {
				_jsonEntityHasRefMap.put( jsonArray, true );
				return true;
			}
		}

		_jsonEntityHasRefMap.put( jsonArray, false );
		return false;
	}

}
