import java.io.File;
import java.io.FileReader;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

import AVM.Association;
import AVM.Component;
import AVM.META.NamedValue;
import AVM.META.Design.DesignModel;
import ISIS.JSONFormatter;

/**
 * Created with IntelliJ IDEA.
 * User: adam
 * Date: 9/26/12
 * Time: 6:02 PM
 * To change this template use File | Settings | File Templates.
 */

public class Main {

    public static void main(String [ ] args)
    {
        Component component = new Component();
        component.set_Name( "Name" );
        component.set_AVMID( "ID22" );

        NamedValue namedValue = new NamedValue();
        namedValue.set_Value( "5" );
        namedValue.set_Name( "NV1" );
        namedValue.set_id( "ID2" );
        component.get_Features().add( namedValue );

        NamedValue namedValue2 = new NamedValue();
        namedValue2.set_Value( "6" );
        namedValue2.set_Name( "NV2" );
        namedValue2.set_id( "ID7" );
        component.get_Features().add( namedValue2 );
        
        Association association = new Association();
        association.set_SrcAssociable( namedValue );
        association.set_DstAssociable( namedValue2 );
        component.get_Associations().add( association );
        
        String json = JSONFormatter.format( component.serialize() );
        System.out.println( json );

        JSONParser jsonParser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)(  jsonParser.parse( json )  );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 1 );
        }
        
        Component component2 = new Component();
        component2.deserialize( jsonObject );
        json = JSONFormatter.format( component2.serialize() );
        System.out.println( json );   
        
        FileReader fileReader = null;
        try {
        	fileReader = new FileReader(  new File( "C:/Projects/Debug/Adam/RC_Car/RC_Car.metadesign.json" )  );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 2 );
        }
        
        DesignModel designModel = new DesignModel();
        try {
            jsonObject = (JSONObject)jsonParser.parse( fileReader );
        } catch( Exception e ) {
        	e.printStackTrace();
        	System.exit( 1 );
        }
        
        designModel.deserialize( jsonObject );
        json = JSONFormatter.format( designModel.serialize() );
        System.out.println( json );   
    }
}
