

class DistributionTypeEnum:
    _Normal_ = "Normal"
    _Exponential_ = "Exponential"
    _Gamma_ = "Gamma"
    _LogNormal_ = "LogNormal"
    _Triangular_ = "Triangular"
    _Uniform_ = "Uniform"
    _Beta_ = "Beta"
    _Poisson_ = "Poisson"




class CausalityEnum:
    _Input_ = "Input"
    _Output_ = "Output"
    _Both_ = "Both"
    _None_ = "None"




class OrientationEnum:
    _SideA_ = "SideA"
    _SideB_ = "SideB"




class AlignmentEnum:
    _Align_ = "Align"
    _Mate_ = "Mate"




class DatumTypeEnum:
    _Point_ = "Point"
    _Axis_ = "Axis"
    _Surface_ = "Surface"
    _CoordinateSystem_ = "CoordinateSystem"




class StructuralInterfaceStyle:
    _Positional_ = "Positional"
    _PhysicalJoin_ = "PhysicalJoin"




class DataTypeEnum:
    _Integer_ = "Integer"
    _Float_ = "Float"
    _Boolean_ = "Boolean"
    _String_ = "String"


import ISIS

class Associable:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        self._id = ""


    def get_id(self):
        return self._id


    def set_id(self,id):
        self._id = id


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.Associable\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Associable\":  " + str( e )

        return self


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self




class Association:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._DstAssociable = None
        self._Note = ""
        self._SrcAssociable = None


    def get_Note(self):
        return self._Note


    def set_DstAssociable(self,DstAssociable):
        self._DstAssociable = DstAssociable


    def set_Note(self,Note):
        self._Note = Note


    def set_SrcAssociable(self,SrcAssociable):
        self._SrcAssociable = SrcAssociable


    def get_DstAssociable(self):
        return self._DstAssociable


    def get_SrcAssociable(self):
        return self._SrcAssociable


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Note":
                    self.deserialize_Note( jsonObject[ "Note" ] )
                elif memberName == "DstAssociable":
                    self.deserialize_DstAssociable( jsonObject[ "DstAssociable" ] )
                elif memberName == "SrcAssociable":
                    self.deserialize_SrcAssociable( jsonObject[ "SrcAssociable" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.Association\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Association\":  " + str( e )

        return self


    def deserialize_Note( self, object ):
        self.set_Note( object )


    def deserialize_DstAssociable( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_DstAssociable )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.Associable\" instance.  Cannot create instance directly from \"AVM.Associable\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM", globals(), locals(), [ "Associable" ] )
            baseAVMClass = getattr( baseModule, "Associable" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.Associable\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.Associable\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_DstAssociable(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return


    def deserialize_SrcAssociable( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_SrcAssociable )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.Associable\" instance.  Cannot create instance directly from \"AVM.Associable\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM", globals(), locals(), [ "Associable" ] )
            baseAVMClass = getattr( baseModule, "Associable" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.Associable\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.Associable\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_SrcAssociable(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class Component:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Associations = []
        self._AVMID = ""
        self._Category = []
        self._DDPSpecVersion = ""
        self._Description = ""
        self._Features = []
        self._Files = []
        self._Name = ""
        self._Revision = ""
        self._Supercedes = []
        self._Version = ""


    def get_AVMID(self):
        return self._AVMID


    def get_Category(self):
        return self._Category


    def get_DDPSpecVersion(self):
        return self._DDPSpecVersion


    def get_Description(self):
        return self._Description


    def get_Name(self):
        return self._Name


    def get_Revision(self):
        return self._Revision


    def get_Version(self):
        return self._Version


    def set_AVMID(self,AVMID):
        self._AVMID = AVMID


    def set_DDPSpecVersion(self,DDPSpecVersion):
        self._DDPSpecVersion = DDPSpecVersion


    def set_Description(self,Description):
        self._Description = Description


    def set_Name(self,Name):
        self._Name = Name


    def set_Revision(self,Revision):
        self._Revision = Revision


    def set_Version(self,Version):
        self._Version = Version


    def get_Associations(self):
        return self._Associations


    def get_Features(self):
        return self._Features


    def get_Files(self):
        return self._Files


    def get_Supercedes(self):
        return self._Supercedes


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "AVMID":
                    self.deserialize_AVMID( jsonObject[ "AVMID" ] )
                elif memberName == "Category":
                    self.deserialize_Category( jsonObject[ "Category" ] )
                elif memberName == "DDPSpecVersion":
                    self.deserialize_DDPSpecVersion( jsonObject[ "DDPSpecVersion" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Revision":
                    self.deserialize_Revision( jsonObject[ "Revision" ] )
                elif memberName == "Version":
                    self.deserialize_Version( jsonObject[ "Version" ] )
                elif memberName == "Associations":
                    self.deserialize_Associations( jsonObject[ "Associations" ] )
                elif memberName == "Features":
                    self.deserialize_Features( jsonObject[ "Features" ] )
                elif memberName == "Files":
                    self.deserialize_Files( jsonObject[ "Files" ] )
                elif memberName == "Supercedes":
                    self.deserialize_Supercedes( jsonObject[ "Supercedes" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.Component\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Component\":  " + str( e )

        return self


    def deserialize_AVMID( self, object ):
        self.set_AVMID( object )


    def deserialize_Category( self, object ):
        del self.get_Category()[:]
        for arrayObject in object:
            self.get_Category().append( arrayObject )

    def deserialize_DDPSpecVersion( self, object ):
        self.set_DDPSpecVersion( object )


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Revision( self, object ):
        self.set_Revision( object )


    def deserialize_Version( self, object ):
        self.set_Version( object )


    def deserialize_Associations( self, object ):
        del self.get_Associations()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Associations(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.Association\" object.  Creating instance directly from \"AVM.Association\" class."
                objectType = "AVM.Association"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "Association" ] )
                baseAVMClass = getattr( baseModule, "Association" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.Association\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.Association\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Associations().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Features( self, object ):
        del self.get_Features()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Features(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.Feature\" instance.  Cannot create instance directly from \"AVM.Feature\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "Feature" ] )
                baseAVMClass = getattr( baseModule, "Feature" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.Feature\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.Feature\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Features().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Files( self, object ):
        del self.get_Files()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Files(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.File\" object.  Creating instance directly from \"AVM.File\" class."
                objectType = "AVM.File"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "File" ] )
                baseAVMClass = getattr( baseModule, "File" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.File\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.File\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Files().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Supercedes( self, object ):
        del self.get_Supercedes()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Supercedes(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.Supercede\" object.  Creating instance directly from \"AVM.Supercede\" class."
                objectType = "AVM.Supercede"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "Supercede" ] )
                baseAVMClass = getattr( baseModule, "Supercede" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.Supercede\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.Supercede\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Supercedes().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class File:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Description = ""
        self._Hash = ""
        self._Location = ""


    def get_Description(self):
        return self._Description


    def get_Hash(self):
        return self._Hash


    def get_Location(self):
        return self._Location


    def set_Description(self,Description):
        self._Description = Description


    def set_Hash(self,Hash):
        self._Hash = Hash


    def set_Location(self,Location):
        self._Location = Location


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Hash":
                    self.deserialize_Hash( jsonObject[ "Hash" ] )
                elif memberName == "Location":
                    self.deserialize_Location( jsonObject[ "Location" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.File\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.File\":  " + str( e )

        return self


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Hash( self, object ):
        self.set_Hash( object )


    def deserialize_Location( self, object ):
        self.set_Location( object )





class Supercede:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._AVMID = ""
        self._Reason = ""


    def get_AVMID(self):
        return self._AVMID


    def get_Reason(self):
        return self._Reason


    def set_AVMID(self,AVMID):
        self._AVMID = AVMID


    def set_Reason(self,Reason):
        self._Reason = Reason


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "AVMID":
                    self.deserialize_AVMID( jsonObject[ "AVMID" ] )
                elif memberName == "Reason":
                    self.deserialize_Reason( jsonObject[ "Reason" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.Supercede\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Supercede\":  " + str( e )

        return self


    def deserialize_AVMID( self, object ):
        self.set_AVMID( object )


    def deserialize_Reason( self, object ):
        self.set_Reason( object )





class Feature(Associable):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        Associable.__init__(self)
        self._Type = ""


    def get_Type(self):
        return self._Type


    def set_Type(self,Type):
        self._Type = Type


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.Feature\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Feature\":  " + str( e )

        return self


    def deserialize_Type( self, object ):
        self.set_Type( object )





class StructuralInterfaceDatum(Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Associable.__init__(self)
        self._Alignment = None
        self._DatumType = None
        self._Name = ""


    def get_Alignment(self):
        return self._Alignment


    def get_DatumType(self):
        return self._DatumType


    def get_Name(self):
        return self._Name


    def set_Alignment(self,Alignment):
        self._Alignment = Alignment


    def set_DatumType(self,DatumType):
        self._DatumType = DatumType


    def set_Name(self,Name):
        self._Name = Name


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Alignment":
                    self.deserialize_Alignment( jsonObject[ "Alignment" ] )
                elif memberName == "DatumType":
                    self.deserialize_DatumType( jsonObject[ "DatumType" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.StructuralInterfaceDatum\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.StructuralInterfaceDatum\":  " + str( e )

        return self


    def deserialize_Alignment( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "AlignmentEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "AlignmentEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.AlignmentEnum\":  " + str( e )
            return

        self.set_Alignment(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_DatumType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "DatumTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DatumTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.DatumTypeEnum\":  " + str( e )
            return

        self.set_DatumType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Name( self, object ):
        self.set_Name( object )





class Base(Feature):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        Feature.__init__(self)
        self._Description = ""
        self._Name = ""


    def get_Description(self):
        return self._Description


    def get_Name(self):
        return self._Name


    def set_Description(self,Description):
        self._Description = Description


    def set_Name(self,Name):
        self._Name = Name


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.Base\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Base\":  " + str( e )

        return self


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )





class UsesLibrary(Feature):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Feature.__init__(self)
        self._Description = ""
        self._Hash = ""
        self._Name = ""
        self._Path = ""
        self._Revision = 0
        self._Version = ""


    def get_Description(self):
        return self._Description


    def get_Hash(self):
        return self._Hash


    def get_Name(self):
        return self._Name


    def get_Path(self):
        return self._Path


    def get_Revision(self):
        return self._Revision


    def get_Version(self):
        return self._Version


    def set_Description(self,Description):
        self._Description = Description


    def set_Hash(self,Hash):
        self._Hash = Hash


    def set_Name(self,Name):
        self._Name = Name


    def set_Path(self,Path):
        self._Path = Path


    def set_Revision(self,Revision):
        self._Revision = Revision


    def set_Version(self,Version):
        self._Version = Version


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Hash":
                    self.deserialize_Hash( jsonObject[ "Hash" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Path":
                    self.deserialize_Path( jsonObject[ "Path" ] )
                elif memberName == "Revision":
                    self.deserialize_Revision( jsonObject[ "Revision" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Version":
                    self.deserialize_Version( jsonObject[ "Version" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.UsesLibrary\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.UsesLibrary\":  " + str( e )

        return self


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Hash( self, object ):
        self.set_Hash( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Path( self, object ):
        self.set_Path( object )


    def deserialize_Revision( self, object ):
        self.set_Revision( object )


    def deserialize_Version( self, object ):
        self.set_Version( object )





class ExternalPort(Base):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        Base.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.ExternalPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.ExternalPort\":  " + str( e )

        return self





class Model(Base):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        Base.__init__(self)
        self._Author = ""
        self._AuthorOrganization = ""
        self._FileFormat = ""
        self._LanguageVersion = ""
        self._Location = ""
        self._ModelingTool = ""
        self._ToolVersion = ""


    def get_Author(self):
        return self._Author


    def get_AuthorOrganization(self):
        return self._AuthorOrganization


    def get_FileFormat(self):
        return self._FileFormat


    def get_LanguageVersion(self):
        return self._LanguageVersion


    def get_Location(self):
        return self._Location


    def get_ModelingTool(self):
        return self._ModelingTool


    def get_ToolVersion(self):
        return self._ToolVersion


    def set_Author(self,Author):
        self._Author = Author


    def set_AuthorOrganization(self,AuthorOrganization):
        self._AuthorOrganization = AuthorOrganization


    def set_FileFormat(self,FileFormat):
        self._FileFormat = FileFormat


    def set_LanguageVersion(self,LanguageVersion):
        self._LanguageVersion = LanguageVersion


    def set_Location(self,Location):
        self._Location = Location


    def set_ModelingTool(self,ModelingTool):
        self._ModelingTool = ModelingTool


    def set_ToolVersion(self,ToolVersion):
        self._ToolVersion = ToolVersion


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Author":
                    self.deserialize_Author( jsonObject[ "Author" ] )
                elif memberName == "AuthorOrganization":
                    self.deserialize_AuthorOrganization( jsonObject[ "AuthorOrganization" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "FileFormat":
                    self.deserialize_FileFormat( jsonObject[ "FileFormat" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "LanguageVersion":
                    self.deserialize_LanguageVersion( jsonObject[ "LanguageVersion" ] )
                elif memberName == "Location":
                    self.deserialize_Location( jsonObject[ "Location" ] )
                elif memberName == "ModelingTool":
                    self.deserialize_ModelingTool( jsonObject[ "ModelingTool" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ToolVersion":
                    self.deserialize_ToolVersion( jsonObject[ "ToolVersion" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.Model\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.Model\":  " + str( e )

        return self


    def deserialize_Author( self, object ):
        self.set_Author( object )


    def deserialize_AuthorOrganization( self, object ):
        self.set_AuthorOrganization( object )


    def deserialize_FileFormat( self, object ):
        self.set_FileFormat( object )


    def deserialize_LanguageVersion( self, object ):
        self.set_LanguageVersion( object )


    def deserialize_Location( self, object ):
        self.set_Location( object )


    def deserialize_ModelingTool( self, object ):
        self.set_ModelingTool( object )


    def deserialize_ToolVersion( self, object ):
        self.set_ToolVersion( object )





class StructuralInterface(ExternalPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ExternalPort.__init__(self)
        self._Datums = []
        self._DefaultJoins = []
        self._Definition = ""
        self._Role = ""
        self._Style = None


    def get_Definition(self):
        return self._Definition


    def get_Role(self):
        return self._Role


    def get_Style(self):
        return self._Style


    def set_Definition(self,Definition):
        self._Definition = Definition


    def set_Role(self,Role):
        self._Role = Role


    def set_Style(self,Style):
        self._Style = Style


    def get_Datums(self):
        return self._Datums


    def get_DefaultJoins(self):
        return self._DefaultJoins


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Definition":
                    self.deserialize_Definition( jsonObject[ "Definition" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Role":
                    self.deserialize_Role( jsonObject[ "Role" ] )
                elif memberName == "Style":
                    self.deserialize_Style( jsonObject[ "Style" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Datums":
                    self.deserialize_Datums( jsonObject[ "Datums" ] )
                elif memberName == "DefaultJoins":
                    self.deserialize_DefaultJoins( jsonObject[ "DefaultJoins" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.StructuralInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.StructuralInterface\":  " + str( e )

        return self


    def deserialize_Definition( self, object ):
        self.set_Definition( object )


    def deserialize_Role( self, object ):
        self.set_Role( object )


    def deserialize_Style( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "StructuralInterfaceStyle" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "StructuralInterfaceStyle" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.StructuralInterfaceStyle\":  " + str( e )
            return

        self.set_Style(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Datums( self, object ):
        del self.get_Datums()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Datums(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.StructuralInterfaceDatum\" object.  Creating instance directly from \"AVM.StructuralInterfaceDatum\" class."
                objectType = "AVM.StructuralInterfaceDatum"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "StructuralInterfaceDatum" ] )
                baseAVMClass = getattr( baseModule, "StructuralInterfaceDatum" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.StructuralInterfaceDatum\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.StructuralInterfaceDatum\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Datums().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_DefaultJoins( self, object ):
        del self.get_DefaultJoins()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_DefaultJoins(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.iFAB.Join\" object.  Creating instance directly from \"AVM.iFAB.Join\" class."
                objectType = "AVM.iFAB.Join"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.iFAB", globals(), locals(), [ "Join" ] )
                baseAVMClass = getattr( baseModule, "Join" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.iFAB.Join\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.iFAB.Join\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_DefaultJoins().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue




