import json

class JSONSerializeHelper:

    _serializedObjectSet = set()
    
    @staticmethod
    def findRefs( object ):

        if not hasattr( object, "__module__" ) or object.__module__[0:3] != "AVM" or not hasattr( object, "_hasRef" ) or object._hasRef != None:
            return False

        object._hasRef = False
        for memberName in object.keys():
            value = object[ memberName ]
            if value.__class__ == list:
                for item in value:
                    if findRefs( item ):
                        object._hasRef == True
            else:
                if object.__module__[0:3] == "AVM" or findRefs( value ):
                    object._hasRef = True

        return object._hasRef

    @staticmethod
    def hasRef( object ):
        if object.__class__ == list:
            for item in object:
                if JSONSerializeHelper.hasRef( item ):
                    return True
            return False
        
        return hasattr( object, "_hasRef" ) and object._hasRef

    @staticmethod
    def serialize( object ):
        JSONSerializeHelper._serializedObjectSet.clear()
        JSONSerializeHelper.findRefs( object )
        return JSONSerializeHelper.serializeAux( object )

    @staticmethod
    def serializeAux( object ):
        jsonObject = {}

        if object in JSONSerializeHelper._serializedObjectSet:
            jsonObject["$ref"] = object.get_id()
            return jsonObject
        elif hasattr( object, "get_id" ):
            JSONSerializeHelper._serializedObjectSet.add( object )
            
        jsonObject["$type"] = object.__module__ + "." + object.__class__.__name__

        methods = []
        for attribute in dir( object ):
           if attribute[0:4] == "get_":
               member = getattr( object.__class__, attribute )
               if callable( member ):
                   methods.append( member )

        ordered_methods = []
        for method in methods:
            member = method( object )
            if JSONSerializeHelper.hasRef( member ):
                ordered_methods.append( method )
            else:
                ordered_methods.insert( 0, method )

        for method in ordered_methods:

            member = method( object )
            memberName = method.__name__[4:]
            if member.__class__ == list:

                ordered_list = []
                for datum in member:
                    if JSONSerializeHelper.hasRef( datum ):
                        ordered_list.append( datum )
                    else:
                        ordered_list.insert( 0, datum )

                jsonArray = []
                for datum in ordered_list:
                    if hasattr( datum, "__module__" ) and datum.__module__[0:3] == "AVM":
                        jsonArray.append(  JSONSerializeHelper.serializeAux( datum )  )
                    else:
                        jsonArray.append( datum )

                if len( jsonArray ) != 0:
                    jsonObject[ memberName ] = jsonArray

            else:

                if hasattr( member, "__module__" ) and member.__module__[0:3] == "AVM":
                    jsonObject[ memberName ] = JSONSerializeHelper.serializeAux( member )
                elif member != None and member != "":
                    jsonObject[ memberName ] = member

        return jsonObject
    
    @staticmethod
    def JSONPrettyPrinted( jsonObject ):
        return json.dumps(  jsonObject, sort_keys=True, indent=4, separators=( ',', ':' )  )

class JSONDeserializeHelper:

    _referencedObjectMap = {}
    _idRefMethodMap = {}
    
    @staticmethod
    def resolveRefs():        
        for id in JSONDeserializeHelper._idRefMethodMap.keys():
            if id in JSONDeserializeHelper._referencedObjectMap:
                for tuple in JSONDeserializeHelper._idRefMethodMap[ id ]:
                    tuple[1]( tuple[0], JSONDeserializeHelper._referencedObjectMap[ id ] )
            else:
                print "WARNING:  JSONDeserializeHelper:  No object with id \"" + id + "\" found."
    
    @staticmethod
    def deserialize( jsonObject ):

        if "$type" in jsonObject:
            objectType = jsonObject[ "$type" ]
        else:
            print "ERROR:  JSONDeserializeHelper:  No \"$type\" for JSON object.  Cannot create object without knowing its type."
            return None

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname )

        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  JSONDeserializeHelper:  Unable to load class \"" + objectType + "\":  " + str( e )
            return None

        if avmClass._isAbstract:
            print "ERROR:  JSONDeserializeHelper:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return None

        avmClassObject = avmClass()
        avmClassObject.__init__()

        object = None

        try:
            object = avmClassObject.deserialize( jsonObject ) 
        except Exception as e:
            print "ERROR:  JSONDeserializeHelper:  Unable to deserialize object of type \"" + objectType + "\" class: " + str( e )
            return None

        return object

