import ISIS
import AVM.META

class AbstractPort:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        self._id = ""
        self._PortConnector = []


    def get_id(self):
        return self._id


    def set_id(self,id):
        self._id = id


    def get_PortConnector(self):
        return self._PortConnector


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "PortConnector":
                    self.deserialize_PortConnector( jsonObject[ "PortConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.AbstractPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.AbstractPort\":  " + str( e )

        return self


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self

    def deserialize_PortConnector( self, object ):
        del self.get_PortConnector()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PortConnector(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.PortConnector\" object.  Creating instance directly from \"AVM.META.Design.PortConnector\" class."
                objectType = "AVM.META.Design.PortConnector"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "PortConnector" ] )
                baseAVMClass = getattr( baseModule, "PortConnector" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.PortConnector\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.PortConnector\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PortConnector().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class AbstractStructuralInterface:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        self._id = ""
        self._StructuralInterfaceConnector = []


    def get_id(self):
        return self._id


    def set_id(self,id):
        self._id = id


    def get_StructuralInterfaceConnector(self):
        return self._StructuralInterfaceConnector


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "StructuralInterfaceConnector":
                    self.deserialize_StructuralInterfaceConnector( jsonObject[ "StructuralInterfaceConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.AbstractStructuralInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.AbstractStructuralInterface\":  " + str( e )

        return self


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self

    def deserialize_StructuralInterfaceConnector( self, object ):
        del self.get_StructuralInterfaceConnector()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_StructuralInterfaceConnector(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.StructuralInterfaceConnector\" object.  Creating instance directly from \"AVM.META.Design.StructuralInterfaceConnector\" class."
                objectType = "AVM.META.Design.StructuralInterfaceConnector"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "StructuralInterfaceConnector" ] )
                baseAVMClass = getattr( baseModule, "StructuralInterfaceConnector" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.StructuralInterfaceConnector\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.StructuralInterfaceConnector\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_StructuralInterfaceConnector().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class ComponentInstance:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._ComponentID = ""
        self._ComponentRevision = ""
        self._ComponentVersion = ""
        self._Definition = ""
        self._id = ""
        self._Name = ""
        self._NamedValueInstances = []
        self._PortInstances = []
        self._SrcDesignSpaceContainerID = ""
        self._StructuralInterfaceInstances = []


    def get_ComponentID(self):
        return self._ComponentID


    def get_ComponentRevision(self):
        return self._ComponentRevision


    def get_ComponentVersion(self):
        return self._ComponentVersion


    def get_Definition(self):
        return self._Definition


    def get_id(self):
        return self._id


    def get_Name(self):
        return self._Name


    def get_SrcDesignSpaceContainerID(self):
        return self._SrcDesignSpaceContainerID


    def set_ComponentID(self,ComponentID):
        self._ComponentID = ComponentID


    def set_ComponentRevision(self,ComponentRevision):
        self._ComponentRevision = ComponentRevision


    def set_ComponentVersion(self,ComponentVersion):
        self._ComponentVersion = ComponentVersion


    def set_Definition(self,Definition):
        self._Definition = Definition


    def set_id(self,id):
        self._id = id


    def set_Name(self,Name):
        self._Name = Name


    def set_SrcDesignSpaceContainerID(self,SrcDesignSpaceContainerID):
        self._SrcDesignSpaceContainerID = SrcDesignSpaceContainerID


    def get_NamedValueInstances(self):
        return self._NamedValueInstances


    def get_PortInstances(self):
        return self._PortInstances


    def get_StructuralInterfaceInstances(self):
        return self._StructuralInterfaceInstances


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "ComponentID":
                    self.deserialize_ComponentID( jsonObject[ "ComponentID" ] )
                elif memberName == "ComponentRevision":
                    self.deserialize_ComponentRevision( jsonObject[ "ComponentRevision" ] )
                elif memberName == "ComponentVersion":
                    self.deserialize_ComponentVersion( jsonObject[ "ComponentVersion" ] )
                elif memberName == "Definition":
                    self.deserialize_Definition( jsonObject[ "Definition" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "SrcDesignSpaceContainerID":
                    self.deserialize_SrcDesignSpaceContainerID( jsonObject[ "SrcDesignSpaceContainerID" ] )
                elif memberName == "NamedValueInstances":
                    self.deserialize_NamedValueInstances( jsonObject[ "NamedValueInstances" ] )
                elif memberName == "PortInstances":
                    self.deserialize_PortInstances( jsonObject[ "PortInstances" ] )
                elif memberName == "StructuralInterfaceInstances":
                    self.deserialize_StructuralInterfaceInstances( jsonObject[ "StructuralInterfaceInstances" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ComponentInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ComponentInstance\":  " + str( e )

        return self


    def deserialize_ComponentID( self, object ):
        self.set_ComponentID( object )


    def deserialize_ComponentRevision( self, object ):
        self.set_ComponentRevision( object )


    def deserialize_ComponentVersion( self, object ):
        self.set_ComponentVersion( object )


    def deserialize_Definition( self, object ):
        self.set_Definition( object )


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self

    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_SrcDesignSpaceContainerID( self, object ):
        self.set_SrcDesignSpaceContainerID( object )


    def deserialize_NamedValueInstances( self, object ):
        del self.get_NamedValueInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_NamedValueInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.ComponentNamedValueInstance\" object.  Creating instance directly from \"AVM.META.Design.ComponentNamedValueInstance\" class."
                objectType = "AVM.META.Design.ComponentNamedValueInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ComponentNamedValueInstance" ] )
                baseAVMClass = getattr( baseModule, "ComponentNamedValueInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ComponentNamedValueInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ComponentNamedValueInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_NamedValueInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_PortInstances( self, object ):
        del self.get_PortInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PortInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.PortInstance\" object.  Creating instance directly from \"AVM.META.Design.PortInstance\" class."
                objectType = "AVM.META.Design.PortInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "PortInstance" ] )
                baseAVMClass = getattr( baseModule, "PortInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.PortInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.PortInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PortInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_StructuralInterfaceInstances( self, object ):
        del self.get_StructuralInterfaceInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_StructuralInterfaceInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.StructuralInterfaceInstance\" object.  Creating instance directly from \"AVM.META.Design.StructuralInterfaceInstance\" class."
                objectType = "AVM.META.Design.StructuralInterfaceInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "StructuralInterfaceInstance" ] )
                baseAVMClass = getattr( baseModule, "StructuralInterfaceInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.StructuralInterfaceInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.StructuralInterfaceInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_StructuralInterfaceInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class Connector:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        pass


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Connector\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Connector\":  " + str( e )

        return self





class ConstraintBase:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        pass


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ConstraintBase\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ConstraintBase\":  " + str( e )

        return self





class Container:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        self._ComponentInstances = []
        self._ContainerPorts = []
        self._Containers = []
        self._ContainerStructuralInterfaces = []
        self._ContainerValues = []
        self._id = ""
        self._Name = ""


    def get_id(self):
        return self._id


    def get_Name(self):
        return self._Name


    def set_id(self,id):
        self._id = id


    def set_Name(self,Name):
        self._Name = Name


    def get_ComponentInstances(self):
        return self._ComponentInstances


    def get_ContainerPorts(self):
        return self._ContainerPorts


    def get_Containers(self):
        return self._Containers


    def get_ContainerStructuralInterfaces(self):
        return self._ContainerStructuralInterfaces


    def get_ContainerValues(self):
        return self._ContainerValues


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ComponentInstances":
                    self.deserialize_ComponentInstances( jsonObject[ "ComponentInstances" ] )
                elif memberName == "ContainerPorts":
                    self.deserialize_ContainerPorts( jsonObject[ "ContainerPorts" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "ContainerStructuralInterfaces":
                    self.deserialize_ContainerStructuralInterfaces( jsonObject[ "ContainerStructuralInterfaces" ] )
                elif memberName == "ContainerValues":
                    self.deserialize_ContainerValues( jsonObject[ "ContainerValues" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Container\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Container\":  " + str( e )

        return self


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self

    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_ComponentInstances( self, object ):
        del self.get_ComponentInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_ComponentInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.ComponentInstance\" object.  Creating instance directly from \"AVM.META.Design.ComponentInstance\" class."
                objectType = "AVM.META.Design.ComponentInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ComponentInstance" ] )
                baseAVMClass = getattr( baseModule, "ComponentInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ComponentInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ComponentInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_ComponentInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_ContainerPorts( self, object ):
        del self.get_ContainerPorts()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_ContainerPorts(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.ContainerPort\" object.  Creating instance directly from \"AVM.META.Design.ContainerPort\" class."
                objectType = "AVM.META.Design.ContainerPort"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ContainerPort" ] )
                baseAVMClass = getattr( baseModule, "ContainerPort" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ContainerPort\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ContainerPort\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_ContainerPorts().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Containers( self, object ):
        del self.get_Containers()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Containers(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.Container\" instance.  Cannot create instance directly from \"AVM.META.Design.Container\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "Container" ] )
                baseAVMClass = getattr( baseModule, "Container" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.Container\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.Container\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Containers().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_ContainerStructuralInterfaces( self, object ):
        del self.get_ContainerStructuralInterfaces()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_ContainerStructuralInterfaces(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.ContainerStructuralInterface\" object.  Creating instance directly from \"AVM.META.Design.ContainerStructuralInterface\" class."
                objectType = "AVM.META.Design.ContainerStructuralInterface"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ContainerStructuralInterface" ] )
                baseAVMClass = getattr( baseModule, "ContainerStructuralInterface" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ContainerStructuralInterface\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ContainerStructuralInterface\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_ContainerStructuralInterfaces().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_ContainerValues( self, object ):
        del self.get_ContainerValues()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_ContainerValues(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.ContainerValue\" instance.  Cannot create instance directly from \"AVM.META.Design.ContainerValue\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ContainerValue" ] )
                baseAVMClass = getattr( baseModule, "ContainerValue" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ContainerValue\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ContainerValue\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_ContainerValues().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class DesignModel:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Connectors = []
        self._Containers = []
        self._DDPSpecVersion = ""
        self._DesignID = ""
        self._Name = ""
        self._SrcDesignSpaceID = ""


    def get_DDPSpecVersion(self):
        return self._DDPSpecVersion


    def get_DesignID(self):
        return self._DesignID


    def get_Name(self):
        return self._Name


    def get_SrcDesignSpaceID(self):
        return self._SrcDesignSpaceID


    def set_DDPSpecVersion(self,DDPSpecVersion):
        self._DDPSpecVersion = DDPSpecVersion


    def set_DesignID(self,DesignID):
        self._DesignID = DesignID


    def set_Name(self,Name):
        self._Name = Name


    def set_SrcDesignSpaceID(self,SrcDesignSpaceID):
        self._SrcDesignSpaceID = SrcDesignSpaceID


    def get_Connectors(self):
        return self._Connectors


    def get_Containers(self):
        return self._Containers


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DDPSpecVersion":
                    self.deserialize_DDPSpecVersion( jsonObject[ "DDPSpecVersion" ] )
                elif memberName == "DesignID":
                    self.deserialize_DesignID( jsonObject[ "DesignID" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "SrcDesignSpaceID":
                    self.deserialize_SrcDesignSpaceID( jsonObject[ "SrcDesignSpaceID" ] )
                elif memberName == "Connectors":
                    self.deserialize_Connectors( jsonObject[ "Connectors" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.DesignModel\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.DesignModel\":  " + str( e )

        return self


    def deserialize_DDPSpecVersion( self, object ):
        self.set_DDPSpecVersion( object )


    def deserialize_DesignID( self, object ):
        self.set_DesignID( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_SrcDesignSpaceID( self, object ):
        self.set_SrcDesignSpaceID( object )


    def deserialize_Connectors( self, object ):
        del self.get_Connectors()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Connectors(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.Connector\" instance.  Cannot create instance directly from \"AVM.META.Design.Connector\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "Connector" ] )
                baseAVMClass = getattr( baseModule, "Connector" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.Connector\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.Connector\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Connectors().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Containers( self, object ):
        del self.get_Containers()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Containers(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.Container\" instance.  Cannot create instance directly from \"AVM.META.Design.Container\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "Container" ] )
                baseAVMClass = getattr( baseModule, "Container" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.Container\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.Container\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Containers().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class TestBenchInstance:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Definition = ""
        self._MappableValueInstances = []
        self._PortInstances = []
        self._TestBenchID = ""


    def get_Definition(self):
        return self._Definition


    def get_TestBenchID(self):
        return self._TestBenchID


    def set_Definition(self,Definition):
        self._Definition = Definition


    def set_TestBenchID(self,TestBenchID):
        self._TestBenchID = TestBenchID


    def get_MappableValueInstances(self):
        return self._MappableValueInstances


    def get_PortInstances(self):
        return self._PortInstances


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Definition":
                    self.deserialize_Definition( jsonObject[ "Definition" ] )
                elif memberName == "TestBenchID":
                    self.deserialize_TestBenchID( jsonObject[ "TestBenchID" ] )
                elif memberName == "MappableValueInstances":
                    self.deserialize_MappableValueInstances( jsonObject[ "MappableValueInstances" ] )
                elif memberName == "PortInstances":
                    self.deserialize_PortInstances( jsonObject[ "PortInstances" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBenchInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBenchInstance\":  " + str( e )

        return self


    def deserialize_Definition( self, object ):
        self.set_Definition( object )


    def deserialize_TestBenchID( self, object ):
        self.set_TestBenchID( object )


    def deserialize_MappableValueInstances( self, object ):
        del self.get_MappableValueInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_MappableValueInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.MappableValueInstance\" object.  Creating instance directly from \"AVM.META.Design.MappableValueInstance\" class."
                objectType = "AVM.META.Design.MappableValueInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "MappableValueInstance" ] )
                baseAVMClass = getattr( baseModule, "MappableValueInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.MappableValueInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.MappableValueInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_MappableValueInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_PortInstances( self, object ):
        del self.get_PortInstances()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PortInstances(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.PortInstance\" object.  Creating instance directly from \"AVM.META.Design.PortInstance\" class."
                objectType = "AVM.META.Design.PortInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "PortInstance" ] )
                baseAVMClass = getattr( baseModule, "PortInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.PortInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.PortInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PortInstances().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class TestBenchMapping:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Connectors = []
        self._TestBenchInstance = []


    def get_Connectors(self):
        return self._Connectors


    def get_TestBenchInstance(self):
        return self._TestBenchInstance


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Connectors":
                    self.deserialize_Connectors( jsonObject[ "Connectors" ] )
                elif memberName == "TestBenchInstance":
                    self.deserialize_TestBenchInstance( jsonObject[ "TestBenchInstance" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.TestBenchMapping\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.TestBenchMapping\":  " + str( e )

        return self


    def deserialize_Connectors( self, object ):
        del self.get_Connectors()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Connectors(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.Connector\" instance.  Cannot create instance directly from \"AVM.META.Design.Connector\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "Connector" ] )
                baseAVMClass = getattr( baseModule, "Connector" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.Connector\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.Connector\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Connectors().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_TestBenchInstance( self, object ):
        del self.get_TestBenchInstance()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_TestBenchInstance(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.TestBenchInstance\" object.  Creating instance directly from \"AVM.META.Design.TestBenchInstance\" class."
                objectType = "AVM.META.Design.TestBenchInstance"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "TestBenchInstance" ] )
                baseAVMClass = getattr( baseModule, "TestBenchInstance" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.TestBenchInstance\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.TestBenchInstance\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_TestBenchInstance().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class ValueType:

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        self._id = ""


    def get_id(self):
        return self._id


    def set_id(self,id):
        self._id = id


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ValueType\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ValueType\":  " + str( e )

        return self


    def deserialize_id( self, object ):
        self.set_id( object )

        ISIS.JSONDeserializeHelper._referencedObjectMap[ self.get_id() ] = self




class ComponentNamedValueInstance(ValueType):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ValueType.__init__(self)
        self._IDinComponentModel = ""
        self._Value = 0.0


    def get_IDinComponentModel(self):
        return self._IDinComponentModel


    def get_Value(self):
        return self._Value


    def set_IDinComponentModel(self,IDinComponentModel):
        self._IDinComponentModel = IDinComponentModel


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IDinComponentModel":
                    self.deserialize_IDinComponentModel( jsonObject[ "IDinComponentModel" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ComponentNamedValueInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ComponentNamedValueInstance\":  " + str( e )

        return self


    def deserialize_IDinComponentModel( self, object ):
        self.set_IDinComponentModel( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class Compound(Container):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Container.__init__(self)
        self._SrcDesignSpaceContainerID = ""


    def get_SrcDesignSpaceContainerID(self):
        return self._SrcDesignSpaceContainerID


    def set_SrcDesignSpaceContainerID(self,SrcDesignSpaceContainerID):
        self._SrcDesignSpaceContainerID = SrcDesignSpaceContainerID


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "SrcDesignSpaceContainerID":
                    self.deserialize_SrcDesignSpaceContainerID( jsonObject[ "SrcDesignSpaceContainerID" ] )
                elif memberName == "ComponentInstances":
                    self.deserialize_ComponentInstances( jsonObject[ "ComponentInstances" ] )
                elif memberName == "ContainerPorts":
                    self.deserialize_ContainerPorts( jsonObject[ "ContainerPorts" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "ContainerStructuralInterfaces":
                    self.deserialize_ContainerStructuralInterfaces( jsonObject[ "ContainerStructuralInterfaces" ] )
                elif memberName == "ContainerValues":
                    self.deserialize_ContainerValues( jsonObject[ "ContainerValues" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Compound\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Compound\":  " + str( e )

        return self


    def deserialize_SrcDesignSpaceContainerID( self, object ):
        self.set_SrcDesignSpaceContainerID( object )





class Constraint(ConstraintBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ConstraintBase.__init__(self)
        self._Expression = ""


    def get_Expression(self):
        return self._Expression


    def set_Expression(self,Expression):
        self._Expression = Expression


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Expression":
                    self.deserialize_Expression( jsonObject[ "Expression" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Constraint\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Constraint\":  " + str( e )

        return self


    def deserialize_Expression( self, object ):
        self.set_Expression( object )





class ContainerPort(AbstractPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AbstractPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "PortConnector":
                    self.deserialize_PortConnector( jsonObject[ "PortConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ContainerPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ContainerPort\":  " + str( e )

        return self





class ContainerStructuralInterface(AbstractStructuralInterface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AbstractStructuralInterface.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "StructuralInterfaceConnector":
                    self.deserialize_StructuralInterfaceConnector( jsonObject[ "StructuralInterfaceConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ContainerStructuralInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ContainerStructuralInterface\":  " + str( e )

        return self





class ContainerValue(ValueType):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        ValueType.__init__(self)
        self._Description = ""
        self._Name = ""


    def get_Description(self):
        return self._Description


    def get_Name(self):
        return self._Name


    def set_Description(self,Description):
        self._Description = Description


    def set_Name(self,Name):
        self._Name = Name


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ContainerValue\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ContainerValue\":  " + str( e )

        return self


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )





class DecisionGroup(ConstraintBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ConstraintBase.__init__(self)
        self._Alternatives = []


    def get_Alternatives(self):
        return self._Alternatives


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Alternatives":
                    self.deserialize_Alternatives( jsonObject[ "Alternatives" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.DecisionGroup\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.DecisionGroup\":  " + str( e )

        return self


    def deserialize_Alternatives( self, object ):
        del self.get_Alternatives()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Alternatives(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.Alternative\" object.  Creating instance directly from \"AVM.META.Design.Alternative\" class."
                objectType = "AVM.META.Design.Alternative"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "Alternative" ] )
                baseAVMClass = getattr( baseModule, "Alternative" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.Alternative\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.Alternative\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Alternatives().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class DesignSpaceContainer(Container):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        Container.__init__(self)
        self._Constraints = []


    def get_Constraints(self):
        return self._Constraints


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ComponentInstances":
                    self.deserialize_ComponentInstances( jsonObject[ "ComponentInstances" ] )
                elif memberName == "Constraints":
                    self.deserialize_Constraints( jsonObject[ "Constraints" ] )
                elif memberName == "ContainerPorts":
                    self.deserialize_ContainerPorts( jsonObject[ "ContainerPorts" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "ContainerStructuralInterfaces":
                    self.deserialize_ContainerStructuralInterfaces( jsonObject[ "ContainerStructuralInterfaces" ] )
                elif memberName == "ContainerValues":
                    self.deserialize_ContainerValues( jsonObject[ "ContainerValues" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.DesignSpaceContainer\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.DesignSpaceContainer\":  " + str( e )

        return self


    def deserialize_Constraints( self, object ):
        del self.get_Constraints()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Constraints(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.ConstraintBase\" instance.  Cannot create instance directly from \"AVM.META.Design.ConstraintBase\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ConstraintBase" ] )
                baseAVMClass = getattr( baseModule, "ConstraintBase" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.ConstraintBase\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ConstraintBase\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Constraints().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class ImpliesConstraint(ConstraintBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ConstraintBase.__init__(self)
        self._Condition = ""
        self._Implication = ""


    def get_Condition(self):
        return self._Condition


    def get_Implication(self):
        return self._Implication


    def set_Condition(self,Condition):
        self._Condition = Condition


    def set_Implication(self,Implication):
        self._Implication = Implication


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Condition":
                    self.deserialize_Condition( jsonObject[ "Condition" ] )
                elif memberName == "Implication":
                    self.deserialize_Implication( jsonObject[ "Implication" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ImpliesConstraint\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ImpliesConstraint\":  " + str( e )

        return self


    def deserialize_Condition( self, object ):
        self.set_Condition( object )


    def deserialize_Implication( self, object ):
        self.set_Implication( object )





class MappableValueInstance(ValueType):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ValueType.__init__(self)
        self._Directionality = None


    def get_Directionality(self):
        return self._Directionality


    def set_Directionality(self,Directionality):
        self._Directionality = Directionality


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Directionality":
                    self.deserialize_Directionality( jsonObject[ "Directionality" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.MappableValueInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.MappableValueInstance\":  " + str( e )

        return self


    def deserialize_Directionality( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "DirectionEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DirectionEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.DirectionEnum\":  " + str( e )
            return

        self.set_Directionality(  getattr( baseAVMEnumClass, "_" + object + "_" )  )





class PortConnector(Connector):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Connector.__init__(self)
        self._EndPoints = []


    def get_EndPoints(self):
        return self._EndPoints


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "EndPoints":
                    self.deserialize_EndPoints( jsonObject[ "EndPoints" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.PortConnector\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.PortConnector\":  " + str( e )

        return self


    def deserialize_EndPoints( self, object ):
        del self.get_EndPoints()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_EndPoints(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.AbstractPort\" instance.  Cannot create instance directly from \"AVM.META.Design.AbstractPort\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "AbstractPort" ] )
                baseAVMClass = getattr( baseModule, "AbstractPort" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.AbstractPort\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.AbstractPort\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_EndPoints().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class PortInstance(AbstractPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AbstractPort.__init__(self)
        self._IDinSourceModel = ""


    def get_IDinSourceModel(self):
        return self._IDinSourceModel


    def set_IDinSourceModel(self,IDinSourceModel):
        self._IDinSourceModel = IDinSourceModel


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IDinSourceModel":
                    self.deserialize_IDinSourceModel( jsonObject[ "IDinSourceModel" ] )
                elif memberName == "PortConnector":
                    self.deserialize_PortConnector( jsonObject[ "PortConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.PortInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.PortInstance\":  " + str( e )

        return self


    def deserialize_IDinSourceModel( self, object ):
        self.set_IDinSourceModel( object )





class PropertyConstraint(ConstraintBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ConstraintBase.__init__(self)
        self._TargetType = ""
        self._TargetValue = 0.0
        self._Value = None


    def get_TargetType(self):
        return self._TargetType


    def get_TargetValue(self):
        return self._TargetValue


    def set_TargetType(self,TargetType):
        self._TargetType = TargetType


    def set_TargetValue(self,TargetValue):
        self._TargetValue = TargetValue


    def set_Value(self,Value):
        self._Value = Value


    def get_Value(self):
        return self._Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "TargetType":
                    self.deserialize_TargetType( jsonObject[ "TargetType" ] )
                elif memberName == "TargetValue":
                    self.deserialize_TargetValue( jsonObject[ "TargetValue" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.PropertyConstraint\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.PropertyConstraint\":  " + str( e )

        return self


    def deserialize_TargetType( self, object ):
        self.set_TargetType( object )


    def deserialize_TargetValue( self, object ):
        self.set_TargetValue( object )


    def deserialize_Value( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_Value )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.META.Design.ValueType\" instance.  Cannot create instance directly from \"AVM.META.Design.ValueType\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ValueType" ] )
            baseAVMClass = getattr( baseModule, "ValueType" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.ValueType\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ValueType\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_Value(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class StructuralInterfaceConnector(Connector):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Connector.__init__(self)
        self._EndPoints = []
        self._Joins = []


    def get_EndPoints(self):
        return self._EndPoints


    def get_Joins(self):
        return self._Joins


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "EndPoints":
                    self.deserialize_EndPoints( jsonObject[ "EndPoints" ] )
                elif memberName == "Joins":
                    self.deserialize_Joins( jsonObject[ "Joins" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.StructuralInterfaceConnector\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.StructuralInterfaceConnector\":  " + str( e )

        return self


    def deserialize_EndPoints( self, object ):
        del self.get_EndPoints()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_EndPoints(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Design.AbstractStructuralInterface\" instance.  Cannot create instance directly from \"AVM.META.Design.AbstractStructuralInterface\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "AbstractStructuralInterface" ] )
                baseAVMClass = getattr( baseModule, "AbstractStructuralInterface" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.AbstractStructuralInterface\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.AbstractStructuralInterface\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_EndPoints().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Joins( self, object ):
        del self.get_Joins()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Joins(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.iFAB.Join\" object.  Creating instance directly from \"AVM.iFAB.Join\" class."
                objectType = "AVM.iFAB.Join"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.iFAB", globals(), locals(), [ "Join" ] )
                baseAVMClass = getattr( baseModule, "Join" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.iFAB.Join\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.iFAB.Join\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Joins().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class StructuralInterfaceInstance(AbstractStructuralInterface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AbstractStructuralInterface.__init__(self)
        self._IDinSourceModel = ""


    def get_IDinSourceModel(self):
        return self._IDinSourceModel


    def set_IDinSourceModel(self,IDinSourceModel):
        self._IDinSourceModel = IDinSourceModel


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IDinSourceModel":
                    self.deserialize_IDinSourceModel( jsonObject[ "IDinSourceModel" ] )
                elif memberName == "StructuralInterfaceConnector":
                    self.deserialize_StructuralInterfaceConnector( jsonObject[ "StructuralInterfaceConnector" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.StructuralInterfaceInstance\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.StructuralInterfaceInstance\":  " + str( e )

        return self


    def deserialize_IDinSourceModel( self, object ):
        self.set_IDinSourceModel( object )





class ValueConnector(Connector):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Connector.__init__(self)
        self._DestinationValue = None
        self._SourceValue = None


    def set_DestinationValue(self,DestinationValue):
        self._DestinationValue = DestinationValue


    def set_SourceValue(self,SourceValue):
        self._SourceValue = SourceValue


    def get_DestinationValue(self):
        return self._DestinationValue


    def get_SourceValue(self):
        return self._SourceValue


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DestinationValue":
                    self.deserialize_DestinationValue( jsonObject[ "DestinationValue" ] )
                elif memberName == "SourceValue":
                    self.deserialize_SourceValue( jsonObject[ "SourceValue" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ValueConnector\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ValueConnector\":  " + str( e )

        return self


    def deserialize_DestinationValue( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_DestinationValue )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.META.Design.ValueType\" instance.  Cannot create instance directly from \"AVM.META.Design.ValueType\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ValueType" ] )
            baseAVMClass = getattr( baseModule, "ValueType" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.ValueType\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ValueType\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_DestinationValue(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return


    def deserialize_SourceValue( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_SourceValue )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "ERROR:  No \"$type\" for \"AVM.META.Design.ValueType\" instance.  Cannot create instance directly from \"AVM.META.Design.ValueType\" class because it is abstract."
            return

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "ValueType" ] )
            baseAVMClass = getattr( baseModule, "ValueType" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.Design.ValueType\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.ValueType\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_SourceValue(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class Alternative(DesignSpaceContainer):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        DesignSpaceContainer.__init__(self)
        self._DecisionGroup = []


    def get_DecisionGroup(self):
        return self._DecisionGroup


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ComponentInstances":
                    self.deserialize_ComponentInstances( jsonObject[ "ComponentInstances" ] )
                elif memberName == "Constraints":
                    self.deserialize_Constraints( jsonObject[ "Constraints" ] )
                elif memberName == "ContainerPorts":
                    self.deserialize_ContainerPorts( jsonObject[ "ContainerPorts" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "ContainerStructuralInterfaces":
                    self.deserialize_ContainerStructuralInterfaces( jsonObject[ "ContainerStructuralInterfaces" ] )
                elif memberName == "ContainerValues":
                    self.deserialize_ContainerValues( jsonObject[ "ContainerValues" ] )
                elif memberName == "DecisionGroup":
                    self.deserialize_DecisionGroup( jsonObject[ "DecisionGroup" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Alternative\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Alternative\":  " + str( e )

        return self


    def deserialize_DecisionGroup( self, object ):
        del self.get_DecisionGroup()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_DecisionGroup(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Design.DecisionGroup\" object.  Creating instance directly from \"AVM.META.Design.DecisionGroup\" class."
                objectType = "AVM.META.Design.DecisionGroup"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META.Design", globals(), locals(), [ "DecisionGroup" ] )
                baseAVMClass = getattr( baseModule, "DecisionGroup" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Design.DecisionGroup\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Design.DecisionGroup\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_DecisionGroup().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class ContainerCalculation(ContainerValue):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ContainerValue.__init__(self)
        self._Script = ""


    def get_Script(self):
        return self._Script


    def set_Script(self,Script):
        self._Script = Script


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Script":
                    self.deserialize_Script( jsonObject[ "Script" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ContainerCalculation\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ContainerCalculation\":  " + str( e )

        return self


    def deserialize_Script( self, object ):
        self.set_Script( object )





class ContainerNamedValue(ContainerValue):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        ContainerValue.__init__(self)
        self._IsParameter = False
        self._Value = ""


    def get_IsParameter(self):
        return self._IsParameter


    def get_Value(self):
        return self._Value


    def set_IsParameter(self,IsParameter):
        self._IsParameter = IsParameter


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IsParameter":
                    self.deserialize_IsParameter( jsonObject[ "IsParameter" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.ContainerNamedValue\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.ContainerNamedValue\":  " + str( e )

        return self


    def deserialize_IsParameter( self, object ):
        self.set_IsParameter( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class Optional(DesignSpaceContainer):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        DesignSpaceContainer.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ComponentInstances":
                    self.deserialize_ComponentInstances( jsonObject[ "ComponentInstances" ] )
                elif memberName == "Constraints":
                    self.deserialize_Constraints( jsonObject[ "Constraints" ] )
                elif memberName == "ContainerPorts":
                    self.deserialize_ContainerPorts( jsonObject[ "ContainerPorts" ] )
                elif memberName == "Containers":
                    self.deserialize_Containers( jsonObject[ "Containers" ] )
                elif memberName == "ContainerStructuralInterfaces":
                    self.deserialize_ContainerStructuralInterfaces( jsonObject[ "ContainerStructuralInterfaces" ] )
                elif memberName == "ContainerValues":
                    self.deserialize_ContainerValues( jsonObject[ "ContainerValues" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Design.Optional\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Design.Optional\":  " + str( e )

        return self




