

class AllocationPortTypeEnum:
    _Executable_ = "Executable"
    _Executor_ = "Executor"




class DirectionEnum:
    _Input_ = "Input"
    _Output_ = "Output"




class BehaviorModelSignalPortTypeEnum:
    _ModelicaRealInput_ = "ModelicaRealInput"
    _ModelicaRealOutput_ = "ModelicaRealOutput"
    _ModelicaBooleanInput_ = "ModelicaBooleanInput"
    _ModelicaBooleanOutput_ = "ModelicaBooleanOutput"
    _ModelicaIntegerInput_ = "ModelicaIntegerInput"
    _ModelicaIntegerOutput_ = "ModelicaIntegerOutput"
    _BondGraphSignalInput_ = "BondGraphSignalInput"
    _BondGraphSignalOutput_ = "BondGraphSignalOutput"




class BehaviorModelSignalPortTimingSemanticsEnum:
    _ContinuousTime_ = "ContinuousTime"
    _DiscreteTime_ = "DiscreteTime"
    _DiscreteEvent_ = "DiscreteEvent"




class BehaviorModelPowerPortTypeEnum:
    _ModelicaElectrical_ = "ModelicaElectrical"
    _ModelicaFlow_ = "ModelicaFlow"
    _ModelicaFluid_ = "ModelicaFluid"
    _ModelicaHeat_ = "ModelicaHeat"
    _ModelicaRotational_ = "ModelicaRotational"
    _ModelicaTranslational_ = "ModelicaTranslational"
    _ModelicaFrame_ = "ModelicaFrame"
    _BondGraphHydraulic_ = "BondGraphHydraulic"
    _BondGraphThermal_ = "BondGraphThermal"
    _BondGraphElectrical_ = "BondGraphElectrical"
    _BondGraphMechanicalR_ = "BondGraphMechanicalR"
    _BondGraphMechanicalD_ = "BondGraphMechanicalD"




class DataTypeFieldTypeEnum:
    _LongLongInteger_ = "LongLongInteger"
    _LongInteger_ = "LongInteger"
    _ShortInteger_ = "ShortInteger"
    _Single_ = "Single"
    _Double_ = "Double"
    _Character_ = "Character"




class LimitType:
    _Max_ = "Max"
    _AbsMax_ = "AbsMax"
    _Min_ = "Min"




class CADModelType:
    _Part_ = "Part"
    _Assembly_ = "Assembly"


import ISIS
import AVM

class BusSignal:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Causality = None
        self._FieldName = ""
        self._Unit = ""


    def get_Causality(self):
        return self._Causality


    def get_FieldName(self):
        return self._FieldName


    def get_Unit(self):
        return self._Unit


    def set_Causality(self,Causality):
        self._Causality = Causality


    def set_FieldName(self,FieldName):
        self._FieldName = FieldName


    def set_Unit(self,Unit):
        self._Unit = Unit


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Causality":
                    self.deserialize_Causality( jsonObject[ "Causality" ] )
                elif memberName == "FieldName":
                    self.deserialize_FieldName( jsonObject[ "FieldName" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.BusSignal\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.BusSignal\":  " + str( e )

        return self


    def deserialize_Causality( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "CausalityEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "CausalityEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.CausalityEnum\":  " + str( e )
            return

        self.set_Causality(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_FieldName( self, object ):
        self.set_FieldName( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )





class DataType:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Definition = ""
        self._Direction = None
        self._Fields = []
        self._IsFaultMessage = None
        self._Name = ""


    def get_Definition(self):
        return self._Definition


    def get_Direction(self):
        return self._Direction


    def get_IsFaultMessage(self):
        return self._IsFaultMessage


    def get_Name(self):
        return self._Name


    def set_Definition(self,Definition):
        self._Definition = Definition


    def set_Direction(self,Direction):
        self._Direction = Direction


    def set_IsFaultMessage(self,IsFaultMessage):
        self._IsFaultMessage = IsFaultMessage


    def set_Name(self,Name):
        self._Name = Name


    def get_Fields(self):
        return self._Fields


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Definition":
                    self.deserialize_Definition( jsonObject[ "Definition" ] )
                elif memberName == "Direction":
                    self.deserialize_Direction( jsonObject[ "Direction" ] )
                elif memberName == "IsFaultMessage":
                    self.deserialize_IsFaultMessage( jsonObject[ "IsFaultMessage" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Fields":
                    self.deserialize_Fields( jsonObject[ "Fields" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.DataType\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.DataType\":  " + str( e )

        return self


    def deserialize_Definition( self, object ):
        self.set_Definition( object )


    def deserialize_Direction( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "DirectionEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DirectionEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.DirectionEnum\":  " + str( e )
            return

        self.set_Direction(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_IsFaultMessage( self, object ):
        self.set_IsFaultMessage( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Fields( self, object ):
        del self.get_Fields()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Fields(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.DataTypeField\" object.  Creating instance directly from \"AVM.META.DataTypeField\" class."
                objectType = "AVM.META.DataTypeField"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "DataTypeField" ] )
                baseAVMClass = getattr( baseModule, "DataTypeField" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.DataTypeField\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.DataTypeField\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Fields().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class LimitCheck:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._LimitType = None
        self._Value = 0.0
        self._VariableName = ""


    def get_LimitType(self):
        return self._LimitType


    def get_Value(self):
        return self._Value


    def get_VariableName(self):
        return self._VariableName


    def set_LimitType(self,LimitType):
        self._LimitType = LimitType


    def set_Value(self,Value):
        self._Value = Value


    def set_VariableName(self,VariableName):
        self._VariableName = VariableName


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "LimitType":
                    self.deserialize_LimitType( jsonObject[ "LimitType" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif memberName == "VariableName":
                    self.deserialize_VariableName( jsonObject[ "VariableName" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.LimitCheck\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.LimitCheck\":  " + str( e )

        return self


    def deserialize_LimitType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "LimitType" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "LimitType" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.LimitType\":  " + str( e )
            return

        self.set_LimitType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Value( self, object ):
        self.set_Value( object )


    def deserialize_VariableName( self, object ):
        self.set_VariableName( object )





class MaterialSpec:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._CompatibleMaterials = []
        self._PowerPorts = []
        self._RedeclareParameterName = ""
        self._RedeclareType = ""


    def get_CompatibleMaterials(self):
        return self._CompatibleMaterials


    def get_RedeclareParameterName(self):
        return self._RedeclareParameterName


    def get_RedeclareType(self):
        return self._RedeclareType


    def set_RedeclareParameterName(self,RedeclareParameterName):
        self._RedeclareParameterName = RedeclareParameterName


    def set_RedeclareType(self,RedeclareType):
        self._RedeclareType = RedeclareType


    def get_PowerPorts(self):
        return self._PowerPorts


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "CompatibleMaterials":
                    self.deserialize_CompatibleMaterials( jsonObject[ "CompatibleMaterials" ] )
                elif memberName == "RedeclareParameterName":
                    self.deserialize_RedeclareParameterName( jsonObject[ "RedeclareParameterName" ] )
                elif memberName == "RedeclareType":
                    self.deserialize_RedeclareType( jsonObject[ "RedeclareType" ] )
                elif memberName == "PowerPorts":
                    self.deserialize_PowerPorts( jsonObject[ "PowerPorts" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.MaterialSpec\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.MaterialSpec\":  " + str( e )

        return self


    def deserialize_CompatibleMaterials( self, object ):
        del self.get_CompatibleMaterials()[:]
        for arrayObject in object:
            self.get_CompatibleMaterials().append( arrayObject )

    def deserialize_RedeclareParameterName( self, object ):
        self.set_RedeclareParameterName( object )


    def deserialize_RedeclareType( self, object ):
        self.set_RedeclareType( object )


    def deserialize_PowerPorts( self, object ):
        del self.get_PowerPorts()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_PowerPorts(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.PowerPortInterface\" object.  Creating instance directly from \"AVM.META.PowerPortInterface\" class."
                objectType = "AVM.META.PowerPortInterface"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "PowerPortInterface" ] )
                baseAVMClass = getattr( baseModule, "PowerPortInterface" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.PowerPortInterface\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.PowerPortInterface\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_PowerPorts().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class Phenomenon:

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        self._Definition = ""


    def get_Definition(self):
        return self._Definition


    def set_Definition(self,Definition):
        self._Definition = Definition


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Definition":
                    self.deserialize_Definition( jsonObject[ "Definition" ] )
                elif memberName == "id":
                    ISIS.JSONDeserializeHelper._referencedObjectMap[ jsonObject[ "id" ] ] = self
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Phenomenon\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Phenomenon\":  " + str( e )

        return self


    def deserialize_Definition( self, object ):
        self.set_Definition( object )





class CADParameter(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._DefaultValue = ""
        self._Description = ""
        self._Name = ""
        self._ParameterType = None
        self._Unit = ""
        self._ValidRange = ""
        self._Value = ""


    def get_DefaultValue(self):
        return self._DefaultValue


    def get_Description(self):
        return self._Description


    def get_Name(self):
        return self._Name


    def get_ParameterType(self):
        return self._ParameterType


    def get_Unit(self):
        return self._Unit


    def get_ValidRange(self):
        return self._ValidRange


    def get_Value(self):
        return self._Value


    def set_DefaultValue(self,DefaultValue):
        self._DefaultValue = DefaultValue


    def set_Description(self,Description):
        self._Description = Description


    def set_Name(self,Name):
        self._Name = Name


    def set_ParameterType(self,ParameterType):
        self._ParameterType = ParameterType


    def set_Unit(self,Unit):
        self._Unit = Unit


    def set_ValidRange(self,ValidRange):
        self._ValidRange = ValidRange


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DefaultValue":
                    self.deserialize_DefaultValue( jsonObject[ "DefaultValue" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ParameterType":
                    self.deserialize_ParameterType( jsonObject[ "ParameterType" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "ValidRange":
                    self.deserialize_ValidRange( jsonObject[ "ValidRange" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.CADParameter\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.CADParameter\":  " + str( e )

        return self


    def deserialize_DefaultValue( self, object ):
        self.set_DefaultValue( object )


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_ParameterType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "DataTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DataTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.DataTypeEnum\":  " + str( e )
            return

        self.set_ParameterType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )


    def deserialize_ValidRange( self, object ):
        self.set_ValidRange( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class CalculationInput(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._Name = ""


    def get_Name(self):
        return self._Name


    def set_Name(self,Name):
        self._Name = Name


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.CalculationInput\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.CalculationInput\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )





class DataTypeField(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._FieldType = None
        self._Locator = ""


    def get_FieldType(self):
        return self._FieldType


    def get_Locator(self):
        return self._Locator


    def set_FieldType(self,FieldType):
        self._FieldType = FieldType


    def set_Locator(self,Locator):
        self._Locator = Locator


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "FieldType":
                    self.deserialize_FieldType( jsonObject[ "FieldType" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Locator":
                    self.deserialize_Locator( jsonObject[ "Locator" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.DataTypeField\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.DataTypeField\":  " + str( e )

        return self


    def deserialize_FieldType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "DataTypeFieldTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DataTypeFieldTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.DataTypeFieldTypeEnum\":  " + str( e )
            return

        self.set_FieldType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Locator( self, object ):
        self.set_Locator( object )





class Datum(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._DatumName = ""
        self._DatumType = None
        self._Name = ""
        self._Orientation = None


    def get_DatumName(self):
        return self._DatumName


    def get_DatumType(self):
        return self._DatumType


    def get_Name(self):
        return self._Name


    def get_Orientation(self):
        return self._Orientation


    def set_DatumName(self,DatumName):
        self._DatumName = DatumName


    def set_DatumType(self,DatumType):
        self._DatumType = DatumType


    def set_Name(self,Name):
        self._Name = Name


    def set_Orientation(self,Orientation):
        self._Orientation = Orientation


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DatumName":
                    self.deserialize_DatumName( jsonObject[ "DatumName" ] )
                elif memberName == "DatumType":
                    self.deserialize_DatumType( jsonObject[ "DatumType" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Orientation":
                    self.deserialize_Orientation( jsonObject[ "Orientation" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Datum\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Datum\":  " + str( e )

        return self


    def deserialize_DatumName( self, object ):
        self.set_DatumName( object )


    def deserialize_DatumType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "DatumTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DatumTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.DatumTypeEnum\":  " + str( e )
            return

        self.set_DatumType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Orientation( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "OrientationEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "OrientationEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.OrientationEnum\":  " + str( e )
            return

        self.set_Orientation(  getattr( baseAVMEnumClass, "_" + object + "_" )  )





class Interface(AVM.Associable):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._Name = ""


    def get_Name(self):
        return self._Name


    def set_Name(self,Name):
        self._Name = Name


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Interface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Interface\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )





class Metric(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._Name = ""
        self._Unit = ""
        self._Value = 0.0


    def get_Name(self):
        return self._Name


    def get_Unit(self):
        return self._Unit


    def get_Value(self):
        return self._Value


    def set_Name(self,Name):
        self._Name = Name


    def set_Unit(self,Unit):
        self._Unit = Unit


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Metric\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Metric\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class Property(AVM.Associable):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Associable.__init__(self)
        self._Name = ""
        self._Unit = ""
        self._Value = ""


    def get_Name(self):
        return self._Name


    def get_Unit(self):
        return self._Unit


    def get_Value(self):
        return self._Value


    def set_Name(self,Name):
        self._Name = Name


    def set_Unit(self,Unit):
        self._Unit = Unit


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.Property\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Property\":  " + str( e )

        return self


    def deserialize_Name( self, object ):
        self.set_Name( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class AggregateInterface(Interface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Interface.__init__(self)
        self._AggregatedInterfaces = []
        self._InterfaceType = ""


    def get_InterfaceType(self):
        return self._InterfaceType


    def set_InterfaceType(self,InterfaceType):
        self._InterfaceType = InterfaceType


    def get_AggregatedInterfaces(self):
        return self._AggregatedInterfaces


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "InterfaceType":
                    self.deserialize_InterfaceType( jsonObject[ "InterfaceType" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "AggregatedInterfaces":
                    self.deserialize_AggregatedInterfaces( jsonObject[ "AggregatedInterfaces" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.AggregateInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.AggregateInterface\":  " + str( e )

        return self


    def deserialize_InterfaceType( self, object ):
        self.set_InterfaceType( object )


    def deserialize_AggregatedInterfaces( self, object ):
        del self.get_AggregatedInterfaces()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_AggregatedInterfaces(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Interface\" instance.  Cannot create instance directly from \"AVM.META.Interface\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Interface" ] )
                baseAVMClass = getattr( baseModule, "Interface" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Interface\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Interface\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_AggregatedInterfaces().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class BehaviorParameter(Interface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Interface.__init__(self)
        self._DefaultValue = ""
        self._Description = ""
        self._Dimension = ""
        self._IsInitialization = None
        self._NativeToolUnit = ""
        self._Unit = ""
        self._ValidRange = ""
        self._Value = ""
        self._VarInitialized = ""


    def get_DefaultValue(self):
        return self._DefaultValue


    def get_Description(self):
        return self._Description


    def get_Dimension(self):
        return self._Dimension


    def get_IsInitialization(self):
        return self._IsInitialization


    def get_NativeToolUnit(self):
        return self._NativeToolUnit


    def get_Unit(self):
        return self._Unit


    def get_ValidRange(self):
        return self._ValidRange


    def get_Value(self):
        return self._Value


    def get_VarInitialized(self):
        return self._VarInitialized


    def set_DefaultValue(self,DefaultValue):
        self._DefaultValue = DefaultValue


    def set_Description(self,Description):
        self._Description = Description


    def set_Dimension(self,Dimension):
        self._Dimension = Dimension


    def set_IsInitialization(self,IsInitialization):
        self._IsInitialization = IsInitialization


    def set_NativeToolUnit(self,NativeToolUnit):
        self._NativeToolUnit = NativeToolUnit


    def set_Unit(self,Unit):
        self._Unit = Unit


    def set_ValidRange(self,ValidRange):
        self._ValidRange = ValidRange


    def set_Value(self,Value):
        self._Value = Value


    def set_VarInitialized(self,VarInitialized):
        self._VarInitialized = VarInitialized


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DefaultValue":
                    self.deserialize_DefaultValue( jsonObject[ "DefaultValue" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Dimension":
                    self.deserialize_Dimension( jsonObject[ "Dimension" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IsInitialization":
                    self.deserialize_IsInitialization( jsonObject[ "IsInitialization" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "NativeToolUnit":
                    self.deserialize_NativeToolUnit( jsonObject[ "NativeToolUnit" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "ValidRange":
                    self.deserialize_ValidRange( jsonObject[ "ValidRange" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif memberName == "VarInitialized":
                    self.deserialize_VarInitialized( jsonObject[ "VarInitialized" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.BehaviorParameter\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.BehaviorParameter\":  " + str( e )

        return self


    def deserialize_DefaultValue( self, object ):
        self.set_DefaultValue( object )


    def deserialize_Description( self, object ):
        self.set_Description( object )


    def deserialize_Dimension( self, object ):
        self.set_Dimension( object )


    def deserialize_IsInitialization( self, object ):
        self.set_IsInitialization( object )


    def deserialize_NativeToolUnit( self, object ):
        self.set_NativeToolUnit( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )


    def deserialize_ValidRange( self, object ):
        self.set_ValidRange( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )


    def deserialize_VarInitialized( self, object ):
        self.set_VarInitialized( object )





class BusPortInterface(Interface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Interface.__init__(self)
        self._BusSignal = None
        self._InterfaceType = ""


    def get_InterfaceType(self):
        return self._InterfaceType


    def set_BusSignal(self,BusSignal):
        self._BusSignal = BusSignal


    def set_InterfaceType(self,InterfaceType):
        self._InterfaceType = InterfaceType


    def get_BusSignal(self):
        return self._BusSignal


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "InterfaceType":
                    self.deserialize_InterfaceType( jsonObject[ "InterfaceType" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "BusSignal":
                    self.deserialize_BusSignal( jsonObject[ "BusSignal" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.BusPortInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.BusPortInterface\":  " + str( e )

        return self


    def deserialize_InterfaceType( self, object ):
        self.set_InterfaceType( object )


    def deserialize_BusSignal( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_BusSignal )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "WARNING:  No \"$type\" for \"AVM.META.BusSignal\" object.  Creating instance directly from \"AVM.META.BusSignal\" class."
            objectType = "AVM.META.BusSignal"

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META", globals(), locals(), [ "BusSignal" ] )
            baseAVMClass = getattr( baseModule, "BusSignal" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.BusSignal\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.BusSignal\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_BusSignal(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class PowerPortInterface(Interface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Interface.__init__(self)
        self._MaterialSpecs = []
        self._PowerPortType = None


    def get_PowerPortType(self):
        return self._PowerPortType


    def set_PowerPortType(self,PowerPortType):
        self._PowerPortType = PowerPortType


    def get_MaterialSpecs(self):
        return self._MaterialSpecs


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "PowerPortType":
                    self.deserialize_PowerPortType( jsonObject[ "PowerPortType" ] )
                elif memberName == "MaterialSpecs":
                    self.deserialize_MaterialSpecs( jsonObject[ "MaterialSpecs" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.PowerPortInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.PowerPortInterface\":  " + str( e )

        return self


    def deserialize_PowerPortType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "BehaviorModelPowerPortTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "BehaviorModelPowerPortTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.BehaviorModelPowerPortTypeEnum\":  " + str( e )
            return

        self.set_PowerPortType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_MaterialSpecs( self, object ):
        del self.get_MaterialSpecs()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_MaterialSpecs(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.MaterialSpec\" object.  Creating instance directly from \"AVM.META.MaterialSpec\" class."
                objectType = "AVM.META.MaterialSpec"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "MaterialSpec" ] )
                baseAVMClass = getattr( baseModule, "MaterialSpec" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.MaterialSpec\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.MaterialSpec\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_MaterialSpecs().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class SignalPortInterface(Interface):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Interface.__init__(self)
        self._Directionality = None
        self._DiscreteTimePhase = None
        self._DiscreteTimeStep = None
        self._SignalPortType = None
        self._TimingSemantics = None


    def get_Directionality(self):
        return self._Directionality


    def get_DiscreteTimePhase(self):
        return self._DiscreteTimePhase


    def get_DiscreteTimeStep(self):
        return self._DiscreteTimeStep


    def get_SignalPortType(self):
        return self._SignalPortType


    def get_TimingSemantics(self):
        return self._TimingSemantics


    def set_Directionality(self,Directionality):
        self._Directionality = Directionality


    def set_DiscreteTimePhase(self,DiscreteTimePhase):
        self._DiscreteTimePhase = DiscreteTimePhase


    def set_DiscreteTimeStep(self,DiscreteTimeStep):
        self._DiscreteTimeStep = DiscreteTimeStep


    def set_SignalPortType(self,SignalPortType):
        self._SignalPortType = SignalPortType


    def set_TimingSemantics(self,TimingSemantics):
        self._TimingSemantics = TimingSemantics


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Directionality":
                    self.deserialize_Directionality( jsonObject[ "Directionality" ] )
                elif memberName == "DiscreteTimePhase":
                    self.deserialize_DiscreteTimePhase( jsonObject[ "DiscreteTimePhase" ] )
                elif memberName == "DiscreteTimeStep":
                    self.deserialize_DiscreteTimeStep( jsonObject[ "DiscreteTimeStep" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "SignalPortType":
                    self.deserialize_SignalPortType( jsonObject[ "SignalPortType" ] )
                elif memberName == "TimingSemantics":
                    self.deserialize_TimingSemantics( jsonObject[ "TimingSemantics" ] )
                elif not memberName.startswith( "$" ) and memberName != "Type":
                    print "WARNING: class \"AVM.META.SignalPortInterface\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.SignalPortInterface\":  " + str( e )

        return self


    def deserialize_Directionality( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "DirectionEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DirectionEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.DirectionEnum\":  " + str( e )
            return

        self.set_Directionality(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_DiscreteTimePhase( self, object ):
        self.set_DiscreteTimePhase( object )


    def deserialize_DiscreteTimeStep( self, object ):
        self.set_DiscreteTimeStep( object )


    def deserialize_SignalPortType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "BehaviorModelSignalPortTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "BehaviorModelSignalPortTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.BehaviorModelSignalPortTypeEnum\":  " + str( e )
            return

        self.set_SignalPortType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_TimingSemantics( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "BehaviorModelSignalPortTimingSemanticsEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "BehaviorModelSignalPortTimingSemanticsEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.BehaviorModelSignalPortTimingSemanticsEnum\":  " + str( e )
            return

        self.set_TimingSemantics(  getattr( baseAVMEnumClass, "_" + object + "_" )  )





class Value(AVM.Base):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        AVM.Base.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Value\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Value\":  " + str( e )

        return self





class AggregatePort(AVM.ExternalPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.ExternalPort.__init__(self)
        self._AggregatedPorts = []


    def get_AggregatedPorts(self):
        return self._AggregatedPorts


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "AggregatedPorts":
                    self.deserialize_AggregatedPorts( jsonObject[ "AggregatedPorts" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.AggregatePort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.AggregatePort\":  " + str( e )

        return self


    def deserialize_AggregatedPorts( self, object ):
        del self.get_AggregatedPorts()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_AggregatedPorts(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.ExternalPort\" instance.  Cannot create instance directly from \"AVM.ExternalPort\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM", globals(), locals(), [ "ExternalPort" ] )
                baseAVMClass = getattr( baseModule, "ExternalPort" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.ExternalPort\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.ExternalPort\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_AggregatedPorts().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class AllocationPort(AVM.ExternalPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.ExternalPort.__init__(self)
        self._AllocationPortType = None


    def get_AllocationPortType(self):
        return self._AllocationPortType


    def set_AllocationPortType(self,AllocationPortType):
        self._AllocationPortType = AllocationPortType


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "AllocationPortType":
                    self.deserialize_AllocationPortType( jsonObject[ "AllocationPortType" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.AllocationPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.AllocationPort\":  " + str( e )

        return self


    def deserialize_AllocationPortType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "AllocationPortTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "AllocationPortTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.AllocationPortTypeEnum\":  " + str( e )
            return

        self.set_AllocationPortType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )





class ArchitectureModel(AVM.Model):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Model.__init__(self)
        self._Properties = []


    def get_Properties(self):
        return self._Properties


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Author":
                    self.deserialize_Author( jsonObject[ "Author" ] )
                elif memberName == "AuthorOrganization":
                    self.deserialize_AuthorOrganization( jsonObject[ "AuthorOrganization" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "FileFormat":
                    self.deserialize_FileFormat( jsonObject[ "FileFormat" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "LanguageVersion":
                    self.deserialize_LanguageVersion( jsonObject[ "LanguageVersion" ] )
                elif memberName == "Location":
                    self.deserialize_Location( jsonObject[ "Location" ] )
                elif memberName == "ModelingTool":
                    self.deserialize_ModelingTool( jsonObject[ "ModelingTool" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ToolVersion":
                    self.deserialize_ToolVersion( jsonObject[ "ToolVersion" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Properties":
                    self.deserialize_Properties( jsonObject[ "Properties" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.ArchitectureModel\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.ArchitectureModel\":  " + str( e )

        return self


    def deserialize_Properties( self, object ):
        del self.get_Properties()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Properties(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Property\" object.  Creating instance directly from \"AVM.META.Property\" class."
                objectType = "AVM.META.Property"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Property" ] )
                baseAVMClass = getattr( baseModule, "Property" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Property\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Property\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Properties().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class BehaviorModel(AVM.Model):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Model.__init__(self)
        self._Interfaces = []
        self._LimitChecks = []
        self._MaterialSpecs = []
        self._Phenomena = []


    def get_Interfaces(self):
        return self._Interfaces


    def get_LimitChecks(self):
        return self._LimitChecks


    def get_MaterialSpecs(self):
        return self._MaterialSpecs


    def get_Phenomena(self):
        return self._Phenomena


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Author":
                    self.deserialize_Author( jsonObject[ "Author" ] )
                elif memberName == "AuthorOrganization":
                    self.deserialize_AuthorOrganization( jsonObject[ "AuthorOrganization" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "FileFormat":
                    self.deserialize_FileFormat( jsonObject[ "FileFormat" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "LanguageVersion":
                    self.deserialize_LanguageVersion( jsonObject[ "LanguageVersion" ] )
                elif memberName == "Location":
                    self.deserialize_Location( jsonObject[ "Location" ] )
                elif memberName == "ModelingTool":
                    self.deserialize_ModelingTool( jsonObject[ "ModelingTool" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ToolVersion":
                    self.deserialize_ToolVersion( jsonObject[ "ToolVersion" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Interfaces":
                    self.deserialize_Interfaces( jsonObject[ "Interfaces" ] )
                elif memberName == "LimitChecks":
                    self.deserialize_LimitChecks( jsonObject[ "LimitChecks" ] )
                elif memberName == "MaterialSpecs":
                    self.deserialize_MaterialSpecs( jsonObject[ "MaterialSpecs" ] )
                elif memberName == "Phenomena":
                    self.deserialize_Phenomena( jsonObject[ "Phenomena" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.BehaviorModel\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.BehaviorModel\":  " + str( e )

        return self


    def deserialize_Interfaces( self, object ):
        del self.get_Interfaces()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Interfaces(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "ERROR:  No \"$type\" for \"AVM.META.Interface\" instance.  Cannot create instance directly from \"AVM.META.Interface\" class because it is abstract."
                continue

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Interface" ] )
                baseAVMClass = getattr( baseModule, "Interface" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Interface\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Interface\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Interfaces().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_LimitChecks( self, object ):
        del self.get_LimitChecks()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_LimitChecks(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.LimitCheck\" object.  Creating instance directly from \"AVM.META.LimitCheck\" class."
                objectType = "AVM.META.LimitCheck"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "LimitCheck" ] )
                baseAVMClass = getattr( baseModule, "LimitCheck" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.LimitCheck\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.LimitCheck\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_LimitChecks().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_MaterialSpecs( self, object ):
        del self.get_MaterialSpecs()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_MaterialSpecs(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.MaterialSpec\" object.  Creating instance directly from \"AVM.META.MaterialSpec\" class."
                objectType = "AVM.META.MaterialSpec"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "MaterialSpec" ] )
                baseAVMClass = getattr( baseModule, "MaterialSpec" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.MaterialSpec\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.MaterialSpec\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_MaterialSpecs().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Phenomena( self, object ):
        del self.get_Phenomena()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Phenomena(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Phenomenon\" object.  Creating instance directly from \"AVM.META.Phenomenon\" class."
                objectType = "AVM.META.Phenomenon"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Phenomenon" ] )
                baseAVMClass = getattr( baseModule, "Phenomenon" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Phenomenon\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Phenomenon\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Phenomena().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class CADAnalysisPoint(AVM.ExternalPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.ExternalPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.CADAnalysisPoint\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.CADAnalysisPoint\":  " + str( e )

        return self





class CADModel(AVM.Model):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        AVM.Model.__init__(self)
        self._CADParameters = []
        self._Datums = []
        self._Metrics = []
        self._ModelType = None


    def get_ModelType(self):
        return self._ModelType


    def set_ModelType(self,ModelType):
        self._ModelType = ModelType


    def get_CADParameters(self):
        return self._CADParameters


    def get_Datums(self):
        return self._Datums


    def get_Metrics(self):
        return self._Metrics


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Author":
                    self.deserialize_Author( jsonObject[ "Author" ] )
                elif memberName == "AuthorOrganization":
                    self.deserialize_AuthorOrganization( jsonObject[ "AuthorOrganization" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "FileFormat":
                    self.deserialize_FileFormat( jsonObject[ "FileFormat" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "LanguageVersion":
                    self.deserialize_LanguageVersion( jsonObject[ "LanguageVersion" ] )
                elif memberName == "Location":
                    self.deserialize_Location( jsonObject[ "Location" ] )
                elif memberName == "ModelingTool":
                    self.deserialize_ModelingTool( jsonObject[ "ModelingTool" ] )
                elif memberName == "ModelType":
                    self.deserialize_ModelType( jsonObject[ "ModelType" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "ToolVersion":
                    self.deserialize_ToolVersion( jsonObject[ "ToolVersion" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "CADParameters":
                    self.deserialize_CADParameters( jsonObject[ "CADParameters" ] )
                elif memberName == "Datums":
                    self.deserialize_Datums( jsonObject[ "Datums" ] )
                elif memberName == "Metrics":
                    self.deserialize_Metrics( jsonObject[ "Metrics" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.CADModel\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.CADModel\":  " + str( e )

        return self


    def deserialize_ModelType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.META", globals(), locals(), [ "CADModelType" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "CADModelType" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.META.CADModelType\":  " + str( e )
            return

        self.set_ModelType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_CADParameters( self, object ):
        del self.get_CADParameters()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_CADParameters(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.CADParameter\" object.  Creating instance directly from \"AVM.META.CADParameter\" class."
                objectType = "AVM.META.CADParameter"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "CADParameter" ] )
                baseAVMClass = getattr( baseModule, "CADParameter" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.CADParameter\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.CADParameter\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_CADParameters().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Datums( self, object ):
        del self.get_Datums()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Datums(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Datum\" object.  Creating instance directly from \"AVM.META.Datum\" class."
                objectType = "AVM.META.Datum"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Datum" ] )
                baseAVMClass = getattr( baseModule, "Datum" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Datum\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Datum\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Datums().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue


    def deserialize_Metrics( self, object ):
        del self.get_Metrics()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Metrics(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.Metric\" object.  Creating instance directly from \"AVM.META.Metric\" class."
                objectType = "AVM.META.Metric"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "Metric" ] )
                baseAVMClass = getattr( baseModule, "Metric" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.Metric\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.Metric\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Metrics().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class Calculation(Value):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Value.__init__(self)
        self._Expression = ""
        self._Inputs = []


    def get_Expression(self):
        return self._Expression


    def set_Expression(self,Expression):
        self._Expression = Expression


    def get_Inputs(self):
        return self._Inputs


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Expression":
                    self.deserialize_Expression( jsonObject[ "Expression" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Inputs":
                    self.deserialize_Inputs( jsonObject[ "Inputs" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Calculation\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Calculation\":  " + str( e )

        return self


    def deserialize_Expression( self, object ):
        self.set_Expression( object )


    def deserialize_Inputs( self, object ):
        del self.get_Inputs()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_Inputs(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.CalculationInput\" object.  Creating instance directly from \"AVM.META.CalculationInput\" class."
                objectType = "AVM.META.CalculationInput"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "CalculationInput" ] )
                baseAVMClass = getattr( baseModule, "CalculationInput" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.CalculationInput\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.CalculationInput\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_Inputs().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class NamedValue(Value):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        Value.__init__(self)
        self._DataType = None
        self._DefaultValue = ""
        self._Dimension = ""
        self._DistributionParameters = ""
        self._DistributionSource = ""
        self._DistributionSourceURI = ""
        self._DistributionType = None
        self._IsParameter = None
        self._IsProminent = None
        self._NominalValueSource = ""
        self._NominalValueSourceURI = ""
        self._Unit = ""
        self._ValidRange = ""
        self._Value = ""


    def get_DataType(self):
        return self._DataType


    def get_DefaultValue(self):
        return self._DefaultValue


    def get_Dimension(self):
        return self._Dimension


    def get_DistributionParameters(self):
        return self._DistributionParameters


    def get_DistributionSource(self):
        return self._DistributionSource


    def get_DistributionSourceURI(self):
        return self._DistributionSourceURI


    def get_DistributionType(self):
        return self._DistributionType


    def get_IsParameter(self):
        return self._IsParameter


    def get_IsProminent(self):
        return self._IsProminent


    def get_NominalValueSource(self):
        return self._NominalValueSource


    def get_NominalValueSourceURI(self):
        return self._NominalValueSourceURI


    def get_Unit(self):
        return self._Unit


    def get_ValidRange(self):
        return self._ValidRange


    def get_Value(self):
        return self._Value


    def set_DataType(self,DataType):
        self._DataType = DataType


    def set_DefaultValue(self,DefaultValue):
        self._DefaultValue = DefaultValue


    def set_Dimension(self,Dimension):
        self._Dimension = Dimension


    def set_DistributionParameters(self,DistributionParameters):
        self._DistributionParameters = DistributionParameters


    def set_DistributionSource(self,DistributionSource):
        self._DistributionSource = DistributionSource


    def set_DistributionSourceURI(self,DistributionSourceURI):
        self._DistributionSourceURI = DistributionSourceURI


    def set_DistributionType(self,DistributionType):
        self._DistributionType = DistributionType


    def set_IsParameter(self,IsParameter):
        self._IsParameter = IsParameter


    def set_IsProminent(self,IsProminent):
        self._IsProminent = IsProminent


    def set_NominalValueSource(self,NominalValueSource):
        self._NominalValueSource = NominalValueSource


    def set_NominalValueSourceURI(self,NominalValueSourceURI):
        self._NominalValueSourceURI = NominalValueSourceURI


    def set_Unit(self,Unit):
        self._Unit = Unit


    def set_ValidRange(self,ValidRange):
        self._ValidRange = ValidRange


    def set_Value(self,Value):
        self._Value = Value


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "DataType":
                    self.deserialize_DataType( jsonObject[ "DataType" ] )
                elif memberName == "DefaultValue":
                    self.deserialize_DefaultValue( jsonObject[ "DefaultValue" ] )
                elif memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Dimension":
                    self.deserialize_Dimension( jsonObject[ "Dimension" ] )
                elif memberName == "DistributionParameters":
                    self.deserialize_DistributionParameters( jsonObject[ "DistributionParameters" ] )
                elif memberName == "DistributionSource":
                    self.deserialize_DistributionSource( jsonObject[ "DistributionSource" ] )
                elif memberName == "DistributionSourceURI":
                    self.deserialize_DistributionSourceURI( jsonObject[ "DistributionSourceURI" ] )
                elif memberName == "DistributionType":
                    self.deserialize_DistributionType( jsonObject[ "DistributionType" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "IsParameter":
                    self.deserialize_IsParameter( jsonObject[ "IsParameter" ] )
                elif memberName == "IsProminent":
                    self.deserialize_IsProminent( jsonObject[ "IsProminent" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "NominalValueSource":
                    self.deserialize_NominalValueSource( jsonObject[ "NominalValueSource" ] )
                elif memberName == "NominalValueSourceURI":
                    self.deserialize_NominalValueSourceURI( jsonObject[ "NominalValueSourceURI" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "Unit":
                    self.deserialize_Unit( jsonObject[ "Unit" ] )
                elif memberName == "ValidRange":
                    self.deserialize_ValidRange( jsonObject[ "ValidRange" ] )
                elif memberName == "Value":
                    self.deserialize_Value( jsonObject[ "Value" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.NamedValue\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.NamedValue\":  " + str( e )

        return self


    def deserialize_DataType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "DataTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DataTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.DataTypeEnum\":  " + str( e )
            return

        self.set_DataType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_DefaultValue( self, object ):
        self.set_DefaultValue( object )


    def deserialize_Dimension( self, object ):
        self.set_Dimension( object )


    def deserialize_DistributionParameters( self, object ):
        self.set_DistributionParameters( object )


    def deserialize_DistributionSource( self, object ):
        self.set_DistributionSource( object )


    def deserialize_DistributionSourceURI( self, object ):
        self.set_DistributionSourceURI( object )


    def deserialize_DistributionType( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM", globals(), locals(), [ "DistributionTypeEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "DistributionTypeEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.DistributionTypeEnum\":  " + str( e )
            return

        self.set_DistributionType(  getattr( baseAVMEnumClass, "_" + object + "_" )  )


    def deserialize_IsParameter( self, object ):
        self.set_IsParameter( object )


    def deserialize_IsProminent( self, object ):
        self.set_IsProminent( object )


    def deserialize_NominalValueSource( self, object ):
        self.set_NominalValueSource( object )


    def deserialize_NominalValueSourceURI( self, object ):
        self.set_NominalValueSourceURI( object )


    def deserialize_Unit( self, object ):
        self.set_Unit( object )


    def deserialize_ValidRange( self, object ):
        self.set_ValidRange( object )


    def deserialize_Value( self, object ):
        self.set_Value( object )





class PowerPort(AVM.ExternalPort):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        AVM.ExternalPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.PowerPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.PowerPort\":  " + str( e )

        return self





class SignalPortBase(AVM.ExternalPort):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        AVM.ExternalPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.SignalPortBase\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.SignalPortBase\":  " + str( e )

        return self





class BusPort(SignalPortBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        SignalPortBase.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.BusPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.BusPort\":  " + str( e )

        return self





class CommunicationPort(SignalPortBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        SignalPortBase.__init__(self)
        self._DataTypes = []


    def get_DataTypes(self):
        return self._DataTypes


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "DataTypes":
                    self.deserialize_DataTypes( jsonObject[ "DataTypes" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.CommunicationPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.CommunicationPort\":  " + str( e )

        return self


    def deserialize_DataTypes( self, object ):
        del self.get_DataTypes()[:]
        for arrayObject in object:
            if "$ref" in arrayObject:
                self._hasRef = None
                id = arrayObject[ "$ref" ]
                if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                    ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self.get_DataTypes(), list.append )  )
                continue

            if "$type" in arrayObject:
                objectType = arrayObject[ "$type" ]
            elif "Type" in arrayObject:
                objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
            else:
                print "WARNING:  No \"$type\" for \"AVM.META.DataType\" object.  Creating instance directly from \"AVM.META.DataType\" class."
                objectType = "AVM.META.DataType"

            (modulename,classname) = objectType.rsplit( '.', 1 )
            classname = str( classname ) # classname must be "str" not "unicode"

            try:
                module = __import__( modulename, globals(), locals(), [classname] )
                avmClass = getattr( module, classname )
            except Exception as e:
                print "ERROR:  Problem loading class \"" + objectType + "\": " + str( e )
                continue

            try:
                baseModule = __import__( "AVM.META", globals(), locals(), [ "DataType" ] )
                baseAVMClass = getattr( baseModule, "DataType" )
            except Exception as e:
                print "ERROR:  Problem loading base class \"AVM.META.DataType\" of class \"" + objectType + "\":  " + str( e )
                continue

            if not issubclass( avmClass, baseAVMClass ):
                print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.DataType\""
                continue

            if avmClass._isAbstract:
                print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
                continue

            avmClassObject = avmClass()
            avmClassObject.__init__()

            try:
                self.get_DataTypes().append(  avmClassObject.deserializeAux( arrayObject )  )
            except Exception as e:
                print "ERROR:  problem deserializing object of \"" + objectType + "\" class:" + str( e )
                continue





class DataPort(SignalPortBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        SignalPortBase.__init__(self)
        self._DataType = None


    def set_DataType(self,DataType):
        self._DataType = DataType


    def get_DataType(self):
        return self._DataType


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif memberName == "DataType":
                    self.deserialize_DataType( jsonObject[ "DataType" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.DataPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.DataPort\":  " + str( e )

        return self


    def deserialize_DataType( self, object ):
        if "$ref" in object:
            id = object[ "$ref" ]
            if ( not id in ISIS.JSONDeserializeHelper._idRefMethodMap ):
                ISIS.JSONDeserializeHelper._idRefMethodMap[ id ] = []
            ISIS.JSONDeserializeHelper._idRefMethodMap[ id ].append(  ( self, self.__class__.set_DataType )  )
            return

        if "$type" in object:
            objectType = object[ "$type" ]
        elif "Type" in arrayObject:
            objectType = arrayObject[ "Type" ].split( ":", 1 )[0]
        else:
            print "WARNING:  No \"$type\" for \"AVM.META.DataType\" object.  Creating instance directly from \"AVM.META.DataType\" class."
            objectType = "AVM.META.DataType"

        (modulename,classname) = objectType.rsplit( '.', 1 )
        classname = str( classname ) # classname must be "str" not "unicode"
        try:
            module = __import__( modulename, globals(), locals(), [classname] )
            avmClass = getattr( module, classname )
        except Exception as e:
            print "ERROR:  Problem loading class \"" + objectType + "\":" + str( e )
            return

        try:
            baseModule = __import__( "AVM.META", globals(), locals(), [ "DataType" ] )
            baseAVMClass = getattr( baseModule, "DataType" )
        except Exception as e:
            print "ERROR:  Problem loading base class \"AVM.META.DataType\" of class \"" + objectType + "\":  " + str( e )
            return

        if not issubclass( avmClass, baseAVMClass ):
            print "ERROR:  Class \"" + objectType + "\" is not a subclass of \"AVM.META.DataType\""
            return

        if avmClass._isAbstract:
            print "ERROR:  Cannot create instance of \"" + objectType + "\" class:  class is abstract."
            return

        avmClassObject = avmClass()
        avmClassObject.__init__()

        try:
            self.set_DataType(  avmClassObject.deserializeAux( object )  )
        except Exception as e:
            print "ERROR:  problem deserializing object of \"" + objectType + "\" class:  " + str( e )
            return





class Electrical(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Electrical\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Electrical\":  " + str( e )

        return self





class Electromagnetic(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Electromagnetic\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Electromagnetic\":  " + str( e )

        return self





class Fluid(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Fluid\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Fluid\":  " + str( e )

        return self





class Heat(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Heat\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Heat\":  " + str( e )

        return self





class Magnetic(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Magnetic\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Magnetic\":  " + str( e )

        return self





class MultiBody(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.MultiBody\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.MultiBody\":  " + str( e )

        return self





class Pneumatic(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Pneumatic\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Pneumatic\":  " + str( e )

        return self





class Rotational(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Rotational\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Rotational\":  " + str( e )

        return self





class SignalPort(SignalPortBase):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        SignalPortBase.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.SignalPort\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.SignalPort\":  " + str( e )

        return self





class Translational(PowerPort):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        PowerPort.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.META.Translational\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.META.Translational\":  " + str( e )

        return self




