

class ITARRestrictionLevelEnum:
    _NotITAR_ = "NotITAR"
    _ITAR_ = "ITAR"
    _ITARDistributionD_ = "ITARDistributionD"


import ISIS
import AVM

class DistributionRestriction(AVM.Base):

    _isAbstract = True


    def __init__(self):
        _hasRef = None
        AVM.Base.__init__(self)


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.VehicleForge.DistributionRestriction\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.VehicleForge.DistributionRestriction\":  " + str( e )

        return self





class ITAR_Restriction(DistributionRestriction):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        DistributionRestriction.__init__(self)
        self._Documentation = []
        self._Level = None


    def get_Documentation(self):
        return self._Documentation


    def get_Level(self):
        return self._Level


    def set_Level(self,Level):
        self._Level = Level


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "Documentation":
                    self.deserialize_Documentation( jsonObject[ "Documentation" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Level":
                    self.deserialize_Level( jsonObject[ "Level" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.VehicleForge.ITAR_Restriction\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.VehicleForge.ITAR_Restriction\":  " + str( e )

        return self


    def deserialize_Documentation( self, object ):
        del self.get_Documentation()[:]
        for arrayObject in object:
            self.get_Documentation().append( arrayObject )

    def deserialize_Level( self, object ):
        try:
            baseAVMEnumModule = __import__( "AVM.VehicleForge", globals(), locals(), [ "ITARRestrictionLevelEnum" ] )
            baseAVMEnumClass = getattr( baseAVMEnumModule, "ITARRestrictionLevelEnum" )
        except Exception as e:
            print "ERROR:  Problem loading enumeration class \"AVM.VehicleForge.ITARRestrictionLevelEnum\":  " + str( e )
            return

        self.set_Level(  getattr( baseAVMEnumClass, "_" + object + "_" )  )





class Proprietary(DistributionRestriction):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        DistributionRestriction.__init__(self)
        self._Organization = ""


    def get_Organization(self):
        return self._Organization


    def set_Organization(self,Organization):
        self._Organization = Organization


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Organization":
                    self.deserialize_Organization( jsonObject[ "Organization" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.VehicleForge.Proprietary\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.VehicleForge.Proprietary\":  " + str( e )

        return self


    def deserialize_Organization( self, object ):
        self.set_Organization( object )





class SecurityClassification(DistributionRestriction):

    _isAbstract = False


    def __init__(self):
        _hasRef = None
        DistributionRestriction.__init__(self)
        self._Level = ""
        self._Organization = ""


    def get_Level(self):
        return self._Level


    def get_Organization(self):
        return self._Organization


    def set_Level(self,Level):
        self._Level = Level


    def set_Organization(self,Organization):
        self._Organization = Organization


    def serialize(self):
        return ISIS.JSONSerializeHelper.serialize( self )


    def deserialize( self, jsonObject ):
        ISIS.JSONDeserializeHelper._referencedObjectMap.clear()
        retval = self.deserializeAux( jsonObject )
        ISIS.JSONDeserializeHelper.resolveRefs()
        return retval


    def deserializeAux( self, jsonObject ):

        for memberName in jsonObject.keys():
            try:
                if memberName == "Description":
                    self.deserialize_Description( jsonObject[ "Description" ] )
                elif memberName == "id":
                    self.deserialize_id( jsonObject[ "id" ] )
                elif memberName == "Level":
                    self.deserialize_Level( jsonObject[ "Level" ] )
                elif memberName == "Name":
                    self.deserialize_Name( jsonObject[ "Name" ] )
                elif memberName == "Organization":
                    self.deserialize_Organization( jsonObject[ "Organization" ] )
                elif memberName == "Type":
                    self.deserialize_Type( jsonObject[ "Type" ] )
                elif not memberName.startswith( "$" ) :
                    print "WARNING: class \"AVM.VehicleForge.SecurityClassification\" has no member \"" + memberName + "\"."
            except Exception as e:
                print "ERROR:  Could not deserialize \"" + memberName + "\" of class \"AVM.VehicleForge.SecurityClassification\":  " + str( e )

        return self


    def deserialize_Level( self, object ):
        self.set_Level( object )


    def deserialize_Organization( self, object ):
        self.set_Organization( object )




