﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AVM.META.Design;
using AVM;

namespace METADesignTestProject
{
    class Program
    {
        static void Main(string[] args)
        {
            DesignModel dm = new DesignModel();
            dm.DesignID = "ID-2012";
            dm.Name = "Test Design";

            Compound c_powerplant = new Compound();
            dm.Containers.AddItem(c_powerplant);
            c_powerplant.Name = "Powerplant";

            #region Build Diesel Engine Instance
            ComponentInstance aci_engine = new ComponentInstance();
            c_powerplant.ComponentInstances.AddItem(aci_engine);
            aci_engine.Name = "Caterpillar C9 Diesel Engine";

            ComponentNamedValueInstance cnvi_engine_weight = new ComponentNamedValueInstance();
            aci_engine.NamedValueInstances.AddItem(cnvi_engine_weight);
            cnvi_engine_weight.Value = 330.3;
            cnvi_engine_weight.IDinComponentModel = "1920";

            PortInstance pi_engine_rotationalOut = new PortInstance();
            aci_engine.PortInstances.AddItem(pi_engine_rotationalOut);
            pi_engine_rotationalOut.IDinSourceModel = "2134";
            #endregion

            Compound c_transAndPD = new Compound();
            c_powerplant.Containers.AddItem(c_transAndPD);
            c_powerplant.Name = "Transmission and Primary Driveshaft";

            #region Build Container ValueFlow
            ContainerCalculation cc_transAndPD = new ContainerCalculation();
            c_transAndPD.ContainerValues.AddItem(cc_transAndPD);
            cc_transAndPD.Description = "Summing Operation";
            cc_transAndPD.Script = "scripts/summing.py";

            ContainerNamedValue cnv_transAndPD_weight = new ContainerNamedValue();
            c_transAndPD.ContainerValues.AddItem(cnv_transAndPD_weight);
            cnv_transAndPD_weight.Name = "Weight";

            ValueConnector vc_transAndPD_sumToWeight = new ValueConnector();
            dm.Connectors.AddItem(vc_transAndPD_sumToWeight);
            vc_transAndPD_sumToWeight.SourceValue = cc_transAndPD;
            vc_transAndPD_sumToWeight.DestinationValue = cnv_transAndPD_weight;
            #endregion

            #region Build Driveshaft Instance
            ComponentInstance aci_driveshaft = new ComponentInstance();
            c_transAndPD.ComponentInstances.AddItem(aci_driveshaft);
            aci_driveshaft.Name = "ABC Corp BR204 Primary Driveshaft";

            PortInstance pi_driveshaft_rotationalInput = new PortInstance();
            aci_driveshaft.PortInstances.AddItem(pi_driveshaft_rotationalInput);
            pi_driveshaft_rotationalInput.IDinSourceModel = "1234";

            PortInstance pi_driveshaft_rotationalOutput = new PortInstance();
            aci_driveshaft.PortInstances.AddItem(pi_driveshaft_rotationalOutput);
            pi_driveshaft_rotationalOutput.IDinSourceModel = "2341";

            ComponentNamedValueInstance cnvi_driveshaft_weight = new ComponentNamedValueInstance();
            aci_driveshaft.NamedValueInstances.AddItem(cnvi_driveshaft_weight);
            cnvi_driveshaft_weight.IDinComponentModel = "9234";
            cnvi_driveshaft_weight.Value = 105.234;

            ComponentNamedValueInstance cnvi_driveshaft_length = new ComponentNamedValueInstance();
            aci_driveshaft.NamedValueInstances.AddItem(cnvi_driveshaft_length);
            cnvi_driveshaft_length.Value = 1.2;
            cnvi_driveshaft_length.IDinComponentModel = "9203";
            #endregion

            #region Build Transmission Instance
            ComponentInstance aci_transmission = new ComponentInstance();
            c_transAndPD.ComponentInstances.AddItem(aci_transmission);
            aci_transmission.Name = "Caterpillar CX31 Transmission";

            PortInstance pi_transmission_rotationalInput = new PortInstance();
            aci_transmission.PortInstances.AddItem(pi_transmission_rotationalInput);
            pi_transmission_rotationalInput.IDinSourceModel = "1020";

            PortInstance pi_transmission_rotationalOutput = new PortInstance();
            aci_transmission.PortInstances.AddItem(pi_transmission_rotationalOutput);
            pi_transmission_rotationalOutput.IDinSourceModel = "2020";

            ComponentNamedValueInstance cnvi_transmission_weight = new ComponentNamedValueInstance();
            aci_transmission.NamedValueInstances.AddItem(cnvi_transmission_weight);
            cnvi_transmission_weight.Value = 203.342;
            cnvi_transmission_weight.IDinComponentModel = "9201";
            #endregion

            #region Build Connectors Between Component Instances
            PortConnector pc_engineToPD = new PortConnector();
            dm.Connectors.AddItem(pc_engineToPD);
            pc_engineToPD.EndPoints.AddItem(pi_engine_rotationalOut);
            pc_engineToPD.EndPoints.AddItem(pi_driveshaft_rotationalInput);

            PortConnector pc_dsToTransmission = new PortConnector();
            dm.Connectors.AddItem(pc_dsToTransmission);
            pc_dsToTransmission.EndPoints.AddItem(pi_driveshaft_rotationalOutput);
            pc_dsToTransmission.EndPoints.AddItem(pi_transmission_rotationalInput);
            #endregion

            String jsonString = dm.Serialize();
            Console.WriteLine(jsonString);
        }
    }
}
