model IFV
annotation(experiment(StartTime = 0.0, StopTime = 80.0, Tolerance = 1e-006), Documentation(info = "
<html>
<head>
<link href=\"special.css\" rel=\"stylesheet\" type=\"text/css\">
</head>
<body>
<h1><b>Configuration</b></h1>
<table id=\"configuration\">
<tr>
<td># of hybrid junctions: </td>
<td>12</td>
</tr>

<tr class=\"alt\">
<td># of non-hybrid junctions: </td>
<td>11</td>
</tr>

<tr>
<td># of elements: </td>
<td>
15</td>
</tr>

<tr class=\"alt\">
<td>
# of bonds: </td>
<td>
42</td>
</tr>
<tr>
<td>
# of cases: </td>
<td>
4096</td>
</tr>
</table>
<h1><b>Flat Bond Graph of the system</b></h1>
Note: please run the <a href=\"file:///C:/Projects/Meta/trunk/models/Verification/generated/IFVCreatePNG.cmd\">command</a> first.
<p align=\"center\">
<img src=\"file:///C:/Projects/Meta/trunk/models/Verification/generated/SimplifiedVerificationTestBenchExtendedv2.png\">
</p>
<hr />
<h1><b>Variable map</b></h1>
<p>The table contains the mapping between the GME model and the equations.</p>
<p>Note: You can open the html file in the GME console, and the hyperlinks will work.</p>
<table id=\"variableList\" border=\"1\" align=\"center\">
<tr>
<th align=\"center\">Variable name</th>
<th align=\"center\">Name in GME</th>
<th align=\"center\">Type</th>
<th align=\"center\">Path</th>
</tr>
<tr>
<td align=\"right\">ZeroJunction2_200000149</td>
<td align=\"center\"><a href=\"mga:id-0066-00000095\">ZeroJunction2</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.Rotational2Translational./.BondGraphDynamics./.ZeroJunction2</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">zed1_200000162</td>
<td align=\"center\"><a href=\"mga:id-0066-000000A2\">zed1</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.ResistiveLoad./.zed1</td>
</tr>
<tr>
<td align=\"right\">zj1_200000945</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B1\">zj1</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.zj1</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">ZeroJunction_200000980</td>
<td align=\"center\"><a href=\"mga:id-0066-000003D4\">ZeroJunction</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.ZeroJunction</td>
</tr>
<tr>
<td align=\"right\">ZeroJunction1_200000986</td>
<td align=\"center\"><a href=\"mga:id-0066-000003DA\">ZeroJunction1</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.ZeroJunction1</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">ZeroJunction_200000148</td>
<td align=\"center\"><a href=\"mga:id-0066-00000094\">ZeroJunction</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.Rotational2Translational./.BondGraphDynamics./.ZeroJunction</td>
</tr>
<tr>
<td align=\"right\">TF_200000145</td>
<td align=\"center\"><a href=\"mga:id-0066-00000091\">TF</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.Rotational2Translational./.BondGraphDynamics./.TF</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Series_200000161</td>
<td align=\"center\"><a href=\"mga:id-0066-000000A1\">Series</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.ResistiveLoad./.Series</td>
</tr>
<tr>
<td align=\"right\">MR_200000158</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009E\">MR</a></td>
<td align=\"center\">MR</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.ResistiveLoad./.MR</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">I_200000159</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009F\">I</a></td>
<td align=\"center\">I</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.ResistiveLoad./.I</td>
</tr>
<tr>
<td align=\"right\">oj5_200000949</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B5\">oj5</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.oj5</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Inertia_200000943</td>
<td align=\"center\"><a href=\"mga:id-0066-000003AF\">Inertia</a></td>
<td align=\"center\">I</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.Inertia</td>
</tr>
<tr>
<td align=\"right\">MSe_Torque_200000944</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B0\">MSe_Torque</a></td>
<td align=\"center\">MSe</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.MSe_Torque</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">DE_BearingLoss_200000947</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B3\">DE_BearingLoss</a></td>
<td align=\"center\">R</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.DE_BearingLoss</td>
</tr>
<tr>
<td align=\"right\">oj12_200000957</td>
<td align=\"center\"><a href=\"mga:id-0066-000003BD\">oj12</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj12</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">ZeroJunction2_200000976</td>
<td align=\"center\"><a href=\"mga:id-0066-000003D0\">ZeroJunction2</a></td>
<td align=\"center\">ZeroJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.ZeroJunction2</td>
</tr>
<tr>
<td align=\"right\">oj10_200000960</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C0\">oj10</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj10</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj8_200000963</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C3\">oj8</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj8</td>
</tr>
<tr>
<td align=\"right\">oj6_200000966</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C6\">oj6</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">OneJunction_200000982</td>
<td align=\"center\"><a href=\"mga:id-0066-000003D6\">OneJunction</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.OneJunction</td>
</tr>
<tr>
<td align=\"right\">oj11_200000955</td>
<td align=\"center\"><a href=\"mga:id-0066-000003BB\">oj11</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj11</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj9_200000959</td>
<td align=\"center\"><a href=\"mga:id-0066-000003BF\">oj9</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj9</td>
</tr>
<tr>
<td align=\"right\">oj7_200000961</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C1\">oj7</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj7</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj5_200000965</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C5\">oj5</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj5</td>
</tr>
<tr>
<td align=\"right\">TF6_200000956</td>
<td align=\"center\"><a href=\"mga:id-0066-000003BC\">TF6</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">TF5_200000958</td>
<td align=\"center\"><a href=\"mga:id-0066-000003BE\">TF5</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF5</td>
</tr>
<tr>
<td align=\"right\">TF4_200000962</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C2\">TF4</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF4</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">TF3_200000964</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C4\">TF3</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF3</td>
</tr>
<tr>
<td align=\"right\">oj4_200000967</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C7\">oj4</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj4</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj3_200000969</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C9\">oj3</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj3</td>
</tr>
<tr>
<td align=\"right\">TF2_200000968</td>
<td align=\"center\"><a href=\"mga:id-0066-000003C8\">TF2</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF2</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj2_200000971</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CB\">oj2</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj2</td>
</tr>
<tr>
<td align=\"right\">TF1_200000970</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CA\">TF1</a></td>
<td align=\"center\">TF</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.TF1</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">oj1_200000972</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CC\">oj1</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.oj1</td>
</tr>
<tr>
<td align=\"right\">Drive_shaft_compliance_200000975</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CF\">Drive shaft compliance</a></td>
<td align=\"center\">C</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.Drive shaft compliance</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear_box_inertia_200000973</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CD\">Gear box inertia</a></td>
<td align=\"center\">I</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.Gear box inertia</td>
</tr>
<tr>
<td align=\"right\">Clutch_resistance_200000974</td>
<td align=\"center\"><a href=\"mga:id-0066-000003CE\">Clutch resistance</a></td>
<td align=\"center\">R</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.Clutch resistance</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">OneJunction1_200000984</td>
<td align=\"center\"><a href=\"mga:id-0066-000003D8\">OneJunction1</a></td>
<td align=\"center\">OneJunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.OneJunction1</td>
</tr>
<tr>
<td align=\"right\">ThrottleSetting_200000150</td>
<td align=\"center\"><a href=\"mga:id-0066-00000096\">ThrottleSetting</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.ThrottleScenario./.TestDriver./.ThrottleSetting</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">ThrottleScenarioFunction_200000151</td>
<td align=\"center\"><a href=\"mga:id-0066-00000097\">ThrottleScenarioFunction</a></td>
<td align=\"center\">ControlFunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.ThrottleScenario./.TestDriver./.ThrottleScenarioFunction</td>
</tr>
<tr>
<td align=\"right\">time_200000152</td>
<td align=\"center\"><a href=\"mga:id-0066-00000098\">time</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.ThrottleScenario./.TestDriver./.time</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">DieselThrottle_200000153</td>
<td align=\"center\"><a href=\"mga:id-0066-00000099\">DieselThrottle</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.ThrottleScenario./.DieselThrottle</td>
</tr>
<tr>
<td align=\"right\">RoadLoad_200000154</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009A\">RoadLoad</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.RoadScenario./.RoadDriver./.RoadLoad</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">RoadScenarioFunction_200000156</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009C\">RoadScenarioFunction</a></td>
<td align=\"center\">ControlFunction</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.RoadScenario./.RoadDriver./.RoadScenarioFunction</td>
</tr>
<tr>
<td align=\"right\">time_200000155</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009B\">time</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.RoadScenario./.RoadDriver./.time</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">ScenarioLoad_200000157</td>
<td align=\"center\"><a href=\"mga:id-0066-0000009D\">ScenarioLoad</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.RoadScenario./.ScenarioLoad</td>
</tr>
<tr>
<td align=\"right\">LoadResistance_200000163</td>
<td align=\"center\"><a href=\"mga:id-0066-000000A3\">LoadResistance</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.ResistiveLoad./.LoadResistance</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">LoadVal_200000165</td>
<td align=\"center\"><a href=\"mga:id-0066-000000A5\">LoadVal</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.TestLoad./.LoadVal</td>
</tr>
<tr>
<td align=\"right\">Throttle_200000942</td>
<td align=\"center\"><a href=\"mga:id-0066-000003AE\">Throttle</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.Throttle</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Throttle_200000950</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B6\">Throttle</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.GenericDEDynamics./.Throttle</td>
</tr>
<tr>
<td align=\"right\">Throttle_200000953</td>
<td align=\"center\"><a href=\"mga:id-0066-000003B9\">Throttle</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.DieselEngineGenericExtended./.Throttle</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear4_200000989</td>
<td align=\"center\"><a href=\"mga:id-0066-000003DD\">InGear4</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear4</td>
</tr>
<tr>
<td align=\"right\">InGear6_200000990</td>
<td align=\"center\"><a href=\"mga:id-0066-000003DE\">InGear6</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear3_200000991</td>
<td align=\"center\"><a href=\"mga:id-0066-000003DF\">InGear3</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear3</td>
</tr>
<tr>
<td align=\"right\">InGear5_200000992</td>
<td align=\"center\"><a href=\"mga:id-0066-000003E0\">InGear5</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear5</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear1_200000995</td>
<td align=\"center\"><a href=\"mga:id-0066-000003E3\">InGear1</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear1</td>
</tr>
<tr>
<td align=\"right\">InGear2_200000996</td>
<td align=\"center\"><a href=\"mga:id-0066-000003E4\">InGear2</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.TransmissionDynamics./.InGear2</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear6_200001000</td>
<td align=\"center\"><a href=\"mga:id-0066-000003E8\">InGear6</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear6</td>
</tr>
<tr>
<td align=\"right\">InGear4_200001001</td>
<td align=\"center\"><a href=\"mga:id-0066-000003E9\">InGear4</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear4</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear3_200001003</td>
<td align=\"center\"><a href=\"mga:id-0066-000003EB\">InGear3</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear3</td>
</tr>
<tr>
<td align=\"right\">InGear2_200001004</td>
<td align=\"center\"><a href=\"mga:id-0066-000003EC\">InGear2</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear2</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">InGear5_200001005</td>
<td align=\"center\"><a href=\"mga:id-0066-000003ED\">InGear5</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear5</td>
</tr>
<tr>
<td align=\"right\">InGear1_200001006</td>
<td align=\"center\"><a href=\"mga:id-0066-000003EE\">InGear1</a></td>
<td align=\"center\">InSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionGenericExtendedv2./.InGear1</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear2_200001007</td>
<td align=\"center\"><a href=\"mga:id-0066-000003EF\">Gear2</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear2</td>
</tr>
<tr>
<td align=\"right\">Gear5_200001008</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F0\">Gear5</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear5</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear1_200001010</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F2\">Gear1</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear1</td>
</tr>
<tr>
<td align=\"right\">Gear3_200001012</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F4\">Gear3</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear3</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear4_200001013</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F5\">Gear4</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear4</td>
</tr>
<tr>
<td align=\"right\">Gear6_200001014</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F6\">Gear6</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.Gear6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear4_200001015</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F7\">Gear4</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear4</td>
</tr>
<tr>
<td align=\"right\">Gear2_200001016</td>
<td align=\"center\"><a href=\"mga:id-0066-000003F8\">Gear2</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear2</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear1_200001018</td>
<td align=\"center\"><a href=\"mga:id-0066-000003FA\">Gear1</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear1</td>
</tr>
<tr>
<td align=\"right\">Gear6_200001020</td>
<td align=\"center\"><a href=\"mga:id-0066-000003FC\">Gear6</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear3_200001021</td>
<td align=\"center\"><a href=\"mga:id-0066-000003FD\">Gear3</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear3</td>
</tr>
<tr>
<td align=\"right\">Gear5_200001022</td>
<td align=\"center\"><a href=\"mga:id-0066-000003FE\">Gear5</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.TransmissionControllerModel./.SimulinkModel./.Gear5</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear2_200001023</td>
<td align=\"center\"><a href=\"mga:id-0066-000003FF\">Gear2</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear2</td>
</tr>
<tr>
<td align=\"right\">Gear6_200001024</td>
<td align=\"center\"><a href=\"mga:id-0066-00000400\">Gear6</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear6</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear5_200001025</td>
<td align=\"center\"><a href=\"mga:id-0066-00000401\">Gear5</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear5</td>
</tr>
<tr>
<td align=\"right\">Gear3_200001026</td>
<td align=\"center\"><a href=\"mga:id-0066-00000402\">Gear3</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear3</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Gear4_200001027</td>
<td align=\"center\"><a href=\"mga:id-0066-00000403\">Gear4</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear4</td>
</tr>
<tr>
<td align=\"right\">Gear1_200001029</td>
<td align=\"center\"><a href=\"mga:id-0066-00000405\">Gear1</a></td>
<td align=\"center\">OutSignal</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.EngTransDriveTrainExtendedv2./.TransmissionControllerv2./.Gear1</td>
</tr>
<tr class=\"alt\">
<td align=\"right\">Parameter_300000029</td>
<td align=\"center\"><a href=\"mga:id-0067-0000001D\">Parameter</a></td>
<td align=\"center\">Parameter</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.ThrottleScenario./.Parameter</td>
</tr>
<tr>
<td align=\"right\">Thyme2_300000030</td>
<td align=\"center\"><a href=\"mga:id-0067-0000001E\">Thyme2</a></td>
<td align=\"center\">Parameter</td>
<td>IFV./.Testing./.VerificationTests Simulink./.SimplifiedVerificationTestBenchExtendedv2./.RoadScenario./.Thyme2</td>
</tr>
</table>
</body></html>
"));
// Variable spec (BEGIN) 
Real e2; Real f2;
Real e10; Real f10;
Real e41; Real f41;
Real e0; Real f0;
Real e1; Real f1;
Real e3; Real f3;
Real e4; Real f4;
Real e5; Real f5;
Real e6; Real f6;
Real e7; Real f7;
Real e8; Real f8;
Real e9; Real f9;
Real e11; Real f11;
Real e12; Real f12;
Real e13; Real f13;
Real e14; Real f14;
Real e15; Real f15;
Real e16; Real f16;
Real e17; Real f17;
Real e18; Real f18;
Real e19; Real f19;
Real e20; Real f20;
Real e21; Real f21;
Real e22; Real f22;
Real e23; Real f23;
Real e24; Real f24;
Real e25; Real f25;
Real e26; Real f26;
Real e27; Real f27;
Real e28; Real f28;
Real e29; Real f29;
Real e30; Real f30;
Real e31; Real f31;
Real e32; Real f32;
Real e33; Real f33;
Real e34; Real f34;
Real e35; Real f35;
Real e36; Real f36;
Real e37; Real f37;
Real e38; Real f38;
Real e39; Real f39;
Real e40; Real f40;
discrete Boolean State_200000957_oj12(start = true);
Boolean OnGuard_200000957_oj12(start = true);
Boolean OffGuard_200000957_oj12(start = true);
discrete Boolean State_200000960_oj10(start = true);
Boolean OnGuard_200000960_oj10(start = true);
Boolean OffGuard_200000960_oj10(start = true);
discrete Boolean State_200000963_oj8(start = true);
Boolean OnGuard_200000963_oj8(start = true);
Boolean OffGuard_200000963_oj8(start = true);
discrete Boolean State_200000966_oj6(start = true);
Boolean OnGuard_200000966_oj6(start = true);
Boolean OffGuard_200000966_oj6(start = true);
discrete Boolean State_200000955_oj11(start = true);
Boolean OnGuard_200000955_oj11(start = true);
Boolean OffGuard_200000955_oj11(start = true);
discrete Boolean State_200000959_oj9(start = true);
Boolean OnGuard_200000959_oj9(start = true);
Boolean OffGuard_200000959_oj9(start = true);
discrete Boolean State_200000961_oj7(start = true);
Boolean OnGuard_200000961_oj7(start = true);
Boolean OffGuard_200000961_oj7(start = true);
discrete Boolean State_200000965_oj5(start = true);
Boolean OnGuard_200000965_oj5(start = true);
Boolean OffGuard_200000965_oj5(start = true);
discrete Boolean State_200000967_oj4(start = true);
Boolean OnGuard_200000967_oj4(start = true);
Boolean OffGuard_200000967_oj4(start = true);
discrete Boolean State_200000969_oj3(start = true);
Boolean OnGuard_200000969_oj3(start = true);
Boolean OffGuard_200000969_oj3(start = true);
discrete Boolean State_200000971_oj2(start = true);
Boolean OnGuard_200000971_oj2(start = true);
Boolean OffGuard_200000971_oj2(start = true);
discrete Boolean State_200000972_oj1(start = true);
Boolean OnGuard_200000972_oj1(start = true);
Boolean OffGuard_200000972_oj1(start = true);
// Variable spec (END) 
// Parameters (BEGIN) 
Real Parameter_200000145_TF = 0.6;
Real Parameter_200000158_MR = 1;
Real Parameter_200000159_I = 4000;
Real Parameter_200000943_Inertia = 50;
Real Parameter_200000944_MSe_Torque = 1200;
Real Parameter_200000947_DE_BearingLoss = 0.01;
Real Parameter_200000956_TF6 = 1.388888889;
Real Parameter_200000958_TF5 = 1;
Real Parameter_200000962_TF4 = 0.598802395;
Real Parameter_200000964_TF3 = 0.431034483;
Real Parameter_200000968_TF2 = 0.327868852;
Real Parameter_200000970_TF1 = 0.235849057;
Real Parameter_200000975_Drive_shaft_compliance = 0.0000001;
Real Parameter_200000973_Gear_box_inertia = 10;
Real Parameter_200000974_Clutch_resistance = 1000;
// Parameters (END) 
/* Swithing functions */
/* Modulation functions */
/* Signal values */
Real ThrottleSetting_200000150(start = 1);
Real time_200000152(start = 1);
Real DieselThrottle_200000153(start = 1);
Real RoadLoad_200000154(start = 1);
Real time_200000155(start = 1);
Real ScenarioLoad_200000157(start = 1);
Real LoadResistance_200000163(start = 1);
Real LoadVal_200000165(start = 1);
Real Throttle_200000942(start = 1);
Real Throttle_200000950(start = 1);
Real Throttle_200000953(start = 1);
Real InGear4_200000989(start = 1);
Real InGear6_200000990(start = 1);
Real InGear3_200000991(start = 1);
Real InGear5_200000992(start = 1);
Real InGear1_200000995(start = 1);
Real InGear2_200000996(start = 1);
Real InGear6_200001000(start = 1);
Real InGear4_200001001(start = 1);
Real InGear3_200001003(start = 1);
Real InGear2_200001004(start = 1);
Real InGear5_200001005(start = 1);
Real InGear1_200001006(start = 1);
Real Gear2_200001007(start = 1);
Real Gear5_200001008(start = 1);
Real Gear1_200001010(start = 1);
Real Gear3_200001012(start = 1);
Real Gear4_200001013(start = 1);
Real Gear6_200001014(start = 1);
Real Gear4_200001015(start = 1);
Real Gear2_200001016(start = 1);
Real Gear1_200001018(start = 1);
Real Gear6_200001020(start = 1);
Real Gear3_200001021(start = 1);
Real Gear5_200001022(start = 1);
Real Gear2_200001023(start = 1);
Real Gear6_200001024(start = 1);
Real Gear5_200001025(start = 1);
Real Gear3_200001026(start = 1);
Real Gear4_200001027(start = 1);
Real Gear1_200001029(start = 1);
Real Parameter_300000029 = 1;
Real Thyme2_300000030 = 1;
/* ControlFunctions (BEGIN) */
/*=============== Function begins ==============*/
/* Original string
function [ThrottleSetting] = fcn(time)%#codegen
%matlab specific
ThrottleSetting = 2000;
#Modelica
algorithm
ThrottleSetting := 2000;
Original string*/
function ThrottleScenarioFunction_200000151
  input Real time;
  output Real ThrottleSetting;

algorithm
ThrottleSetting := 2000;
end ThrottleScenarioFunction_200000151;
/*===============  Function ends  ==============*/
/*=============== Function begins ==============*/
/* Original string
function [RoadLoad] = fcn(time)%#codegen
%matlab specific
RoadLoad = 200;
#Modelica
algorithm
RoadLoad := 200;
Original string*/
function RoadScenarioFunction_200000156
  input Real time;
  output Real RoadLoad;

algorithm
RoadLoad := 200;
end RoadScenarioFunction_200000156;
/*===============  Function ends  ==============*/
/* ControlFunctions (END) */
// Initial values (BEGIN) 
initial equation
f4 = 0;
f6 = 0;
e35 = 0;
f36 = 0;
// Initial values (END) 
/*# of cases : 4096

*/
equation

//Case #: 4095
/* Swithing functions */
/* Modulation functions */
/* Signal values */
ThrottleSetting_200000150 = ThrottleScenarioFunction_200000151(time_200000152);
DieselThrottle_200000153 = ThrottleSetting_200000150;
RoadLoad_200000154 = RoadScenarioFunction_200000156(time_200000155);
ScenarioLoad_200000157 = RoadLoad_200000154;
LoadResistance_200000163 = LoadVal_200000165;
LoadVal_200000165 = ScenarioLoad_200000157;
Throttle_200000942 = DieselThrottle_200000153;
Throttle_200000950 = Throttle_200000953;
Throttle_200000953 = Throttle_200000942;
InGear4_200000989 = InGear4_200001001;
InGear6_200000990 = InGear6_200001000;
InGear3_200000991 = InGear3_200001003;
InGear5_200000992 = InGear5_200001005;
InGear1_200000995 = InGear1_200001006;
InGear2_200000996 = InGear2_200001004;
InGear6_200001000 = Gear6_200001024;
InGear4_200001001 = Gear4_200001027;
InGear3_200001003 = Gear3_200001026;
InGear2_200001004 = Gear2_200001023;
InGear5_200001005 = Gear5_200001025;
InGear1_200001006 = Gear1_200001029;
Gear2_200001007 = Gear2_200001016;
Gear5_200001008 = Gear5_200001022;
Gear1_200001010 = Gear1_200001018;
Gear3_200001012 = Gear3_200001021;
Gear4_200001013 = Gear4_200001015;
Gear6_200001014 = Gear6_200001020;
Gear2_200001023 = Gear2_200001007;
Gear6_200001024 = Gear6_200001014;
Gear5_200001025 = Gear5_200001008;
Gear3_200001026 = Gear3_200001012;
Gear4_200001027 = Gear4_200001013;
Gear1_200001029 = Gear1_200001010;
Parameter_300000029 = time_200000152;
Thyme2_300000030 = time_200000155;
/* System's equations */
e0*Parameter_200000145_TF = e1;
f1*Parameter_200000145_TF = f0;
e2 = e0;
-f2 +f0 = 0;
e2 = e5;
+f2 -f5 = 0;
e10 = e9;
-f10 +f9 = 0;
e37 = f37*Parameter_200000974_Clutch_resistance;
e10 = e37;
e37 = e40;
+f10 -f37 -f40 = 0;
e41 = e39;
-f41 +f39 = 0;
e41 = e1;
+f41 -f1 = 0;
e3 = f3*LoadResistance_200000163;
e4 = der(f4)*Parameter_200000159_I;
-e3 -e4 +e5 = 0;
f3 = f4;
f4 = f5;
e6 = der(f6)*Parameter_200000943_Inertia;
e7 = Throttle_200000950;
e8 = f8*Parameter_200000947_DE_BearingLoss;
-e6 +e7 -e8 -e9 = 0;
f6 = f7;
f7 = f8;
f8 = f9;
f35 = der(e35)*Parameter_200000975_Drive_shaft_compliance;
e11 = e12;
e12 = e13;
e13 = e14;
e14 = e27;
e27 = e31;
e31 = e35;
e35 = e38;
+f11 +f12 +f13 +f14 +f27 +f31 -f35 -f38 = 0;
e36 = der(f36)*Parameter_200000973_Gear_box_inertia;
-e15 -e16 -e17 -e18 -e28 -e34 -e36 +e40 = 0;
f15 = f16;
f16 = f17;
f17 = f18;
f18 = f28;
f28 = f34;
f34 = f36;
f36 = f40;
+e38 -e39 = 0;
f38 = f39;
e19*Parameter_200000956_TF6 = e20;
f20*Parameter_200000956_TF6 = f19;
OnGuard_200000957_oj12 = InGear6_200000990 <> 0;
OffGuard_200000957_oj12 = InGear6_200000990 == 0;
State_200000957_oj12 = OnGuard_200000957_oj12 and not OffGuard_200000957_oj12;
if State_200000957_oj12 then
f11 = f19;
-e11 +e19 = 0;
else
f11 = 0;
f19 = 0;
end if;
e22*Parameter_200000958_TF5 = e21;
f21*Parameter_200000958_TF5 = f22;
OnGuard_200000960_oj10 = InGear5_200000992 <> 0;
OffGuard_200000960_oj10 = InGear5_200000992 == 0;
State_200000960_oj10 = OnGuard_200000960_oj10 and not OffGuard_200000960_oj10;
if State_200000960_oj10 then
f12 = f22;
-e12 +e22 = 0;
else
f12 = 0;
f22 = 0;
end if;
e23*Parameter_200000962_TF4 = e24;
f24*Parameter_200000962_TF4 = f23;
OnGuard_200000963_oj8 = InGear4_200000989 <> 0;
OffGuard_200000963_oj8 = InGear4_200000989 == 0;
State_200000963_oj8 = OnGuard_200000963_oj8 and not OffGuard_200000963_oj8;
if State_200000963_oj8 then
f13 = f23;
-e13 +e23 = 0;
else
f13 = 0;
f23 = 0;
end if;
e26*Parameter_200000964_TF3 = e25;
f25*Parameter_200000964_TF3 = f26;
OnGuard_200000966_oj6 = InGear3_200000991 <> 0;
OffGuard_200000966_oj6 = InGear3_200000991 == 0;
State_200000966_oj6 = OnGuard_200000966_oj6 and not OffGuard_200000966_oj6;
if State_200000966_oj6 then
f14 = f26;
-e14 +e26 = 0;
else
f14 = 0;
f26 = 0;
end if;
OnGuard_200000955_oj11 = InGear6_200000990 <> 0;
OffGuard_200000955_oj11 = InGear6_200000990 == 0;
State_200000955_oj11 = OnGuard_200000955_oj11 and not OffGuard_200000955_oj11;
if State_200000955_oj11 then
f15 = f20;
+e15 -e20 = 0;
else
f15 = 0;
f20 = 0;
end if;
OnGuard_200000959_oj9 = InGear5_200000992 <> 0;
OffGuard_200000959_oj9 = InGear5_200000992 == 0;
State_200000959_oj9 = OnGuard_200000959_oj9 and not OffGuard_200000959_oj9;
if State_200000959_oj9 then
f16 = f21;
+e16 -e21 = 0;
else
f16 = 0;
f21 = 0;
end if;
OnGuard_200000961_oj7 = InGear4_200000989 <> 0;
OffGuard_200000961_oj7 = InGear4_200000989 == 0;
State_200000961_oj7 = OnGuard_200000961_oj7 and not OffGuard_200000961_oj7;
if State_200000961_oj7 then
f17 = f24;
+e17 -e24 = 0;
else
f17 = 0;
f24 = 0;
end if;
OnGuard_200000965_oj5 = InGear3_200000991 <> 0;
OffGuard_200000965_oj5 = InGear3_200000991 == 0;
State_200000965_oj5 = OnGuard_200000965_oj5 and not OffGuard_200000965_oj5;
if State_200000965_oj5 then
f18 = f25;
+e18 -e25 = 0;
else
f18 = 0;
f25 = 0;
end if;
e30*Parameter_200000968_TF2 = e29;
f29*Parameter_200000968_TF2 = f30;
OnGuard_200000967_oj4 = InGear2_200000996 <> 0;
OffGuard_200000967_oj4 = InGear2_200000996 == 0;
State_200000967_oj4 = OnGuard_200000967_oj4 and not OffGuard_200000967_oj4;
if State_200000967_oj4 then
f27 = f30;
-e27 +e30 = 0;
else
f27 = 0;
f30 = 0;
end if;
OnGuard_200000969_oj3 = InGear2_200000996 <> 0;
OffGuard_200000969_oj3 = InGear2_200000996 == 0;
State_200000969_oj3 = OnGuard_200000969_oj3 and not OffGuard_200000969_oj3;
if State_200000969_oj3 then
f28 = f29;
+e28 -e29 = 0;
else
f28 = 0;
f29 = 0;
end if;
e32*Parameter_200000970_TF1 = e33;
f33*Parameter_200000970_TF1 = f32;
OnGuard_200000971_oj2 = InGear1_200000995 <> 0;
OffGuard_200000971_oj2 = InGear1_200000995 == 0;
State_200000971_oj2 = OnGuard_200000971_oj2 and not OffGuard_200000971_oj2;
if State_200000971_oj2 then
f31 = f32;
-e31 +e32 = 0;
else
f31 = 0;
f32 = 0;
end if;
OnGuard_200000972_oj1 = InGear1_200000995 <> 0;
OffGuard_200000972_oj1 = InGear1_200000995 == 0;
State_200000972_oj1 = OnGuard_200000972_oj1 and not OffGuard_200000972_oj1;
if State_200000972_oj1 then
f33 = f34;
-e33 +e34 = 0;
else
f33 = 0;
f34 = 0;
end if;
end IFV;